;-----------------------------------------------------------
; 
;	Api92/Api89 Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		edit.xas
;	Utility>	A complete single line editor
;
;-----------------------------------------------------------


EDIT_X		equ	$00
EDIT_Y		equ	$02
EDIT_MAX	equ	$04
EDIT_MASK	equ	$06
EDIT_FLAG	equ	$07
EDIT_CBKDOWN	equ	$08
EDIT_CBKUP	equ	$0C


;----------------------------------------------------
;Input>	a0.l : Address of structure
;	a1.l : Address of buffer
;
;Out>	d0.w : nb of chars entered (0 if error)
;	d1.w : Value given in api92CallBack_KeyDown
;		function 
;
;	00.w	:	X position
;	02.w	:	Y position
;	04.w	:	Max length
;	06.b	:	If not null, char used for a mask
;	07.b	:	Flag
;	08.l	:	If not null, address of an
;			 api92CallBack_edKeyDown function
;	0C.l	:	If not null, address of an
;			 api92CallBack_edKeyUp function
;
; Flags	: xxxxxxx1 : convert in lowercase
;	  xxxxxx1x : convert in uppercase
;	  xxxxx1xx : Allow only decimal numbers
;	  xxxx1xxx : if null : ESC return 0 in d0
;			else ESC return 264 in d0
;----------------------------------------------------
;api92CallBack_KeyUp
;Input>	d0.w : Key Pressed
;	a0.l : Address of buffer
;	a6.l : Address of original structure
;----------------------------------------------------
;api92CallBack_KeyDown
;Input>	d0.w : Key Pressed
;	a0.l : Address of buffer
;	a6.l : Address of original structure
;Out>	d0.w : 0 : ignore that key
;		else char to insert in the buffer
;	d1.w : 	0=continue
;		else exit component
;----------------------------------------------------
apilib@0049:
_EditComponent:


_Edit2Component:
	movem.l	d2-d7/a0-a6,-(a7)

	move.l	a0,a6


	move.l	a1,a4			;Save addr of buffer

	clr.w	d3			;current char
	clr.w	d2			;nb of char

	move.w	(a0)+,d4		;X
	move.w	(a0)+,d5		;Y
	move.w	(a0)+,d6		;Maxlegnth
	move.w	(a0)+,d7		;Flag
	clr.b	(a4)
	bsr	DrawCursor

	clr.w	-(a7)			;current key

\waitkey move.w	(a7),d0			;restore value of key
	beq.s	\first
	move.l	EDIT_CBKUP(a6),d1
	beq.s	\first
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	d1,a1
	move.l	a4,a0
	jsr	(a1)
	movem.l	(a7)+,d0-d7/a0-a6

\first 	bsr	_WaitKey
	move.w	d0,(a7)			;save keyvalue

	cmp.w	#264,d0			;Is ESC ?
	beq	\esc

	cmp.w   #13,d0			; Enter ?
	beq	\Enter
	cmp.w   #257,d0			; Backspace ?
	beq   	\BackSp

	cmp.w	#PAD_RIGHT,d0
	beq	\padright
	cmp.w	#PAD_LEFT,d0
	beq	\padleft

	btst.b  #2,d7			; Allow only nb ?
	beq.s   \nonum
	cmp.w   #'0',d0
	bcs.s   \waitkey
	cmp.w   #'9',d0
	bhi.s   \waitkey

\nonum  btst.b  #0,d7			; Convert lower case ?
	beq.s   \nomaj
	cmp.w   #65,d0
	bcs.s   \nomaj
	cmp.w   #90,d0
	bhi.s   \nomaj
	add.w   #32,d0

\nomaj	btst.b	#1,d7			;Convert Uppercase ?
	beq.s	\nomin
	cmp.w	#(65+32),d0
	bcs.s	\nomin
	cmp.w	#(90+32),d0
	bhi.s	\nomin
	sub.w	#32,d0

\nomin	move.l	EDIT_CBKDOWN(a6),d1	;CallBack_KeyDown
	beq.s	\nokd
	movem.l	d2-d7/a0-a6,-(a7)
	move.l	d1,a1
	move.l	a4,a0			;Address of buffer
	jsr	(a1)
	movem.l	(a7)+,d2-d7/a0-a6
	tst.w	d0
	beq	\waitkey
	tst.w	d1
	beq.s	\nokd
	clr.w	d0
	bra	\exit

\nokd	cmp.w   #255,d0         ;Valid character ?
	bhi   	\waitkey        ;if not, loop

	tst.b	0(a4,d3.w)
	bne.s	\nozero

	cmp.w   d2,d6           ;Max of characters ?
	beq   	\waitkey

	bsr	DrawCursor	;delete old cursor
	move.b	d0,0(a4,d3.w)
	addq.w	#1,d3
	addq.w	#1,d2
	clr.b	0(a4,d3.w)
	bra.s	\skip

\nozero	bsr	DrawCursor	;delete old cursor
	move.b	d0,0(a4,d3.w)
	addq.w	#1,d3

\skip	bsr	DrawInput
	bsr	DrawCursor		;draw cursor
\gowk	bra	\waitkey


\BackSp	tst.w	d3
	beq.s	\gowk
	bsr	DrawCursor		;Erase cursor
	tst.b	0(a4,d3.w)
	bne.s	\skip2
	subq.w	#1,d3
	subq.w	#1,d2
\rd	move.b	#32,0(a4,d2.w)
	bsr	edDrawStr
	clr.b	0(a4,d2.w)
	bsr	DrawInput
	bra.s	\skip
	
\skip2	lea	0(a4,d3.w),a1
	lea	-1(a1),a0
\mov	move.b	(a1)+,(a0)+
	tst.b	(a1)
	bne.s	\mov
	subq.w	#1,d2
	subq.w	#1,d3
	bra.s	\rd


\padleft tst.w	d3
	beq.s	\gowk
	bsr	DrawCursor
	subq.w	#1,d3
	bra.s	\expad
\padright
	tst.b	0(a4,d3.w)
	beq.s	\gowk
	bsr	DrawCursor
	addq.w	#1,d3
\expad	bsr	DrawCursor
	bra.s	\gowk

\Enter	move.w	d2,d0			;nb copied
	clr.w	d1			;default value

\exit	bsr	DrawCursor
	addq.l	#2,a7			;delete stack  frame
	movem.l	(a7)+,d2-d7/a0-a6
	rts

\esc	btst.b	#3,d7			;if set
	bne.s	\exit			; return 264
	clr.w	d0
	bra.s	\exit


DrawCursor:
	movem.l	d0-d7,-(a7)
	bsr	_GetFontWidthHeight
	move.w	d0,d6		;Width
	move.w	d1,d2		;Height

	move.w	d5,d1
	move.w	d3,d0		;current char
	mulu.w	d6,d0
	add.w	d4,d0		;add X
	bsr	DrawVerticalLine
	addq.w	#1,d0
	bsr	DrawVerticalLine

	movem.l	(a7)+,d0-d7
	rts

edDrawStr:
	move.l	a4,a1
	move.w	d4,d0
	move.w	d5,d1
	bsr	_draw_StringSpecial
	rts

DrawInput:
	movem.l	d2-d7,-(a7)

	clr.w	d2
	move.b	EDIT_MASK(a6),d2
	beq.s	\nomask
	bsr	_GetFontWidthHeight
	move.w	d0,d6		;Width
	move.w	d4,d0		;X
	move.w	d5,d1		;Y
	move.l	a4,a0
\char	tst.b	(a0)+
	beq.s	\exit
	bsr	_draw_CharSpecial
	add.w	d6,d0		;X+=Width
	bra.s	\char

\nomask	bsr	edDrawStr
\exit	movem.l	(a7)+,d2-d7
	rts

;-----------------------------------------------------
;input>	d0.w : X
;	d1.w : Y
;	d2.w : Height-1
;-----------------------------------------------------
DrawVerticalLine:
	movem.l	d0-d3/a0-a2,-(a7)
	move.l	#LCD_MEM,a0
	move.w	d0,d3			;save d0
	lsr.w	#3,d0			;
	mulu.w	#30,d1
	add.w	d0,d1
	adda.w	d1,a0
	and.w	#7,d3
	moveq.w	#7,d0
	sub.w	d3,d0

\draw	bchg.b	d0,(a0)
	lea	30(a0),a0
	dbra.s	d2,\draw

	movem.l	(a7)+,d0-d3/a0-a2
	rts


;-----------------------------------------------------------
;Input>	a0.l : Header
;	a1.l : string
;00.W : X
;00.W : Y
;00.W : MAXLETTER
;00.W : Offset
;-----------------------------------------------------------
ScrollingCaptionComponent:
apilib@0073:
	movem.l	d0-d4/a0-a3,-(a7)

	move.l	a1,a2

	clr.l	d3
\length	tst.b	(a2)+
	beq.s	\eos
	addq.l	#1,d3
	bra.s	\length
\eos

	cmp.w	4(a0),d3
	bcs.s	\noscroll

	move.w	d3,d0
	sub.w	6(a0),d0
	cmp.w	4(a0),d0
	bhi.s	\skip
	move.w	d3,d0
	sub.w	4(a0),d0
	move.w	d0,6(a0)	;nouvel offset
\skip	bra.s	\draw
\noscroll clr.w	6(a0)
\draw	move.w	4(a0),d4
	addq.l	#3,d4
	bclr.b	#0,d4
	suba.w	d4,a7
	move.l	a7,a3		;save buffer addr
	adda.w	6(a0),a1	;add offset

	movem.l	d0-d2/a0-a1,-(a7)
	clr.l	d0
	move.w	4(a0),d0
	move.l	d0,-(a7)
	move.l	a1,-(a7)
	move.l	a3,-(a7)
	TIOS_CALL strncpy
	lea	12(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1

	move.w	4(a0),d0
	clr.b	0(a3,d0.w)

	move.l	a3,a1
	move.w	0(a0),d0
	move.w	2(a0),d1
	bsr	_draw_StringSpecial

	adda.w	d4,a7
	movem.l	(a7)+,d0-d4/a0-a3
	rts




