;-----------------------------------------------------------
; 
;       Api92/Api89 Source Code
;
;       (c) NeXO Software, Benoit SCHERRER
;       e-mail : p.c.scherrer@wanadoo.fr
;
;
;       File>           files.xas
;       Utility>        VAT Management
;
;-----------------------------------------------------------


;#ifdef TIPLUS
VAR_RELOCOFFSET    equ     8
;#else
VAR_RELOCOFFSET    equ     10
;#endif


;---------------------------------------------------
; AddVatEntry - Internal function
; Add a VAT entry and short the list
;
;Input> d0.w : Handle of a VAT
;       a0.l : Address of a VAT entry
;Out>   d1.w : Error Code
;---------------------------------------------------
_GetVarState:

	rts

;---------------------------------------------------
; AddVatEntry - Internal function
; Add a VAT entry and short the list
;
;Input> d0.w : Handle of a VAT
;       a0.l : Address of a VAT entry
;Out>   d1.w : Error Code
;---------------------------------------------------
_AddVatEntry:
	movem.l d0/a0-a2,-(a7)

	move.b  9(a0),-(a7)
	clr.b   9(a0)
	movem.l d0/d2/a0,-(a7)             ;Check if var exists
	bsr     _vat_Find               ;Call subroutine
	move.w  d2,d1
	movem.l (a7)+,d0/d2/a0
	move.b  (a7)+,9(a0)
	tst.w   d1
	bne.s   \already_exist

	moveq.w #VATENTRY_SIZE,d1
	bsr     _array_AddItem          ;Call an array_x function
	tst.w   d1                      ;If error
	bne.s   \exit                   ;Then exit


	moveq.w #VATENTRY_SIZE,d1
	lea     CallBack_ShortVAT(PC),a0
	bsr     _array_Short
	clr.w   d1                      ;No error

\exit   movem.l (a7)+,d0/a0-a2
	rts

\already_exist
	btst.b  #VAT_FOLDERBIT,VATENTRY_FLG(a1) ;check if file or folder
	beq.s   \fileexist
	moveq.w #EC_FOLDEREXIST,d1
	bra.s   \exit

\fileexist moveq.w #EC_FILEEXIST,d1
	bra.s   \exit


CallBack_ShortVAT:
	move.l  a1,-(a7)
	move.l  a0,-(a7)
	TIOS_CALL strcmp
	addq.l  #8,a7

	cmp.w   #0,d0
	ble.s   \noswap
	moveq.w #1,d0                   ;swap
	bra.s   \exit
\noswap clr.w   d0                      ;don't swap
\exit   rts



;--------------------------------------------------------
;       vat_IsAddressInVAT:
;
;> 
;
;Input> a0.l : Address to test
;Out>   d0.w = 0 if not, else handle of file
;--------------------------------------------------------
_vat_IsAddressInVAT:
apilib@007C:
	movem.l	d1-d3/a0-a3,-(a7)

	;---------------------------------------
	; get folder table addr and nb folders
	;---------------------------------------
	move.l	a0,a1			;save addr
	API92_FOLDHDL d0		;Folder Table Handle
	bsr	DEREFd0a0		;folder table addr
	lea	2(a0),a2

	move.w	(a2)+,d2		;nb folders
	beq.s	\notfound
	subq.w	#1,d2

	;---------------------------------------
	; scan each folder, and get VAT associed
	;---------------------------------------
\folders move.w	VAT_ENTRYHDL(a2),d0
	beq.s	\nfold
	bsr	DEREFd0a0		;folder handle
	
	lea	2(a0),a3

	move.w	(a3)+,d3		;nb files in that folder
	beq.s	\nfold
	subq.w	#1,d3

	;---------------------------------------
	; scan each files of VAT
	;---------------------------------------
\files	move.w	VAT_ENTRYHDL(a3),d0	;handle of file
	beq.s	\nfile
	bsr	DEREFd0a0
	
	;----------------------------------
	; Compare addresses
	;----------------------------------
	cmp.l	a1,a0
	bhi.s	\nfile
	add.w	(a0),a0
	addq.l	#2,a0
	cmp.l	a1,a0
	bhi.s	\exit

\nfile	lea	VAT_ENTRYSIZE(a3),a3
	dbra.s	d3,\files

\nfold	lea	VAT_ENTRYSIZE(a2),a2
	dbra.s	d2,\folders

\notfound clr.w	d0

\exit	movem.l	(a7)+,d1-d3/a0-a3

	rts



;--------------------------------------------------------
;       vat_MoveVar
;
;> Move a var from a folder to an other folder
;
;Input> d0.w : Handle of source folder
;       d1.w : Handle of destination folder
;       d2.w : 0-based index of var in the source folder
;Out>   d1.w : Error Code
;--------------------------------------------------------
;a0=addr of CB function
_vat_MoveRRVar:
apilib@0078:
	movem.l d0/d2-d4/a0-a3,-(a7)
	move.w	#1,-(a7)
	move.l	a0,a3
	bra.s	_vat_Move

apilib@003C:
_vat_MoveVar:
	movem.l d0/d2-d4/a0-a3,-(a7)
	clr.w	-(a7)

_vat_Move:
	move.w  d1,d3                   ;Save handle of dest folder
	bsr     _vat_IndexToAddr        ;return (d0,a0)
	tst.w   d1
	bne.s   \exit

	move.l  d0,-(a7)
	move.w  VATENTRY_HDL(a0),d0     ;Handle of file
	move.l	a0,a2			;save original VAT entry
	bsr     _vat_IsVarInUse         ;Check if file is in use
	move.l  (a7)+,d0
	tst.w   d1
	bne.s   \exit

\checkname
	tst.w	(a7)
	beq.s	\noreplace
	movem.l	d0/d2-d7/a1-a6,-(a7)
	move.w	d3,d0			;dest folder handle
	jsr	(a3)
	movem.l	(a7)+,d0/d2-d7/a1-a6
	cmp.w	#EC_PERSONAL,d1		;if new name suggesteed, test again
	beq.s	\checkname
	tst.w	d1
	bne.s	\exit

;#ifdef TIPLUS
	clr.w	8(a0)
	move.l	10(a2),10(a0)		;copy flag & hdl
;#else
	clr.b	8(a0)
	move.b	9(a2),9(a0)
	move.w	10(a2),10(a0)
;#endif

\noreplace
	move.l	a0,a3			;save file name (maybe new)

	exg.w   d0,d3                   ;Create the entry in
	bsr     _AddVatEntry            ;the destination folder
	tst.w   d1                      ;Test if successful
	bne.s   \exit


;#ifdef TIPLUS
	move.l  d2,-(a7)

	exg.w   d0,d3                   ;d0=source hdl
	bsr     _vat_IndexToAddr        ;get VAT entry addr
	tst.w   d1
	bne.s   \noarch
	
	move.l	a3,a0			;file name
	exg.w   d0,d3                   ;d0=dest
	bsr     _vat_Find
	tst.w   d2
	beq.s   \noarch
	subq.w  #1,d2
	btst.b  #1,VAT_ENTRYFLAG-1(a1)  ;if var
	beq.s   \noarch                 ;was archived

	bsr     _vat_UnarchiveVar       ;unarchive and
	bsr     _vat_ArchiveVar         ;archive it again

\noarch move.l  (a7)+,d2
;#endif

	move.w  d3,d0                   ;d0=source
	moveq.w #VATENTRY_SIZE,d1
	bsr     _array_DeleteItem

\exit	addq.l	#2,a7
	movem.l (a7)+,d0/d2-d4/a0-a3
	rts

;--------------------------------------------------------
;       vat_CopyVar
;
; > Copy a var from a folder in an other folder
;
;Input> d0.w : Handle of source folder
;       d1.w : Handle of destination folder
;       d2.w : 0-based index of var in the source folder
;Out>   d1.w : Error Code
;--------------------------------------------------------

;a0=addr of CB function
_vat_CopyRRVar:
apilib@0076:
	movem.l d0/d2-d4/a0-a3,-(a7)
	move.w	#1,-(a7)
	move.l	a0,a3
	bra.s	_vat_Copy

apilib@003B:
_vat_CopyVar:
	movem.l d0/d2-d4/a0-a3,-(a7)
	move.w	#0,-(a7)

_vat_Copy:
	move.w  d1,d4                   ;Save dest folder

	bsr     _vat_IndexToAddr        ;return (d0,a0)
	tst.w   d1
	bne.s   \exit

	move.l  a0,-(a7)                ;Save a0
	move.w  VATENTRY_HDL-2(a0),d1   ;Flags of src var
	btst.l  #9,d1
	beq.s   \noarch
	and.w   #%1111110111110111,d1
\noarch move.w  VATENTRY_HDL(a0),d0     ;Handle of src var
	move.w  d0,d3                   ;Save handle
	bsr     DEREFd0a0               ;Its address
	move.w  (a0),d2                 ;Its size
	move.l  (a7)+,a0                ;Restore a0

;#ifdef TIPLUS
	move.l  d1,-(a7)
	bsr     _vat_IsVarInUse         ;d0=file hdl
	move.w  d1,d0
	move.l  (a7)+,d1
	tst.w   d0
	bne.s   \inuse
;#endif

	move.w	d1,d0			;save d1=flags
\checkname
	tst.w	(a7)
	beq.s	\noreplace
	movem.l	d0/d2-d7/a1-a6,-(a7)
	move.w	d4,d0			;folder handle
	jsr	(a3)
	movem.l	(a7)+,d0/d2-d7/a1-a6
	cmp.w	#EC_PERSONAL,d1		;if new name suggesteed, test again
	beq.s	\checkname
	tst.w	d1
	bne.s	\exit
	move.w	d0,d1			;restore d1

\noreplace

	move.w  d4,d0                   ;Handle of dest folder
	bsr     _vat_CreateVar
	tst.w   d1
	bne.s   \exit

	move.l  a0,a1                   ;Save address of var
	move.w  (a0),d2                 ;Size of file
	addq.w  #1,d2                   ;for dbra
	exg.w   d3,d0                   ;d0=Handle of src var ; d3=hdl of dest var
	bsr     DEREFd0a0               ;Its address

\copy   move.b  (a0)+,(a1)+             ;Copy data
	dbra.s  d2,\copy        

;#ifdef TIPLUS
;#else
	bsr     _vat_IsVarInUse
	tst.w   d1
	beq.s   \skip
	move.w  d3,d0                   ;hdl of dest var
	bsr     DEREFd0a0
	clr.w   VAR_RELOCOFFSET+2(a0)
;#endif
\skip   clr.w   d1
	
\exit	addq.l	#2,a7			;delete stack frame
	movem.l (a7)+,d0/d2-d4/a0-a3
	rts

\inuse  move.w  d0,d1
	bra.s   \exit


;-------------------------------------------------------
;       vat_CreateFolder
;
; > Create a new folder in the VAT of the calculator
;
;Input> a0.l : Address of the 0-terminated folder name
;       d0.w : Flags of folder
;Out>   d0.w : Handle of created folder if successful
;       d1.w : Error Code
;-------------------------------------------------------
apilib@003E:
_vat_CreateFolder:
	movem.l d2-d4/a0-a2,-(a7)

	move.w  d0,d2                   ;Save flags
	suba.w  #VATENTRY_SIZE,a7       ;Create stack frame
	move.l  a7,a2

	moveq.w #VATENTRY_SIZE,d1       ;Item Size
	bsr     _array_Create           ;Create the VAT
	move.w  d0,d4                   ;Check if error or not
	beq.s   \memerror

	movem.l d0-d2/a0-a2,-(a7)       ;Create a VAT entry
	move.l  #8,-(a7)
	move.l  a0,-(a7)
	move.l  a2,-(a7)
	TIOS_CALL strncpy
	lea     12(a7),a7
	movem.l (a7)+,d0-d2/a0-a2

	move.l  a2,a0                   ;Save a2
	addq.l  #8,a2
;#ifdef TIPLUS
	clr.w   (a2)+
;#endif
	move.w  d2,(a2)+
	move.w  d0,(a2)+

	API92_FOLDHDL d0	      ;Folder Table Handle
	bsr     _AddVatEntry            ;Add the entry
	tst.w   d1
	beq.s   \exit
	bsr     _vat_DelHdl

\exit   move.w  d4,d0                   ;Handle of folder
	adda.w  #VATENTRY_SIZE,a7       ;Delete stack frame
	movem.l (a7)+,d2-d4/a0-a2
	rts

\memerror
	moveq.w #EC_OUTOFMEMORY,d1
	bra.s   \exit

;---------------------------------------------------------------
; Intern function
; Used by CreateFolder and CreateVar in case of an error
;Input> d4.w : Handle of buffer
;---------------------------------------------------------------
_vat_DelHdl:
	movem.l d0-d2/a0-a1,-(a7)
	move.w  d4,-(a7)
	TIOS_CALL HeapFree
	addq.l  #2,a7
	movem.l (a7)+,d0-d2/a0-a1
	rts

;---------------------------------------------------------------
;       vat_CreateVar
;
; > Create a new var in a folder
;
;Input> d0.w : Handle of folder
;       d1.w : Flags of the var
;       d2.w : Size of data
;       a0.l : Address of the 0-terminated var name
;Out>   d0.w : Handle of created file buffer if successful
;       d1.w : Error Code
;       a0.l : Address of created file buffer if successful
;---------------------------------------------------------------
apilib@003F:
_vat_CreateVar:
	movem.l d2-d4/a1-a2,-(a7)

	suba.w  #VATENTRY_SIZE,a7               ;Create stack frame
	move.l  a7,a2
	move.w  d0,d3                           ;Save d0

	and.l   #$0000FFFF,d2                   ;Word -> long
	movem.l d1-d2/a0-a2,-(a7)               ;Create buffer
	addq.l  #2,d2
	move.l  d2,-(a7)
	TIOS_CALL HeapAlloc                 ;Alloc buffer
	addq.l  #4,a7
	movem.l (a7)+,d1-d2/a0-a2
	move.w  d0,d4                           ;Check if error
	beq.s   \memerror

	movem.l d0-d2/a0-a2,-(a7)               ;Create a VAT entry
	move.l  #8,-(a7)
	move.l  a0,-(a7)
	move.l  a2,-(a7)

	bsr     DEREFd0a0                       ;Get addr of buffer
	move.w  d2,(a0)                         ;Put its size

	TIOS_CALL strncpy
	lea     12(a7),a7
	movem.l (a7)+,d0-d2/a0-a2

	move.l  a2,a0                           ;Save a2
	addq.l  #8,a2
;#ifdef TIPLUS
	clr.w   (a2)+
;#endif
	move.w  d1,(a2)+
	move.w  d0,(a2)+

	move.w  d3,d0                           ;Handle of folder
	bsr     _AddVatEntry
	tst.w   d1
	bne.s   \error

	move.w  d4,d0                           ;Handle of buffer
	bsr     DEREFd0a0                       ;Address of buffer

\exit   adda.w  #VATENTRY_SIZE,a7               ;Delete stack frame
	movem.l (a7)+,d2-d4/a1-a2
	rts

\memerror moveq.w       #EC_OUTOFMEMORY,d1
	bra.s   \exit

\error  bsr     _vat_DelHdl
	bra.s   \exit



;--------------------------------------------------------
; Delete a VAT entry, a folder or a file
;Input> d0.w : Handle of VAT
;       d2.w : 0-based index of var to delete
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@004F:
_vat_Delete:
	movem.l d0/a0,-(a7)

	bsr     _vat_IndexToAddr
	tst.w   d1
	bne.s   \exit

	btst.b  #VAT_FOLDERBIT,VATENTRY_FLG(a0)
	beq.s   \file
	move.w  VATENTRY_HDL(a0),d0
	bsr     _vat_DeleteFolder
	bra.s   \exit
\file   bsr     _vat_DeleteVar

\exit   movem.l (a7)+,d0/a0
	rts


;--------------------------------------------------------
;       vat_DeleteVar
;
; > Delete a var
;
;Input> d0.w : Handle of folder
;       d2.w : 0-based index of var to delete
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@0040:
_vat_DeleteVar:
	movem.l d0/d4/a0,-(a7)

\delete bsr     _vat_IndexToAddr                ;Check if valid
	tst.w   d1                              ;if not, exit
	bne.s   \exit

;#ifdef TIPLUS
	btst.b  #VAT_ARCHBIT,VATENTRY_FLG-1(a0)
	beq.s   \not_archived

	bsr     _vat_UnarchiveVar
	tst.w   d1
	beq.s   \delete
	bra.s   \exit
;#endif

\not_archived
	move.l  d0,-(a7)
	move.w  VATENTRY_HDL(a0),d0     ;Handle of file
	move.w  d0,d4                   ;For _vat_DelHdl
	bsr     _vat_IsVarInUse         ;Check if file is in use
	move.l  (a7)+,d0
	tst.w   d1
	bne.s   \exit

	moveq.w #VATENTRY_SIZE,d1               ;Delete entry
	bsr     _array_DeleteItem
	tst.w   d1                              ;Check if no error
	bne.s   \exit

	bsr     _vat_DelHdl                     ;And delete buffer
	clr.w   d1                              ;No error

\exit   movem.l (a7)+,d0/d4/a0
	rts

;--------------------------------------------------------
;       vat_DeleteFolder
;
; > Delete a folder
;
;Input> d0.w : Handle of folder
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@0041:
_vat_DeleteFolder:
	movem.l d0/d4/a0,-(a7)
       
	move.w  d0,d4                   ;Else delete VAT buffer
	bsr     DEREFd0a0               ;Get VAT address
	addq.l  #2,a0                   ;skip first word
	move.w  (a0)+,d0                ;Get nb of files
	bne.s   \not_empty              ;If not zero error

	API92_FOLDHDL	d0      	;VAT list
	move.w  d4,d1                   ;Item hdl
	bsr     _vat_FindHdl            ;return (d0,d2)
	tst.w   d2
	beq.s   \notfound
	subq.w  #1,d2
	moveq.w #VATENTRY_SIZE,d1               ;Delete entry
	bsr     _array_DeleteItem
	tst.w   d1                              ;Check if no error
	bne.s   \exit


	bsr     _vat_DelHdl

\exit   movem.l (a7)+,d0/d4/a0
	rts

\not_empty
	moveq.w #EC_NOTEMPTY,d1
	bra.s   \exit
\notfound
	moveq.w #EC_HDLNOTFOUND,d1
	bra.s   \exit


;--------------------------------------------------------
;       vat_Rename
;
; > Rename an entry of the VAT (folder or file)
;
;Input> d0.w : Handle of a VAT
;       d2.w : 0-based index of entry to rename
;       a0.l : Address of 0-terminated new name of entry
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@003D:
_vat_Rename:
	movem.l d0/d2-d4/a0,-(a7)

	suba.w  #10,a7
	move.l  a7,a2

	movem.l d0-d2/a0-a1,-(a7)
	move.l  #8,-(a7)
	move.l  a0,-(a7)
	move.l  a2,-(a7)
	TIOS_CALL strncpy
	lea     12(a7),a7
	movem.l (a7)+,d0-d2/a0-a1

	move.w  d2,d3                   ;save d2=index of file
	move.l  a2,a0                   ;look for file
	bsr     _vat_Find               ;check if exist
	tst.w   d2
	bne.s   \already_exist
	
	move.w  d3,d2                   ;restore d2
	bsr     _vat_IndexToAddr        ;return (d0,a0)
	tst.w   d1
	bne.s   \exit

	move.l  (a2)+,(a0)+
	move.l  (a2)+,(a0)+

	moveq.w #VATENTRY_SIZE,d1
	lea     CallBack_ShortVAT(PC),a0
	bsr     _array_Short

	clr.w   d1                      ;No error

\exit   adda.w  #10,a7
	movem.l (a7)+,d0/d2-d4/a0
	rts

\already_exist
	btst.b  #VAT_FOLDERBIT,VATENTRY_FLG(a1) ;check if file or folder
	beq.s   \fileexist
	moveq.w #EC_FOLDEREXIST,d1
	bra.s   \exit

\fileexist moveq.w #EC_FILEEXIST,d1
	bra.s   \exit

;--------------------------------------------------------
;       vat_ToggleHide
;
; > Toggle Hide/Unhide attribute of a VAT item
;
;Input> d0.w : Handle of a VAT
;       d2.w : 0-based index of entry to rename
;Out>   d1.w : Error Code
;--------------------------------------------------------
_vat_ToggleHide:
apilib@0055:
	moveq.w #VAT_HIDEBIT,d1
	bsr     _vat_ChangeAttr
	rts

;--------------------------------------------------------
;       vat_ToggleHideSelection
;
; > Toggle Hide/Unhide attribute of selected items in
; a folder
;
;Input> d0.w : Handle of a folder
;Out>   d1.w : Error Code
;--------------------------------------------------------
_vat_ToggleHideSelection
apilib@0056:
	move.l  a1,-(a7)
	lea     _vat_ToggleHide(PC),a1
	bsr     _use_Selection
	move.l  (a7)+,a1
	rts

;--------------------------------------------------------
;       vat_ToggleLock
;
; > Toggle Lock/Unlock attribute of a VAT item
;
;Input> d0.w : Handle of a VAT
;       d2.w : 0-based index of entry to rename
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@0057:
_vat_ToggleLock:
	moveq.w #VAT_LOCKBIT,d1
	bsr     _vat_ChangeAttr
	rts

;--------------------------------------------------------
;       vat_ToggleLockSelection
;
; > Toggle Lock/Unlock attribute of selected items in
; a folder
;
;Input> d0.w : Handle of a folder
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@0058:
_vat_ToggleLockSelection
	move.l  a1,-(a7)
	lea     _vat_ToggleLock(PC),a1
	bsr     _use_Selection
	move.l  (a7)+,a1
	rts
	  
;-----------------------
;Input> d0.w : Handle of a VAT
;       d1.w : bit to invert
;       d2.w : 0-based index of entry to rename
;Out>   d1.w : Error Code
;-----------------------
_vat_ChangeAttr:        
	movem.l d0/d2-d3/a0,-(a7)
	move.w  d1,d3                   ;save d1
	bsr     _vat_IndexToAddr        ;Get addr
	tst.w   d1                      ;found ?
	bne.s   \exit

;#ifdef TIPLUS
	cmp.w   #VAT_LOCKBIT,d1
	bne.s   \skip
	btst.b  #VAT_ARCHBIT,VAT_ENTRYFLAG(a0)
	beq.s   \skip
	moveq.w #EC_VARARCHIVED,d1
	bra.s   \exit
\skip
;#endif

	bchg.b  d3,VAT_ENTRYFLAG(a0)
	clr.w   d1                      ;no error

\exit   movem.l (a7)+,d0/d2-d3/a0
	rts

;--------------------------------------------------------
;       vat_ToggleSelect
;
; > Toggle Selected/Unselected attribute of a VAT item
;
;Input> d0.w : Handle of a VAT
;       d2.w : 0-based index of entry to rename
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@0059:
_vat_ToggleSelect:
	moveq.w  #VAT_SELECTBIT,d1
	bsr     _vat_ChangeAttr
	rts


;--------------------------------------------------------
;       vat_SelectAll
;
; > Select all the items of a VAT
;
;Input> d0.w : Handle of a VAT
;Out>   Nothing
;--------------------------------------------------------
apilib@005A:
_vat_SelectAll:
	move.l  d1,-(a7)
	moveq.w #1,d1
	bsr     _vat_SelectDeselect
	move.l  (a7)+,d1
	rts

;--------------------------------------------------------
;       vat_DeselectAll
;
; > Deselect all items in a VAT
;
;Input> d0.w : Handle of a VAT
;--------------------------------------------------------
apilib@005B:
_vat_DeselectAll:
	move.l  d1,-(a7)
	clr.w   d1
	bsr     _vat_SelectDeselect
	move.l  (a7)+,d1
	rts

;d1:0=deselect  1=select
_vat_SelectDeselect:        
	movem.l d0/a0,-(a7)
	bsr     DEREFd0a0        
	addq.l  #2,a0
	move.w  (a0)+,d0                        ;get nb of files
	beq.s   \exit                           ;if null, exit
	subq.w  #1,d0                           ;-1 for dbra

\loop   tst.w   d1
	bne.s   \skip
	bclr.b  #VAT_SELECTBIT,VAT_ENTRYFLAG(a0) ;clear select bit flag
	bra.s   \next
\skip   bset.b  #VAT_SELECTBIT,VAT_ENTRYFLAG(a0)
\next   lea     VAT_ENTRYSIZE(a0),a0            ;next VAT entry
	dbra.s  d0,\loop

\exit   movem.l (a7)+,d0/a0
	rts


;-------------------------------------------------
; universal function to use selection
;input> d0.w : Handle of folder
;       d1.w : Parameters to pass to the function
;       a1.l : Address of function
;out>   d1.w : Error Code
;       d2.w : Last index of file
;         _vat_CopyVar/_vat_MoveVar/_vat_DeleteVar
;-------------------------------------------------
_use_Selection:
	movem.l d0/d3-d4/a0-a1,-(a7)

	move.w  d1,d4                   ;save d1

\getaddr bsr    DEREFd0a0               ;addr of VAT in a0
	addq.l  #2,a0                   ;skip first word
	clr.w   d1                      ;clear d1=default error value
	move.w  (a0)+,d3                ;nb of items
	beq.s   \sucess                 ;if nul, exit
	subq.w  #1,d3                   ;for dbra
	clr.w   d2                      ;file index

\loop   btst.b  #VAT_SELECTBIT,VATENTRY_FLG(a0)
	beq.s   \skip
	bclr.b  #VAT_SELECTBIT,VATENTRY_FLG(a0)
	move.w  d4,d1                   ;restore value of d1
	jsr     (a1)                    ;call fct
	tst.w   d1                      ;Check if error
	beq.s   \getaddr                ;if success read again addr
	bsr     DEREFd0a0
	addq.l  #4,a0
	move.w  d2,d0
	mulu.w  #VATENTRY_SIZE,d0
	bset.b  #VAT_SELECTBIT,VATENTRY_FLG(a0,d0) ;if error reset selection bit
	bra.s   \exit                   ;exit with error code

\skip   lea     VATENTRY_SIZE(a0),a0    ;next entry
	addq.w  #1,d2
	dbra.s  d3,\loop

\sucess clr.w   d1                      ;no error
\exit   movem.l (a7)+,d0/d3-d4/a0-a1

	rts

;--------------------------------------------------------
;       vat_DeleteSelection
;
;> Delete all selected variables in a folder
;
;Input> d0.w : Handle of folder
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@004B:
_vat_DeleteSelection:
	move.l  a1,-(a7)
	lea     _vat_Delete(PC),a1
	bsr     _use_Selection
	move.l  (a7)+,a1
	rts

;--------------------------------------------------------
;       vat_CopySelection
;
;> Copy selected variables from a folder to an other folder
;
;Input> d0.w : Handle of source folder
;       d1.w : Handle of destination folder
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@004C:
_vat_CopySelection:
	move.l  a1,-(a7)
	lea     _vat_CopyVar(PC),a1
	bsr     _use_Selection
	move.l  (a7)+,a1
	rts

;--------------------------------------------------------
;       vat_CopyRRSelection
;
;> Copy selected variables from a folder to an other folder
;
;Input> d0.w : Handle of source folder
;       d1.w : Handle of destination folder
;	a0.l : Addr of callback function
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@0077:
_vat_CopyRRSelection:
	movem.l  a1/a4,-(a7)
	move.l	a0,a4
	lea     cb_CRRS(PC),a1
	bsr     _use_Selection
	movem.l  (a7)+,a1/a4
	rts

cb_CRRS:
	move.l	a4,a0
	bsr	_vat_CopyRRVar
	rts

;--------------------------------------------------------
;       vat_MoveSelection
;
;> Move selected variables from a folder to an other folder
;
;Input> d0.w : Handle of source folder
;       d1.w : Handle of destination folder
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@004D:
_vat_MoveSelection:
	move.l  a1,-(a7)
	lea     _vat_MoveVar(PC),a1
	bsr     _use_Selection
	move.l  (a7)+,a1
	rts

;--------------------------------------------------------
;       vat_MoveRRSelection
;
;> Move selected variables from a folder to an other folder
;
;Input> d0.w : Handle of source folder
;       d1.w : Handle of destination folder
;	a0.l : Addr of callback function
;Out>   d1.w : Error Code
;--------------------------------------------------------
apilib@0079:
_vat_MoveRRSelection:
	movem.l  a1/a4,-(a7)
	move.l	a0,a4
	lea     cb_MRRS(PC),a1
	bsr     _use_Selection
	movem.l  (a7)+,a1/a4
	rts

cb_MRRS:
	move.l	a4,a0
	bsr	_vat_MoveRRVar
	rts

;------------------------------------------------
;       var_CountSelection
;
;Input> d0.w : Handle of a VAT
;Out>   d0.w : number of items selected
;------------------------------------------------
apilib@004E:
_vat_CountSelection:
	movem.l d1-d2/a0,-(a7)
	tst.w   d0
	beq.s   \exit
	bsr     DEREFd0a0
	addq.l  #2,a0
	clr.l   d0
	move.w  (a0)+,d2
	beq.s   \exit
	subq.w  #1,d2

\loop   btst.b  #VAT_SELECTBIT,VATENTRY_FLG(a0)
	beq.s   \skip
	addq.l  #1,d0
\skip   lea     VATENTRY_SIZE(a0),a0
	dbra.s  d2,\loop

\exit   movem.l (a7)+,d1-d2/a0
	rts


;----------------------------------------------------------
; -- internal function for archive / unarchive --
;----------------------------------------------------------
hsymprep:
	clr.l   d6                      ; d6.L = 0
	move.w  d0,d6                   ; d6.w = handle of the folder
	swap    d6                      ; d6.w = 0, the other word of d6 contains the handle of the folder
	moveq.l #4,d5                   ; d5 will be the displacement from the beginning of the list
	mulu    #14,d2                  ; d5 = 4 + (14 * index)
	add.w   d2,d5
	move.w  d5,d6                   ; stores d5
	rts

;--------------------------------------------------------------
;       vat_UnarchiveVar
;
; > Unarchives a variable
;
;Input> d0.w : handle of the folder containing the file
;       d2.w : 0-based index of the file
;Out>   d1.w : Error Code
;
; Thanks to Xavier Vassor for this functions
;--------------------------------------------------------------
_vat_UnarchiveVar:
apilib@0068:
;#ifdef TIPLUS
	movem.l d0/d2-d7/a0-a6,-(a7)
	TIOS_LEAADDR EM_moveSymFromExtMem,a0
	clr.l	d1
	bra.s   _arch_fct2
;#endif

;--------------------------------------------------------------
;       vat_ArchiveVar
;
; > Archives a var
;
;Input> d0.w : handle of the folder containing the file
;       d2.w : 0-based index of the file
;Out>   d1.w : Error code
;
; Thanks to Xavier Vassor for this functions
;--------------------------------------------------------------
_vat_ArchiveVar:
apilib@0067:
;#ifdef TIPLUS
	movem.l d0/d2-d7/a0-a6,-(a7)
	TIOS_LEAADDR EM_moveSymToExtMem,a0

_arch_fct:
	movem.l d0/a0,-(a7)
	bsr     _vat_IndexToAddr
	move.w  VAT_ENTRYHDL(a0),d0     ;get var hdl
	bsr     _vat_IsVarInUse         ;uis in use ?
	movem.l (a7)+,d0/a0

_arch_fct2:
	tst.w   d1                      ;check error code
	bne.s   \exit

	bsr     hsymprep                ; prepare d6 = Sym info for the ROM CALL
	move.l  d6,-(a7)                ; pushes d6
	clr.l   -(a7)                   ; the 2nd arg is unused here
	jsr     (a0)                    ; (un)Archive !
	addq.l  #8,a7
	tst.w   d0                      ; did it work ?
	beq.s   \memerror
	clr.w   d1
\exit   movem.l (a7)+,d0/d2-d7/a0-a6

;#endif
	rts

;#ifdef TIPLUS

\memerror moveq.w #EC_OUTOFMEMORY,d1        
	bra.s   \exit
;#endif

;--------------------------------------------------------------
;       vat_UnarchiveSelection 
;
; > Unarchives every selected files in a folder
;
;Input> d0.w : handle of the folder containing the file
;Out>   d1.w : Error Code
;--------------------------------------------------------------
apilib@006A:
_vat_UnarchiveSelection:
;#ifdef TIPLUS
	move.l  a1,-(a7)
	lea     _vat_UnarchiveVar(PC),a1
	bsr     _use_Selection
	move.l  (a7)+,a1
;#endif
	rts

;--------------------------------------------------------------
;       vat_ArchiveSelection 
;
; > Archives every selected files in a folder
;
;Input> d0.w : handle of the folder containing the file
;Out>   d1.w : Error Code
;--------------------------------------------------------------
apilib@0069:
_vat_ArchiveSelection:
;#ifdef TIPLUS
	move.l  a1,-(a7)
	lea     _vat_ArchiveVar(PC),a1
	bsr     _use_Selection
	move.l  (a7)+,a1
;#endif
	rts


;-------------------------------------------------------
;       vat_IndexToAddr
;
; > Convert (Folder Handle, Index) to the address
; of the entry in the VAT
;
;Input> d0.w : Handle of folder
;       d2.w : 0-based index of var
;Out>   d1.w : Error Code
;       a0.l : Address of entry in the VAT
;-------------------------------------------------------
apilib@004A:
_vat_IndexToAddr:
	movem.l d0/d2,-(a7)

	bsr     DEREFd0a0               ;Address of VAT

	move.l	a0,d0			;check if common error
	btst.l	#0,d0
	bne.s	\error
	

	addq.w  #2,a0                   ;Skip first word
	move.w  (a0)+,d1                ;Number of file

	cmp.w   d1,d2                   ;if d2>=d1
	bcc.s   \error                  ; error

	mulu.w  #VATENTRY_SIZE,d2
	adda.w  d2,a0
	clr.w   d1                      ;No error
		
\exit   movem.l (a7)+,d0/d2
	rts

\error  moveq.w #EC_INVALIDINDEX,d1
	bra.s   \exit



;-----------------------------------------------------
;       _vat_IsVarInUse
;
; > Check if a var is in use or not.
;
;input> d0.w : Handle of the var
;out>   d1.w : Error code
;----------------------------------------------------
apilib@0042:
_vat_IsVarInUse:
	movem.l d0/d2/a0,-(a7)

	moveq.w #EC_UNKNOWNERROR,d1
	tst.w   d0
	beq.s   \exit

	clr.w   d1                      ;default return value
	bsr     DEREFd0a0               ;Get address of file

	move.w  (a0)+,d2                ;Get size of file

;#ifdef TIPLUS
	cmp.l   #$03FFFF,a0             ;in RAM ?
	bhi.s   \exit			;if archived => not used

	movem.l	d1-d2/a0-a2,-(a7)	;Check if locked
	move.w	d0,-(a7)
	TIOS_CALL HeapGetLock
	addq.l	#2,a7
	movem.l	(a7)+,d1-d2/a0-a2
	tst.w	d0
	bne.s	\inuse

	cmp.b   #$F3,-1(a0,d2.w)        ;is a ASM prog (TI92+/TI89) ?
	bne.s   \exit

	cmp.l   #$36386b50,4(a0)        ;is 68kP ?
	beq.s   \ok
	cmp.l   #$36386b4C,4(a0)        ;is 68kL ?
	bne.s   \exit
\ok

;#else
	cmp.b   #$DC,-1(a0,d2.w)        ;is a prog (TI92) ?
	bne.s   \exit

	cmp.w   #$0032,(a0)             ;is a fargo prog ?
	bne.s   \exit
;#endif

	tst.w   VAR_RELOCOFFSET(a0)
	beq.s   \exit

\inuse	moveq.w #EC_VARINUSE,d1 

\exit   movem.l (a7)+,d0/d2/a0
	rts



;---------------------------------------------------
;       vat_FindVarEverywhere
;
; > Find an item everywhere in the calculator, giving
; its name
;
;Input> a0.l : Address of null terminated string
;Out>   d0.w : Handle of folder
;       d1.w : Handle of the var if found
;       d2.w :  Null if not found
;               Else 1-based index of VAT entry if found
;       a0.l : Address of variable in memory
;       a1.l : Address of VAT entry 
;---------------------------------------------------
apilib@003A:
_vat_FindVarEverywhere:
	movem.l d3/a2-a3,-(a7)

	move.l  a0,a3                   ;Save string addr
	API92_FOLDHDL	d0     		;Handle of folder table
	bsr     DEREFd0a0               ;its address
	lea     2(a0),a2
	clr.l   d2                      ;Default error value
	clr.w   d1
	move.w  (a2)+,d3                ;Get nb of folders
	beq.s   \exit                   ;If no folder, exit
	subq.w  #1,d3                   ;(for dbra)

\loop   move.w  VATENTRY_HDL(a2),d0     ;Get folder handle
	beq.s   \next                   ;If null, skip
	move.l  a3,a0                   ;Restore string addr
	bsr     _vat_Find
	tst.w   d2
	bne.s   \exit                   ;If var found exit
\next   lea     VATENTRY_SIZE(a2),a2    ;next folder
	dbra.s  d3,\loop
	
	clr.w   d2                      ;If not found
	clr.w   d1

\exit   movem.l (a7)+,d3/a2-a3
	rts

;---------------------------------------------------
;       vat_Find
;
; > Find an item in a VAT giving its name
;
;Input> d0.w : Handle of a VAT
;       a0.l : Address of null terminated string
;Out>   d0.w : Handle of the VAT
;       d1.w : Handle of the var if found
;       d2.w :  Null if not found
;               Else 1-based index of VAT entry if found
;       a0.l : Address of variable in memory
;       a1.l : Address of VAT entry 
;---------------------------------------------------
apilib@0039:
_vat_Find:
	movem.l  d0/d3,-(a7)

	tst.w   d0                      ;Check if valid handle
	beq.s   \not_found

	move.w  #$FFFF,d3               ;Use CallBack
	lea     _CB_CmpVat(PC),a1       ;CallBack function addr
	moveq.w #VATENTRY_SIZE,d1       ;
	bsr     _array_FindItem         ;Call array_x function
	tst.w   d0
	beq.s   \not_found

	move.w  d0,d2                   ;Save index
	move.w  VATENTRY_HDL(a1),d0     ;Handle of found item
	bsr     DEREFd0a0               ;its address in memory
	move.w  d0,d1

\exit   movem.l  (a7)+,d0/d3
	rts

\not_found
	clr.w   d1
	clr.w   d2
	bra.s   \exit

_CB_CmpVat:
	move.l  #8,-(a7)
	move.l  a0,-(a7)
	move.l  a2,-(a7)
	TIOS_CALL strncmp
	lea     12(a7),a7

	tst.w   d0
	beq.s   \found
	clr.w   d0
	bra.s   \exit
\found  moveq.w #1,d0
\exit   rts

;---------------------------------------------------
;  vat_FindHdl
;input> d0.w : Handle of a VAT
;       d1.w : Handle of item to search
;out>   d2.w :  0 if not found
;               Else 1-based index of entry if found
;       a0.l : Address of variable in memory
;       a1.l : Address of VAT entry
;---------------------------------------------------
_vat_FindHdl:
apilib@0028:        
	movem.l d0-d1/d3,-(a7)

	bsr     DEREFd0a0               ;Get VAT address
	addq.l  #2,a0                   ;Skip first word
	clr.l   d2                      ;Default error value
	move.w  (a0)+,d3                ;Get number of items
	beq.s   \exit
	subq.w  #1,d3

\loop   addq.l  #1,d2                   ;Increment item index
	cmp.w   VATENTRY_HDL(a0),d1     ;Compare handles
	beq.s   \found                  ;if equal, jump
	lea     VATENTRY_SIZE(a0),a0
	dbra.s  d3,\loop
	clr.l   d2                      ;If not found,
	bra.s   \exit                   ;exit

\found  move.l  a0,a1                   ;Save address of VAT entry
	move.w  d1,d0                   ;addr of var
	bsr     DEREFd0a0               ;get its addr

\exit   movem.l (a7)+,d0-d1/d3
	rts


;---------------------------------------------------
;  vat_FindHdlEverywhere
;input> d1.w : Handle of item to search
;out>   d0.w : Handle of folder if found
;       d2.w :  0 if not found
;               Else 1-based index of entry if found
;       a0.l : Address of variable in memory
;       a1.l : Address of VAT entry
;---------------------------------------------------
apilib@0046:
_vat_FindHdlEverywhere:
	movem.l d1/d3/a2,-(a7)

	API92_FOLDHDL d0      		;Handle of folder table
	bsr     DEREFd0a0               ;its address
	lea     2(a0),a2                ;Skip first word
	clr.l   d0                      ;Default error value
	move.w  (a2)+,d3                ;Get nb of folders
	beq.s   \exit                   ;If no folder, exit
	subq.w  #1,d3                   ;(for dbra)

\loop   move.w  VATENTRY_HDL(a2),d0     ;Get folder handle
	beq.s   \next                   ;If null, skip
	bsr     _vat_FindHdl
	tst.w   d2
	bne.s   \exit                   ;If var found exit
\next   lea     VATENTRY_SIZE(a2),a2    ;next folder
	dbra.s  d3,\loop
	clr.w   d2                      ;If not found
	clr.w   d0

\exit   movem.l (a7)+,d1/d3/a2
	rts


;---------------------------------------------------
; GetBasicArgString
;Input> d0.w : Handle
;       d1.w : Size of buffer
;       a0.l : Buffer addr
;Out>   a0.l : New addr of arg string
;---------------------------------------------------
_GetBasicArgString:
apilib@0072:
	movem.l d0-d4/a0-a4,-(a7)

	;------------------------------
	; Save variables
	;------------------------------
	move.l  a0,a3
	move.w  d1,d3
	subq.w  #1,d3           ;for the final 0x0

	;------------------------------
	; Check if PRGM/FUNC
	;------------------------------
	bsr     DEREFd0a0
	bsr     _GetFileExt
	cmp.w   #EXT_PRGM,d2
	beq.s   \ok
	cmp.w   #EXT_FUNC,d2
	bne.s   \exit

	;------------------------------
	; Check if compiled or not
	;------------------------------
\ok     clr.l   d0
	move.w  (a0),d0
	lea     0(a0,d0.l),a1

	btst.b  #3,(a1)
	beq.s   \compiled

	;---------------------------
	; not compiled
	;---------------------------
	addq.l  #2,a0
\loop1  move.b  (a0)+,d0
	beq.s   \eos
	cmp.b   #$0D,d0
	beq.s   \eos
	subq.w  #1,d3
	beq.s   \exit
	move.b  d0,(a3)+
	bra.s   \loop1        
\eos    bra.s   \exit

	;---------------------------
	; compiled
	;---------------------------
\compiled move.b  #'(',(a3)+
\loop2  move.b  -(a1),d0
	beq.s   \loop2
	cmp.b   #$E5,d0
	beq.s   \exitloop
	cmp.b   #$1B,d0
	bhi.s   \varname

	bsr     Tag_To_Letter
	subq.w  #1,d3
	beq.s   \exit
	move.b  d0,(a3)+
	subq.w  #1,d3
	beq.s   \exit
	move.b  #',',(a3)+
	bra.s   \loop2

\varname tst.b  -(a1)
	bne.s   \varname                ;look for beginning
	addq.l #1,a1
\copy2  subq.w  #1,d3
	beq.s   \exit
	move.b  (a1)+,(a3)+
	bne.s   \copy2
	move.b  #',',-1(a3)
	subq.l  #1,a1
\bos    tst.b   -(a1)
	bne.s   \bos
	bra.s   \loop2

\exitloop cmp.b #',',-1(a3)
	bne.s   \skip
	subq.l  #1,a3
\skip   move.b #')',(a3)+      ;replace last " , "

\exit   clr.b   (a3)
	movem.l (a7)+,d0-d4/a0-a4
	rts

Tag_To_Letter:
	cmp.b   #$0A,d0
	bhi.s   \skip
	add.b   #112,d0
	bra.s   \exit
\skip   add.b   #86,d0
\exit   rts

;---------------------------------------------------
;       GetFileExt
;
; This function is used to know the extension
; of a file.
; Use the EXT_??? constants of api92cst.h to
; know the extension of the file. (EXT_ASM,
; EXT_GDB, EXT_PIC... )
;
; To get the 4 chars extension name, use the
; ExtIDToStr function or the ExtStrTbl address
;
;input> a0.l : address of the beginning of file
;out>   d2.w : Extension Identifier (ID) of the file
;
;       No Other Register Modified
;---------------------------------------------------
apilib@0014:
_GetFileExt:
	movem.l d0-d1/a0-a1,-(a7)

	clr.l   d0
	move.w  (a0)+,d0        ;size of file
	move.b  -1(a0,d0.l),d1  ;type byte

;First scan if it is a special type
;(Program-Function-Fargo1-Lib1-Fargo2-Lib2
; and matrix-list)

;#ifdef TIPLUS
	cmp.b   #$F3,d1         ;is ASM type ?
	bne.s   \noasm

	moveq.w #EXT_ASM,d2

	cmp.l   #$36386b50,4(a0)
	bne.s   \noexe

	moveq.w #EXT_EXE,d2
	move.w  $0C(a0),d0              ;Check plugin
	bclr.b  #0,d0                   ;avoid word-align error
	adda.w  d0,a0
	cmp.l   #$6014504C,(a0)+
	bne     \exit
	cmp.w   #$5547,(a0)+
	bne     \exit
	moveq.w #EXT_PLUG,d2
	bra     \exit

\noexe  cmp.l   #$36386b4C,4(a0)
	bne     \exit                   ;exit with EXT_ASM
	moveq.w #EXT_LIB,d2
	bra     \exit

\noasm  cmp.b   #$F8,d1
	bne.s   \noperso

	lea     -1-5(a0,d0.l),a1
	tst.b   (a1)+
	bne.s   \noperso
	cmp.b   #'Z',(a1)+
	bne.s   \noperso
	cmp.b   #'I',(a1)+
	bne.s   \noperso
	cmp.b   #'P',(a1)+
	bne.s   \noperso
	tst.b   (a1)+
	bne.s   \noperso

	moveq.w #EXT_ZIP,d2
	bra.s   \exit

\noperso cmp.w   #$2D,d1                 ;STR
	bne.s   \nostr
	moveq.w #EXT_RUNC,d2
	cmp.l   #'CPkP',(a0)
	beq.s   \exit
	cmp.l   #'CPkS',(a0)
	beq.s   \exit
\nostr

;#endif
	cmp.b   #$DC,d1
	bne.s   \noprog

	moveq.w #EXT_PRGM,d2             ;default index (PRGM)
	
	lea     -1(a0,d0.l),a1
\searchtype cmp.b #$E5,-(a1)
	bne.s   \searchtype
	
	cmp.b   #$19,-2(a1)               ;-7(a0,d0.l)
;#ifdef TIPLUS
	beq.s   \exit                     ;if Ti92+ exit with PRGM
;#else
	beq.s   \NoFunc
;#endif
	moveq.w #EXT_FUNC,d2             ;"FUNC" index
	bra     \exit

\NoFunc
;#ifdef TIPLUS
;#else
	cmp.w   #$0032,(a0)
	bne.s   \farg1          ;exit with the default val (PRGM)
	cmp.w   #$444c,6(a0)
	beq.s   \LibTp

	adda.w  #24,a0          ;test if  plugin
	cmp.l   #$6014504C,(a0)+
	bne.s   \asmprog
	cmp.w   #$5547,(a0)+
	bne.s   \asmprog
	moveq.w #EXT_PLUG,d2
	bra.s   \exit

\asmprog moveq.w #EXT_EXE,d2      ;"EXE" index
	bra.s   \exit

\LibTp  moveq.w #EXT_LIB,d2             ;"LIB " index
	bra.s   \exit

\farg1  cmp.w   #$0050,(a0)
	bne.s   \lib1
	moveq.w #EXT_EXE1,d2             ;"EXE1" index
	bra.s   \exit
\lib1   cmp.w   #$004C,(a0)
	bne.s   \exit                   ;exit with def val (PRGM)
	moveq.w #EXT_LIB1,d2             ;"LIB1" index
	bra.s   \exit
;#endif

\noprog cmp.b   #$D9,d1         ;List/Matr
	bne.s   \nomat

	cmp.b   #$0,-2(a0,d0.w)
	bne.s   \nozip
	cmp.b   #$FF,(a0)
	bne.s   \nozip
	moveq.w #EXT_ZIP,d2
	bra.s   \exit
	
\nozip  cmp.b   #$D9,-2(a0,d0.w)
	bne.s   \ListTp
	moveq.w #EXT_MAT,d2              ;"MAT " index
	bra.s   \exit
\ListTp moveq.w #EXT_LIST,d2             ;"LIST" index
	bra.s   \exit
\nomat

;if no special type then loop
	moveq.w #(NB_EXT-1),d2         ;nb types-1
	lea     ExtByte(PC),a0          ;
\loop   cmp.b   (a0)+,d1
	beq.s   \finded
	dbra.s  d2,\loop
	moveq.w #EXT_EXPR,d2           ;if not found -> EXPR

\finded
\exit   movem.l (a7)+,d0-d1/a0-a1
	rts


;---------------------------------------------------
;       ExtID_Str
;
; This function returns the 4 chars null terminated
; string associated with an extension constant.
; (EXT_ASM, EXT_GDB...)
;
; This function is used to keep compatibility
; with the next versions of Api92, while using
; a alphabetic sorted list of extension names.
;
;Input> d2.w : Extension Identifier (ID)
;               (EXT_ASM, EXT_PIC... )
;out>   a1.l : Address of the null terminated 
;               extension name
;
;       No Other Register Modified
;---------------------------------------------------
apilib@0015:
ExtID_Str:
	move.l  d0,-(a7)
	lea     ExtStrIndexTbl(PC),a1
	clr.l   d0
	move.b  0(a1,d2.w),d0           ;id of string
	mulu.w  #5,d0                   ;*5
	lea     ExtTbl(PC),a1           ;string table
	adda.w  d0,a1
	move.l  (a7)+,d0
	rts



;---------------------------------------------------
;       vat_GetExtStr
;
;Input> d0.w : Handle of the file
;       d2.w : Extension Identifier (ID)
;               (EXT_ASM, EXT_PIC... )
;out>   a1.l : Address of the null terminated 
;               extension name
;
;       No Other Register Modified
;---------------------------------------------------
apilib@006C:
_vat_GetExtStr:
	cmp.b   #EXT_OTHER,d2
	bne.s   ExtID_Str
	
	movem.l d0/a0,-(a7)

	bsr     DEREFd0a0
	clr.l   d0
	move.w  (a0),d0
	lea     0(a0,d0.l),a1
\begin  tst.b   -(a1)
	bne.s   \begin
	addq.l  #1,a1

	movem.l (a7)+,d0/a0
	rts


;----------------------------------------------------
;       ExtID_Picture
;
; Return the address of the 8x8 picture associated
; with a extension ID (EXT_ASM, EXT_STR...)
;
;Input> d2.w : Extension ID
;Out>   a0.l : address of the 8x8 pixel picture
;----------------------------------------------------
_ExtID_Picture:
_vat_ExtID_Picture:
apilib@0018:
	movem.l d0-d1/a1,-(a7)
	lea     ExtPicID(PC),a1
	clr.w   d0
	move.b  0(a1,d2.w),d0           ;Picture ID
	lsl.w   #3,d0                   ;d0*8
	lea     ExtGFX(PC),a0
	adda.w  d0,a0
	movem.l (a7)+,d0-d1/a1
	rts


	

EXTGFX_DEFAULT  equ 0
EXTGFX_EXE      equ 1
EXTGFX_PIC      equ 2
EXTGFX_TXT      equ 3
EXTGFX_LIB      equ 4
EXTGFX_ASM      equ 8

;#ifdef TIPLUS

ExtByte dc.b    $FF,$F8,$FF,$E0,$2D,$FF,$FF,$DF,$FF,$E2,$FF,$FF
	dc.b    $DE,$FF,$E1,$FF,$FF,$DD,$FF

filtall dc.b    "ALL ",0

ExtPicID dc.b   EXTGFX_ASM,EXTGFX_DEFAULT,EXTGFX_EXE
	dc.b    EXTGFX_DEFAULT,EXTGFX_DEFAULT,EXTGFX_DEFAULT
	dc.b    EXTGFX_DEFAULT,EXTGFX_LIB,EXTGFX_DEFAULT
	dc.b    EXTGFX_DEFAULT,EXTGFX_DEFAULT,EXTGFX_PIC
	dc.b    EXTGFX_EXE,EXTGFX_DEFAULT,EXTGFX_DEFAULT
	dc.b    EXTGFX_TXT,EXTGFX_DEFAULT,EXTGFX_DEFAULT
	dc.b    EXTGFX_DEFAULT

apilib@0016:
ExtTbl  dc.b    "ASM ",0,"DATA",0,"EXE ",0
	dc.b    "EXPR",0,"FIG ",0,"FUNC",0
	dc.b    "GDB ",0,"LIB ",0,"LIST",0
	dc.b    "MACR",0,"MAT ",0,"PIC ",0
	dc.b    "PLUG",0,"PRGM",0,"RUNC",0,"STR ",0
	dc.b    "TEXT",0,"ZIP ",0,"????",0

apilib@0017:
ExtStrIndexTbl:
	;EXT_ must be sorted in order
	;the number in dc. is the index
	;of the string in the table
	
	dc.b    0       ;EXT_ASM
	dc.b    1       ;EXT_DATA
	dc.b    2       ;EXT_EXE
	dc.b    3       ;EXT_EXPR
	dc.b    4       ;EXT_FIG
	dc.b    5       ;EXT_FUNC
	dc.b    6       ;EXT_GDB
	dc.b    7       ;EXT_LIB
	dc.b    8       ;EXT_LIST
	dc.b    9       ;EXT_MACR
	dc.b    10      ;EXT_MAT
	dc.b    11      ;EXT_PIC
	dc.b    12      ;EXT_PLUG
	dc.b    13      ;EXT_PRGM
	dc.b    15      ;EXT_STR
	dc.b    16      ;EXT_TEXT
	dc.b    17      ;EXT_ZIP
	dc.b    18      ;EXT_OTHER
	dc.b    14      ;EXT_RUNC
;#else

ExtByte dc.b    $F8,$FF,$E0,$2D,$FF,$FF,$DF,$FF,$E2,$FF,$FF,$FF
	dc.b    $DE,$FF,$E1,$FF,$FF,$FF,$DD

ExtPicID dc.b   EXTGFX_DEFAULT,EXTGFX_EXE,EXTGFX_EXE
	dc.b    EXTGFX_DEFAULT,EXTGFX_DEFAULT,EXTGFX_DEFAULT
	dc.b    EXTGFX_DEFAULT,EXTGFX_LIB,EXTGFX_LIB
	dc.b    EXTGFX_DEFAULT,EXTGFX_DEFAULT,EXTGFX_DEFAULT
	dc.b    EXTGFX_PIC,EXTGFX_EXE,EXTGFX_DEFAULT
	dc.b    EXTGFX_DEFAULT,EXTGFX_TXT,EXTGFX_DEFAULT
	dc.b    EXTGFX_DEFAULT

filtall dc.b    "ALL ",0

apilib@0016:
ExtTbl  dc.b    "DATA",0,"EXE ",0,"EXE1",0
	dc.b    "EXPR",0,"FIG ",0,"FUNC",0
	dc.b    "GDB ",0,"LIB ",0,"LIB1",0
	dc.b    "LIST",0,"MACR",0,"MAT ",0
	dc.b    "PIC ",0,"PLUG",0,"PRGM",0
	dc.b    "STR ",0,"TEXT",0,"ZIP ",0
	dc.b    "????",0

apilib@0017:
ExtStrIndexTbl:
	dc.b    0       ;EXT_DATA
	dc.b    1       ;EXT_EXE
	dc.b    2       ;EXT_EXE1       
	dc.b    3       ;EXT_EXPR
	dc.b    4       ;EXT_FIG
	dc.b    5       ;EXT_FUNC
	dc.b    6       ;EXT_GDB
	dc.b    7       ;EXT_LIB
	dc.b    8       ;EXT_LIB1
	dc.b    9       ;EXT_LIST
	dc.b    10      ;EXT_MACR
	dc.b    11      ;EXT_MAT
	dc.b    12      ;EXT_PIC
	dc.b    13      ;EXT_PLUG
	dc.b    14      ;EXT_PRGM
	dc.b    15      ;EXT_STR
	dc.b    16      ;EXT_TEXT
	dc.b    17      ;EXT_ZIP
	dc.b    18      ;EXT_OTHER

;#endif

ExtGFX:
filegfx:
	dc.b    %01111000
	dc.b    %01000100
	dc.b    %01000010
	dc.b    %01000010
	dc.b    %01000010
	dc.b    %01000010
	dc.b    %01111110
	dc.b    %00000000

execgfx
	dc.b    %00000000
	dc.b    %01111110
	dc.b    %01111110
	dc.b    %01000010
	dc.b    %01000010
	dc.b    %01000010
	dc.b    %01111110
	dc.b    %00000000

imggfx:
	dc.b    %01111000
	dc.b    %01000100
	dc.b    %01011010
	dc.b    %01011010
	dc.b    %01011010
	dc.b    %01000010
	dc.b    %01111110
	dc.b    %00000000

txtgfx:
	dc.b    %01111000
	dc.b    %01000100
	dc.b    %01011010
	dc.b    %01000010
	dc.b    %01011010
	dc.b    %01000010
	dc.b    %01111110
	dc.b    %00000000

libgfx:
	dc.b    %00000000
	dc.b    %00111110
	dc.b    %00100010
	dc.b    %11111010
	dc.b    %10001110
	dc.b    %10001000
	dc.b    %11111000
	dc.b    %00000000

; TI92 picture
tigfx:  
	dc.b    %00000000
	dc.b    %01111110
	dc.b    %10100101
	dc.b    %10111101
	dc.b    %10000001
	dc.b    %10000001
	dc.b    %01111110
	dc.b    %00000000

; Folder picture
dirgfx: 
	dc.b    %00000000
	dc.b    %01100000
	dc.b    %10011100
	dc.b    %10000010
	dc.b    %10000010
	dc.b    %10000010
	dc.b    %01111110
	dc.b    %00000000

; Back picture
backgfx:        
	dc.b    %00000000
	dc.b    %00111100
	dc.b    %00011100
	dc.b    %00111100
	dc.b    %01110100
	dc.b    %01100000
	dc.b    %01000000
	dc.b    %00100000


nostubgfx
	dc.b    %00000000
	dc.b    %01111110
	dc.b    %01111110
	dc.b    %01000010
	dc.b    %01011010
	dc.b    %01000010
	dc.b    %01111110
	dc.b    %00000000


	ds.w    0
