;===========================================================
;-----------------------------------------------------------
; 
;	Api92/Api89 Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	Compiled with MultiASM by Aaron Hill
; 	And : 	- Fargo2 for TI-92/TI-92 II
;       	- DoorsOS for TI-92+/TI-89
;
;-----------------------------------------------------------
;===========================================================


;================ TI92 PLUS / TI89 DEFINITION ==============
;#ifdef TIPLUS



VATENTRY_SIZE   equ     14
ENTRY_HDL       equ     12
VATENTRY_HDL	equ     12
VATENTRY_FLG	equ	11

;---------------------- NOSTUB DEFINITION ------------------
;#ifdef NSTUB
		include "os.h"

TIOS_CALL 	macro
			move.l	a4,save_a4
 			move.l 	($C8),a4
 			add.l 	#\1*4,a4
 			move.l 	(a4),a4
 			jsr 	(a4)
			move.l	save_a4(PC),a4
 		endm

TIOS_ADDR	macro
			move.l	a4,save_a4
 			move.l 	($C8),a4
 			add.l 	#\1*4,a4
 			move.l 	(a4),\2
			move.l	save_a4(PC),a4
 		endm

TIOS_LEAADDR	macro	
			move.l	a4,save_a4
 			move.l 	($C8),a4
 			add.l 	#\1*4,a4
 			move.l 	(a4),\2
			move.l	save_a4(PC),a4
 		endm

API92_MAINHDL	macro
			move.w	MainHandle(PC),\1
		endm

API92_FOLDHDL	macro
			move.w	FolderListHandle(PC),\1
		endm

API92_CMPFOLDHDL macro
			cmp.w	FolderListHandle(PC),\1
		endm


save_a4:		dc.l	0
MAINLIST_HDL  equ	0
FOLDERLIST_HDL  equ	0


KEY_PRESSED_FLAG	equ	LCD_MEM+$1c 	;not used

;#ifdef TI89
KEY_DIAMOND		equ	$4000
;#else
KEY_DIAMOND		equ	$2000
;#endif




;---------------------- KERNEL DEDINITION -----------------
;#else
		include	"tios.h"

TIOS_CALL 	macro
			jsr	tios::\1
 		endm

TIOS_ADDR	macro
			move.l	tios::\1,\2
		endm

TIOS_LEAADDR	macro
			lea	tios::\1,\2
		endm

API92_MAINHDL	macro
			move.w	#tios::MainHandle,\1
		endm

API92_FOLDHDL	macro
			move.w	#tios::FolderListHandle,\1
		endm

API92_CMPFOLDHDL macro
			cmp.w	#tios::FolderListHandle,\1
		endm

;#endif


	DEFINE	_version01

	xdef    _library

;#ifdef TI89
	xdef _ti89
	xdef _ti89ti
;#else
	xdef _ti92plus
	xdef _v200
;#endif




;====================== TI92 DEFINITIONS =================
;#else
	include "tios.h"

VATENTRY_SIZE   equ     12
MAINLIST_HDL  	equ	$0C
FOLDERLIST_HDL  equ     $0B
ENTRY_HDL       equ     10
VATENTRY_HDL	equ     10
VATENTRY_FLG	equ	9






;#endif

	



;#ifdef TI89

PAD_UP          equ     337
PAD_DOWN        equ     340
PAD_LEFT        equ     338
PAD_RIGHT       equ     344

LCDWIDTH	equ	160
LCDHEIGHT	equ	100

XO		equ	-40
YO		equ	-5

;#else

PAD_UP          equ     338
PAD_DOWN        equ     344
PAD_LEFT        equ     337
PAD_RIGHT       equ     340

LCDWIDTH	equ	240
LCDHEIGHT	equ	128

XO		equ	0
YO		equ	0

;#endif


	xdef    apilib@0000              ;draw_sWindow
	xdef    apilib@0001              ;draw_Window
	xdef    apilib@0002              ;draw_sString
	xdef    apilib@0003              ;draw_StringSpecial
	xdef    apilib@0004              ;DrawCharSpecial
	xdef    apilib@0005              ;DrawEraseRect
	xdef    apilib@0006              ;SetFont
	xdef    apilib@0007              ;GetFont
	xdef    apilib@0008              ;GetFontWidthHeight
	xdef    apilib@0009              ;InvertArea
	xdef    apilib@000A              ;ScreenToBuffer
	xdef    apilib@000B              ;BufferToScreen

	xdef    apilib@000C              ;DecimalToStr
	xdef    apilib@000D              ;HexaToStr
	xdef    apilib@000E              ;GetFreeRAM
	xdef    apilib@000F              ;DEREFd0a0
	xdef    apilib@0010              ;SetIntVect
	xdef    apilib@0011              ;InputStr

	xdef    apilib@0012              ;GetHWVersion
	xdef    apilib@0013              ;

	xdef    apilib@0014              ;GetFileExt
	xdef    apilib@0015              ;ExtID_Str
	xdef    apilib@0016              ;ExtStrTbl
	xdef    apilib@0017              ;ExtStrIndexTbl
	xdef    apilib@0018              ;ExtID_Picture

	xdef    apilib@0019              ;DecodeEXPRVar
	
	xdef    apilib@001A              ;GetTIOSFileName

	xdef    apilib@001B              ;CopyStr

	xdef    apilib@001C              ;CheckNestedFolders
	xdef    apilib@001D              ;SearchNestedBuffer
	xdef    apilib@001E              ;AddNestedFolder
	xdef    apilib@001F              ;nf_Search
	xdef    apilib@0020              ;IsFolderNested
	xdef    apilib@0021              ;GetNestedCount          

	xdef    apilib@0022              ;array_Add
	xdef    apilib@0023              ;array_Delete
	xdef    apilib@0024              ;array_Create

	xdef    apilib@0025              ;SearchFolder  

	xdef    apilib@0026              ;sInvertArea
	xdef    apilib@0027              ;SaveScreenToPIC

	xdef    apilib@0028              ;vat_FindHdl

	xdef	apilib@0029		;DrawFrameRect
	xdef	apilib@002A		;DrawEraseRect
	xdef	apilib@002B		;WaitKey

	xdef	apilib@002C		;ZapScreen
	xdef	apilib@002D		;ClearScreen

	xdef	apilib@002E		;array_FindItem
	xdef	apilib@002F		;array_Short

	xdef	apilib@0030		;nf_IsParentOf

	xdef	apilib@0031		;InterfaceEngine
	xdef	apilib@0032		;ErrorDialogBox

	xdef	apilib@0033		;array_oCreate
	xdef	apilib@0034		;array_oAddItem
	xdef	apilib@0035		;array_oDeleteItem
	xdef	apilib@0036		;array_fCreate
	xdef	apilib@0037		;array_fAddItem
	xdef	apilib@0038		;array_fDeleteItem

	xdef	apilib@0039		;vat_Find
	xdef	apilib@003A		;vat_FindVarEverywhere
	xdef	apilib@003B		;vat_CopyVar
	xdef	apilib@003C		;vat_MoveVar
	xdef	apilib@003D		;vat_Rename
	xdef	apilib@003E		;vat_CreateFolder
	xdef	apilib@003F		;vat_CreateVar
	xdef	apilib@0040		;vat_DeleteVar
	xdef	apilib@0041		;vat_DeleteFolder
	xdef	apilib@0042		;vat_IsVarInUse
	
	xdef	apilib@0043		;draw_HorizontalLine
	
	xdef	apilib@0044		;ListViewComponent
	xdef	apilib@0045		;MenuComponent

	xdef	apilib@0046		;vat_FindHdlEverywhere
	xdef	apilib@0047		;draw_GFX8x8
	xdef	apilib@0048		;draw_GFX8xn

	xdef	apilib@0049		;EditComponent

	xdef	apilib@004A		;vat_IndexToAddr
	xdef	apilib@004B		;vat_DeleteSelection
	xdef	apilib@004C		;vat_CopySelection
	xdef	apilib@004D		;vat_MoveSelection
	xdef	apilib@004E		;vat_CountSelection
	xdef	apilib@004F		;vat_Delete

	xdef	apilib@0050		;nf_FolderName
	xdef	apilib@0051		;nf_FileName

	xdef	apilib@0052		;SelectFileComponent

	xdef	apilib@0053		;draw_Window2
	xdef	apilib@0054		;draw_sWindow2

	xdef	apilib@0055		;vat_ToggleHide
	xdef	apilib@0056		;vat_ToggleHideSelection
	xdef	apilib@0057		;vat_ToggleLock
	xdef	apilib@0058		;vat_ToggleLockSelection
	xdef	apilib@0059		;vat_ToggleSelect
	xdef	apilib@005A		;vat_SelectAll
	xdef	apilib@005B		;vat_DeselectAll
	
	xdef	apilib@005C		;draw_sAnimedWindow
	xdef	apilib@005D		;draw_sAnimedWindow2

	xdef	apilib@005E		;vat_CreateBuffer

	xdef	apilib@005F		;util_GetAPD
	xdef	apilib@0060		;util_SetAPD

	xdef	apilib@0061		;array_oShort
	xdef	apilib@0062		;array_InsertItem
	xdef	apilib@0063		;array_fInsertItem
	xdef	apilib@0064		;array_oInsertItem

	xdef	apilib@0065		;CheckBoxComponent
	xdef	apilib@0066		;ProgressBarComponent

	xdef	apilib@0067		;vat_ArchiveVar
	xdef	apilib@0068		;vat_UnarchiveVar
	xdef	apilib@0069		;vat_ArchiveSelection
	xdef	apilib@006A		;vat_UnarchiveSelection

	xdef	apilib@006B		;VScrollComponent
	xdef	apilib@006C		;vat_GetExtStr

	xdef	apilib@006D		;RunProg

	xdef	apilib@006E		;nf_GetFolderSize
	xdef	apilib@006F		;nf_DeleteFolder

	xdef	apilib@0070		;util_BatteriesState
	xdef	apilib@0071		;GetFreeArchive

	xdef	apilib@0072		;GetBasicArgString
	xdef	apilib@0073		;ScrollingCaptionComponent

	xdef	apilib@0074		;util_GetKeyInitDelay
	xdef	apilib@0075		;util_GetBetweenKeyDelay

	xdef	apilib@0076		;vat_CopyRRVar
	xdef	apilib@0077		;vat_CopyRRSelection
	xdef	apilib@0078		;vat_MoveRRVar
	xdef	apilib@0079		;vat_MoveRRSelection

	xdef	apilib@007A		;util_GetRequiredLibraries
	xdef	apilib@007B		;util_HeapLock

	xdef 	apilib@007C		;vat_IsAddressInVAT

;************** Start of Fargo library ***************


	include "apilibct.h"


;--------------------------------------------------------------------------
;       InputStr
; 
;Input> a0.l : address of a api92Input structure
;
; Format of api92Input structure
;  x.B : Input Flag
;       xxxxxxx1  -> masked input
;       xxxxxx1x  -> convert lower case
;       xxxxx1xx  -> only '0'..'9'
;
;  x.B : Char used when masked input
;  x.B : Max number of chars
;  x.B : X
;  x.B : Y
;  (xx).b : Buffer where put chars. Must be large
;           enough
;
;Out>   d0.w :  0 if ESC.
;               else nb of chars input
;       a0.l : Address of the beginning of the buffer
;---------------------------------------------------------------------
apilib@0011:
Input:
	movem.l d1-d6/a1-a2,-(a7)

	move.b  (a0)+,d5        ;flag
	move.b  (a0)+,d6        ;a value

	clr.w   d3
	move.b  (a0)+,d3        ;nb char
	clr.w   d4              ;current char   
	
	clr.w   d0
	clr.w   d1
	move.b  (a0)+,d0        ;X
	move.b  (a0)+,d1        ;Y
	move.l  a0,a1           ;save a0
		
	moveq.b #95,d2          ;the '_' char
	bsr     DrawCharSpecial


\WaitKey move.l d0,-(a7)                ;push X
	jsr     _WaitKey         ;get a key
	move.w  d0,d2                   ;key in d2
	move.l  (a7)+,d0                ;pop X

	cmp.w   #13,d2                  ; Enter ?
	beq.s   \enter
	cmp.w   #257,d2                 ; Backspace ?
	beq.s   \BackSp
	cmp.w   #264,d2                 ;ESC ?
	beq.s   \ESC

	btst.b  #2,d5
	beq.s   \nonum
	cmp.w   #'0',d2
	bcs.s   \WaitKey
	cmp.w   #'9',d2
	bhi.s   \WaitKey        

\nonum  btst.b  #1,d5
	beq.s   \nomaj
	cmp.w   #65,d2
	bcs.s   \nomaj
	cmp.w   #90,d2
	bhi.s   \nomaj
	add.w   #32,d2

\nomaj  cmp.w   #255,d2         ;Valid character ?
	bhi.s   \WaitKey        ;if not, loop

	cmp.w   d4,d3           ;Max of characters ?
	beq.s   \WaitKey


	move.b  d2,(a0)+
	btst.b  #0,d5           ;type
	beq.s   \nomasked
	move.b  d6,d2
\nomasked bsr     DrawCharSpecial       
	addq.w  #6,d0           ;X+=6
	moveq.b #95,d2
	bsr     DrawCharSpecial
	addq.w  #1,d4           ;cur nb += 1
	
	bra.s   \WaitKey

\BackSp
	tst.w   d4
	beq.s   \WaitKey

	subq.w  #1,d4
	clr.b   -(a0)

	moveq.b #32,d2          ;' '
	bsr     DrawCharSpecial
	subq.w  #6,d0
	moveq.b #95,d2          ;'_'
	bsr     DrawCharSpecial
	bra     \WaitKey

\enter
	moveq.b #32,d2
	bsr     DrawCharSpecial
	clr.b   (a0)
	move.w  d4,d0
	bra.s   \end

\ESC    clr.w   d0

\end    move.l  a1,a0
	movem.l (a7)+,d1-d6/a1-a2
	rts




apilib@0013:
	rts


	ds.w	0


