;-----------------------------------------------------------
; 
;	Api92/Api89 Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		menu.xas
;	Utility>	A complete menu component
;
;-----------------------------------------------------------


MNU_NBITEM	equ	$0
MNU_X		equ	$2
MNU_Y		equ	$4
MNU_RESERVED	equ	$6
MNU_WIDTH	equ	$8
MNU_FLAG	equ	$0A
MNU_CBKEY	equ	$0C
MNU_CBDRAWITEM	equ	$10
MNU_ITEMPROP	equ	$14
MNU_SHORTKEY	equ	$18

;-----------------------------------------------------
;Input>	a0.l : Address of a api92Menu structure
;	a1.l : Address of data
;Out>	d0.w : if no api92CallBack_Keys function used:
;		d0.w=0 if ESC 
;		else d0.w=1-based index of selection item
;	d1.w : Zero based index of selected item
;	a0.l : Address of selected item
;
;Format of the api92Menu structure :
;	00.w	:	Number of items
;	02.w 	:	X position
;	04.w	:	Y position
;	06.w	:	Reserved (must be 0)
;	08.w	:	Width of the Menu
;	0A.b	:	Flags
;	0B.b	:	Nothing
;	0C.l	:	If not null, address of an 
;			api92CallBack_mnuKeys function
;	10.l	:	Address of an api92CallBack_mnuDrawItem
;			function (used if flag xxxxx1xx is set)
;	14.l	:	If not null, Address of an 
;			api92_lvItemsProperties buffer
;	18.l	:	If not null, address of an 
;			api92_mnuShortCut buffer
;
; Flags :
;	xxxxxxx1 : If set don't draw the rect
;	xxxxxx1x : If set allow the user to jump from the
;			first item to the last with up
;	xxxxx1xx : If set, keep the previous selected item
;
; api92_lvItemsProperties : 
; This buffer is an array of one byte for each item.
; Each byte describe the properties of the item. It
; has the following format :
; 	xxxxxxxO : Enabled (1) / Disabled (0) bit
;	xxxxxxOx : Use Checkbox (1)
;	xxxxxOxx : Checked (1) / Unchecked (0) bit
;
;-----------------------------------------------------
;api92CallBack_mnuDrawItem:
;Input>	d0.w : X position
;	d1.w : Y position
;	d6.w : 0-based index of current item
;	a1.l : Address of current item string
;	a6.l : Address of the api92Menu structure
;		used
;Out>	d0.w : 	If d0.w = 0 : don't use internal drawing
;		of the item
;		If d0.w = 1 : use internal drawing of the
;		item
;-----------------------------------------------------
;api92CallBack_lvKeys:
;Input>	d0.w : ScanCode of key pressed
;	d6.w : 0-based index of selected item
;	a1.l : Address of selected item string
;	a6.l : Address of the api92Menu structure
;		used 
;Out>	d0.w :	If d0.w = 0 : continue
;		If d0.w = $FFFF : Redraw component
;		Else exit component with d0 and d1
;		 values 
;-----------------------------------------------------
apilib@0045:
_MenuComponent:
	movem.l	d2-d7/a1-a6,-(a7)

	suba.w	#LV_STRUCTSIZE+4,a7
	move.l	a7,a2
	move.l	a0,(a2)+		;Push original struct

	move.l	a2,a3			;Save for ListView component
	move.l	a0,a5			;Save
	move.w	(a0),(a2)+		;NbItem
	move.w	(a0)+,(a2)+		;NbItemPerPage
	move.l	(a0)+,(a2)+		;X, Y
	move.w	(a0),(a2)+		;Selected Item Index
	move.w	(a0)+,(a2)+		;Selected Screen Index
	move.w	(a0)+,(a2)+		;Width
	clr.w	(a2)+			;Constant Item Size
	clr.w	(a2)+			;Height of item
	move.w	(a0)+,(a2)+		;Flags
	clr.l	(a2)+			;api92CB_lvKeyDown
	lea	menuCallBack_Keys(PC),a4
	move.l	a4,(a2)+ 		;New CallBack_Keys
	clr.l	(a2)+			;api92CB_lvSelect
	lea	menuCallBack_DrawItem(PC),a4
	move.l	a4,(a2)+		;New CallBack_DrawItem
	move.l	8(a0),(a2)+		;Properties

	move.l	a3,a0
	bsr	_ListViewComponent

	move.w	LV_RESERVED1(a3),MNU_RESERVED(a5)
	move.w	MNU_RESERVED(a5),d1	;selected item

	adda.w	#LV_STRUCTSIZE+4,a7
	movem.l	(a7)+,d2-d7/a1-a6
	rts


menuCallBack_Keys:
	move.l	-4(a6),a6		;Get original struct
	move.l	MNU_CBKEY(a6),a0	;Get Key fct address
	move.l	a0,d2			;Check if function or not
	beq.s	\no_fct
	movem.l	d2-d7/a0-a6,-(a7)
	jsr	(a0)
	movem.l	(a7)+,d2-d7/a0-a6
	tst.w	d0
	bne.s	\exit

\no_fct	cmp.w	#264,d0
	beq.s	\exit

	cmp.w	#13,d0
	bne.s	\noenter
	move.l	MNU_ITEMPROP(a6),a0
	move.l	a0,d2
	beq.s	\enab
	adda.w	d6,a0
	btst.b	#0,(a0)
	beq.s	\noenter
\enab	move.w	d6,d0
	addq.w	#1,d0
	bra.s	\exit

\noenter cmp.w	#PAD_RIGHT,d0		;RIGHT pad
	beq.s	\exit
	cmp.w	#PAD_LEFT,d0		;LEFT pad
	beq.s	\exit

	cmp.w   #49,d0          	;Test if 1..9
	bcs.s   \nochif
	cmp.w   #57,d0
	bhi     \nochif
	sub.w   #49,d0
	cmp.w   (a6),d0
	bhi.s   \nochif			;pas grave si d2-48
	addq.l  #1,d0
	bra.s   \exit			;d0!=0 : exit menu component

\nochif clr.w	d0			;Continue

\exit	rts

menuCallBack_DrawItem:
	move.l	-4(a6),a6		;Get original struct
	move.l	MNU_CBDRAWITEM(a6),a0	;Get DrawItem fct address
	cmp.l	#0,a0
	beq.s	\no_fct			;if null, skip

	movem.l	d1-d7/a0-a6,-(a7)
	jsr	(a0)
	movem.l	(a7)+,d1-d7/a0-a6
	tst.w	d0			;If no internal drawing
	beq.s	\exit			;exit

\no_fct	movem.l	d0-d7/a0-a2,-(a7)
	move.l	MNU_SHORTKEY(a6),a1	;Get addr of ShortKeys
	move.l	a1,d2			;If null, exit
	beq.s	\noShortCut
	add.w	(a1)+,d0		;Add X offset

	tst.w	d6			;If first item, skip
	beq.s	\skip
	subq.w	#1,d6			;Else get ShortKey string
\nexti	tst.b	(a1)+			;if item
	bne.s	\nexti
	dbra.s	d6,\nexti
\skip	bsr	_draw_StringSpecial

\noShortCut
	movem.l	(a7)+,d0-d7/a0-a2
	moveq.w	#1,d0			;Use internal drawing

\exit	rts

