;-----------------------------------------------------------
; 
;	Api92/Api89 Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		nostub.xas
;	Utility>	Support of Nostub 
;
;-----------------------------------------------------------

;#ifdef NSTUB

	xdef	nostub_InitApi92

	xdef	nostub_GetVatHandles
	xdef	nostub_getHeapAddr



	xdef	MainHandle
	xdef	FolderListHandle
	xdef	tios::Heap
	xdef	ROM_VERSION

;-----------------------------------------------------------
; Initialization of NOSTUB version of Api92
;Input>	/
;Out>	d0.w = 0 : error
;-----------------------------------------------------------
	xdef	_main

	dc.l	exportation_table

_main:
nostub_InitApi92:
	move.l	a0,-(a7)

	bsr	nostub_GetVatHandles

	bsr	nostub_getHeapAddr
	move.l	a0,tios::Heap

	bsr	nostub_getRomVersion
	move.w	d0,ROM_VERSION

	move.l	(a7)+,a0
	rts

;-----------------------------------------------------------
; Set VAT Handles
;Input>	/
;Out>	/
;-----------------------------------------------------------
nostub_GetVatHandles:
	movem.l		d0-d2/a0-a2,-(a7)

	pea		HSymMain(pc)		;
	TIOS_CALL	SymFindHome		;
	move.l		d0,(a7)			;
	swap		d0			; 
	move.w		d0,FolderListHandle	;The handle was in the 2nd part of d0
	TIOS_CALL	DerefSym		;
	move.w		12(a0),MainHandle	;
	addq.w		#4,a7			;

	movem.l		(a7)+,d0-d2/a0-a2
	rts

;-----------------------------------------------------------
;Get Address of Heap
;Input>	/
;Out>	a0.l : Address of the Heap
;-----------------------------------------------------------
nostub_getHeapAddr:
	move.l	d0,-(a7)

 	move.l 	($C8),a0
 	add.l 	#DerefSym*4,a0
 	move.l 	(a0),a0
\look	cmp.w	#$2078,(a0)+		;code of movea.l
	bne.s	\look
	clr.l	d0
	move.w	(a0),d0
	move.l	d0,a0
	move.l	(a0),a0

	move.l	(a7)+,d0
	rts

;-----------------------------------------------------------
;Get version of ROM
;Input>	/
;Out>	d0.w : 0 if error, else ROM Version
;	format : bit 7 = 0 if ti89
;		 bit 6 .. bit 4 = Major Version
;		 bit 3 .. bit 0 = Minor Version
;		(example : $0205 = ti89 rom2.05 )
;			   $1203 = ti92+ rom2.03 )
;-----------------------------------------------------------
nostub_getRomVersion:
	movem.l	a0-a2,-(a7)

	move.l	($C8),a2
	lea	tableROM(PC),a0
	lea	tableROMVersion(PC),a1
	moveq.l	#NB_KNOWN_ROM-1,d0

\loop	cmp.l	(a0)+,a2
	beq.s	\found
	addq.l	#2,a1
	dbra.s	d0,\loop
	clr.w	d0
	bra.s	\exit

\found	move.w	(a1),d0			;get rom version

\exit	movem.l	(a7)+,a0-a2
	rts


MainHandle		dc.w	0
FolderListHandle 	dc.w	0
ROM_VERSION		dc.w	0
tios::Heap		dc.l	0

			dc.b	0,"main"
HSymMain		dc.b	0


NB_KNOWN_ROM		equ	13

tableROM:
	dc.l            $478A74,$279578,$478BB4,$278EAC,$478280
	dc.l            $279E02,$479B0E,$279F3A,$479C42,$23A17A,$43A0AE
	dc.l		$23A1C6,$43A0FA
tableROMVersion:
	dc.w            $1100,$0100,$1101,$0105,$1105,$0201 
	dc.w            $1201,$0203,$1203,$0204,$1204,$0205
	dc.w		$1205


exportation_table:
	dc.l    api92@0000              ;draw_sWindow
	dc.l    api92@0001              ;draw_Window
	dc.l    api92@0002              ;draw_sString
	dc.l    api92@0003              ;draw_StringSpecial
	dc.l    api92@0004              ;DrawCharSpecial
	dc.l    api92@0005              ;DrawEraseRect
	dc.l    api92@0006              ;SetFont
	dc.l    api92@0007              ;GetFont
	dc.l    api92@0008              ;GetFontWidthHeight
	dc.l    api92@0009              ;InvertArea
	dc.l    api92@000A              ;ScreenToBuffer
	dc.l    api92@000B              ;BufferToScreen

	dc.l    api92@000C              ;DecimalToStr
	dc.l    api92@000D              ;HexaToStr
	dc.l    api92@000E              ;GetFreeRAM
	dc.l    api92@000F              ;DEREFd0a0
	dc.l    api92@0010              ;SetIntVect
	dc.l    api92@0011              ;InputStr

	dc.l    api92@0012              ;GetHWVersion
	dc.l    api92@0013              ;

	dc.l    api92@0014              ;GetFileExt
	dc.l    api92@0015              ;ExtID_Str
	dc.l    api92@0016              ;ExtStrTbl
	dc.l    api92@0017              ;ExtStrIndexTbl
	dc.l    api92@0018              ;ExtID_Picture

	dc.l    api92@0019              ;DecodeEXPRVar
	
	dc.l    api92@001A              ;GetTIOSFileName

	dc.l    api92@001B              ;CopyStr

	dc.l    api92@001C              ;CheckNestedFolders
	dc.l    api92@001D              ;SearchNestedBuffer
	dc.l    api92@001E              ;AddNestedFolder
	dc.l    api92@001F              ;nf_Search
	dc.l    api92@0020              ;IsFolderNested
	dc.l    api92@0021              ;GetNestedCount          

	dc.l    api92@0022              ;array_Add
	dc.l    api92@0023              ;array_Delete
	dc.l    api92@0024              ;array_Create

	dc.l    api92@0025              ;SearchFolder  

	dc.l    api92@0026              ;sInvertArea
	dc.l    api92@0027              ;SaveScreenToPIC

	dc.l    api92@0028              ;vat_FindHdl

	dc.l	api92@0029		;DrawFrameRect
	dc.l	api92@002A		;DrawEraseRect
	dc.l	api92@002B		;WaitKey

	dc.l	api92@002C		;ZapScreen
	dc.l	api92@002D		;ClearScreen

	dc.l	api92@002E		;array_FindItem
	dc.l	api92@002F		;array_Short

	dc.l	api92@0030		;nf_IsParentOf

	dc.l	api92@0031		;InterfaceEngine
	dc.l	api92@0032		;ErrorDialogBox

	dc.l	api92@0033		;array_oCreate
	dc.l	api92@0034		;array_oAddItem
	dc.l	api92@0035		;array_oDeleteItem
	dc.l	api92@0036		;array_fCreate
	dc.l	api92@0037		;array_fAddItem
	dc.l	api92@0038		;array_fDeleteItem

	dc.l	api92@0039		;vat_Find
	dc.l	api92@003A		;vat_FindVarEverywhere
	dc.l	api92@003B		;vat_CopyVar
	dc.l	api92@003C		;vat_MoveVar
	dc.l	api92@003D		;vat_Rename
	dc.l	api92@003E		;vat_CreateFolder
	dc.l	api92@003F		;vat_CreateVar
	dc.l	api92@0040		;vat_DeleteVar
	dc.l	api92@0041		;vat_DeleteFolder
	dc.l	api92@0042		;vat_IsVarInUse
	
	dc.l	api92@0043		;draw_HorizontalLine
	
	dc.l	api92@0044		;ListViewComponent
	dc.l	api92@0045		;MenuComponent

	dc.l	api92@0046		;vat_FindHdlEverywhere
	dc.l	api92@0047		;draw_GFX8x8
	dc.l	api92@0048		;draw_GFX8xn

	dc.l	api92@0049		;EditComponent

	dc.l	api92@004A		;vat_IndexToAddr
	dc.l	api92@004B		;vat_DeleteSelection
	dc.l	api92@004C		;vat_CopySelection
	dc.l	api92@004D		;vat_MoveSelection
	dc.l	api92@004E		;vat_CountSelection
	dc.l	api92@004F		;vat_Delete

	dc.l	api92@0050		;nf_FolderName
	dc.l	api92@0051		;nf_FileName

	dc.l	api92@0052		;SelectFileComponent

	dc.l	api92@0053		;draw_Window2
	dc.l	api92@0054		;draw_sWindow2

	dc.l	api92@0055		;vat_ToggleHide
	dc.l	api92@0056		;vat_ToggleHideSelection
	dc.l	api92@0057		;vat_ToggleLock
	dc.l	api92@0058		;vat_ToggleLockSelection
	dc.l	api92@0059		;vat_ToggleSelect
	dc.l	api92@005A		;vat_SelectAll
	dc.l	api92@005B		;vat_DeselectAll
	
	dc.l	api92@005C		;draw_sAnimedWindow
	dc.l	api92@005D		;draw_sAnimedWindow2

	dc.l	api92@005E		;vat_CreateBuffer

	dc.l	api92@005F		;util_GetAPD
	dc.l	api92@0060		;util_SetAPD

	dc.l	api92@0061		;array_oShort
	dc.l	api92@0062		;array_InsertItem
	dc.l	api92@0063		;array_fInsertItem
	dc.l	api92@0064		;array_oInsertItem

	dc.l	api92@0065		;CheckBoxComponent
	dc.l	api92@0066		;ProgressBarComponent

	dc.l	api92@0067		;vat_ArchiveVar
	dc.l	api92@0068		;vat_UnarchiveVar
	dc.l	api92@0069		;vat_ArchiveSelection
	dc.l	api92@006A		;vat_UnarchiveSelection

	dc.l	api92@006B		;VScrollComponent
	dc.l	api92@006C		;vat_GetExtStr

	dc.l	api92@006D		;RunProg

	dc.l	api92@006E		;nf_GetFolderSize
	dc.l	api92@006F		;nf_DeleteFolder

	dc.l	api92@0070		;util_BatteriesState
	dc.l	api92@0071		;GetFreeArchive

	dc.l	api92@0072		;GetBasicArgString
	dc.l	api92@0073		;ScrollingCaptionComponent

	dc.l	api92@0074		;util_GetKeyInitDelay
	dc.l	api92@0075		;util_GetBetweenKeyDelay

	dc.l	api92@0076		;vat_CopyRRVar
	dc.l	api92@0077		;vat_CopyRRSelection
	dc.l	api92@0078		;vat_MoveRRVar
	dc.l	api92@0079		;vat_MoveRRSelection

;#endif
