;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		associate.mdl
;	Utility>	Associate Window
;-----------------------------------------------------------


ASSOITEM_SIZE	equ	20

; 4+1 : Extension
; 8+1 : prog
; 2   : flag
; 4   : signature

;-----------------------------------------------------------
; Associate Window
;-----------------------------------------------------------
AssociateWindow:

	;-----------------------------------
	; Show Window
	;-----------------------------------
	bsr	SetAnimatedState	;make animation if needed
\rd	lea	win_Associate(PC),a0
	bsr	InterfaceEngine
	clr.b	1(a0)			;clear animation

	;-----------------------------------
	; Get Array addr
	;-----------------------------------
	bsr	CFG_AssoAddr
	tst.w	d0			;Check if error
	beq.s	\exit

	;-----------------------------------
	; Show ListView component
	;-----------------------------------
	move.l	a0,a1
	lea	header_Asso(PC),a0
	move.w	(a1)+,(a0)
	bne.s	\notempty
	move.w	#1,(a0)
	subq.w	#2,a1			;have an empty word
\notempty jsr	apilib::ListViewComponent
	cmp.w	#264,d0
	beq.s	\exit

	;-----------------------------------
	; Key Management
	;-----------------------------------
	cmp.w	#257,d0
	bne.s	\nodel
	bsr	DelAsso
	bra.s	\rd	
\nodel	cmp.w	#KASSO_ADD,d0
	bne.s	\exit
	bsr	AddAsso
	bra.s	\rd

\exit	rts


;-----------------------------------------------------------
; Draw an association 
;-----------------------------------------------------------
asso_lvDrawItem:
	tst.w	(a1)				;empty ?
	bne.s	\draw
	
	;-------------------------------------------------
	; If no association set draw 'no association'
	;-------------------------------------------------
	lea	asso_empty(PC),a1
	jsr	apilib::draw_StringSpecial
	bra.s	\exit	

	;-------------------------------------------------
	; Else draw string at a1.l = ASSO EXTENSION
	;-------------------------------------------------
\draw	jsr	apilib::draw_StringSpecial	;draw ext

	;-------------------------------------------------
	; Draw associated program
	;-------------------------------------------------
	lea	5(a1),a1
	add.w	#40,d0				;X
	jsr	apilib::draw_StringSpecial	;draw prog

	;-------------------------------------------------
	; Draw or not 'P' = Parameters
	;-------------------------------------------------
	add.w	#60,d0
	tst.b	9(a1)
	beq.s	\noparam
	moveq.w	#'P',d2
	jsr	apilib::draw_CharSpecial

	;-------------------------------------------------
	; Draw or not 'S' = signature
	;-------------------------------------------------
\noparam add.w	#10,d0
	tst.b	10(a1)
	beq.s	\exit
	moveq.w	#'S',d2
	jsr	apilib::draw_CharSpecial

\exit	clr.w	d0				;don't use internal drawing
	rts



;-----------------------------------------------------------
; Key handler of ListView for association
;-----------------------------------------------------------
asso_lvKey:
	cmp.w	#KASSO_ADD,d0
	beq.s	\exit
	cmp.w	#257,d0
	bne.s	\nodel
	move.w	d6,d1
	bra.s	\exit
\nodel	cmp.w	#264,d0
	beq.s	\exit
	clr.w	d0		;continue
	clr.w	d1
\exit	rts



;-----------------------------------------------------------
; Add association
;-----------------------------------------------------------
_use_sign	dc.w	0
AddAsso:
	;-------------------------------------------------
	; Get and save if we can use signature
	;-------------------------------------------------
	bsr	CanUseSign
	move.w	d0,_use_sign

	;-------------------------------------------------
	;  Show Add Association window
	;-------------------------------------------------
	lea	win_AddAsso(PC),a0
	bsr	InterfaceEngine
	bsr	RedrawAssoCB
	moveq.w	#1,d1
	bsr	FontSet

	;-------------------------------------------------
	; Use Edit Component for Extension
	;-------------------------------------------------
	suba.w	#ASSOITEM_SIZE+2,a7
	move.l	a7,a1
	lea	asso_Ext(PC),a0
	jsr	apilib::EditComponent
	tst.w	d0
	beq.s	\exit

	;-------------------------------------------------
	; Use Edit Component for associated prog
	;-------------------------------------------------
	addq.l	#5,a1
	lea	asso_Prog(PC),a0
	jsr	apilib::EditComponent
	tst.w	d0
	beq.s	\exit

	;-------------------------------------------------
	; Create the flag
	;-------------------------------------------------
	clr.w	d0
	move.b	asso_ParamCB(PC),d0
	lsl.w	#8,d0
	move.b	asso_SignCB(PC),d0		; Param | Sign
	move.w	d0,14(a7)
	tst.b	d0
	beq.s	\nosign
	bsr	CanUseSign			;Check if we can use sign
	tst.w	d0
	bne.s	\usesign
	clr.b	14(a7)				;clear signature byte
	bra.s	\nosign
	;----------------------------------------------
	; GetCurrentVATAddr is called only if CanUseSign
	; returned true, so if d6<>0 so OK
	;----------------------------------------------
\usesign bsr	GetCurrentVATAddr
	move.w	VAT_ENTRYHDL(a0),d0
	bsr	DEREFd0a0			;get current file addr
	move.l	2(a0),16(a7)			;save sign

	;-------------------------------------------------
	; Get addr of ASSOCIATION in data file
	;-------------------------------------------------
\nosign	bsr	CFG_AssoAddr			;get file handle
	tst.w	d0
	beq.s	\exit

	;-------------------------------------------------
	; Add Association
	;-------------------------------------------------
	moveq.w	#ASSOITEM_SIZE,d1
	moveq.w	#(PCT_DATA-PCT_SAVED_DATA)+2+CFGFILE_SLENGTH,d2		;offset (see cfgfile.mdl)
	move.l	a7,a0
	jsr	apilib::array_fAddItem

\exit	adda.w	#ASSOITEM_SIZE+2,a7
	rts


;-----------------------------------------------------------
;Input>	d1.w : item index
;-----------------------------------------------------------
DelAsso:
	movem.l	d0-d4/a0,-(a7)

	move.w	d1,d3			;index
	bsr	CFG_AssoAddr
	move.w	d0,d4			;save handle
	beq.s	\exit
	tst.w	(a0)			;check if nb items
	beq.s	\exit
	moveq.w	#(PCT_DATA-PCT_SAVED_DATA)+2+CFGFILE_SLENGTH,d2	;offset
	moveq.w	#ASSOITEM_SIZE,d1

	lea	win_DelAsso(PC),a0
	bsr	InterfaceEngine
\loop	bsr	GetKey
	cmp.w	#264,d0
	beq.s	\exit
	cmp.w	#13,d0
	bne.s	\loop

	move.w	d4,d0			;restore handle	
	jsr	apilib::array_fDeleteItem

\exit	movem.l	(a7)+,d0-d4/a0
	rts


;-----------------------------------------------------------
; Routine that dertermine if we can use signature or not,
; according to the selected item
;Out>	d0.w : 	0 = false
;		else ok
;-----------------------------------------------------------
CanUseSign:
	movem.l	d1-d2/a0-a2,-(a7)

	clr.w	d0
	btst.b	#0,S_MODE(a6)			;Check if true VAT
	beq.s	\exit
	tst.w	d6				;first item selected ?
	beq.s	\exit
	bsr	GetCurrentVATAddr
	btst.b	#7,VAT_ENTRYFLAG(a0)		;check if folder
	bne.s	\exit
	tst.w	VAT_ENTRYHDL(a0)
	beq.s	\exit

	moveq.w	#1,d0
\exit	movem.l	(a7)+,d1-d2/a0-a2
	rts

;-----------------------------------------------------------
; Routine that redraw CheckBoxes
;-----------------------------------------------------------
RedrawAssoCB:
	movem.l	d0-d1/a0,-(a7)

	clr.w	d1
	bsr	FontSet

	bsr	CanUseSign
	tst.w	d0
	beq.s	as_ns

as_rd2:	lea	asso_SignCB(PC),a0
	jsr	apilib::CheckBoxComponent
as_ns	lea	asso_ParamCB(PC),a0
	jsr	apilib::CheckBoxComponent

	moveq.w	#1,d1
	bsr	FontSet

	movem.l	(a7)+,d0-d1/a0
	rts

RedrawAssoCB_ed:
	movem.l	d0-d1/a0,-(a7)

	clr.w	d1
	bsr	FontSet

	tst.w	_use_sign
	beq.s	as_ns
	bra.s	as_rd2


;------------------------------------------------
; Convert in lower case
;Input>	d0.w : char
;Out>	d0.w : char
;------------------------------------------------
CharLowerCase:
	cmp.w	#'A',d0
	bcs.s	\skip
	cmp.w	#'Z',d0
	bhi.s	\skip
	sub.w	#'A'-'a',d0
\skip	rts

;-----------------------------------------------------------
; d2 : EXTID of current file
; d0 : file handle
;-----------------------------------------------------------
ExecAssociate:
	movem.l	d0-d4/a0-a4,-(a7)

	btst.b	#0,S_MODE(a6)			;Check if true VAT
	beq.s	\exit
	tst.w	d6
	beq.s	\exit

	move.w	d0,d4
	bsr	DEREFd0a0
	lea	2(a0),a4		;save file addr

	;---------------------------------
	; Get current file ext string in a1
	;---------------------------------
	jsr	apilib::vat_GetExtStr
	
	;---------------------------------
	; look for pctasso file addr
	;---------------------------------
\noadv	bsr	CFG_AssoAddr
	tst.w	d0
	beq.s	\exit

	move.w	(a0)+,d3		;nb ext
	beq.s	\exit
	subq.w	#1,d3

	;---------------------------------
	; look for extension :
	; compare strings
	;---------------------------------
\loop	move.l	a1,a3
	move.l	a0,a2
\cmp	tst.b	(a2)
	beq.s	\run
	clr.l	d0			;convert in lower case
	clr.l	d1
	move.b	(a3)+,d0
	bsr	CharLowerCase
	move.w	d0,d1
	move.b	(a2)+,d0
	bsr	CharLowerCase

	cmp.b	d0,d1
	beq.s	\cmp

	lea	ASSOITEM_SIZE(a0),a0
	dbra.s	d3,\loop

\exit	movem.l	(a7)+,d0-d4/a0-a4
	rts

	;---------------------------------
	; Here a valid association has been
	; found. Exec it 
	;---------------------------------
\run	tst.b	15(a0)			;signature or not ?
	beq.s	\nosign
	move.l	16(a0),d0		;signature
	cmp.l	(a4),d0			;check signature
	bne.s	\exit

	;---------------------------------
	; Basic-Like Parameters
	;---------------------------------
\nosign	tst.b	14(a0)
	beq.s	\tips

	;---------------------------------
	; Firstly, find prog handle
	; and gets its handle
	;---------------------------------
	addq.l	#5,a0
	jsr	apilib::vat_FindVarEverywhere 	;get Var hdl
	tst.w	d2				;if not found, exit
	beq.s	\exit
	move.w  VAT_ENTRYHDL(a1),d3		;d3=hdl of prog

	;---------------------------------
	; Then get the TIOS file name
	; ( folder\file ) of the current
	; selected file (hdl:d4)
	;---------------------------------
	suba.w	#22+(22+20+4),a7
	move.w	d4,d0
	move.l	a7,a0
	move.b	#'"',(a0)+
	jsr	apilib::GetTIOSFileName
	tst.w	d0
	beq.s	\exexec

	subq.l	#1,a0				;start at " char
	move.l	a0,a1
\eos	tst.b	(a1)+				;find end of string
	bne.s	\eos
	move.b	#'"',-1(a1)			;add " char at the end
	clr.b	(a1)

	;---------------------------------
	; if no error, build complete
	; command line :
	; folder\viewer(folder\file) 
	;---------------------------------
	move.w	d3,d0				;file to run
	move.l	a0,a1				;with that args
	lea	20(a7),a0			;buffer
	bsr	BuildCommandLine	
	tst.w	d0
	beq.s	\exexec

	;---------------------------------
	; if no error, exec the prog
	;---------------------------------
	jsr	apilib::ClearScreen
	move.l	a0,-(a7)
	jsr	apilib::RunProg
	addq.l	#4,a7
	move.w	d0,-(a7)		;HRESULT from RunProg
	beq.s	\nodel
	bsr	_HeapFree
\nodel	addq.l	#2,a7
	bsr	DelTmpIfArchived
	bsr   RedrawScreen
\exexec	adda.w	#22+(22+20+4),a7
	bra	\exit

	;---------------------------------
	; Here exec a viewer with the tips
	; found by Sacha Kaercher and me.
	;---------------------------------
\tips	addq.l	#5,a0			;get viewer string
	bsr	ExecViewer		;d4 already set
	bra	\exit	




asso_Ext:
	dc.w	120+XO,55+YO
	dc.w	4
	dc.b	0,%00000010
	dc.l	asso_edKD,0

asso_Prog:
	dc.w	120+XO,63+YO
	dc.w	8
	dc.b	0,%00000001
	dc.l	asso_edKD,0

asso_edKD:
	cmp.w	#KASSO_SIGN,d0
	bne.s	\nosign
	bchg.b	#0,asso_SignCB
	bra.s	\rd
\nosign cmp.w	#KASSO_PARAM,d0
	bne.s	\exit
	bchg.b	#0,asso_ParamCB
\rd	bsr	RedrawAssoCB_ed
	clr.w	d0
\exit	clr.w	d1		;continue
	rts



header_Asso:
	dc.w	0			;NbItem
	dc.w	4
	dc.w	52+XO,42+YO
	dc.l	0
	dc.w	128
	dc.w	ASSOITEM_SIZE
	dc.w	0
	dc.b	%01000010,0
	dc.l	0,asso_lvKey,0,asso_lvDrawItem,0



DefaultAssoFile:
;#ifdef TIPLUS
	dc.w	4
;#else
	dc.w	1
;#endif

	dc.b	"TEXT",0
;#ifdef TIPLUS
	dc.b	"txtrider",0
;#else
	dc.b	"xetal",0,0,0,0
;#endif
	dc.w	0
	dc.l	0

;#ifdef TIPLUS
	dc.b	"EBK",0,0
	dc.b	"ebook",0,0,0,0
	dc.w	$0100
	dc.l	0

	dc.b	"RUNC",0
	dc.b	"runc",0,0,0,0,0
	dc.w	$0000
	dc.l	0

	dc.b	"PPG",0,0
	dc.b	"ttstart",0,0
	dc.w	$0100
	dc.l	0

;#endif
end_DefaultAssoFile

	ds.w	0