;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		setup.mdl
;	Utility>	Setup Window
;
;-----------------------------------------------------------


;-----------------------------------------------------------
; Setup Window
;-----------------------------------------------------------
SetupWindow:
	;---------------------------------------
	; Draw interface and listview component
	;---------------------------------------
	bsr	SetAnimatedState	;make animation if needed

\draw_lv lea	ieOptionWin(PC),a0
	bsr	InterfaceEngine
	clr.b	1(a0)

	lea	OptionHeader(PC),a0
	lea	OptionData(PC),a1
	move.l	#apilib::ListViewComponent,a3
	bsr	_drawmnu

	cmp.w	#$2121,d1
	beq.s	\draw_lv

	cmp.w	#13,d0
	bne.s	\noasso
	cmp.w	#4,d1
	bne.s	\noasso
	bsr	AssociateWindow
	bra.s	\exit
\noasso

	;---------------------------------------
	; Check if new style
	;---------------------------------------
	bsr	SetNewVarStyleIfNeeded

	;---------------------------------------
	; Return to main loop
	;---------------------------------------
\exit	bra	LoopRDListArea


;-----------------------------------------------------------
; api92CB_lvKey called by the Option menu
;-----------------------------------------------------------
OptionKeys:
	cmp.w	#264,d0
	beq.s	\exit
	cmp.w   #13,d0
	bne.s   \noenter

	tst.w	d6
	beq.s	\filter
	cmp.w 	#1,d6
	beq.s	\style
	cmp.w   #2,d6
	beq.s   \shortby
	cmp.w	#3,d6
	beq.s	\setpass
	cmp.w	#4,d6			;associations
	beq	\exit
	cmp.w	#5,d6
	beq	\interface
	bra.s	\exit

\noenter cmp.w  #PAD_RIGHT,d0
	bne.s   \noright
	cmp.w   #1,d6
	beq.s   \style
	cmp.w   #2,d6
	beq.s   \shortby

\noright clr.w	d0			;continue
\exit	move.w	d6,d1
	lea	ieOptionWin+1(PC),a0
	clr.b	(a0)
	rts


\shortby lea    mnuShortByHeader(PC),a0
	lea     mnuShortByData(PC),a1
	bsr	DrawSubmenu
\goex	moveq.w  #$2,d0			;exit ListView component
	move.w	#$2121,d6		;and redraw
	bra.s   \exit

\style	lea     mnuStyleHeader(PC),a0
	lea     mnuStyleData(PC),a1
	bsr	DrawSubmenu
	bra.s   \goex

\filter	bsr	FilterWindow
	bra.s	\goex

\setpass bsr     SetPasswordWin
	bra.s	\goex

\interface
	lea	ieOptionWin(PC),a0
	bsr	InterfaceEngine
	moveq.w	#0,d1
	bsr	FontSet
	lea	optInterfaceHeader(PC),a0
	lea	InterfaceData(PC),a1
	jsr	apilib::ListViewComponent
	moveq.w	#1,d1
	bsr	FontSet
	bsr	SetMenuMemState
	bsr	SetAnimatedState
	bra	\goex


DrawSubmenu:
	move.l	a3,-(a7)
	move.l	#apilib::MenuComponent,a3
	bsr	_drawmnu
	move.l	(a7)+,a3
	rts

;-----------------------------------------------------------
; api92CB_lvKey called by 'Short By' menu
;-----------------------------------------------------------
mnuShortByCBKey:
	cmp.w   #13,d0
	bne.s   \noenter

	move.l  $14(a6),a0
	bclr.b  #2,(a0)
	bclr.b  #2,1(a0)
	bclr.b  #2,2(a0)
	bclr.b  #2,3(a0)
 
\noenter cmp.w  #264,d0
	beq.s   \exit
	cmp.w   #PAD_LEFT,d0
	beq.s   \exit
	clr.w   d0
\exit   rts


;---------------------------------------------------------
;Input>	d0.w : Animated State
;---------------------------------------------------------
SetAnimatedState:
	clr.w	d0
	btst.b	#2,optIProperties+1(PC)
	beq.s	\noanim
	moveq.w	#ANIMTIMER,d0
\noanim	bsr	_SetAnimatedState
	rts


_SetAnimatedState:
	move.b	d0,winRename+1
	move.b	d0,winNewFolder+1
	move.b	d0,winDelete+1
	move.b	d0,winCopy+1
	move.b	d0,winMove+1
	move.b	d0,winExecB+1
	move.b	d0,winAbout+1
	move.b	d0,winLicense+1
	move.b	d0,winFilter+1
	move.b	d0,ieSaveFilter+1
	move.b	d0,ieSystInfo+1
	move.b	d0,ieErrorCatcher+1
	move.b	d0,ieErrorCatcher2+1
	move.b	d0,winPassword+1
	move.b	d0,winPassResult+1
	move.b	d0,winNoPass+1
	move.b	d0,ieOptionWin+1
	move.b	d0,win_Associate+1
	move.b	d0,win_AddAsso+1
	move.b	d0,win_DelAsso+1
	move.b	d0,ieLinkErrorCatcher+1
	move.b	d0,ieReceiveDirectory+1
	move.b	d0,ieInvalidCalc+1
	rts

;---------------------------------------------------------
;---------------------------------------------------------
SetMenuMemState:
	btst.b	#2,optIProperties(PC)
	beq.s	\nosave
	bset.b	#2,mnuToolsHeader+10
	bset.b	#2,mnuSecureHeader+10
	bset.b	#2,mnuFileHeader+10
	bra.s	\exit

\nosave	bclr.b	#2,mnuToolsHeader+10
	bclr.b	#2,mnuSecureHeader+10
	bclr.b	#2,mnuFileHeader+10

\exit	rts


OptionHeader:
	dc.w	6			;NbItem
	dc.w	5			;NbItemPerPage
	dc.w	XO+67			;X
	dc.w	YO+42			;Y
	dc.l	0			;reserved
	dc.w	98			;Width
	dc.w	0			;Constant size of each item
	dc.w	0			;Constant height
	dc.b	%01000110,0		;flags
	dc.l	0
	dc.l	OptionKeys
	dc.l	0
	dc.l	0
	dc.l	0

optInterfaceHeader:
	dc.w	2			;NbItem
	dc.w	5			;NbItemPerPage
	dc.w	XO+68			;X
	dc.w	YO+46			;Y
	dc.l	0			;reserved
	dc.w	102			;Width
	dc.w	0			;Constant size of each item
	dc.w	0			;Constant height
	dc.b	%00000111,0		;flags
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	optIProperties


	ds.w    0
mnuShortByHeader:
	dc.w	4                       ;NbItems
	dc.w    XO+72+60+XO,YO+50+5        ;X,Y
	dc.w    0                       ;Save Position
	dc.w    70                      ;Width
	dc.b    %00000110
	dc.b    0
	dc.l    mnuShortByCBKey         ;Keys
	dc.l    0                       ;DrawItem
	dc.l    mnuShortByProperties    ;Properties
	dc.l    0                       ;ShortCut

	ds.w    0

mnuStyleHeader:
	dc.w    3                       ;NbItems
	dc.w    XO+72+60+XO,YO+50+5        ;X,Y
	dc.w    0                       ;Save Position
	dc.w    70                      ;Width
	dc.b    %00000110
	dc.b    0
	dc.l    mnuShortByCBKey         ;Keys
	dc.l    0                       ;DrawItem
	dc.l    mnuStyleProperties      ;Properties
	dc.l    0                       ;ShortCut

	ds.w	0

