NBSTYLE	equ	2
NBSHORTBY equ	4

;#ifdef TIPLUS
NB_ADV	equ	7
;#else
NB_ADV	equ	5
;#endif

;#ifdef TIPLUS
FALIGN	equ	0
;#else
FALIGN	equ	0
;#endif

FILTERENTRY_SIZE	equ	14+NB_EXT+NB_ADV+NBSHORTBY+FALIGN+NBSTYLE
FILTERVAR_OFFSET	equ	2+2*6

;-------------------------------------------------------
; This file contains the routines which draw the
; Filter Window of PCTOOLS 98
;-------------------------------------------------------
FilterWindow:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SetAnimatedState	;make animation if needed

	;-------------------------------------
	; Draw interface
	;-------------------------------------	
\Loop	lea	winFilter(PC),a0
	bsr	InterfaceEngine
	clr.b	1(a0)			;remove animation
	lea	FilterMenuHeader(PC),a0
	lea	FilterMenuData(PC),a1
	jsr	apilib::MenuComponent

	cmp.w	#1,d0
	beq.s	\filter
	cmp.w	#2,d0
	beq.s	\afilter
	cmp.w	#4,d0
	beq	\savef
	cmp.w	#5,d0
	beq	\delf

\exit	movem.l	(a7)+,d0-d7/a0-a6
	rts


;------------------------------------------------------------
; Extension filters
;------------------------------------------------------------	
\filter	clr.w	d1
	bsr	FontSet
	lea	FilterHeader(PC),a0
	lea	apilib::vat_ExtStrTbl,a1
	jsr	apilib::ListViewComponent
	moveq.w	#1,d1
	bsr	FontSet
	bra	\Loop

;------------------------------------------------------------
; Advanced Filters
;------------------------------------------------------------
\afilter clr.w	d1
	bsr	FontSet
	lea	AdvFilterHeader(PC),a0
	lea	AdvFilterData(PC),a1
	jsr	apilib::ListViewComponent
	moveq.w	#1,d1
	bsr	FontSet
	bra	\Loop

;------------------------------------------------------------
; Save Filter 
;------------------------------------------------------------
\savef	lea	ieSaveFilter(PC),a0
	bsr	InterfaceEngine

	;-------------------------------------
	; Enter filter name
	;-------------------------------------
	suba.w	#FILTERENTRY_SIZE,a7
	move.l	a7,a1				;addr of buffer
	lea	FilterEditHeader(PC),a0
	jsr	apilib::EditComponent
	tst.w	d0				;esc ?
	beq.s	\ex2

	;-------------------------------------
	; Save data in a buffer
	;-------------------------------------
	adda.w	#14,a1				;skip name
	lea	FilterProperties(PC),a0		;copy filter prop
	moveq.w	#NB_EXT-1,d0
\copy	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy
	lea	AdvFilterProperties(PC),a0	;copy adv filter
	moveq.w	#NB_ADV-1,d0
\copy2	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy2
	lea	mnuShortByProperties(PC),a0	;copy ShortBy filter
	moveq.w	#NBSHORTBY-1,d0
\copy6	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy6
	lea	mnuStyleProperties(PC),a0
	moveq.w	#NBSTYLE-1,d0
\copy4	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy4

	;-------------------------------------
	; Get Handle of file
	;-------------------------------------
	bsr	CFG_FilterAddr
	tst.w	d0
	beq.s	\ex2

	;-------------------------------------
	; Add item
	;-------------------------------------
	move.l	a7,a0	
	moveq.w	#FILTERENTRY_SIZE,d1
	bsr	CFG_FilterOffset		;return offset in d2
	jsr	apilib::array_fAddItem
	cmp.w	#EC_OUTOFMEMORY,d1
	beq	MemoryCatcher

\ex2	adda.w	#FILTERENTRY_SIZE,a7
	bra	\Loop


;------------------------------------------------------------
; Delete Filter
;------------------------------------------------------------
\delf	lea	SavedFilterHeader+4(PC),a1
	move.l	#(82+XO)*65536+46+YO,(a1)
	bsr	ShowSavedFilter
	move.l	#(OMENUX+2)*65536+30+YO,(a1)

	cmp.w	#13,d0
	bne.s	\ex3
	move.w	d1,d3				;index
	bsr	CFG_FilterAddr
	tst.w	d0
	beq.s	\ex2
	moveq.w	#FILTERENTRY_SIZE,d1
	bsr	CFG_FilterOffset		;return offset in d2
	jsr	apilib::array_fDeleteItem
\ex3	bra	\Loop


;------------------------------------------------------
;Out>	d0.w : 13 if enter, 264 if esc
;	d1.w : 0-based index of selected item
;	a0.l : addr of selected item in the array
;------------------------------------------------------
ShowSavedFilter:
	movem.l	d2/a1,-(a7)

	;-------------------------------------
	; Get filter file handle
	;-------------------------------------
	bsr	CFG_FilterAddr
	tst.w	d0
	beq.s	\exit

	clr.w	d1
	bsr	FontSet

	;-------------------------------------
	; Show ListView component
	;-------------------------------------
	lea	2(a0),a1
	lea	SavedFilterHeader(PC),a0
	move.w	(a1)+,d0
	move.w	d0,d2			;save if saved filter
	bne.s	\skip
	lea	NoSavedFilterData(PC),a1 ;if no saved filter
	moveq.w	#1,d0			;show "(no saved filter)

\skip	move.w	d0,(a0)
	jsr	apilib::ListViewComponent

	tst.w	d2			;if no saved filters
	bne.s	\exit			;return always ESC
	move.w	#264,d0

\exit	move.l	d1,-(a7)
	moveq.w	#1,d1
	bsr	FontSet
	move.l	(a7)+,d1

	movem.l	(a7)+,d2/a1
	rts

;------------------------------------------------------
; > Select a saved filter in the list, and
; set data if successful
;Out>	d0.w : 0 if cancel
;	else ok
;------------------------------------------------------
SelectSavedFilter:
	movem.l	d1-d4/a0-a2,-(a7)

	;-------------------------------------
	; Firstly, show listview component
	;-------------------------------------
	bsr	ShowSavedFilter
	cmp.w	#13,d0
	bne.s	\cancel
	adda.w	#14,a0


	;-------------------------------------
	; And set data filters
	;-------------------------------------
	lea	FilterProperties(PC),a1		;copy filter prop
	moveq.w	#NB_EXT-1,d0
\copy3	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy3

	lea	AdvFilterProperties(PC),a1	;copy adv filter
	moveq.w	#NB_ADV-1,d0
\copy4	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy4

	lea	mnuShortByProperties(PC),a1	;copy ShortBy filter
	moveq.w	#NBSHORTBY-1,d0
\copy5	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy5

	lea	mnuStyleProperties(PC),a1
	moveq.w	#NBSTYLE-1,d0
\copy6	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy6

	moveq.w	#1,d0				;success
\exit	movem.l	(a7)+,d1-d4/a0-a2
	rts

\cancel	clr.w	d0
	bra.s	\exit

sfKeyDown:
	move.w	d6,d1
	cmp.w	#264,d0
	beq.s	\exit
	cmp.w	#PAD_LEFT,d0
	beq.s	\exit
	cmp.w	#13,d0
	beq.s	\exit
	clr.w	d0
\exit	rts


;--------------------------------------------------
;Format of the Filter File :
;
; 00.l : 'filt' signature
; 04.w : Nb extension supported
; 06.w : Nb adv filter supported
; 08.w : Nb Order
; 0A.w : Nb style supported
; 0C.x :  data
;--------------------------------------------------


FilterEditHeader
	dc.w	60+XO,69+YO,12
	dc.b	0,0
	dc.l	0,0

;--------------------------------------------------
; Datas for ListView component
;--------------------------------------------------
FilterHeader:
	dc.w	NB_EXT		;NbItem
	dc.w	7		;NbItemPerPage
	dc.w	90+XO,43+YO	;X,Y
	dc.w	0,0		;reserved
	dc.w	35		;Width
	dc.w	0		;cstSize
	dc.w	0		;cstHeight
	dc.b	%01000110	;Flag
	dc.b	0
	dc.l	0		;KeyDown
	dc.l	0		;Key
	dc.l	0		;Select
	dc.l	0		;DrawItem
	dc.l	FilterProperties


	ds.w	0

FilterMenuHeader:
	dc.w	5		;Nb
	dc.w	62+XO,40+YO	;X,Y
	dc.w	0		;reserved
	dc.w	115		;width
	dc.b	%00000110,0
	dc.l	0,0,0,0

AdvFilterHeader:
	dc.w	NB_ADV
	dc.w	5		;NbItemPerPage
	dc.w	68+XO,49+YO	;X,Y
	dc.w	0,0		;reserved
	dc.w	90		;Width
	dc.w	0		;cstSize
	dc.w	0		;cstHeight
AdvFlg:	dc.b	%01000110	;Flag
	dc.b	0
	dc.l	0		;KeyDown
	dc.l	0		;Key
	dc.l	0		;Select
	dc.l	0		;DrawItem
	dc.l	AdvFilterProperties



	ds.w	0
SavedFilterHeader:
	dc.w	0		;NbItem
	dc.w	5		;NbItemPerPage
	dc.w	OMENUX+2,30+YO	;X,Y
	dc.w	0,0		;reserved
	dc.w	80		;Width
	dc.w	FILTERENTRY_SIZE	;cstSize
	dc.w	0		;cstHeight
	dc.b	%00000010	;Flag
	dc.b	0
	dc.l	0		;KeyDown
	dc.l	sfKeyDown	;Key
	dc.l	0		;Select
	dc.l	0		;DrawItem
	dc.l	0		;Properties





	ds.w	0

