;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		intro.mdl
;	Utility>	First part of the source
;			Definition of constant
;
;-----------------------------------------------------------


;---------------------------------------------------
; COMMENTS... COMMENTS... COMMENTS...
;---------------------------------------------------
; * Some register have a unique use in the entire
;   program. In fact, they are used as global 
;   variables :
;   - d6.w : Zero based index of current item
;   - d7.w : Zero based index of screen pos
;   - a6.l : Address of current style
;
; * For debbugging the program, you should use :
;   #define DEBUG
;   else :
;   #define NODBG
;
; * Multiple language compilation :
;   English Version : no define
;   French Version : #define FRENCH
;
;---------------------------------------------------


;---------------------------------------------------
; DEFINITION OF PRE-COMPILATOR CONSTANTS
;---------------------------------------------------
		   
;#define NODBG

;---------------------------------------------------
; LIBRARIES USED
;---------------------------------------------------

	include "apilib.h"
	include "apilibct.h"
	include "tios.h"
;#ifdef TIPLUS
;#ifdef NSTUB
;#else
	include "userlib.h"     ;for exec
;#endif
;#else
	include "kernel.h"
;#endif



;---------------------------------------------------
; DEFINITION OF PROGRAM CONSTANTS, ACCORDING TO
; THE CALCULATOR
;---------------------------------------------------


;--------------
; TI89
;--------------
;#ifdef TI89
NBVARPERPAGE    equ     8
NBCOLUMN	equ	2
COLUMNWIDTH	equ	72

PAD_UP          equ     337
PAD_DOWN        equ     340
PAD_LEFT        equ     338
PAD_RIGHT       equ     344

YO              equ     -5
XO              equ     -40
WLCD            equ     160
HLCD            equ     100
LW              equ     -80     ;160+80=240
LH              equ     -28     ;100+28=128

LSTY            equ     25

;--------------
; TI92+/V200
;--------------
;#else

NBVARPERPAGE    equ     12
NBCOLUMN	equ	3
COLUMNWIDTH	equ	72

PAD_UP          equ     338
PAD_DOWN        equ     344
PAD_LEFT        equ     337
PAD_RIGHT       equ     340

YO              equ     0
XO              equ     0
WLCD            equ     240
HLCD            equ     128
LW              equ     0
LH              equ     0

LSTY            equ     22              ;dbut de la liste

;#endif


;----------------
; TI89/TI92P/V200
;----------------
;#ifdef TIPLUS

;#ifdef NSTUB
;#else
kernel::exec    equ     userlib::exec
;#endif

FOLDERLIST_HDL  equ     tios::FolderListHandle
MAINLIST_HDL    equ     tios::MainHandle
VATENTRY_SIZE   equ     14
ENTRYHDL        equ     12
ENTRYFLG        equ     10

COMMENT_OFFSET  equ     $0A
RELOC_OFFSET    equ     $08

PRT_BIT         equ     5       ;ok pour le prog mais
IMBFOLD_BIT     equ     4       ;pas pour CreateFolder

;----------------
; TI92 (no more supported)
;----------------
;#else

tios::OSLinkReset	equ     tios::reset_link
tios::OSLinkOpen	equ     tios::flush_link
tios::OSReadLinkBlock	equ     tios::receive
tios::OSWriteLinkBlock	equ     tios::transmit
tios::OSLinkClose	equ	tios::OSLinkReset

FOLDERLIST_HDL  equ     $0B
MAINLIST_HDL    equ     $0C
VATENTRY_SIZE   equ     12
ENTRYHDL        equ     10
ENTRYFLG        equ     8

COMMENT_OFFSET  equ     $14
RELOC_OFFSET    equ     10

PRT_BIT         equ     2       ;ok pour le prog mais
IMBFOLD_BIT     equ     1       ;pas pour CreateFolder

;#endif

ARCH_BIT        equ     1
LOCK_BIT        equ     3
HIDE_BIT        equ     4
SLCT_BIT        equ     5       ;bit selected

ANIMTIMER       equ     70



;---------------------------------------------------
; MULTISTYLE OFFSETS
;---------------------------------------------------

S_MODE		equ	0
S_MAKELIST	equ	2
S_PRINTLIST	equ	6
S_REDRAWLIST	equ	10
S_RWML		equ	14
S_DRAWITEM	equ	18
S_DRAWFIRSTITEM	equ	22
S_PADDOWN	equ	26
S_PADUP		equ	30
S_SLCTITEM	equ	34
S_CLRLIST	equ	38
S_DELETEITEM	equ	42
S_SHOWCOMMENT	equ	46
S_KEYENTER	equ	50
S_ENABMENUS	equ	54
S_INTERFACE	equ	58
S_INITSTYLE	equ	62
S_GETITEMXY	equ	66
S_PADLEFT	equ	70
S_PADRIGHT	equ	74
S_OTHERKEY	equ	78
S_BEFOREDRAWINGLIST equ	82
S_REDRAWLISTAREA equ	86
S_REFRESHUPBAR	equ	90

STYLE_VIRTUAL 	equ	0
STYLE_LINK 	equ	1
STYLE_PLUGIN	equ	2
STYLE_CURRENT 	equ	3


STYLEID_VIRTUAL		equ	0
STYLEID_DETAILED	equ	1
STYLEID_LIST		equ	2
STYLEID_TREE		equ	3
STYLEID_TREEF		equ	4
STYLEID_LINKFOLDER	equ	5
STYLEID_LINKFILE	equ	6
STYLEID_PLUGIN		equ	7


;---------------------------------------------------
; DEFINITION OF SOME MACROS
;---------------------------------------------------
INTERRUPT_OFF	MACRO
			move.w	#$500,d0
			trap	#1
			move.l	d0,-(a7)
		ENDM

INTERRUPT_ON	MACRO
			move.l	(a7)+,d0
			trap	#1
		ENDM


;---------------------------------------------------
; START OF THE PROGRAM
;---------------------------------------------------
	DEFINE	_version01

	xdef	_library
	xdef    pctprgm@0000

;#ifdef TIPLUS
;#ifdef TI89
	xdef    _ti89
	xdef	_ti89ti
;#else
	xdef    _ti92plus      ; will run on.
	xdef	_v200
;#endif
;#endif



;---------------------------------------------------
; DEBUGGING ROUTINES
;---------------------------------------------------

;#ifdef DEBUG
	include "hexlib.h"

dbgstop:
	movem.l d0-d7/a0-a6,-(a7)
	jsr     apilib::WaitKey
	movem.l (a7)+,d0-d7/a0-a6
	rts

showd0:
	movem.l d0-d7/a0-a6,-(a7)
	moveq.l #1,d1
	moveq.l #1,d2
	moveq.l #5,d4
	jsr     hexlib::put_hex
	bsr     dbgstop
	movem.l (a7)+,d0-d7/a0-a6
	rts

;#endif

;---------------------------------------------------
; GLOBAL VARIABLES
;---------------------------------------------------

HWVERSION dc.w	0

;---------------------------------------------------
; END OF THAT FILE
;---------------------------------------------------
