;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		link.mdl
;	Utility>	Function for link
;
;-----------------------------------------------------------

Style_Link_Folders:
	dc.b	%00000100,0
	dc.l	sl_CreateFolderBuffer
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	sl_DrawItem
	dc.l	sl_DrawFirstItem
	dc.l	s3_PadDown
	dc.l	s3_PadUp
	dc.l	s1_SelectItem
	dc.l	s1_ClearList
	dc.l	s3_DeleteItem
	dc.l	sl_ShowComment
	dc.l	sl_KeyEnter
	dc.l	sg1_EnableMenus
	dc.l	sl_DrawInterface
	dc.l	sl_InitStyle
	dc.l	sg1_GetItemXY
	dc.l	sl_PadLeft
	dc.l	sg1_PadRight
	dc.l	sl_OtherKey
	dc.l	s1_BeforeDrawingList
	dc.l	RedrawList			;RedrawListArea
	dc.l	sg1_RefreshUpBar

Style_Link_Files:
	dc.b	%00000100,0
	dc.l	sl_CreateFolderBuffer		;same code
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	slf_DrawItem
	dc.l	slf_DrawFirstItem
	dc.l	s3_PadDown
	dc.l	s3_PadUp
	dc.l	slf_SelectItem
	dc.l	s1_ClearList
	dc.l	slf_DeleteItem
	dc.l	slf_ShowComment
	dc.l	slf_KeyEnter
	dc.l	sg1_EnableMenus
	dc.l	slf_DrawInterface
	dc.l	slf_InitStyle
	dc.l	sg1_GetItemXY
	dc.l	slf_PadLeft
	dc.l	s_NOP_Loop
	dc.l	slf_OtherKey
	dc.l	s1_BeforeDrawingList
	dc.l	RedrawList			;RedrawListArea
	dc.l	sg1_RefreshUpBar

folder_hdl dc.w	0
folder_d6 dc.w	0
folder_d7 dc.w	0
folder_nb dc.w	0

file_lasthdl dc.w 0
file_d6	dc.w	0
file_d7	dc.w	0


	ds.w	0

;-----------------------------------------------------------
;Out>	d0.w : Nb of selected items
;-----------------------------------------------------------
link_CountSelection:
	move.l	a0,-(a7)

	clr.w	nb_slct

	move.w	folder_hdl(PC),d0
	lea	cbCountGlobalSelection(PC),a0
	bsr	BrowseFolders
	move.w	nb_slct(PC),d0

	move.l	(a7)+,a0
	rts

nb_slct:	dc.w	0

cbCountGlobalSelection
	btst.b  #7,ENTRYFLG+1(a1)		;if it is a folder, exit
	bne.s   \exit
	btst.b  #SLCT_BIT,ENTRYFLG+1(a1)	;check if selected
	beq.s   \exit
	add.w	#1,nb_slct

\exit	moveq.w	#1,d0			;continue
	rts


;------------------------------------------------------------
; Extract the Folder Name of a 'folder\file' string
;
;Input>	a0.l : String
;	a1.l : Buffer (9 bytes at min)
;Out>	d0.w : 0 if error, else success
;------------------------------------------------------------
ExtractFolderName:
	movem.l	d1/a0-a1,-(a7)

	moveq.w	#7,d1			;8 chars at max

\folder	move.b	(a0)+,d0
	beq.s	\error
	cmp.b	#'\',d0
	beq.s	\ok
	move.b	d0,(a1)+
	dbra.s	d1,\folder

\error	clr.w	d0
	bra.s	\exit

\ok	clr.b	(a1)
	moveq.w	#1,d0

\exit	movem.l	(a7)+,d1/a0-a1
	rts


;------------------------------------------------------------
; 
;------------------------------------------------------------
LinkService:
	bsr	GetDirectory
	tst.w	d0
	beq.s	\rd		;if error, return in VirtualList
	
	clr.w	level			;var in style3.mdl

	lea	folder_hdl(PC),a0
	move.w	d0,(a0)+
	clr.l	(a0)+			;folder_d6 and folder_d7
	clr.l	(a0)+			;folder_nb & file_lasthdl
	clr.l	(a0)+			;file_d6 & file_d7

	clr.l	d6			;pour sl_SetFocusOnFolder
	clr.l	d7
	bsr	sl_SetFocusOnFolder

	clr.w	d0			;give focus to folder
	bsr	RedrawInterface
	lea	ieLinkMenuBar(PC),a0
	bsr	InterfaceEngine

\rd	bsr	RedrawListArea

\exit	rts

sl_InitStyle:
	clr.w	d6
	clr.w	d7
	rts


;----------------------------------------------------------------
; Receive Selected Files
;----------------------------------------------------------------
ReceiveFiles:
	movem.l	d0-d5/a0-a4,-(a7)

	API92_MAINHDL d5			;default destination folder

	;------------------------------------------
	; Show Window
	;------------------------------------------
	bsr	SetAnimatedState
\redraw	lea	ieReceiveFiles(PC),a0
	jsr	apilib::InterfaceEngine
	clr.b	1(a0)					;clear timer

\loop	moveq.w	#0,d1
	bsr	FontSet
	lea	cbKeepFolders(PC),a0
	jsr	apilib::CheckBoxComponent

	;------------------------------------------
	; Check if keep original folder or not
	;------------------------------------------
	lea	strOriginal(PC),a1			;string addr
	tst.b	(a0)
	bne.s	\skip

	;------------------------------------------
	; Look for folder name according to its handle d5
	;------------------------------------------
	API92_FOLDHDL d0
	move.w	d5,d1					;folder to look for
	jsr	apilib::vat_FindHdl			;return VAT entry in a1
	tst.w	d2
	beq.s	\exit

	;------------------------------------------
	; Show Destination Folder
	;------------------------------------------
\skip	lea	linkdest(PC),a0
	move.l	a1,(a0)
	lea	ieLinkDest(PC),a0
	jsr	apilib::InterfaceEngine

	;------------------------------------------
	; Key Handler
	;------------------------------------------
\loopkey bsr	GetKey
	cmp.w	#264,d0
	beq.s	\exit

	cmp.w	#KLINK_KEEPFOLDER,d0
	beq.s	\keepfolder
	cmp.w	#PAD_RIGHT,d0
	beq.s	\choosefolder

	cmp.w	#13,d0
	bne.s	\loopkey

	;------------------------------------------
	; if Enter
	;------------------------------------------
	move.w	folder_hdl(PC),d0			;Base Folder
	lea	cb_ReceiveFiles(PC),a0

	tst.b	cbKeepFolders
	beq.s	\skip2
	clr.w	d5
\skip2	move.w	d5,link_dest_folder
	bsr	BrowseFolders

\exit	bsr	RedrawLinkInterface
	movem.l	(a7)+,d0-d5/a0-a4
	rts

\keepfolder bchg.b #0,cbKeepFolders
	bra	\loop

\choosefolder tst.b cbKeepFolders
	bne.s	\loopkey
	bsr	_movecopy_SelectFolder
	tst.w	d0
	beq	\redraw
	move.w	d0,d5
	bra	\redraw

;------------------------------------------------------------
; CalcBack function that request selected files
;------------------------------------------------------------
cb_ReceiveFiles:
	suba.w	#20,a7				;Create stack frame
	move.l	a7,a3
	move.l	a1,a4				;save it

	btst.b  #SLCT_BIT,ENTRYFLG+1(a1)	;check if it is selected
	beq.s   \exit
	btst.b  #7,ENTRYFLG+1(a1)		;if it is a folder, exit
	bne.s   \exit

	;---------------------------------------------
	; Look for current folder name
	;---------------------------------------------
	move.l	a1,a2				;save file name

	move.w	d0,d1				;Handle of current folder
	move.w	folder_hdl(PC),d0		;Handle of Base folder
	jsr	apilib::vat_FindHdl
	tst.w	d2
	beq.s	\exit

	;---------------------------------------------
	; Make 'folder\file' string
	;---------------------------------------------
	move.l	a2,-(a7)
	move.l	a1,-(a7)
	pea	folderfile(PC)
	move.l	a3,-(a7)
	bsr	_sprintf
	lea	16(a7),a7

	;---------------------------------------------
	; Request File
	;---------------------------------------------
	move.l	a3,a0
	move.w	link_dest_folder(PC),d0
	bsr	RequestVar

	;--------------------------------------
	; If EC_FILEEXIST error, get d0.w d2.w 
	; for error message.
	;--------------------------------------
	cmp.w	#EC_FILEEXIST,d1
	bne.s	\noerr
	move.l	a2,a0				;file name
	move.w	d2,d0				;hdl of dest folder
	jsr	apilib::vat_Find
	subq.w	#1,d2
	moveq.w	#EC_FILEEXIST,d1
	bra.s	\error
	;---------------------------------------------
	; Check other error
	;---------------------------------------------
\noerr	cmp.w	#EC_LINKERROR,d1		;skip, because link error
	beq.s	\nomsg				;already printed
	tst.w	d1
	bne.s	\error
\nomsg

	;---------------------------------------------
	; clear selection if successful
	;---------------------------------------------	
	bclr.b  #SLCT_BIT,ENTRYFLG+1(a4)
	moveq.w	#1,d0				;continue

\exit	adda.w	#20,a7
	rts

	;---------------------------------------------
	; If error show error message
	;---------------------------------------------
\error	bsr	ErrorDlg
	clr.w	d0				;STOP
	bra.s	\exit

link_dest_folder dc.w	0


;------------------------------------------------------------
; d0.w:	0 = give file to folder
;	else give focus to file
;------------------------------------------------------------
RedrawLinkInterface:
	movem.l	d0-d4/a0-a5,-(a7)

	bsr	RedrawInterface

	lea	ieLinkMenuBar(PC),a0
	bsr	InterfaceEngine

	tst.w	d0
	bne.s	\file

	;--------------------------------------
	; Draw FILE side just for comment
	;--------------------------------------
	bsr	sl_SetFocusOnFile
	lea	slf_SelectItemDisabled(PC),a0
	move.l	a0,S_SLCTITEM(a6)
	bsr	StyleInterface
	bsr	RedrawList
	lea	slf_SelectItem(PC),a0
	move.l	a0,S_SLCTITEM(a6)
	;--------------------------------------
	; and give focus to FOLDER side again
	;--------------------------------------
	bsr	sl_SetFocusOnFolder
	bsr	StyleInterface
	bsr	RedrawList
	bra.s	\exit

\file	bsr	sl_SetFocusOnFolder
	bsr	StyleInterface
	bsr	RedrawList
	bsr	sl_SetFocusOnFile
	bsr	StyleInterface
	bsr	RedrawList

\exit	movem.l	(a7)+,d0-d4/a0-a5
	rts

;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_SetFocusOnFolder:
	bsr	Free_ListBuf

	lea	file_d6(PC),a0
	move.w	d6,(a0)+
	move.w	d7,(a0)+

	move.w	folder_hdl(PC),ListReal_Hdl
	lea	Style_Link_Folders(PC),a6
	move.w	folder_nb(PC),NbItem

	bsr	InitStyle

	lea	folder_d6(PC),a0
	move.w	(a0)+,d6
	move.w	(a0)+,d7

	rts

;------------------------------------------------------------
;
;------------------------------------------------------------
sl_SetFocusOnFile:
	tst.w	d6			;cannot set focus if d6=0
	beq.s	\skip2

	bsr	Free_ListBuf
	lea	Style_Link_Files(PC),a6

	;--------------------------------------
	; Save datas
	;--------------------------------------
	lea	folder_d6(PC),a0
	move.w	d6,(a0)+
	move.w	d7,(a0)+
	move.w	NbItem(PC),(a0)+

	;--------------------------------------
	; Get Hdl of folder where we want
	; to enter
	;--------------------------------------
	bsr     GetCurrentVATAddr
	move.w	VAT_ENTRYHDL(a0),d0
	move.w	d0,ListReal_Hdl		;Handle of folder

	bsr	InitStyle
	;--------------------------------------
	; Restore position if needed
	;--------------------------------------
	cmp.w	file_lasthdl(PC),d0
	bne.s	\skip2
	lea	file_d6(PC),a0
	move.w	(a0)+,d6
	move.w	(a0)+,d7

\skip2	rts


;------------------------------------------------------------
; 
;------------------------------------------------------------
slf_InitStyle:
	clr.w	d6
	clr.w	d7
	rts

;----------------------------------------------------------
; Draw only one panel
;----------------------------------------------------------
sl_DrawInterface:
	move.l	a0,-(a7)
	lea	sl_Interface(PC),a0
	bsr	InterfaceEngine
	move.l	(a7)+,a0
	rts
	
;----------------------------------------------------------
; Draw only one panel
;----------------------------------------------------------
slf_DrawInterface:
	move.l	a0,-(a7)
	lea	slf_Interface(PC),a0
	bsr	InterfaceEngine
	move.l	(a7)+,a0
	rts

;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_CreateFolderBuffer:
	movem.l	d0/a0,-(a7)

	move.w	ListReal_Hdl(PC),d0
	bsr     DEREFd0a0		;Get array address
	lea     2(a0),a2		;skip first word
	move.w  (a2),NbItem             ;put nb items
	clr.w	d1			;no error
	movem.l	(a7)+,d0/a0
	rts

;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_DrawItem:
	movem.l	d0-d2/a0-a2,-(a7)

	;-----------------------------------------
	; Draw filename
	;-----------------------------------------
	bsr     CpyFileName     ;return a2 in a1 with 8 char+0
	moveq.w #24,d0          ;X pos
	bsr     PrintSp         ;a1&d1 already set

	;-----------------------------------------
	; Draw GFX
	;-----------------------------------------
	moveq.w #FOLD_GFX,d2
;#ifdef TI89
;	subq.w  #2,d1
;#endif
	moveq.w #2,d0			;col (x=16)
	bsr     PutImg			;draw picture

	movem.l	(a7)+,d0-d2/a0-a2
	rts

;------------------------------------------------------------
; 
;------------------------------------------------------------
slf_DrawFirstItem:
	movem.l	d0-d2/a0,-(a7)

	lea	str_back(PC),a0
	bsr     printf

	moveq.w #BACK_GFX,d2
	moveq.w #11,d0
	moveq.w #LSTY,d1
	bsr     PutImg

	movem.l	(a7)+,d0-d2/a0
	rts

;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_DrawFirstItem:
	movem.l	d0-d2/a0,-(a7)

	;--------------------------------------
	; Print text
	;--------------------------------------
	lea	str_link(PC),a0
	bsr	printf

	;--------------------------------------
	; Draw GFX
	;--------------------------------------
	moveq.w	#LINK_GFX,d2
	moveq.w	#1,d0				;X
	moveq.w	#LSTY,d1			;Y
	bsr	PutImg
	movem.l	(a7)+,d0-d2/a0
	rts

;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_ShowComment:
	;--------------------------------------
	; If first item selected, clear panel
	;--------------------------------------
	tst.w	d6
	bne.s	\skip
	bsr	slf_DrawInterface
	bra.s	\exit

\skip	movem.l	d0-d7/a0-a6,-(a7)

	;--------------------------------------
	; Draw FILE side just for comment
	;--------------------------------------
	bsr	sl_SetFocusOnFile
	lea	slf_SelectItemDisabled(PC),a0
	move.l	a0,S_SLCTITEM(a6)
	bsr	RedrawList
	lea	slf_SelectItem(PC),a0
	move.l	a0,S_SLCTITEM(a6)

	;--------------------------------------
	; and give focus to FOLDER side again
	;--------------------------------------
	bsr	sl_SetFocusOnFolder

	movem.l	(a7)+,d0-d7/a0-a6
	
\exit	rts


;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_KeyEnter:
	;--------------------------------------
	; If first item selected, back
	;--------------------------------------
	tst.w	d6
	bne	\skip1

	move.w	folder_hdl(PC),d0
	bsr	DeleteLinkDir
	clr.w	folder_hdl

	lea	VirtualList(PC),a6		;current style
	bsr	InitStyle
	moveq.w	#3,d6
	moveq.w	#3,d7
	bsr	RedrawInterface
	bra.s	\exit
	

	;--------------------------------------
	; Else give focus to FILE side
	;--------------------------------------
\skip1	bsr	sl_SetFocusOnFile
	
	;--------------------------------------
	; Save handle and redraw
	;--------------------------------------
	move.w	d0,file_lasthdl		;save handle where we enter
	bsr	RedrawList

\exit	bra	LoopRDList


;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_gKeys:
	;--------------------------------------
	; Support 2nd+Up or 2nd+Down
	;--------------------------------------
	cmp.w   #PAD_UP+4096,d0
	beq     sg2_BigUp
	cmp.w   #PAD_DOWN+4096,d0
	beq     sg2_BigDown

	;--------------------------------------
	; Disable menu
	;--------------------------------------
	cmp.w   #KM_FILE,d0
	beq	ShowLinkMenu
	cmp.w   #KM_SECURE,d0
	beq	\loop
	cmp.w   #KM_TOOLS,d0
	beq	\loop
	cmp.w   #KM_PLUGIN,d0
	beq	\loop

	;--------------------------------------
	; Send Files
	;--------------------------------------
	cmp.w	#KM_LINK_SEND,d0
	beq.s	SendFiles

	;--------------------------------------
	; Support of Letter
	;--------------------------------------
	cmp.w   #97,d0
	bcs.s   \nolet
	cmp.w   #122,d0
	bls     sg1_GoLetter

\nolet	bra	OK_Continue

\loop	bra 	Loop

;------------------------------------------------------------
; Show and use the Link Menu
;------------------------------------------------------------
ShowLinkMenu:
	lea     mnuLinkHeader(PC),a0
	lea     mnuLinkData(PC),a1
	bsr     DrawMenu

	cmp.w	#1,d0
	beq	SendFiles
	cmp.w	#3,d0
	beq	SelectFile
	cmp.w	#4,d0
	beq	SelectAll
	cmp.w	#5,d0
	beq	DeselectLink
	cmp.w	#7,d0
	beq	Exit

	bra	Loop

;------------------------------------------------------------
; Send a file or selected files
;------------------------------------------------------------
SendFiles:
	bsr	link_CountSelection
	move.w	d0,d3				;nb selected items
	bne.s	\slct

	tst.w	d6
	beq.s	\exit
	bsr	GetCurrentVATAddr
	btst.b  #7,ENTRYFLG+1(a0)		;if it is a folder, exit
	bne.s   \exit
	bset.b	#SLCT_BIT,ENTRYFLG+1(a0)

\slct	bsr	ReceiveFiles
	tst.w	d3
	bne.s	\exit
	bsr	GetCurrentVATAddr
	bclr.b	#SLCT_BIT,ENTRYFLG+1(a0)
	bsr	RedrawList

\exit	bra	Loop


;------------------------------------------------------------
; 
;------------------------------------------------------------
link_Select:
	tst.w	d6
	bne.s	\nofirst
	




	;-----------------------------------
	; If first item selected
	;-----------------------------------
	bsr	GetListBufAddr
	move.w	d1,d0				;Handle
	beq.s	\exit
	bsr	vat_CountSelection		;
	cmp.w	(a0),d0
	bne	SelectAll
	bsr	_deslct
	bra	LoopRDList

	;-----------------------------------
	; Else
	;-----------------------------------
\nofirst
	btst.b	#7,ENTRYFLG+1(a0)		;Check if a folder
	bne.s	\exit
	
	bsr		GetCurrentVATAddr
	bchg.b	#SLCT_BIT,ENTRYFLG+1(a0)

	move.l	a0,a2
	bsr     DeleteItem                      ;delete previous item
	bsr	GetItemXY			;Get X/Y
	bsr	DrawItem
	bsr	SelectItem
	bsr	MakeList
\exit   bra     Loop



;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_OtherKey:
	bra	sl_gKeys

;------------------------------------------------------------
; 
;------------------------------------------------------------
slf_OtherKey:
	cmp.w   #KM_TOOLS_SELECT,d0
	beq     link_Select

	bra	sl_gKeys

;------------------------------------------------------------
; 
;------------------------------------------------------------
sl_PadLeft:
	clr.w   d6
	bra     KeyEnter

;------------------------------------------------------------
; 
;------------------------------------------------------------
slf_PadLeft:
	;--------------------------------------
	; Save position in FILE side
	;--------------------------------------
	lea	file_d6(PC),a0
	move.w	d6,(a0)+
	move.w	d7,(a0)+

	;--------------------------------------
	; Give focus to the FOLDER side
	;--------------------------------------
	bsr	sl_SetFocusOnFolder

	bra	LoopRDList

;------------------------------------------------------------
; 
;------------------------------------------------------------
slf_DrawItem:
	movem.l	d0-d2/a0-a2,-(a7)

	;-----------------------------------------
	; Selected File ?
	;-----------------------------------------
	btst.b  #SLCT_BIT,ENTRYFLG+1(a2)
	beq.s   \noslct
	moveq.w #15,d2          ;char=selected
	moveq.w #89,d0           ;X pos. Y already set
	bsr     printchar

	;--------------------------------------
	; Print name of file
	;--------------------------------------
\noslct	bsr     CpyFileName			;return a2 in a1 with 8 char+0
	moveq.w #104,d0				;X pos
	bsr     PrintSp				;a1&d1 already set

	;--------------------------------------
	; draw GFX
	;--------------------------------------
	moveq.w	#96,d0				;X
	lea	filegfx(PC),a0
	jsr	apilib::draw_GFX8x8

	movem.l	(a7)+,d0-d2/a0-a2
	rts


;--------------------------------------------------------
; Select the current item
;--------------------------------------------------------
slf_SelectItem:
	movem.l	d1/a0,-(a7)

	bsr.s   sl_ItemScrPos
	moveq.w #7,d1           ; 8 lines

\line
;#ifdef TI89
	not.b   (a0)+
	not.l   (a0)+
	not.w   (a0)+
	not.b   (a0)+
	lea     22(a0),a0
;#else
	not.b   (a0)+
	not.l   (a0)+
	not.l   (a0)+
	not.l	(a0)+
	not.l	(a0)+
	lea     21-4*2(a0),a0
;#endif
	dbra.s  d1,\line

	movem.l	(a7)+,d1/a0
	rts


;--------------------------------------------------------
; Select the current item
;--------------------------------------------------------
slf_SelectItemDisabled:
	movem.l	d1/a0,-(a7)

	bsr.s   sl_ItemScrPos
	moveq.w #1,d1           ; 2 lines

\line
;#ifdef TI89
	not.b   (a0)+
	not.l   (a0)+
	not.w   (a0)+
	not.b   (a0)+
	lea     22+30*6(a0),a0
;#else
	not.b   (a0)+
	not.l   (a0)+
	not.l   (a0)+
	not.l	(a0)+
	not.l	(a0)+
	lea     21-4*2+30*6(a0),a0
;#endif
	dbra.s  d1,\line

	movem.l	(a7)+,d1/a0
	rts


;--------------------------------------------------------
; delete the item d7
;--------------------------------------------------------
slf_DeleteItem:
	movem.l	d0-d3/a0,-(a7)
	bsr.s   sl_ItemScrPos
	
	moveq.w #7,d3           ;delete 8 lines
\line	
;#ifdef TI89
	moveq.w	#7,d1
;#else
	moveq.w #17,d1          ;
;#endif
\row	clr.b   0(a0,d1.w)
	dbra.s  d1,\row
	lea     30(a0),a0       ;adda.w #30,a0
	dbra.s  d3,\line

	movem.l	(a7)+,d0-d3/a0	
	rts

;---------------------------------------------------
;ItemScrPos
;return in a0 the offset of the d7 item in
;the video memory
;Ouput>
;--------------------------------------------------
sl_ItemScrPos:
	move.w  d7,d0
	lsl.w   #3,d0
	add.w   #LSTY,d0
	mulu.w  #30,d0
	
	move.l  #LCD_MEM+11,a0
	adda.w  d0,a0
	rts

;------------------------------------------------------------
; 
;------------------------------------------------------------
slf_ShowComment:
	rts

;------------------------------------------------------------
; 
;------------------------------------------------------------
slf_KeyEnter:
	bra	Loop



