;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		varfct.xas
;	Utility>	Menu Management
;
;-----------------------------------------------------------

;-----------------------------------------------------------
; Hide/Lock functions
;-----------------------------------------------------------
Hide2:	lea	apilib::vat_ToggleHide,a2
	lea	apilib::vat_ToggleHideSelection,a3
	bra.s	LockHide2

Lock2:	lea	apilib::vat_ToggleLock,a2
	lea	apilib::vat_ToggleLockSelection,a3
	
;-----------------------------------------------------------
; -- internal function --
;
; a2.l : ToggleXX
; a3.l : ToggleXXSelection
;-----------------------------------------------------------
LockHide2:
	btst.b	#0,S_MODE(a6)			;Check if true VAT
	beq.s	\exit
	move.w	ListReal_Hdl(PC),d0
	move.w	d0,d3				;save hdl
	bsr	vat_CountSelection	;count selection
	tst.w	d0
	beq.s	\noslct

	move.w	d3,d0				;restore hdl
	jsr	(a3)				;xxSelection
	bra.s	\exit

\noslct	tst.w	d6				;first item?
	beq.s	\exit				;if yes, exit
	bsr	RealFileIndex			;Get real file index
	tst.w	d1
	beq.s	\exit
	jsr	(a2)
\exit	bra	LoopRDList


;#ifdef TIPLUS

;-------------------------------------------------------------
; Archive/Unarchive capability
;-------------------------------------------------------------
Archive:
	lea	apilib::vat_ArchiveVar,a2
	lea	apilib::vat_ArchiveSelection,a3
	bra.s	ArchUnarch

Unarchive:
	lea	apilib::vat_UnarchiveVar,a2
	lea	apilib::vat_UnarchiveSelection,a3

ArchUnarch:
	btst.b	#0,S_MODE(a6)			;Check if true VAT
	beq.s	\exit

	move.w	ListReal_Hdl(PC),d0	;hdl of buffer
	move.w	d0,d3
	bsr	vat_CountSelection
	tst.w	d0
	beq.s	\noslct			;if 0=>no selection
	move.w	d3,d0
	jsr	(a3)
	bra.s	\skip

\noslct	tst.w	d6
	beq.s	\exit			;exit
	bsr     RealFileIndex           ;return d0,d2
	tst.w	d1
	beq.s	\skip
	jsr	(a2)			;(d0,d2) set by RealFileIndex

\skip	tst.w	d1
	bne.s	\error
\exit	bsr	RefreshPluginTable
	bra	LoopRDListArea

\error	bsr.s	ErrorDlg
	bra.s	\exit

;#endif


;-----------------------------------------------------------
; Rename a VAT entry
;-----------------------------------------------------------
Rename2:
	btst.b	#0,S_MODE(a6)			;Check if true VAT
	beq.s	\ex
	tst.w	d6			;if first item
	beq.s	\ex			;exit

	;-------------------------------------------
	; Get index of file in real VAT
	;-------------------------------------------

	bsr     RealFileIndex           ;return d0,d2
	tst.w	d1
	beq.s	\ex

	move.l	d0,d3			;save d0=real hdl

	;-------------------------------------------
	; Get complete entry name
	;-------------------------------------------

	suba.w	#40,a7			;Create stack frame
	move.l	a7,a0
	move.l	a0,a1			;Save buffer for edition
	moveq.w	#25,d1			;max length
	jsr	apilib::nf_GetVatName	;d0,d2 are set
	tst.w	d1
	bne.s	\error

	;-------------------------------------------
	; Show window & use Edit component
	;-------------------------------------------

	move.l	a0,winRenameVar		;Draw Rename window
	lea	winRename(PC),a0
	bsr	InterfaceEngine
	
	lea	VarEditHeader(PC),a0	;Edit Component
	jsr	apilib::EditComponent
	tst.w	d0			;If cancel, skip
	beq.s	\exit

	;-------------------------------------------
	; Rename variable
	;-------------------------------------------

	move.l	a1,a0			;new name
	move.l	d3,d0			;Restore d0
	jsr	apilib::vat_Rename	;Rename VAT entry !
	tst.w	d1
	bne.s	\error

\exit	adda.w	#40,a7
\ex	bra     LoopRDListArea

\error	cmp.w	#EC_FILEEXIST,d1
	beq.s	\nameerr
	cmp.w	#EC_FOLDEREXIST,d1
	bne.s	\rundlg

\nameerr move.w	d1,-(a7)
	jsr	apilib::vat_Find		;d0,a0 set
	move.w	(a7)+,d1
	tst.w	d2
	beq.s	\rundlg
	subq.w	#1,d2			;

\rundlg	bsr	ErrorDlg
	bra.s	\exit


ErrorDlg:
	jsr	apilib::ErrorDialogBox
	rts


;----------------------------------------------
; Create a new folder
;----------------------------------------------
CreateFolder2:
	suba.w	#40,a7				;Create stack frame

	btst.b	#0,S_MODE(a6)			;Check if true VAT
	beq.s	\exit

	move.w	ListReal_Hdl(PC),d4		;default current folder
	lea	Style3(PC),a0
	cmp.l	a0,a6
	bne.s	\notree
	API92_FOLDHDL d4			;default if tree
	tst.w	d6				; if d6=0
	beq.s	\notree
	bsr	GetCurrentVATAddr		;else get current seleccteed folder
	move.w	VAT_ENTRYHDL(a0),d4

\notree
	;-------------------------------------------
	; Get name of source folder
	;-------------------------------------------

	move.l	a7,a0				;
	move.l	a0,a1				;save buffer addr for edition
	move.w	d4,d0			;Handle
	move.w	#25,d1				;buffer length
	jsr	apilib::nf_GetFolderName		;
	tst.w	d1
	beq.s	\skip
	clr.b	(a0)
\skip	move.l	a0,winFolderName
\eos	tst.b	(a0)+
	bne.s	\eos
	subq.w	#1,a0
	move.b	#'\',(a0)+
	clr.b	(a0)+


	;-------------------------------------------
	; Show window & use Edit component
	;-------------------------------------------

	lea	winNewFolder(PC),a0		;Draw window
	bsr	InterfaceEngine

	lea	VarEditHeader(PC),a0		;Edit Component
	jsr	apilib::EditComponent
	tst.w	d0				;if cancel, exit
	beq.s	\exit

	;-------------------------------------------
	; Create a normal folder
	;-------------------------------------------

	move.l	a1,a0				;Addr of folder name
	move.w	#$0080,d0
	jsr	apilib::vat_CreateFolder
	tst.w	d1
	bne.s	\error

	;-------------------------------------------
	; Make it nested if needed
	;-------------------------------------------

	move.w	d0,d2				;nested folder
	move.w	d4,d1				;parent folder
	jsr	apilib::nf_AddFolder
	tst.w	d1
	bne.s	\error

\exit	adda.w	#40,a7
	bra	LoopRDListArea

\error	cmp.w	#EC_FOLDEREXIST,d1
	bne.s	\no_err4
	API92_FOLDHDL d0
	move.l	a1,a0
	jsr	apilib::vat_Find
	tst.w	d2
	beq.s	\no_err41
	subq.w	#1,d2
\no_err41 moveq.w #EC_FOLDEREXIST,d1
\no_err4 bsr	ErrorDlg
	bra.s	\exit


;---------------------------------------------------------
; 	internal function
;
;a2.l : addr of buffer
;a3.l : addr of dest string
;
;out>	d4.w : nb of selected items
;	d1.w =0 if error
;	d3.w : handle of buffer
;---------------------------------------------------------
prep_MoveCpyDel:
	clr.w	d1			;return value
	move.w	ListReal_Hdl(PC),d0	;hdl of buffer
	move.w	d0,d3			;save handle
	bsr	vat_CountSelection
	move.w	d0,d4			;save nb of items
	beq.s	\slct			;if 0=>no selection

	lea	s_SFile(PC),a0
	bra.s	\next

\slct	tst.w	d6
	beq.s	\exit			;exit with d1=0
	bsr     RealFileIndex           ;return d0,d2
	tst.w	d1
	beq.s	\exit
	move.w	VAT_ENTRYHDL(a1),slct_Hdl
	move.l	a2,a0			;Buffer addr
	moveq.w	#25,d1			;Max size
	jsr	apilib::nf_GetVatName	;Get item name
	moveq.w	#1,d1			;no error
	move.w	d0,d3			;save handle

\next	move.l	a0,(a3)
	moveq.w	#1,d1			;no error

\exit	rts

;----------------------------------------------
; Delete Function
;----------------------------------------------
Delete2:
	suba.w	#40,a7			;Create stack frame

	btst.b	#0,S_MODE(a6)		;Check if true VAT
	beq.s	\exit

	move.l	a7,a2
	lea	winDeleteName(PC),a3
	bsr	prep_MoveCpyDel
	tst.w	d1
	beq.s	\exit

	lea	winDelete(PC),a0
	bsr	InterfaceEngine
\wk	bsr	GetKey
	cmp.w	#264,d0
	beq.s	\exit
	cmp.w	#13,d0
	bne.s	\wk

	move.w	d3,d0			;restore saved handle
	tst.w	d4
	beq.s	\noslct
	jsr	apilib::vat_DeleteSelection
	bra.s	\skip
\noslct	bsr	IsFolder		;is it a folder ?
	tst.w	d1
	beq.s	\file			;if not, skip
	jsr	apilib::nf_DeleteFolder	;else use recursiv delete folder
	bra.s	\skip
\file	jsr	apilib::vat_Delete	;(d0,d2) set by RealFileIndex
\skip	tst.w	d1
	bne.s	\error

\exit	jsr     apilib::nf_CheckIfValid
	bsr	RefreshPluginTable
	adda.w	#40,a7
	bra	LoopRDListArea

\error	bsr	ErrorDlg
	bra.s	\exit

;input>	d0:Handle, d2:index
;out>	d1=0 if not a folder
;	if folder d0=handle of folder
IsFolder:
	movem.l	d2/a0-a1,-(a7)
	jsr	apilib::vat_IndexToAddr	;get addr
	tst.w	d1			;
	bne.s	\err
	moveq.w	#1,d1			;default:folder
	btst.b	#7,VAT_ENTRYFLAG(a0)
	bne.s	\folder
\err	clr.w	d1			;file
	bra.s	\exit
\folder	move.w	VAT_ENTRYHDL(a0),d0	;modify hdl
\exit	movem.l	(a7)+,d2/a0-a1
	rts


VarEditHeader:
	dc.w	80+XO,63+YO	;X,Y
	dc.w	8		;Maxlength
	dc.b	0,%00000001
	dc.l	0
	dc.l	0

;------------------------------------------------------
; Copy Function
;------------------------------------------------------
_win_used	dc.l	0

	;--------------------------------------------------
	; Copy function, doesn't work on a folder 
	;--------------------------------------------------
Copy2:	tst.w	d6			;if d6=0 don't check
	beq.s	\skip

	bsr	GetCurrentVATAddr	;copy a folder ?
	btst.b	#VAT_FOLDERBIT,VAT_ENTRYFLAG(a0)
	bne	Loop

\skip	move.l	#winCopy,_win_used
	lea	apilib::vat_CopyRRVar,a4
	lea	apilib::vat_CopyRRSelection,a5
	bra.s	CopyMove2

	;--------------------------------------------------
	; Move function, works on a folder
	;--------------------------------------------------
Move2:	move.l	#winMove,_win_used
	lea	apilib::vat_MoveRRVar,a4
	lea	apilib::vat_MoveRRSelection,a5


	;--------------------------------------------------
	; Copy/Move universal function
	;--------------------------------------------------
CopyMove2:	
	suba.w	#40,a7			;create stack frame

	btst.b	#0,S_MODE(a6)		;Check if true VAT
	beq	\exit

	move.l	a7,a2			;save its address
	lea	winCopyName(PC),a3
	bsr	prep_MoveCpyDel
	tst.w	d1
	beq	\exit

	clr.w	d0
	btst.b	#VAT_FOLDERBIT,VAT_ENTRYFLAG(a1)
	beq.s	\nofolder
	tst.w	d4			;if selection
	bne.s	\nofolder
	moveq.w	#1,d0
\nofolder move.w d0,copy_Mode		;0=file 1=folder

	clr.w	d5			;d5=0:no folder choosen
	bsr	SetAnimatedState	;make animation if needed
	clr.w	(a7)			;count = 0 (in stack frame)

	;--------------------------------------------------
	; Redraw Loop : redraw interface
	;--------------------------------------------------
\redraw	move.l	_win_used,a0
	bsr	InterfaceEngine
	clr.b	1(a0)			;remove animation
	lea	winCopyMove(PC),a0
	bsr	InterfaceEngine

	;--------------------------------------------------
	; If first draw of the window, show SelectFolder
	;--------------------------------------------------
	tst.w	(a7)			;(stack frame)
	bne.s	\notfirst
	move.w	#1,(a7)
	bra	\SelectFolder
	

	;--------------------------------------------------
	; If a folder is selected, draw its name
	;--------------------------------------------------
\notfirst tst.w	d5			;folder choosen?
	beq.s	\waitkey		;if no, skip

	suba.w	#40,a7
	move.l	a7,a0			;addr
	move.w	d5,d0			;handle
	API92_CMPFOLDHDL d0		;if folder=folder list hdl
	bne.s	\noroot			;draw 'root'
	lea	root_move(PC),a1
	bra.s	\draws
\noroot	moveq.w	#25,d1
	jsr	apilib::nf_GetFolderName
	tst.w	d1
	bne.s	\nodest
	move.l	a0,a1
\draws	moveq.w	#45+XO,d0
	moveq.w	#70+YO,d1
	jsr	apilib::draw_StringSpecial
\nodest	adda.w	#40,a7

	;--------------------------------------------------
	; Key Dispatcher
	;--------------------------------------------------
\waitkey bsr	GetKey
	cmp.w	#264,d0
	beq.s	\exit

	;--------------------------------------------------
	; PadLeft > Show SelectFolder
	;--------------------------------------------------
	cmp.w	#PAD_RIGHT,d0
	bne.s	\nopad
\SelectFolder:	bsr _movecopy_SelectFolder
	tst.w	d0
	beq.s	\redraw
	move.w	d0,d5
	bra.s	\redraw

	;--------------------------------------------------
	; ENTER ?
	;--------------------------------------------------
\nopad	cmp.w	#13,d0
	bne.s	\waitkey
	tst.w	d5
	beq.s	\waitkey

	bsr	RealFileIndex			;if d6.w=0 it will return only
						;d0.w -> ok

	;--------------------------------------------------
	; If we are on a folder, move nested folder
	;--------------------------------------------------
	tst.w	copy_Mode
	beq.s	\modefile
	move.w	d5,d1				;Destination folder = new parent
	move.w	VAT_ENTRYHDL(a1),d2		;nested folder
	jsr	apilib::nf_AddFolder
	tst.w	d1
	bne.s	\error
	bra.s	\exit
	
	;--------------------------------------------------
	; Else, if we are on a file, just call function
	; pointed by a4.l
	;--------------------------------------------------
\modefile tst.w	d4				;Selection ?
	beq.s	\noslct
	move.w	d5,d1				;Dest Folder
	lea	cb_ReplaceVar(PC),a0		;ReplaceCB function, if Copy
	jsr	(a5)				;Selection
	bra.s	\skip

\noslct	move.w	d5,d1				;dest folder
	lea	cb_ReplaceVar(PC),a0		;ReplaceCB function, if Copy
	jsr	(a4)

\skip	tst.w	d1
	bne.s	\error

	;--------------------------------------------------
	; Exit : don't forget to refresh plugin table
	;--------------------------------------------------
\exit	bsr	RefreshPluginTable
	adda.w	#40,a7
	bra	LoopRDListArea

\error	bsr	ErrorDlg
	bra.s	\exit

;------------------------------------------------
; return d0 = 0 if cancel
;	else d0=dest folder
;------------------------------------------------
_movecopy_SelectFolder:
	clr.w	d1
	bsr	FontSet				;Font 0
	lea	SelectFolder(PC),a0
	jsr	apilib::SelectFileComponent
	moveq.w	#1,d1				;Font 1
	bsr	FontSet
	rts



;---------------------------------------------------------
; CallBack function for apilib::vat_CopyReplaceRenameVar
;Input>	d0.w : Folder Handle
;	a0.l : Variable Name
;Out>	a0.l : New variable name, JUST if new name needed
;		(buffer of 14 bytes at min)
;	d1.w : Error Code (EC_NEWNAME -> set a new name)
;---------------------------------------------------------
cb_ReplaceVar:
	movem.l	d0/d2-d4/a1-a2,-(a7)
	move.l	a0,a2			;save file name

	;-----------------------------------------
	; Look for file name is the folder
	;-----------------------------------------
	jsr	apilib::vat_Find
	tst.w	d2			;not found
	beq.s	\noerr

	subq.w	#1,d2			;0-based index of file
	move.w	d0,d3			;save folder hdl

	;-----------------------------------------
	; Draw window & file name
	;-----------------------------------------
	lea     winReplaceVar(PC),a0
	bsr	InterfaceEngine

	suba.w	#30,a7
	move.l	a7,a0			;addr of the buffer
	moveq.w	#25,d1			;Max size
	jsr	apilib::nf_GetVatName	;Get item name
	tst.w	d1
	bne.s	\noname
	move.l	a0,a1
	moveq.w #45+XO,d0
	moveq.w #51+YO,d1
	bsr	PrintSp
\noname	adda.w	#30,a7

	;-----------------------------------------
	; Wait a key
	;-----------------------------------------
\waitkey bsr	GetKey
	moveq.w	#EC_FILEEXIST,d1		;default error code (for ESC)
	cmp.w   #264,d0
	beq.s   \exit
	cmp.w	#268,d0
	beq.s	\rename
	cmp.w	#13,d0
	bne.s	\waitkey

	;-----------------------------------------
	; Replace -> delete file first
	;-----------------------------------------
	move.w	d3,d0				;handle
	jsr	apilib::vat_DeleteVar		;D2 is already set
	bra.s	\exit	

\rename	lea	VarEditHeader(PC),a0		;Edit Component
	lea	VarName(PC),a1
	move.w	2(a0),-(a7)			;save y
	move.w	#70+YO,2(a0)
	jsr	apilib::EditComponent
	move.w	(a7)+,2(a0)
	tst.w	d0				;If cancel, skip
	beq.s	\noerr
	move.l	a1,a2
	moveq.w	#EC_PERSONAL,d1
	bra.s	\exit

\noerr	clr.w	d1
\exit	move.l	a2,a0
	movem.l	(a7)+,d0/d2-d4/a1-a2
	rts

VarName: dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0

copy_Mode	dc.w	0
slct_Hdl	dc.w	0
root_move	dc.b	"[root]",0,0
;#ifdef TIPLUS
		dc.w	0
;#endif
		dc.b	0,%00000000
;#ifdef NSTUB
		dc.w	0
;#else
		dc.w	FOLDERLIST_HDL
;#endif

CB_Filter:
	
	movem.l d0-d2/a0-a1,-(a7)
	tst.w	copy_Mode
	beq.s	\skip
	API92_CMPFOLDHDL d6
	bne.s	\skip
	move.w	d7,d0
	bsr	DEREFd0a0
	cmp.w	#1,2(a0)			;if only TI92 item
	bne.s	\skip
\addroot move.w	d7,d0
	move.w	#VATENTRY_SIZE,d1
	lea	root_move(PC),a0
	jsr	apilib::array_AddItem
\skip	movem.l	(a7)+,d0-d2/a0-a1

	btst.b	#VAT_FOLDERBIT,ENTRYFLG+1(a0)
	beq.s	\noadd

	tst.w	copy_Mode
	beq.s	\add

	move.w	VAT_ENTRYHDL(a0),d1
	move.w	slct_Hdl,d0
	cmp.w	d0,d1
	beq.s	\noadd
	jsr	apilib::nf_IsParentOf
	tst.w	d0
	bne.s	\noadd

\add	moveq.w	#1,d0
\exit	rts
\noadd	clr.w	d0
	bra.s	\exit


CB_KeyDown:
	cmp.w	#13,d0
	bne.s	\exit
	tst.w	d6
	beq.s	\exit
	move.w	#2121,d0		;code to exit
\exit	rts

CB_Key:
	cmp.w	#2121,d0
	beq.s	\ok
	clr.w	d0
	bra.s	\exit
\ok	move.w	ENTRYHDL(a1),d0
\exit	rts
	
SelectFolder:
	dc.w	60+XO,50+YO
	dc.w	4
	dc.w	110
	dc.w	0
	dc.b	%01011000,0
	dc.l	CB_Filter
	dc.l	CB_KeyDown
	dc.l	CB_Key
	dc.l	0
	dc.l	0

	