
;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		plugins.xas
;	Utility>	gestion of plugins
;
;-----------------------------------------------------------


PITEM_WIDTH	equ	32
PSKEY_WIDTH	equ	4

;--------------------------------------------------
; Plugin Menu
;--------------------------------------------------
PluginMenu:
	;--------------------------------
	; Create array for short cuts
	;--------------------------------
	moveq.w	#PSKEY_WIDTH,d1			;create the array
	jsr	apilib::array_Create
	move.w	d0,hPluginShortKey			;save handle
	beq	MemoryCatcher			;if error exit

	;--------------------------------
	; Create array for items
	;--------------------------------
	moveq.w	#PITEM_WIDTH,d1			;create the array
	jsr	apilib::array_Create
	move.w	d0,hPluginMenu			;save handle
	beq	MemoryCatcher			;if error exit


	;--------------------------------
	; Fill it 
	;--------------------------------
	lea	_menu_plugin(PC),a0		;
	bsr	_common_ExecPlugin


	;--------------------------------
	; Prepare ListView component
	;--------------------------------
	lea	PluginMenuHeader(PC),a2
	move.w	hPluginMenu(PC),d0
	bsr	DEREFd0a0
	lea	2(a0),a1			;skip first word
	move.w	(a1)+,(a2)			;copy nb item
	bne.s	\skip

	;--------------------------------
	; if no plugin, show item
	; "(no plugin)"
	;--------------------------------
	addq.w	#1,(a2)
	move.w	hPluginMenu(PC),d0		;Add Item
	lea	s_noplugin(PC),a0
	moveq.w	#PITEM_WIDTH,d1
	jsr	apilib::array_AddItem
	cmp.w	#EC_OUTOFMEMORY,d1
	beq	MemoryCatcher
	tst.w	d1
	bne.s	\exit
	move.w	#0,PITEM_WIDTH-2(a1)		;put plugin handle
						;and a1=data

	;--------------------------------
	; Show ListView component
	;--------------------------------
\skip	lea	ph_f(PC),a0
	move.w	(a2),d0				;nb items
	bclr.b	#6,(a0)				;default:no scroll
	move.w	d0,2(a2)				; and 
	cmp.w	#8,d0				;if
	bls.s	\noscroll			; d0<=8 no scroll
	bset.b	#6,(a0)
	move.w	#8,2(a2)

\noscroll:
	move.l	a2,a0				;draw list view component
	movem.l	a2-a3,-(a7)
	move.l	#apilib::ListViewComponent,a3
	bsr	_drawmenu
	movem.l	(a7)+,a2-a3

	clr.w	d3				;default
	cmp.w	#13,d0
	bne.s	\exit

	;--------------------------------
	; If Enter, exec plugin
	;--------------------------------
	move.w	PITEM_WIDTH-2(a0),d0		;Handle of plugin
	beq.s	\exit
	moveq.w	#8,d1				;funtion 8
	clr.w	d2				;don't use extension
	bsr	ExecOnePlugin
	moveq.w	#1,d3				;don't redraw screen

	;--------------------------------
	; Exit:free array
	;--------------------------------
\exit	move.l	d0,-(a7)
	move.w	hPluginMenu(PC),-(a7)		;free buffer
	beq.s	\nofree
	bsr	_HeapFree
\nofree	move.w	hPluginShortKey(PC),(a7)
	beq.s	\nofree2
	bsr	_HeapFree
\nofree2 addq.l	#2,a7
	move.l	(a7)+,d0

	tst.w	d3
	bne	Loop
	moveq.w #12,d1                           ;offset
	bra     CommonMenu



menuCB_DrawItem:

	movem.l	d0-d7/a0-a2,-(a7)
	move.l	d0,d4
	move.l	d1,d5

	move.w	hPluginShortKey(PC),d0		;hdl of buffer
	beq.s	\skip
	bsr	DEREFd0a0			;addr
	lea	2(a0),a1			;skip first word
	tst.w	(a1)+				;is there item?
	beq.s	\skip

	mulu.w	#PSKEY_WIDTH,d6
	add.w	d6,a1
	move.l	d4,d0
	add.w	#88,d0
	move.l	d5,d1
	bsr	PrintSp				;print a1 on (d0,d1)

\skip	movem.l	(a7)+,d0-d7/a0-a2
	moveq.w	#1,d0				;Use internal drawing
	rts


;----------------------------------------------------------
; function used by common_ExecPlugin function to retrieve
; all the strings that should be in the plugin menu
;----------------------------------------------------------
_menu_plugin:
	movem.l	d2/a0-a2,-(a7)

	;-------------------------------
	; Hide Menu or not ??
	;-------------------------------
	moveq.w	#10,d1			;Function ID
	clr.w	d2			;No Extension
	move.l	d0,-(a7)		;Save plugin handle
	bsr	ExecOnePlugin
	move.l	d1,d2
	move.l	(a7)+,d1		;restore plugin handle
	cmp.w	#$FFFE,d2		;execution error
	beq.s	\exit
	tst.w	d0			;if fct not used, return
	bne.s	\exit

	move.l	d1,d0

	;-------------------------------
	; Else use menu
	;-------------------------------
	bsr	GetPluginAddr

\no_ext	move.l  8(a1),d1                ;get offset of PLUGIN_TABLE
	add.w	#7*4,d1			;get offset of string
;#ifdef TIPLUS
	move.l	2(a0,d1),d1
;#else
        move.l   0(a0,d1),d1
;#endif
	beq.s   \exit			;if null, no string
;#ifdef TIPLUS
	lea	2(a0,d1),a2
;#else
	lea	0(a0,d1),a2
;#endif

	;-------------------------------
	; add 1 string item
	;-------------------------------
	move.w	hPluginMenu(PC),d0		;Add Item
	moveq.w	#PITEM_WIDTH,d1
	jsr	apilib::array_AddItem
	tst.w	d1
	bne.s	\exit

	;-------------------------------
	; and copy hdl+string into		
	;-------------------------------
	move.w	-2(a3),d0			;hdl of current plugin
	bclr.l	#15,d0				;clear flag if archived
	move.w	d0,PITEM_WIDTH-2(a1)		;put plugin handle
\cpy	move.b	(a2)+,(a1)+			;and copy string
	bne.s	\cpy

	;-------------------------------
	; Add 1 shortkey string item
	;-------------------------------
	move.w	hPluginShortKey(PC),d0		;Add Item
	moveq.w	#PSKEY_WIDTH,d1
	jsr	apilib::array_AddItem
	tst.w	d1
	bne.s	\exit

	;-------------------------------
	; And copy string into
	; (only 3bytes+0 )
	;-------------------------------
\cpy2	move.b	(a2)+,(a1)+
	move.b	(a2)+,(a1)+
	move.b	(a2)+,(a1)+
	clr.b	(a1)+

\exit	clr.l	d1				;next plugin
	subq.l	#1,d1

	movem.l	(a7)+,d2/a0-a2
	rts




;/////////////////////////////////////////////////
; DATA
;/////////////////////////////////////////////////

hPluginMenu dc.w	0

hPluginShortKey dc.w	0



PluginMenuHeader:
	dc.w	0			;NbItem
ph_nbpp	dc.w	8			;NbItemPerPage
	dc.w	PMENUX			;X
	dc.w	12			;Y
	dc.l	0			;reserved
	dc.w	101			;Width
	dc.w	PITEM_WIDTH		;Constant size of each item
	dc.w	0			;Constant height
ph_f:	dc.b	%01000010,0		;flags
	dc.l	0
	dc.l	mnuGeneralKeys
	dc.l	0
	dc.l	menuCB_DrawItem
	dc.l	0


