;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		multisty.mdl
;	Utility>	Multi-Style Management
;
;-----------------------------------------------------------


;---------------------------------------------------
; MultiStyle Flag :
;
;	0000000x	: Set if use a true VAT
;	000000x0	: Set if VirtualList Mode
;	00000x00	: Set if Link Mode
;---------------------------------------------------

;DrawItem
;Input>	d0.w : X
;	d1.w : Y
;	a2.l : Var Entry

;MakeList:
;Input>	
;Out>	Set NbItem, ListBuf_Hdl
;	a2.l : addr of nbitem in VAT
;	d1.w : error code

;Maked6d7Valid
;Input>	d2.w : nb items
;	d6.w,d7.w : initial values
;Out>	d6,d7 : new values
;	d5.w : Nb *Var* Per Page


;---------------------------------------------------
; MultiStyle jumps
;---------------------------------------------------
MakeList:       move.l  S_MAKELIST(a6),-(a7)
		rts
;PrintList:      move.l  S_PRINTLIST(a6),-(a7)
;		rts
;RedrawList:     move.l  S_REDRAWLIST(a6),-(a7)
;		rts
;_Rd_WML:        move.l  S_RWML(a6),-(a7)
;		rts

DrawItem:	btst.b	#0,S_MODE(a6)			;Check if true VAT
		beq.s	\skip
	;-------------------------------------------
	; PLUGIN - FUNCTION 6 -  DrawItem
	;-------------------------------------------
		movem.l	d0-d4/a0-a1,-(a7)
		moveq.w #6,d4
		move.l  d1,-(a7)
		bsr     ExecPlugin
		addq.l  #4,a7
		tst.w   d0
		bne     \exit           	;SKIP_PCTPROCESS ?
		movem.l	(a7)+,d0-d4/a0-a1
\skip		move.l  S_DRAWITEM(a6),-(a7)
		rts
\exit		movem.l	(a7)+,d0-d4/a0-a1
		rts

DrawFirstItem:  move.l  S_DRAWFIRSTITEM(a6),-(a7)
		rts
PadDOWN:        move.l  S_PADDOWN(a6),-(a7)
		rts
PadUP:          move.l  S_PADUP(a6),-(a7)
		rts
SelectItem      move.l  S_SLCTITEM(a6),-(a7)
		rts
ClrList:        move.l  S_CLRLIST(a6),-(a7)
		rts
DeleteItem:     move.l  S_DELETEITEM(a6),-(a7)
		rts
ShowComment:    move.l  S_SHOWCOMMENT(a6),-(a7)
		rts
KeyEnter:       move.l  S_KEYENTER(a6),-(a7)
		rts
EnableMenus:    move.l  S_ENABMENUS(a6),-(a7)
		rts
InitStyle:      move.l  S_INITSTYLE(a6),-(a7)
		rts
StyleInterface: move.l  S_INTERFACE(a6),-(a7)
		rts
GetItemXY:      move.l  S_GETITEMXY(a6),-(a7)
		rts
PadLeft:        move.l  S_PADLEFT(a6),-(a7)
		rts
PadRight:       move.l  S_PADRIGHT(a6),-(a7)
		rts
OtherKey:       move.l  S_OTHERKEY(a6),-(a7)
		rts
BeforeDrawingList: move.l S_BEFOREDRAWINGLIST(a6),-(a7)
		rts
RedrawListArea:	move.l	S_REDRAWLISTAREA(a6),-(a7)
		rts
Refresh_UpBar:	move.l	S_REFRESHUPBAR(a6),-(a7)
		rts

s_NOP_Loop:	bra	Loop
s_NOP_Rts:	rts

;-------------------------------------------------
; Set a new style
;Input>	d0.w : STYLE_?? constant
;		(see intro.mdl)
;-------------------------------------------------
SetStyle:
	movem.l	d0-d4/a0-a4,-(a7)

	bsr	Free_ListBuf

	tst.w	d0
	bne.s	\skip1
	lea	VirtualList(PC),a0
	bra.s	\set
\skip1	cmp.w	#STYLE_LINK,d0
	bne.s	\skip2
	lea	Style_Link_Folders(PC),a0
	bra.s	\set
\skip2	cmp.w	#STYLE_PLUGIN,d0
	bne.s	\skip3
	lea	PluginList(PC),a0
	bra.s	\set

\skip3	bsr	GetStyleAddr
	API92_FOLDHDL ListReal_Hdl

\set	move.l	a0,a6
	bsr	InitStyle
	bsr	PrintList

	movem.l	(a7)+,d0-d4/a0-a4
	rts


;-------------------------------------------------
; Get the address of current used style 
; (according the the Style menu
;Input> nothing
;Out>   a0.l : addr of style
;-------------------------------------------------
GetStyleAddr:
	move.l  a1,-(a7)
	lea     mnuStyleProperties(PC),a1

	lea     Style1(PC),a0		;Detailed
	cmp.b   #7,(a1)+
	beq.s   \ok

	lea     Style2(PC),a0		;List
	cmp.b	#7,(a1)+
	beq.s	\ok
	lea	Style3(PC),a0		;Tree

\ok	move.l  (a7)+,a1
	rts

;------------------------------------------------
;Out>	d0.w : 0 = VLIST
;		cf STYLEID_.. constants in intro.mdl
;------------------------------------------------
GetCurrentStyleID:
	movem.l	d1/a0,-(a7)

	lea	tableStyleAddr(PC),a0
	clr.w	d0
	moveq.w	#7,d1
\loop	cmp.l	(a0)+,a6
	beq.s	\ok
	addq.l	#1,d0
	dbra.s	d1,\loop
	
\ok	movem.l	(a7)+,d1/a0
	rts

; no plugin or link style for the moment
tableStyleAddr:	dc.l	VirtualList
		dc.l	Style1,Style2,Style3,Style3_file
		dc.l	Style_Link_Folders,Style_Link_Files
		dc.l	PluginList


;	d0.w = STYLEID constant
;	a0.l = Addr
GetStyleIDAddr:
	move.l	d0,-(a7)
	lsl.w	#2,d0			;d0*4
	lea	tableStyleAddr(PC),a0
	adda.w	d0,a0
	move.l	(a7)+,d0
	rts

;
;
;
SetNewVarStyleIfNeeded:
	movem.l	d0-d2/a0-a2,-(a7)

	btst.b	#0,S_MODE(a6)		;check if true VAT
	beq.s	\nonew
	bsr     GetStyleAddr		;Get style addr
	cmp.l   a0,a6			;if no new, skip
	beq.s   \nonew

	exg.l	a0,a6
	bsr	GetCurrentStyleID
	move.w	d0,d1			;d1=required new style
	exg.l	a0,a6
	bsr	GetCurrentStyleID	;d0=current style
	cmp.w	#STYLEID_TREE,d1
	bne.s	\notree
	cmp.w	#STYLEID_TREEF,d0
	beq.s	\nonew

\notree	move.l  a0,a6			;else init new style
	bsr     InitStyle

\nonew	movem.l	(a7)+,d0-d2/a0-a2
	rts



;------------------------------------------------
; Get the addr of the virtual list
; Check the memory errors
; out>  d1.w : hdl
;       a0.l : addr
;------------------------------------------------
GetListBufAddr:
	move.l  d0,-(a7)
	move.w  ListBuf_Hdl(PC),d0      ;hdl of buffer
	bne.s   \buf                    ;no memory error
	move.w  ListReal_Hdl(PC),d0     ;else d1=addr of real file list
\buf    bsr     DEREFd0a0
	addq.l  #2,a0                   ;skip first word
	exg.l   d0,d1                   ;exchange hdl
	move.l  (a7)+,d0
	rts


;--------------------------------------------------
; This function return the address of the selected
; item VAT entry
; out>  a0.l : addr of VAT entry addr
;       d1.w : hdl of current list
;--------------------------------------------------
GetCurrentVATAddr:
	move.l  d6,-(a7)
	tst.w	d6
	beq	EC_d6null
	; cmp.w	NbItem(PC),d6	;marche pas, cf quand on construit la liste
	; bge	EC_d6toobig	;NbItem n'est pas encore mis a jour
	bsr.s   GetListBufAddr
	mulu.w  #VATENTRY_SIZE,d6
	lea     -ENTRYHDL(a0,d6.w),a0
	move.l  (a7)+,d6
	rts

;-------------------------------------------------
; return the addr of the real VAT list
;out>   d0.w : hdl of real list
;       a2.l : addr of real list
;-------------------------------------------------
GetRealListAddr:
	move.l  a0,-(a7)
	move.w  ListReal_Hdl(PC),d0
	bsr     DEREFd0a0
	lea     2(a0),a2
	move.l  (a7)+,a0
	rts

;-------------------------------------------------
;GetItemType
;Get if the selected item is a file, a normal
;folder, a special folder or a protected folder
;
;input> a0.l : addr of VAT
;out>   d1.w :  0 = file
;               1 = folder
;               3 = protected folder
;-------------------------------------------------
GetItemType:    
	moveq.w #3,d1           ;prt
	btst.b  #PRT_BIT,ENTRYFLG(a0)
	bne.s   \exit

	moveq.w #1,d1           ;folder
	btst.b  #7,ENTRYFLG+1(a0)
	bne.s   \exit

	clr.w   d1              ;file
\exit   rts


;---------------------------------------------------
; Free the memory used by the list buffer
; and set ListBuf_Hdl to 0
;---------------------------------------------------
Free_ListBuf:
	movem.l d0-d2/a0-a2,-(a7)
	lea     ListBuf_Hdl(PC),a2      ;addr of buffer list
	tst.w   (a2)                    ;if zero
	beq.s   \exit                   ;don't destroy

	move.w  (a2),-(a7)
	bsr	_HeapFree
	addq.l  #2,a7

	clr.w   (a2)
\exit   movem.l (a7)+,d0-d2/a0-a2
	rts


;--------------------------------------------------
; Function used by ALL styles to start redrawing
; the list
;--------------------------------------------------
PrintList:
	moveq.w	#1,d6
	moveq.w	#1,d7
	bsr	DeSelectAll		;Deselect all items

RedrawList: bsr	MakeList		;Create the buffer

_Rd_WML:
	movem.l	d0-d5/a0-a4,-(a7)

	INTERRUPT_OFF

	move.w	NbItem(PC),d2		;NbItem in d2
	bsr	BeforeDrawingList

	bsr	sg1_CommonDrawList	;a2 is set

	INTERRUPT_ON
	movem.l	(a7)+,d0-d5/a0-a4
	rts

