;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		style_g2.xas
;	Utility>	General routines 2 for styles
;
;-----------------------------------------------------------



;--------------------------------------------------
; BigDown is called when the user press 
; [2nd]+[pad down]
;--------------------------------------------------
sg2_BigDown:
	move.w  NbItem(PC),d0   ;d0=NbItem
	move.w  d6,d1           ;save d6
	cmp.w   d0,d6
	beq.s   goloop2

	add.w   #NBVARPERPAGE-1,d6          ;
	cmp.w   d0,d6
	bcs.s   \noend
	move.w  d0,d6

\noend	move.w  d6,d0
	sub.w   d1,d0

	add.w   d0,d7
	cmp.w   #NBVARPERPAGE-1,d7
	ble.s   \nobottom       ;=< signed
	moveq.w #NBVARPERPAGE-1,d7  
\nobottom
	
BigUpDn: bsr     RedrawList_WML
	bsr     ShowComment
goloop2	bra	Loop


;--------------------------------------------------
; BigDown is called when the user press 
; [2nd]+[pad up]
;--------------------------------------------------
sg2_BigUp:
	tst.w   d6
	beq.s   goloop2
	sub.w   #NBVARPERPAGE-1,d6
	tst.w   d6
	bge.s   \nofirst        ;>= signed
	clr.w   d6

\nofirst sub.w  #NBVARPERPAGE-1,d7
	tst.w   d7
	bge.s   \nof2
	clr.w   d7
\nof2   bra.s   BigUpDn



;-------------------------------------------------
; Jump to files thanks to the first char of
; their name
;Input>	/
;Out>	d2.w : 0 if error else ok
;	d4.w : new pos
;-------------------------------------------------
sg2_GoLetter:
	;----------------------------------------
	;if d6=0 just get first item of buf addr
	;----------------------------------------
	tst.w	d6
	bne.s	\nofst
	bsr	GetListBufAddr
	addq.l	#4,a0
	bra.s	\skip
	;----------------------------------------
	;else get current selected item
	;----------------------------------------
\nofst	bsr     GetCurrentVATAddr	;get current VAT addr
\skip

	move.w  NbItem(PC),d3
	move.w  d3,d2			;save d3
	beq.s   \exit			;exit if null
	sub.w   d6,d3           	;nb loop for first search
	beq.s   \f2
	subq.w  #1,d3			;for dbra

	move.w  d6,d4			;first search : search AFTER
	adda.w  #VATENTRY_SIZE,a0	;current pos
\find   addq.w  #1,d4
	cmp.b   (a0),d0
	beq.s   \okex
	lea     VATENTRY_SIZE(a0),a0
	dbra.s  d3,\find
					;if not found, search from
					;the beginning of the list
\f2     subq.w  #1,d2			;for dbra
	bsr     GetListBufAddr		;addr of list
	addq.l  #2,a0
	clr.w   d4
\find2  addq.w  #1,d4
	cmp.b   (a0),d0
	beq.s   \okex
	lea     VATENTRY_SIZE(a0),a0
	dbra.s  d2,\find2
	bra.s	\err

\okex	cmp.w   d4,d6
	beq.s   \err
	moveq.w	#1,d2

\exit	rts

\err	clr.w	d2
	bra.s	\exit


;-----------------------------------------------------------
; Key Handler
; for VList, Style1
;-----------------------------------------------------------
sg2_OtherKey:
	cmp.w   #PAD_UP+4096,d0
	beq     sg2_BigUp
	cmp.w   #PAD_DOWN+4096,d0
	beq     sg2_BigDown

	cmp.w   #97,d0
	bcs.s   \nolet
	cmp.w   #122,d0
	bls     sg1_GoLetter

\nolet	bra	OK_Continue
