
;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		vlist.xas
;	Utility>	Routines for the virtual list
;
;-----------------------------------------------------------

VirtualList:
	dc.b	%00000010,0
	dc.l	vl_MakeList
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	vl_DrawItem
	dc.l	vl_DrawFirstItem
	dc.l	s1_PadDown
	dc.l	s1_PadUp
	dc.l	s1_SelectItem
	dc.l	s1_ClearList
	dc.l	s1_DeleteItem
	dc.l	vl_ShowComment
	dc.l	vl_KeyEnter
	dc.l	vl_EnableMenus
	dc.l	s1_DrawInterface
	dc.l	vl_InitStyle
	dc.l	sg1_GetItemXY
	dc.l	sg1_PadLeft
	dc.l	sg1_PadRight
	dc.l	sg2_OtherKey
	dc.l	s1_BeforeDrawingList
	dc.l	RedrawList		;RedrawListArea
	dc.l	sg1_RefreshUpBar

;-------------------------------------------------------
;	- Style Function -
; Enter in virtual list mode
;-------------------------------------------------------
vl_InitStyle:
	clr.w	d6
	clr.w	d7

	bsr	CreateVList
	tst.w	d0
	beq.s	\exit

	move.w	d0,ListBuf_Hdl		;put it as a buff list
	move.w	d0,ListReal_Hdl		;put it as a real list

	bsr	StyleInterface

\exit	rts



;-------------------------------------------------------
;	- Style Function -
;
;Create the list to show in the screen
;
;input>
;out>   a2.l : addr of new list
;               (or the same if no memory)
;-------------------------------------------------------
vl_MakeList:
	movem.l	d0-d2/a0-a1,-(a7)

	move.w	ListBuf_Hdl(PC),d0
	beq.s	\exit
	bsr	DEREFd0a0
	lea	2(a0),a2
	move.w	(a2),NbItem

\exit	movem.l	(a7)+,d0-d2/a0-a1
	rts


;------------------------------------------------------
; 	- Style Function -
;------------------------------------------------------
vl_DrawItem:
	move.l	a2,a1
	moveq.w	#24,d0		X
	bsr	PrintSp

	lea	img_table(PC),a0
	clr.w	d2
	move.b	-1(a0,d6.w),d2
	moveq.w #2,d0           ;col (x=16)
	bsr     PutImg          ;draw picture
	rts

img_table:
	dc.b	TI_GFX,SYSTEM_GFX,LINK_GFX,PLUGIN_GFX

;------------------------------------------------------
;	- Style Function -
;	Draw the first item of the list
;------------------------------------------------------
vl_DrawFirstItem:
	lea	vlisttxt(PC),a0
	bsr	printf

	moveq.w	#HOME_GFX,d2
	moveq.w #1,d0
	moveq.w #LSTY,d1
	bsr     PutImg

	rts

;------------------------------------------------------
; 	- Style Function -
;------------------------------------------------------
vl_ShowComment:

	lea	vl_comments(PC),a0
	move.w	d6,d0
	lsl.w	#2,d0
	move.l	0(a0,d0.w),a2
	bsr	ST_Message

	tst.w	isPanelDrawn
	beq.s	\skip
	bsr	s1_ClearRightPanel
	move.w	#0,isPanelDrawn
\skip	rts

vl_comments:
	dc.l	strNul,strTI,strSyst,strLink,strPlugins

;------------------------------------------------------
; 	- Style Function -
;------------------------------------------------------
vl_KeyEnter:
	cmp.w	#1,d6
	bne.s	\noti
	move.w	#STYLE_CURRENT,d0
	bsr	SetStyle
	bra.s	\exit

\noti	cmp.w	#2,d6
	bne.s	\nosyst
	bsr	SystemInfo
	bra	LoopRDList

\nosyst	cmp.w	#3,d6
	bne.s	\nolink
	bsr	LinkService
	bra.s	\exit

\nolink	cmp.w	#4,d6
	bne.s	\noplug
	move.w	#STYLE_PLUGIN,d0
	bsr	SetStyle

\noplug

\exit	bra	Loop

;------------------------------------------------------
; 	- Style Function -
;------------------------------------------------------
vl_MIS:
	;First item
	dc.l	$00000000,$00000000
	dc.w	$0000
	dc.l	$00000001

vl_EnableMenus:
	move.l	a0,-(a7)

	lea	vl_MIS(PC),a0
	bsr	SetMenuItemsState

	move.l	(a7)+,a0
	rts

;-----------------------------------------------------
; Create the virtual list (delete the old if needed)
;Out>	d0.w :  Handle of list if successful
;		0 if error
;-----------------------------------------------------
CreateVList:
	movem.l	d1-d2/a0-a2,-(a7)

	bsr	Free_ListBuf

	move.w	#VATENTRY_SIZE,d1	;create the new array
	jsr	apilib::array_Create
	tst.w	d0			;check if error
	beq.s	\memerror
	move.w	d0,ListBuf_Hdl

	bsr	DEREFd0a0		;get addr
	lea	defaultList(PC),a1
	move.w	#(enddl-defaultList)-1,d1
\cpy	move.b	(a1)+,(a0)+
	dbra.s	d1,\cpy

\exit	movem.l	(a7)+,d1-d2/a0-a2
	rts

\memerror
	bra.s	\exit


;=======================================================
; Definition of variables for the virtual list
;=======================================================

isPanelDrawn dc.w	0

defaultList:
	dc.w	10
	dc.w	4
;#ifdef TI89
	dc.b	"TI89"
;#else
	dc.b	"TI92"
;#endif
	dc.b	0,0,0,0,0,0,0,0
;#ifdef TIPLUS
	dc.b	0,0
;#endif
	dc.b	"System",0,0,0,0,0,0
;#ifdef TIPLUS
	dc.b	0,0
;#endif
	dc.b	"Link",0,0,0,0,0,0,0,0
;#ifdef TIPLUS
	dc.b	0,0
;#endif
	dc.b	"Plugins",0,0,0,0,0
;#ifdef TIPLUS
	dc.b	0,0
;#endif

enddl

	ds.w	0
