;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : Huffman Compression Plugin
;=====================================================================

	include "tios.h"                ;library includes files
	include "flib.h"
	include "ziplib2.h"
	include	"APILib.h"
	include "APILibCT.h"

	xdef    _main                   ;normal assembly program
	xdef    _comment

	include "pctplug.h"             ;and after we include pctplug.h

;--------------------------------------------------------------------
; Start of PCTOOLS 98 plugin
;--------------------------------------------------------------------
plug_SPEXT	equ	0		;specific extension ?

	PRG_AS_PLUGIN

PLUGIN_TABLE:
	dc.l    NOT_USED         	;1:Initialization of PCT98
	dc.l    NOT_USED                ;2:End of PCT98
	dc.l    NOT_USED              	;3:Key pressed
	dc.l    NOT_USED                ;4:ENTER pressed
	dc.l    NOT_USED            	;5:Cursor moved
	dc.l    NOT_USED                ;6:Show Item
	dc.l	CompressionService	;7:Compression Service

END_PLUGIN_TABLE:
	;(...)                          the program can continue
	rts

;---------------------------------------------------------------------
; Compression Service Function
; This function is called when PCT98 want to :
; * Compress/Extract a single file archive
; * Extract temporarily a single file archive
;
; It should in a future version support multiple
; files archives
;
;Input>	a0.l : Address of a PluginParameters structure
;	04(a0).w : 
;		ZIP_SWAPMODE (0) : Compress or extract
;				a single file archive
;		ZIP_TMPEXTRAT (1) : Extract temporarily
;				a single file archive
;Out>	if ZIP_TMPEXTRAT : return value2.w : 
;			0 if error
;			else handle of created buffer
;
;RETURN> SHOW_MESSAGE : request to print a message in the
;	  status bar. The message is pointed by rg2 and must
;	  be valid
;	 SKIP_PCTPROCESS : request that PCT98 don't print something
;	  in the status bar
;---------------------------------------------------------------------
CompressionService:
	move.w	20(a0),d1		;hdl of selected file
	beq.s	\exit
	move.w	18(a0),d0		;hdl of folder
	jsr	apilib::vat_HdlToPos
	tst.w	d1
	beq.s	\exit
	subq.w	#1,d1

	cmp.w	#ZIP_TMPEXTRACT,4(a0)
	beq.s	ZipTmpExtract

	jsr	ziplib2::zip_file

\exit	rtplugin	(SKIP_NEXTPLUGINS+REDRAW_SCREEN)

ZipTmpExtract:
	jsr	ziplib2::extract_tmp
	move.w	d0,4(a0)
	rtplugin	SKIP_NEXTPLUGINS

;====================================================================
; Plugin Data
;====================================================================
_comment
	dc.b    "HuffZIP PCT98 Plugin",0
	end

