;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : XExpr Plugin
;			  Show EXPR files,with a scrolling
;			  if needed
;=====================================================================

	include 	"tios.h"			;library includes files
	include		"APILib.h"
	include 	"APILibCT.h"

	xdef    	_main				;normal assembly program
	xdef    	_comment

;#ifdef TI89
	 xdef		_ti89
WSCR	equ	160
HSCR	equ	92
V1	equ	35
V2	equ	52

OX	equ	-40
OY	equ	-10

;#else
	xdef		_ti92plus
WSCR	equ	240
HSCR	equ	120
V1	equ	12
V2	equ	80

OX	equ	0
OY	equ	0

;#endif

MIDDLEX equ	WSCR/2
MIDDLEY equ	HSCR/2

	include 	"pctplug.h"             ;and after we include pctplug.h

;--------------------------------------------------------------------
; Header of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	4,EXT_LIST,EXT_MAT,EXT_EXPR,EXT_STR
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	NOT_USED		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	KeyEnter		;enter_pressed
	dc.l	NOT_USED		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	NOT_USED		;
	dc.l	NOT_USED		;
	dc.l	NOT_USED		;
	dc.l	NOT_USED		;hide_menu


;--------------------------------------------------------------------
; Normal launch of the program
;--------------------------------------------------------------------
END_PLUGIN_TABLE:

StartPrgm:
	lea		ieAbout(PC),a0
	jsr		apilib::InterfaceEngine
	rts



KeyEnter:
	move.w		$10(a0),d7			;Handle of selected item

	;--------------------------------------------
	; Create a window, pointed by a5
	;--------------------------------------------
	move.l		tios::top_estack,d4		;save estack
	move.l		a7,a6

	suba.w		#60*4,a7			;create stack frame
	move.l		a7,a5				;save stack frame addr

	move.w		#$300,-(a7)			;window flag
	pea		rect(Pc)			;window size
	move.l		a5,-(a7)			;window structure area
	jsr    	tios::WinOpen		;Open window
	tst.b		d0
	beq		\w_err

	;--------------------------------------------
	; Check if protected tag
	;--------------------------------------------
	move.w   	d7,-(a7)			;Push Expr handle
	jsr    	tios::HToESI		;build ESI
	move.l		a0,a2
	move.b		(a0),-(a7)			;pushes *ESI
	jsr		tios::QSysProtected
	tst.w		d0
	bne		\exit

	;--------------------------------------------
	; Build picture data
	;--------------------------------------------
	clr.w		-(a7)				;
	move.l		a2,-(a7)			
	jsr    	tios::Parse2DExpr		;build picture, return in a0
	move.l		a0,a2				;save a0
	pea		bottom(pc)
	pea		top(pc)
	pea		width(pc)
	move.l		a2,-(a7)
	jsr		tios::Parms2D

	;--------------------------------------------
	; now show picture, according to :
	; d6 = x
	; d7 = y
	;--------------------------------------------

	move.w		bottom(PC),d7
	clr.w		d6

\loop:	;--------------------------------------------
	; turn off interruption for speed reason
	;--------------------------------------------
	move.w		#$500,d0			;turn off interruptions
	trap		#1
	move.l		d0,-(a7)

	;--------------------------------------------
	; Show picture
	;--------------------------------------------
	jsr		apilib::ClearScreen		;Faster than tios::WinClr
	move.w		d7,-(a7)			;y
	move.w		d6,-(a7)			;x
	move.l		a5,-(a7)
	move.l		a2,-(a7)			;picture data
	jsr    	tios::Print2DExpr		;Show in pretty print
	lea		12(a7),a7		

	;--------------------------------------------
	; Check which move is autorised
	;--------------------------------------------
	clr.w		d5				;Mode
	tst.w		d6
	beq.s		\noleft
	bset.b		#0,d5
\noleft move.w	d6,d0
	add.w		width(PC),d0
	sub.w		#LCD_WIDTH-V1,d0
	cmp.w		LCD_WIDTH,d0
	bgt.s		\skip1
	bra.s		\noright
\skip1	bset.b		#1,d5
\noright cmp.w	bottom,d7
	beq.s		\noup
	bset.b		#2,d5
\noup	move.w		d7,d0
	add.w		top(PC),d0
	sub.w		#LCD_HEIGHT-V2,d0
	cmp.w		LCD_HEIGHT,d0
	bgt.s		\skip2
	bra		\nodown
\skip2	bset.b		#3,d5
\nodown

	bsr		DrawArrow

	;--------------------------------------------
	; turn on interruptions
	;--------------------------------------------
	move.l		(a7)+,d0			;turn on interruptions
	trap		#1

	;--------------------------------------------
	; Key Loop
	;--------------------------------------------
\waitkey jsr		apilib::WaitKey
	cmp.w		#KEY_LEFT,d0
	beq.s		\left
	cmp.w		#KEY_RIGHT,d0
	beq.s		\right
	cmp.w		#KEY_UP,d0
	beq.s		\up
	cmp.w		#KEY_DOWN,d0
	beq.s		\down

	cmp.w		#264,d0
	bne.s		\waitkey

	;--------------------------------------------
	; End of the prog : close the window
	;--------------------------------------------
\exit	move.l		a5,-(a7)
	jsr		tios::WinClose

	;--------------------------------------------
	; delete stack frame & restore estack
	;--------------------------------------------
\w_err	adda.w		#60*4,a7				;delete stack frame
	move.l		a6,a7
	move.l		d4,tios::top_estack

	rtplugin SKIP_NEXTPLUGINS+REDRAW_SCREEN+SKIP_PCTPROCESS


	;--------------------------------------------
	; Key Manegement
	;--------------------------------------------
\left	btst.b		#0,d5					;test mode
	beq.s		\waitkey
	addq.w		#8,d6
	bra		\loop

\right	btst.b		#1,d5
	beq.s		\waitkey
	subq.w		#8,d6
	bra		\loop

\up	btst.b		#2,d5
	beq.s		\waitkey
	addq.w		#8,d7
	bra		\loop

\down	btst.b		#3,d5
	beq.s		\waitkey
	subq.w		#8,d7
	bra		\loop

;---------------------------------------------------------------------
;Draw arrow, according to d5.b
; 0000000x : if set draw left arrow
; 000000x0 : if set draw right arrow
; 00000x00 : if set draw up arrow
; 0000x000 : if set draw down arrow
;---------------------------------------------------------------------
DrawArrow:
	moveq.w	#3,d3
	lea		ArrowData(PC),a0

\loop	btst.b		d3,d5
	beq.s		\skip

	move.w		#LCD_WIDTH,d0
	move.w		#LCD_HEIGHT,d1
	move.w		(a0),d0
	move.w		2(a0),d1
	move.w		4(a0),d2
	jsr		apilib::draw_CharSpecial

\skip	lea		6(a0),a0
	dbra.s		d3,\loop

	rts

;====================================================================
; Plugin Data
;====================================================================
ArrowData:	dc.w		MIDDLEX,HSCR-7,20
		dc.w		MIDDLEX,0,19
		dc.w		WSCR-7,MIDDLEY,18
		dc.w		0,MIDDLEY,17

rect		dc.w		0,0,LCD_WIDTH,LCD_HEIGHT-8
width		dc.w		0
top		dc.w		0
bottom		dc.w		0

ieAbout:	dc.b		IE_ANIMEDWIN2,50,50+OX,40+OY,189+OX,80+OY,"XExpr Plugin",0
		dc.b		IE_SETFONT,1
		dc.b		IE_STRING,58+OX,53+OY,"XExpr Plugin",0
		dc.b		IE_SETFONT,0
		dc.b		IE_STRING,58+OX,66+OY,"for Pctools, release 1.0.2",0
		dc.b		IE_STRING,58+OX,72+OY,"Ibrahim/Benoit Scherrer",0
		dc.b		IE_SOLIDRECT,58+OX,62+OY,178+OX,63+OY
		dc.b		IE_WAITKEY
		dc.b		IE_END


_comment	dc.b		"XExpr Plugin",0

	
	end

