;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : XExpr Plugin
;			  Show EXPR files,with a scrolling
;			  if needed
;=====================================================================

	include 	"tios.h"			;library includes files
	include		"APILib.h"
	include 	"APILibCT.h"

	xdef    	_main				;normal assembly program
	xdef    	_comment

	include 	"pctplug.h"             ;and after we include pctplug.h

;--------------------------------------------------------------------
; Header of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	4,EXT_LIST,EXT_MAT,EXT_EXPR,EXT_STR
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	NOT_USED		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	NOT_USED		;enter_pressed
	dc.l	NOT_USED		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	NOT_USED		;
	dc.l	NOT_USED		;
	dc.l	NOT_USED		;
	dc.l	NOT_USED		;hide_menu



IS_READY_SIZE		equ	4
is_ready_data:	dc.b	$08,$68,$00,$00

;--------------------------------------------------------------------
; Normal launch of the program
;--------------------------------------------------------------------
END_PLUGIN_TABLE:

StartPrgm:
	bsr	dbglink_init
	bsr	IsCalcReady
	

	move.l	dbglink_addr(PC),a0
	move.b	#$0D,-1(a0)
	move.b	#$20,(a0)+
	move.b	#0,(a0)+

	rts
	
	
;-----------------------------------------------------
; Check if the calc is ready
;Out>	d0.w : 0 = false 1 = true
;-----------------------------------------------------
IsCalcReady
	movem.l d1-d2/a0-a2,-(a7)
	move.l	#IS_READY_SIZE,-(a7)
	pea	is_ready_data(PC)
;#ifdef DBGLINK
	bsr		dbglink_printsend
	bsr		dbglink_printbytes
	bsr		dbglink_printline
;#endif
	jsr		tios::LIO_SendData
	addq.l	#8,a7

	bsr	WaitForAck
	movem.l (a7)+,d1-d2/a0-a2
	rts
	
;-----------------------------------------------------
;Out>	d0.w : Byte
;-----------------------------------------------------
GetByte:
	movem.l d1-d2/a0-a2,-(a7)

	clr.w	-(a7)
	move.l	a7,a2

	move.l	#50,-(a7)
	move.l	#1,-(a7)
	move.l	a2,-(a7)
	jsr	tios::LIO_RecvData
	lea	12(a7),a7

	tst.w	d0
	bne	\LinkErrorCatcher

	clr.l	d0
	move.b	(a2),d0

\exit addq.l	#2,a7
	
;#ifdef DBGLINK
	bsr	dbglink_printbyte
;#endif
	
	movem.l (a7)+,d1-d2/a0-a2
	rts

\LinkErrorCatcher
	clr.l	d0
	bra.s	\exit
	
;-------------
; OLD VERSION
;-------------
	movem.l d1-d3/a0-a2,-(a7)
	clr.w	-(a7)
	move.l	a7,a2
	move.l #$5000,d3			;timer

\wait	move.w	#1,-(a7)			;only one byte
	move.l	a2,-(a7)			;buffer addr
	jsr	tios::OSReadLinkBlock
	addq.l	#6,a7

	subq.l	#1,d3
	;beq	LinkErrorCatcher

	tst.w	d0				;0 bytes read ?
	beq.s	\wait				;wait
	
	clr.w	d0
	move.b	(a2),d0
	addq.l	#2,a7				;delete stack frame
	movem.l (a7)+,d1-d3/a0-a2
	rts
	

;-----------------------------------------------------
; WaitForAck
;Input>
;Out>		d0.w : 0=false  1=true
;-----------------------------------------------------
WaitForAck:
;#ifdef DBGLINK
	bsr	dbglink_waitack
;#endif
	bsr	GetByte		;Get ID_CALC
	bsr	GetByte
	cmp.b	#$56,d0
	bne.s	\failed
	bsr	GetByte
	bsr	GetByte
	moveq.w #1,d0
\exit
;#ifdef DBGLINK
	bsr		dbglink_printline
;#endif
	rts
	
\failed clr.w	d0
	bra.s	\exit
	
	
	
	
DEREFd0a0:	;pct.tmp(6799)
	move.l	d0,-(a7)	;pct.tmp(6800)
	jsr	apilib::DEREFd0a0	;pct.tmp(6801)
\exit	move.l	(a7)+,d0	;pct.tmp(6805)
	rts	;pct.tmp(6806)
	
dbglink_filename	dc.b	"dbglink",0
dbglink_hdl			dc.w	0
dbglink_addr		dc.l	0

strdbglink_send		dc.b "Send : ",0
strdbglink_rec			dc.b "Rec : ",0
strdbglink_waitack			dc.b "WaitAck : ",0
strdbglink_request			dc.b "Request : ",0
strdbglink_continueornot			dc.b "Continue or not : ",0
strdbglink_getlinkheader			dc.b "GetLinkHeader: ",0
strdbglink_getvatentry			dc.b "GetVatEntry: ",0
	ds.w	0
;-----------------------------------------------------
; Init link
;-----------------------------------------------------
dbglink_init:
	movem.l	d0-d2/a0-a2,-(a7)
	
	;------------------------------------------
	; Look for variable
	;------------------------------------------
	lea		dbglink_filename(PC),a0
	move.w	#tios::MainHandle,d0						;Handle of 'Main' folder
	jsr		apilib::vat_Find					;find 'nested' file
	tst.w	d2
	bne		\exit

	;------------------------------------------
	; if not found create it
	;------------------------------------------
\create	
	move.w	#tios::MainHandle,d0						;Handle of 'Main' folder*
	clr.w	d1								;flags
	move.w	#8192,d2						;size
	lea		dbglink_filename(PC),a0				;address of filename
	jsr		apilib::vat_CreateVar

	;------------------------------------------
	; Lock variable and get its addr
	;------------------------------------------
\exit	move.w	d0,dbglink_hdl
	bne.s	\getadr
	clr.l	d0
	move.l	d0,a0
	bra.s	\end
\getadr

	movem.l	d0-d2/a0-a2,-(a7)
	move.w	d0,-(a7)
	jsr		tios::HeapLock
	addq.l	#2,a7
	movem.l	(a7)+,d0-d2/a0-a2
	
	bsr	DEREFd0a0
	move.w	#8190,(a0)+
	move.b	#$0,-2+8190(a0)
	move.b	#$E0,-1+8190(a0)
	move.b	#$08,8190(a0)
	
	move.w	#$000A,(a0)+
	move.b	#$20,(a0)+
	
\end move.l	a0,dbglink_addr

	movem.l	(a7)+,d0-d2/a0-a2
	rts
	
;-----------------------------------------------------
; print text message
; msg : A1.l
;-----------------------------------------------------
dbglink_printmsg:
	movem.l	d0-d4/a0-a4,-(a7)
	move.l	dbglink_addr(PC),a0
\msg move.b (a1)+,(a0)+
	bne.s	\msg
	subq.l	#1,a0	
	move.l	a0,dbglink_addr
	movem.l	(a7)+,d0-d4/a0-a4
	rts
	
dbglink_printsend:
	move.l	a1,-(a7)
	lea		strdbglink_send(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts

dbglink_printrec:
	move.l	a1,-(a7)
	lea		strdbglink_rec(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_waitack:
	move.l	a1,-(a7)
	lea		strdbglink_waitack(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_request:
	move.l	a1,-(a7)
	lea		strdbglink_request(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_continueornot:
	move.l	a1,-(a7)
	lea		strdbglink_continueornot(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts

dbglink_getvatentry:
	move.l	a1,-(a7)
	lea		strdbglink_getvatentry(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_getlinkheader:
	move.l	a1,-(a7)
	lea		strdbglink_getlinkheader(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_printline:
	move.l	a0,-(a7)
	move.l	dbglink_addr(PC),a0
	move.b	#$0D,-1(a0)
	move.b	#$20,(a0)+
	move.l	a0,dbglink_addr
	move.l	(a7)+,a0
	rts
	
;-----------------------------------------------------
; byte : d0.b
;-----------------------------------------------------
dbglink_printbyte:
	movem.l	d0-d4/a0-a4,-(a7)
	move.l	dbglink_addr(PC),a0
	
	and.l	#$FF,d0
	moveq.w	#1,d4
\loop
	move.l	d0,d3		; save the number
	move.l	d4,d2		; d2=Nb of charac-1
	lsl.l	#2,d2		; d2 = 4*loopcount (# bits to shift)
	lsr.l	d2,d0
	and.l	#$0000000F,d0

	cmp.l	#9,d0		;d0=9?
	bhi.s	\letter
	add.l	#48,d0		;d0=48
	bra.s	\char
\letter	
	add.l	#55,d0		;d0=d0+55
\char
	move.b	d0,(a0)+
	move.l	d3,d0		; restore the number
	dbf.w	d4,\loop

	move.b	#32,(a0)+
	move.l	a0,dbglink_addr
	movem.l	(a7)+,d0-d4/a0-a4
	rts
		
;-----------------------------------------------------
; dbglink_printbytes ( ULONG size, void *data )
;-----------------------------------------------------
dbglink_printbytes:
	movem.l	d0-d2/a0-a2,-(a7)
	move.l	6*4+8(a7),d2			;size
	beq.s	\exit
	subq.l	#1,d2
	move.l	6*4+4(a7),a1			;data
	
\loop 
	move.b	(a1)+,d0
	bsr		dbglink_printbyte
	dbra.s	d2,\loop
	
\exit movem.l	(a7)+,d0-d2/a0-a2	
	rts




_comment	dc.b		"Test link",0

	
	end

