// Sauf mention contraire, toutes les fonctions ont t codes par Thibaut Barthlemy
// Veuillez excuser mon anglais pitoyable l o j'ai tent de nommer mes identificateurs en cette belle langue
// N'hsitez pas  m'crire : barthib@hotmail.com




// C Source File
// Created 06/06/02; 13:59:54


#ifdef __GTC__
  #include "common_files\global_declarations.h"
#else
  #include "global_declarations.h"
#endif




#define DERNIER_X (X_MAX+1 - (X_MAX+1)%4 - 3*4)
#define DERNIER_Y (Y_MAX+1 - (Y_MAX+1)%7 - 2*7)
#define NB_CARS_X (DERNIER_X/4 + 1)
#define NB_CARS_Y (DERNIER_Y/7 + 1)




typedef enum {cDROIT=0x01, cBAS=0x02} tCote;


typedef struct
{
  short
    begin,
    end,
    stack[17];
} tLoopedStack17;

#define incIndexLS17(index) ({if ((index) == 16) (index)= -1; (index)++;})
#define decIndexLS17(index) ({if ((index) ==  0) (index)= 17; (index)--;})


typedef struct
{
  char  *debut_actu;
  short  nb_cars;
  short  espace64;
  char  *debut_suiv;
} tEL;




short AfficherTexte(HANDLE fichierHdl);

void  initLoppedStack(tLoopedStack17 *ls);
void  scrollLoopedStack(tLoopedStack17 *ls, short sens, short newItem);
short longueur_ligne(char *ligne);
short extraire_ligne(char *debut, tEL *result, short longueur);
char *LoopHz(char *texte, char *ligne_depart);
char *LoopWw(char *texte, char *ligne_depart);
void  afficher_ligneHz(void *plane, char *ligne, short longueur, short y, short offset);
void  afficher_colonneHz(void *plane, char *ligne, tLoopedStack17 *ls, short x, short offset);
void  afficher_ligneWw(void *plane, char *ligne, short espace64, short combien, short y);
void  AscenseursTexte(unsigned short NbColonnes, unsigned short NbLignes, unsigned short indexC, unsigned short indexL, tCote cote);

void  VisionnerPic(HANDLE handle);
short VisionnerBmp(HANDLE handle);
void  LoopAffichageImage(BITMAP *dark_picture, BITMAP *light_picture);





short AfficherTexte(HANDLE fichierHdl)
{
  char *texte= HLock(fichierHdl) + 2 + 2 + 1;
  char *ret= texte;
  enum {Hz, Ww} typeviewer= Hz;
  
  do
    switch (typeviewer)
    {
      case Hz : ret= LoopHz(texte, ret);
                typeviewer= Ww;
                break;
      case Ww : ret= LoopWw(texte, ret);
                typeviewer= Hz;
                break;
    }
  while (ret != NULL && ret != (char *)(-1));
  HeapUnlock(fichierHdl);
  return (ret == NULL) ? TRUE : FALSE;
}




void initLoopedStack17(tLoopedStack17 *ls)
{
  short i;

  ls->begin= 0;
  ls->end= 0;

  for (i=16; i>=0; i--) ls->stack[i]= 0;
}




void scrollLoopedStack(tLoopedStack17 *ls, short sens, short newItem)
{
  if (sens < 0)
  { // le texte doit monter
    incIndexLS17(ls->begin);
    incIndexLS17(ls->end);
    ls->stack[ls->end]= newItem;
  }
  else
  { // le texte doit descendre
    decIndexLS17(ls->begin);
    decIndexLS17(ls->end);
    ls->stack[ls->begin]= newItem;
  }
}




short longueur_ligne(char *ligne)
{
  char *car= ligne;
  
  while (*car != 0 && *car != 13) car++;
  
  return car-ligne;
}




short extraire_ligne(char *debut, tEL *result, short longueur)
{
  short fin_atteinte= FALSE; // fin du fichier non atteinte
  
  result->debut_actu= debut;
  if (longueur <= NB_CARS_X)
  {
    result->nb_cars= longueur;
    result->espace64= 4 << 6;
    result->debut_suiv= debut + longueur;
    if (*result->debut_suiv == 13) result->debut_suiv+= 2; // zappage du $0D et du $20
                              else fin_atteinte= TRUE;
    return fin_atteinte;
  }
  else // la ligne ne tient pas sur la largeur de l'cran
  {
    char *fin= debut + NB_CARS_X;
    short nb_espaces= 0;
    
    while (*fin-- != ' ');
    if (fin < debut)
    {
      result->nb_cars= NB_CARS_X;
      result->espace64= 4 << 6;
      result->debut_suiv= debut + NB_CARS_X;
    }
    else
    {
      result->nb_cars= fin - debut + 1;
      result->debut_suiv= fin + 2; // zappage de l'espace (il est remplac par un RC)
      while (debut <= fin) if (*debut++ == ' ') nb_espaces++;
      if (nb_espaces == 0)
        result->espace64= 4 << 6;
      else
        result->espace64= ((DERNIER_X+4 - 4*(result->nb_cars - nb_espaces)) << 6) / nb_espaces;
    }
    return fin_atteinte;
  }
}




char *LoopHz(char *texte, char *ligne_depart)
{
  char  buffer[128*30];
  tLoopedStack17 ls;
  char *debut_texte= texte;
  short NbLignes= 0, NbColMax= 0;
  short premY= 0, premX= 0;
  void *L_plane= GetPlane(LIGHT_PLANE),
       *D_plane= GetPlane(DARK_PLANE);
  
  { // calcul de la taille de la plus longue ligne ET du nombre de lignes
    char *debut_ligne= debut_texte;

    while (TRUE)
    {
      NbLignes++;
      if (debut_ligne < ligne_depart) premY++; // recherche le numro de la premire ligne  afficher
      while (*texte != 0 && *texte != 13) texte++;
      if (texte-debut_ligne > NbColMax) NbColMax= texte-debut_ligne;
      if (*texte == 0) break;
                  else texte+= 2; // zappage du $0D et du $20
      debut_ligne= texte;
    }
  }
  PortSet(buffer, 239, 127);
  ClrScr();
  PortSet(L_plane, 239, 127);
  ClrScr();
  PortSet(D_plane, 239, 127);
  ClrScr();
  { // remplissage de la pile et affichage des premires lignes
    short y, stop;
    
    initLoopedStack17(&ls);
    texte= ligne_depart;
    stop= (NbLignes-premY < NB_CARS_Y) ? NbLignes : NB_CARS_Y;
    for (y=0; y<stop; y++)
    {
      short longueur= longueur_ligne(texte);
      
      ls.stack[y]= longueur;
      afficher_ligneHz(buffer, texte, longueur, 7*y, 0);
      texte+= longueur + 2; // zappage du $0D et du $20
    }
    ls.end= stop-1;
    
    copy_textviewerbuffer_to_plane(L_plane, buffer, DERNIER_Y+7);
    copy_textviewerbuffer_to_plane(D_plane, buffer, DERNIER_Y+7);
    AscenseursTexte(NbColMax, NbLignes, premX, premY, cDROIT | cBAS);
  }
  
  texte= ligne_depart;
  
  while (TRUE)
  {
    if (RIGHTpresse)
    {
      if (premX < NbColMax-NB_CARS_X)
      {
        premX++;
        scroll4_left(buffer);
        erase_right(buffer, 4);
        afficher_colonneHz(buffer, texte, &ls, DERNIER_X, premX+NB_CARS_X-1);
        copy_textviewerbuffer_to_plane(L_plane, buffer, DERNIER_Y+7);
        copy_textviewerbuffer_to_plane(D_plane, buffer, DERNIER_Y+7);
        AscenseursTexte(NbColMax, NbLignes, premX, premY, cBAS);
      }
    }
    else if (LEFTpresse)
    {
      if (premX > 0)
      {
        premX--;
        scroll4_right(buffer);
        erase4_left(buffer);
        afficher_colonneHz(buffer, texte, &ls, 0, premX);
        copy_textviewerbuffer_to_plane(L_plane, buffer, DERNIER_Y+7);
        copy_textviewerbuffer_to_plane(D_plane, buffer, DERNIER_Y+7);
        AscenseursTexte(NbColMax, NbLignes, premX, premY, cBAS);
      }
    }
    else if (UPpresse)
    {
      if (premY > 0)
      {
        short longueur;
        char *fin_ligne;
        
        premY--;
        // - Recherche du dbut de la ligne prcdente
        texte-= 2; // on pointe sur le #13 indiquant la fin de la ligne prcdente
        fin_ligne= texte;
        if (texte > debut_texte && texte[-2] != 13) // si on n'est pas arriv sur la premire ligne et si la ligne n'est pas vide
        {
          texte--; // on pointe sur son dernier caractre
          while (texte > debut_texte && *texte != 13) texte--; // recherche du dbut de la premire ligne OU de la fin de la ligne avant la ligne prcdente
          if (*texte == 13) texte+= 2; // zappage du #13 et du #32 si on est arriv sur la fin de la ligne avant la ligne prcdente
        }
        longueur= fin_ligne - texte;
        // -
        scrollLoopedStack(&ls, 1, longueur);
        scroll7_down(buffer);
        erase7_up(buffer);
        afficher_ligneHz(buffer, texte, longueur, 0, premX);
        copy_textviewerbuffer_to_plane(L_plane, buffer, DERNIER_Y+7);
        copy_textviewerbuffer_to_plane(D_plane, buffer, DERNIER_Y+7);
        AscenseursTexte(NbColMax, NbLignes, premX, premY, cDROIT);
      }
    }
    else if (DOWNpresse)
    {
      if (premY < NbLignes-NB_CARS_Y)
      {
        short i, i_pile, longueur;
        char *derniere_ligne;
        
        premY++;
        texte+= ls.stack[ls.begin]+2; // calcul du dbut de la ligne suivante
        // - Recherche du dbut de la (nouvelle) dernire ligne
        derniere_ligne= texte;
        i_pile= ls.begin;
        for (i=NB_CARS_Y-2; i>=0; i--)
        {
          incIndexLS17(i_pile);
          derniere_ligne+= ls.stack[i_pile]+2;
        }
        // -
        longueur= longueur_ligne(derniere_ligne);
        scrollLoopedStack(&ls, -1, longueur);
        scroll7_up(buffer);
        erase_down(buffer, 7);
        afficher_ligneHz(buffer, derniere_ligne, longueur, DERNIER_Y, premX);
        copy_textviewerbuffer_to_plane(L_plane, buffer, DERNIER_Y+7);
        copy_textviewerbuffer_to_plane(D_plane, buffer, DERNIER_Y+7);
        AscenseursTexte(NbColMax, NbLignes, premX, premY, cDROIT);
      }
    }
    else if (ECHAPpresse)
    {
      GuetterRelachement(ECHAPpresse);
      break;
    }
    else if (SECONDpresse)
    {
      GuetterRelachement(SECONDpresse);
      return texte;
    }  
    else if (PLUSpresse)
    {
      OSContrastUp();
      Temporiser(4);
    }
    else if (MINUSpresse)
    {
      OSContrastDn();
      Temporiser(4);
    }
  }
  
  return NULL;
}




char *LoopWw(char *texte, char *ligne_depart)
{
  char   buffer[128*30];
  char  *debut_texte= texte;
  short  NbLignes= 0;
  short  premY= 0;
  unsigned char *longueurs= NULL;
  tEL    infosligne;
  void  *L_plane= GetPlane(LIGHT_PLANE),
        *D_plane= GetPlane(DARK_PLANE);
  
  { // calcul du nombre de lignes
    short fin_atteinte= FALSE;
    short longueur_restante= 0;
    
    while (!fin_atteinte)
    {
      if (NbLignes % 128 == 0)
      {
        longueurs= realloc(longueurs, sizeof(*longueurs) * (128 + NbLignes));
        if (longueurs == NULL) return (char *)(-1);
      }
      if (texte < ligne_depart) premY++; // recherche le numro de la premire ligne  afficher
      if (longueur_restante <= 0) longueur_restante= longueur_ligne(texte);
      fin_atteinte= extraire_ligne(texte, &infosligne, longueur_restante);
      longueur_restante-= longueurs[NbLignes]= infosligne.debut_suiv - texte;
      texte= infosligne.debut_suiv;
      NbLignes++;
    }
  }
  PortSet(buffer, 239, 127);
  ClrScr();
  PortSet(L_plane, 239, 127);
  ClrScr();
  PortSet(D_plane, 239, 127);
  ClrScr();
  { // affichage des premires lignes
    short y, stop;
    
    texte= ligne_depart;
    stop= (NbLignes-premY < NB_CARS_Y) ? NbLignes : NB_CARS_Y;
    for (y=0; y<stop; y++)
    {
      extraire_ligne(texte, &infosligne, longueur_ligne(texte));
      afficher_ligneWw(buffer, infosligne.debut_actu, infosligne.espace64, infosligne.nb_cars, 7*y);
      texte= infosligne.debut_suiv;
    }
    
    copy_textviewerbuffer_to_plane(L_plane, buffer, DERNIER_Y+7);
    copy_textviewerbuffer_to_plane(D_plane, buffer, DERNIER_Y+7);
    AscenseursTexte(NB_CARS_X, NbLignes, 0, premY, cDROIT | cBAS);
  }
  
  texte= ligne_depart;
  while (TRUE)
  {
    if (UPpresse)
    {
      if (premY > 0)
      {
        premY--;
        texte-= longueurs[premY];
        extraire_ligne(texte, &infosligne, longueur_ligne(texte));
        scroll7_down(buffer);
        erase7_up(buffer);
        afficher_ligneWw(buffer, infosligne.debut_actu, infosligne.espace64, infosligne.nb_cars, 0);
        copy_textviewerbuffer_to_plane(L_plane, buffer, DERNIER_Y+7);
        copy_textviewerbuffer_to_plane(D_plane, buffer, DERNIER_Y+7);
        AscenseursTexte(NB_CARS_X, NbLignes, 0, premY, cDROIT);
      }
    }
    else if (DOWNpresse)
    {
      if (premY < NbLignes-NB_CARS_Y)
      {
        short i;
        char *derniere_ligne;
        
        texte+= longueurs[premY];
        premY++;
        derniere_ligne= texte;
        for (i=premY+NB_CARS_Y-2; i>=premY; i--) derniere_ligne+= longueurs[i];
        extraire_ligne(derniere_ligne, &infosligne, longueur_ligne(derniere_ligne));
        scroll7_up(buffer);
        erase_down(buffer, 7);
        afficher_ligneWw(buffer, infosligne.debut_actu, infosligne.espace64, infosligne.nb_cars, DERNIER_Y);
        copy_textviewerbuffer_to_plane(L_plane, buffer, DERNIER_Y+7);
        copy_textviewerbuffer_to_plane(D_plane, buffer, DERNIER_Y+7);
        AscenseursTexte(NB_CARS_X, NbLignes, 0, premY, cDROIT);
      }
    }
    else if (ECHAPpresse)
    {
      GuetterRelachement(ECHAPpresse);
      break;
    }
    else if (SECONDpresse)
    {
      char *pauhynteur;
      short lignes_restantes= 1;
      
      GuetterRelachement(SECONDpresse);
      
      // - pointage sur la fin de la ligne prcdente
      if (*texte == 13 && texte > debut_texte)
        texte-= 2; // si on pointe sur une ligne vide
      else
        while (texte > debut_texte && *texte != 13) texte--; // recherche de la fin de la ligne prcdente ou du dbut de la premire ligne
      // -
      if (texte > debut_texte) // si on n'est pas au dbut de la premire ligne
      {
        texte+= 2; // zappage du #13 et du #32 : on pointe au dbut de la ligne
        
        pauhynteur= texte;
        while (lignes_restantes < NB_CARS_Y) // s'il reste moins de lignes  afficher qu'il n'y en a d'affichable  l'cran en mode Hz, il faut remonter
          switch (*pauhynteur++)
          {
            case  0 : // il reste moins de lignes  afficher qu'il n'y en a d'affichable :(
                      while (texte > debut_texte)
                        if (*--texte == 13)
                          if (++lignes_restantes == NB_CARS_Y)
                          {
                            if (texte > debut_texte) texte--; // zappage du #13
                            while (texte > debut_texte && *texte != 13) texte--;
                            if (texte > debut_texte) texte+= 2; // zappage du #13 et du #32
                            break;
                          }
                      lignes_restantes= NB_CARS_Y; // beurk :D
                      break;
            case 13 : lignes_restantes++;
          }
      }
      free(longueurs);
      return texte;
    }
    else if (PLUSpresse)
    {
      OSContrastUp();
      Temporiser(4);
    }
    else if (MINUSpresse)
    {
      OSContrastDn();
      Temporiser(4);
    }
  }
  free(longueurs);
  return NULL;
}




void afficher_ligneHz(void *plane, char *ligne, short longueur, short y, short offset)
{
  short x;
  
  if (offset >= longueur) return;
  ligne+= offset;
  longueur-= offset;
  if (longueur > NB_CARS_X) longueur= NB_CARS_X;
  longueur*= 4;
  for (x=0; x<longueur; x+=4)
    MonDrawChar(plane, x, y, *ligne++, FALSE);
}




void afficher_colonneHz(void *plane, char *ligne, tLoopedStack17 *ls, short x, short offset)
{
  short y, i_pile= ls->begin;
  
  for (y=0; y<=DERNIER_Y; y+= 7)
  {
    if (offset < ls->stack[i_pile])
      MonDrawChar(plane, x, y, ligne[offset], FALSE);
    ligne+= ls->stack[i_pile] + 2; // 13 et espace
    incIndexLS17(i_pile);
  }
}




void afficher_ligneWw(void *plane, char *ligne, short espace64, short combien, short y)
{
  short x= 0 << 6; // #triso#
  
  while (combien--)
  {
    if (*ligne == ' ')
    {
      ligne++;
      x+= espace64;
    }
    else
    {
      MonDrawChar(plane, x >> 6, y, *ligne++, FALSE);
      x+= 4 << 6;
    }
  }
}




void AscenseursTexte(unsigned short NbColonnes, unsigned short NbLignes, unsigned short indexC, unsigned short indexL, tCote cote)
{
  SCR_RECT Coordonnees;
  unsigned long LongueurBarre64;
  unsigned short premiere_coordonnee64;
  void *L_plane= GetPlane(LIGHT_PLANE),
       *D_plane= GetPlane(DARK_PLANE);
  
  if (cote & cBAS)
  {
    erase_down(L_plane, 6);
    erase_down(D_plane, 6);
    
    GrayPutSprite16(0, Y_MAX-15, s_viewerGB);
    GrayPutSprite16(X_MAX-15, Y_MAX-15, s_viewerDB);
    
    if (NbColonnes <= NB_CARS_X)
      LongueurBarre64= (X_MAX - 7 - 7) << 6;
    else
      LongueurBarre64= (((unsigned long)NB_CARS_X * (X_MAX - 7 - 7)) << 6) / NbColonnes;
    
    premiere_coordonnee64= (7 << 6) + (indexC * LongueurBarre64) / NB_CARS_X;
    Coordonnees.xy.x0= premiere_coordonnee64 >> 6;
    Coordonnees.xy.y0= Y_MAX-5;
    Coordonnees.xy.x1= (premiere_coordonnee64 + LongueurBarre64) >> 6;
    Coordonnees.xy.y1= Y_MAX-1;
    
    PortSet(D_plane, 239, 127);
    ScrRectFill(&Coordonnees, &(SCR_RECT){{0, 0, 239, 127}}, A_NORMAL);
    PortSet(L_plane, 239, 127);
    DrawLine(Coordonnees.xy.x0+1, Coordonnees.xy.y0, Coordonnees.xy.x1-1, Coordonnees.xy.y0, A_NORMAL);
    DrawLine(Coordonnees.xy.x0+1, Coordonnees.xy.y1, Coordonnees.xy.x1-1, Coordonnees.xy.y1, A_NORMAL);
    DrawLine(Coordonnees.xy.x0, Coordonnees.xy.y0+1, Coordonnees.xy.x0, Coordonnees.xy.y1-1, A_NORMAL);
    DrawLine(Coordonnees.xy.x1, Coordonnees.xy.y0+1, Coordonnees.xy.x1, Coordonnees.xy.y1-1, A_NORMAL);
  }
  if (cote & cDROIT)
  {
    erase_right(L_plane, 6);
    erase_right(D_plane, 6);
    
    GrayPutSprite16(X_MAX-15, 0, s_viewerDH);
    GrayPutSprite16(X_MAX-15, Y_MAX-15, s_viewerDB);
    
    if (NbLignes <= NB_CARS_Y)
      LongueurBarre64= (Y_MAX - 7 - 13) << 6;
    else
      LongueurBarre64= (((unsigned long)NB_CARS_Y * (Y_MAX - 7 - 13)) << 6) / NbLignes;
    
    premiere_coordonnee64= (7 << 6) + (indexL * LongueurBarre64) / NB_CARS_Y;
    Coordonnees.xy.x0= X_MAX-5;
    Coordonnees.xy.y0= premiere_coordonnee64 >> 6;
    Coordonnees.xy.x1= X_MAX-1;
    Coordonnees.xy.y1= (premiere_coordonnee64 + LongueurBarre64) >> 6;
    
    PortSet(D_plane, 239, 127);
    ScrRectFill(&Coordonnees, &(SCR_RECT){{0, 0, 239, 127}}, A_NORMAL);
    PortSet(L_plane, 239, 127);
    DrawLine(Coordonnees.xy.x0+1, Coordonnees.xy.y0, Coordonnees.xy.x1-1, Coordonnees.xy.y0, A_NORMAL);
    DrawLine(Coordonnees.xy.x0+1, Coordonnees.xy.y1, Coordonnees.xy.x1-1, Coordonnees.xy.y1, A_NORMAL);
    DrawLine(Coordonnees.xy.x0, Coordonnees.xy.y0+1, Coordonnees.xy.x0, Coordonnees.xy.y1-1, A_NORMAL);
    DrawLine(Coordonnees.xy.x1, Coordonnees.xy.y0+1, Coordonnees.xy.x1, Coordonnees.xy.y1-1, A_NORMAL);
  }
}




void VisionnerPic(HANDLE handle)
{
  BITMAP *picture= HeapDeref(handle)+2;
  LoopAffichageImage(picture, picture);
}




short VisionnerBmp(HANDLE handle)
{
  BITMAP *D_picture, *L_picture;
  short taille_bitmap;
  short howmanyplanes;
  struct
  {
    short nbPlans;
    short hauteur;
    short opl;
    char  bitmap[];
  } *pv;
  
  pv= HeapDeref(handle) + 2 + 2;
  taille_bitmap= pv->opl * pv->hauteur;
  howmanyplanes= pv->nbPlans;
  
  D_picture= malloc(2+2+taille_bitmap);
  if (howmanyplanes > 1) L_picture= malloc(2+2+taille_bitmap);
                    else L_picture= D_picture;
  if (!D_picture || !L_picture)
  {
    free(D_picture);
    free(L_picture);
    return FALSE;
  }
  
  pv = HeapDeref(handle)+2+2; // les 'malloc' prcdents ont pu dplacer le fichier
  memcpy(D_picture->Data, pv->bitmap, taille_bitmap);
  if (howmanyplanes > 1)
  {
    memcpy(L_picture->Data, pv->bitmap + 4 + taille_bitmap, taille_bitmap);
    L_picture->NumRows= pv->hauteur;
    L_picture->NumCols= pv->opl*8;
  }
  D_picture->NumRows= pv->hauteur;
  D_picture->NumCols= pv->opl*8;
  
  LoopAffichageImage(D_picture, L_picture);
  
  free(D_picture);
  if (howmanyplanes > 1) free(L_picture);
  return TRUE;
}




void LoopAffichageImage(BITMAP *dark_picture, BITMAP *light_picture)
{
  short actualiser= TRUE;
  short largeur= dark_picture->NumCols,
        hauteur= dark_picture->NumRows;
  short x= (X_MAX-largeur)/2,
        y= (Y_MAX-hauteur)/2;
  short Xmin= (largeur<=X_MAX) ? x : (X_MAX-largeur+1),
        Ymin= (hauteur<=Y_MAX) ? y : (Y_MAX-hauteur+1),
        Xmax= (largeur<=X_MAX) ? x : 0,
        Ymax= (hauteur<=Y_MAX) ? y : 0;
  void *L_plane= GetPlane(LIGHT_PLANE),
       *D_plane= GetPlane(DARK_PLANE);
  
  PortSet(D_plane, 239, 127);
  ClrScr();
  PortSet(L_plane, 239, 127);
  ClrScr();
  
  do
  {
    if (RIGHTpresse)
    {
      if (x > Xmin)
      {
        x-= 8;
        if (x < Xmin) x= Xmin;
        actualiser= TRUE;
      }
    }
    else if (LEFTpresse)
    {
      if (x < Xmax)
      {
        x+= 8;
        if (x > Xmax) x= Xmax;
        actualiser= TRUE;
      }
    }
    else if (UPpresse)
    {
      if (y < Ymax)
      {
        y+= 8;
        if (y > Ymax) y= Ymax;
        actualiser= TRUE;
      }
    }
    else if (DOWNpresse)
    {
      if (y > Ymin)
      {
        y-= 8;
        if (y < Ymin) y= Ymin;
        actualiser= TRUE;
      }
    }
    else if (PLUSpresse)
    {
      OSContrastUp();
      Temporiser(4);
    }
    else if (MINUSpresse)
    {
      OSContrastDn();
      Temporiser(4);
    }
    else if (ECHAPpresse)
    {
      GuetterRelachement(ECHAPpresse);
      break;
    }

    if (actualiser)
    {
      actualiser= FALSE;
      PortSet(D_plane, 239, 127);
      BitmapPut(x, y, dark_picture, &(SCR_RECT){{0, 0, 239, 127}}, A_REPLACE);
      PortSet(L_plane, 239, 127);
      BitmapPut(x, y, light_picture, &(SCR_RECT){{0, 0, 239, 127}}, A_REPLACE);
    }
  } while (TRUE);
}





