/*GFA Font, Font library v1.0.
==============================================================================================
 Creation: Mardi 19 Avril 2005
 Modifications: 
 19/04/05, 20/04/05, 21/04/05
==============================================================================================
----------------------------------------------------------------------------------------------
 Librairie de gestion des fontes personnalises de GFA-Basic.

 Auteur: Geoffrey ANNEHEIM
 Dernire modification: Jeudi 21 Avril 2005
----------------------------------------------------------------------------------------------*/

#ifndef __H_GFA_FontLib
#define __H_GFA_FontLib

/***********************
 Modes d'une fonte
 **********************/
#define FONT_NORMAL							0
#define FONT_BOLD								1
#define FONT_ITALIC							2
#define FONT_UNDERLINE					4
#define FONT_BARRED							8
  
  
/***********************
 Modes graphique
 **********************/
#define FONT_OR									0
#define FONT_XOR								1
#define FONT_AND								2
#define FONT_REPLACE						3
#define FONT_NOT								4


/***********************
 Fonctions
 **********************/
extern unsigned short FONT_OpenFile (register unsigned char *file_name asm("%a0")) __attribute__((__regparm__));
extern void FONT_CloseFile (void);
  
extern unsigned short FONT_DrawCharWidth (register unsigned short c asm("%d0"), register unsigned short font_mode asm("%d1")) __attribute__((__regparm__)); 
extern unsigned short FONT_DrawCharHeight (register unsigned short font_mode asm("%d0")) __attribute__((__regparm__));
  
extern unsigned short FONT_DrawChar (unsigned short x, unsigned short y, unsigned short c, unsigned short font_mode, unsigned short graphic_mode, void *mem) __attribute__((__stkparm__));
extern void FONT_DrawStr (unsigned short x, unsigned short y, unsigned char *string, unsigned short font_mode, unsigned short graphic_mode, void *mem) __attribute__((__stkparm__));
  
extern void FONT_DrawFastChar (register unsigned short x asm("%d0"), register unsigned short y asm("%d1"), register unsigned short c asm("%d2"), register void *mem asm("%a0")) __attribute__((__regparm__));
extern void FONT_DrawFastStr (register unsigned short x asm("%d0"), register unsigned short y asm("%d1"), register unsigned char *str asm("%a1"), register void *mem asm("%a0")) __attribute__((__regparm__));
  
extern unsigned short FONT_DrawStrWidth (register unsigned char *str asm ("%a0"), register unsigned short font_mode asm ("%d0")) __attribute__((__regparm__));
extern unsigned char *FONT_GetSprite (register unsigned short c asm("%d0")) __attribute__((__regparm__));
  
 
/***********************
 Variables
 **********************/
#define FONT_SPACE32						FONT_CHAR256
#define FONT_BLANK							FONT_CHAR257

extern const char FONT_COMMENT[];
extern const unsigned char FONT_VERSION;
extern const char FONT_SIGNATURE[];

extern unsigned char *FONT_NAME;
extern unsigned short FONT_MODE;

extern unsigned short FONT_SIZE_X;
extern unsigned short FONT_SIZE_Y;

extern unsigned short FONT_CHAR256;
extern unsigned short FONT_CHAR257;

extern unsigned short FONT_standard_italic_size;
extern unsigned short FONT_italic_size;

extern unsigned char *FONT_sprites_pointer;

#endif

