#include <iostream>
#include <stdlib.h>
#include <windows.h>

#include "Header.h"

using namespace std;
unsigned char *buffer;
int FONT_SIZE_X, FONT_SIZE_Y;
int FONT_MODE;
char buffer_text [23];

void MakeFile (FILE *output, char *font_name)
{
  unsigned short empty_char = 0;
  unsigned short jump_sprites = 0;
  
  fputs ("GFA_FNT", output);                   //Magic
  fputc (1, output);                           //Version
  fwrite (font_name, 23, 1, output);
  fputc (0x00, output);                        //NULL
  
  fputc (FONT_MODE, output);                   //Mode 256 caractres, dbut 0
  
  fputc ((FONT_SIZE_X<<4)+FONT_SIZE_Y, output);//FONT_SIZE
  
  jump_sprites = FONT_MODE?(33*FONT_SIZE_Y):0;
  fwrite (buffer+jump_sprites, (FONT_SIZE_Y*256)-jump_sprites, 1, output);
}

bool MakeBuffer (FILE *input)
{ 
  int buffer_pos = 0;
  int value = 0;
  
  //Allocation buffer binaire
  if (!(buffer = (unsigned char *)malloc (MAX_BUFFER_SIZE))) return false;
  memset (buffer, 0x00, MAX_BUFFER_SIZE);
  
  fscanf(input, "%d", &FONT_SIZE_X);
  fscanf(input, "%d", &FONT_SIZE_Y);
   
  while (!feof (input))
  {
    if (fscanf(input, "%d", &value))
    {
      value = value<<(8-FONT_SIZE_X);
      buffer [buffer_pos++] = (unsigned char)value;
    }    
  } 
  
  return true;    
}

int main(int argc, char *argv[])
{  
  char *input, *output;
  FILE *file_input, *file_output;

  printf ("ConvertCHS file into GFA-Font file\n");
  printf ("Copyright 2005 by ANNEHEIM Geoffrey\n\n");
  printf ("Usage: source file destination file mode\n\n");
  printf ("Example: ConvertCHS example.dat example.bin mode\n\n");
  
  if (argc!=4) {
    cerr << "Error: Incorrect arguments.\n"; return 0;}
  
  input = argv [1]; output = argv [2];
  FONT_MODE = atoi (argv [3])?0xFF:0x00;
              
  if (!(file_input = fopen (input, "r"))) {
    cerr << "Error: Incorrect input file.\n"; return 0;}
  if (!(file_output = fopen (output, "wb"))) {
    cerr << "Error: Incorrect output file.\n"; return 0;} 
  
  buffer = NULL; 
  
  if (!MakeBuffer (file_input)) {
    cerr << "Error: No enough memory.\n"; 
    fclose (file_input); fclose (file_output);
    return 0;}
  
  memset (buffer_text, 0x00, 23);
  printf ("Font name :"); 
  sscanf (buffer_text, "%s");
  MakeFile (file_output, gets (buffer_text));
  
  fclose (file_input); fclose (file_output);
  if (buffer) free (buffer);
    
  return -1;
}
