		.include  "Defines.h"
		
		.data
		.xdef     FONT_DrawChar

|=======================================================================================================================================================
|unsigned short FONT_DrawChar (unsigned short x, unsigned short y, unsigned short car, unsigned short font_mode, unsigned short graphic_mode, void *mem) 
|-------------------------------------------------------------------------------------------------------------------------------------------------------
|Dessine un caractre
|-------------------------------------------------------------------------------------------------------------------------------------------------------
|input:
|  dc.l   %SP = Mmoire vido.
|  dc.w   %SP = Mode graphique.
|  dc.w   %SP = Font mode.
|  dc.w   %SP = Caractre.
|  dc.w   %SP = Coordonne Y.
|  dc.w   %SP = Coordonne X.
|
|output:
|  dc.w   %d0 = Taille du caractre en largeur
|
|destroy:
|=======================================================================================================================================================
_FONT_DrawChar_Or:
		jbsr      FONT_ClipSprite16_OR_R
		jbra      _FONT_DrawChar_exit

_FONT_DrawChar_Xor:
		jbsr      FONT_ClipSprite16_XOR_R
		jbra      _FONT_DrawChar_exit
		
_FONT_DrawChar_And:
		jbsr      FONT_ClipSprite16_BLIT_R
		jbra      _FONT_DrawChar_exit

FONT_DrawChar:
		movem.l   %d3-%d6/%a2,-(%SP) 			|Sauvegarde les registres
		
		|N'affiche pas un caractre non compris dans la fonte
		move.w    28(%SP),%d0				|Numro du caractre
		move.w    %d0,%d5
		tst.w     FONT_MODE
		jbeq      _FONT_DrawChar_next
		subi.w    #33,%d0
		jbcs      _FONT_DrawChar_exit_no_char
_FONT_DrawChar_next:
		|Ce place au bon sprite dans le fichier
		move.w    FONT_SIZE_Y,%d1
		mulu.w    %d1,%d0
		move.l    FONT_sprites_pointer,%a0			|Zone des sprites de la fonte
		lea.l     (%d0.w,%a0),%a0
		
		|Vide buffer 16x16
		lea.l     FONT_sprite_buffer,%a1
		moveq.l   #0,%d0
		moveq.l   #0,%d1
		moveq.l   #0,%d2
		moveq.l   #0,%d3
		moveq.l   #0,%d4
		movem.l   %d0-%d4,(%a1)
		
		|Hauteur du caractre
		move.w    FONT_SIZE_Y,%d2
		
		|Font mode
		move.w    30(%SP),%d3				
				
		|Caractres d'espacement?
		cmpi.w    #255,%d5
		jbhi      _FONT_DrawChar_ITALIC_end
		
		|Remplie buffer
		moveq.l   #0,%d0
		move.w    %d2,%d0
		movea.l   %a1,%a2
		subq.w    #1,%d0
_FONT_DrawChar_buffer_loop:
		move.b    (%a0)+,(%a2)
		addq.l    #2,%a2
		dbf       %d0,_FONT_DrawChar_buffer_loop

		|Application mode fonte
		btst.b    #0,%d3
		jbeq      _FONT_DrawChar_BOLD_end
		
		|Caractre en gras
_FONT_DrawChar_BOLD:
		movea.l   %a1,%a0				|Buffer dans %a3
		moveq.l   #7,%d4				|Prpare boucle 8 itrations
_FONT_DrawChar_BOLD_loop:		
		move.w    (%a0),%d0				|Ligne du sprite dans %d0
		move.w    %d0,%d1				|Ligne du sprite dans %d1
		lsr.w     #1,%d0
		or.w      %d1,%d0
		move.w    %d0,(%a0)+
		dbf       %d4,_FONT_DrawChar_BOLD_loop
_FONT_DrawChar_BOLD_end:
		btst.b    #1,%d3
		jbeq	  _FONT_DrawChar_ITALIC_end

		|Caractre en italique
_FONT_DrawChar_ITALIC:
		movea.l   %a1,%a0				|Buffer dans %a3
		moveq.l   #3,%d4				|Nombre d'itrations
		moveq.l   #0,%d1				|Nombre de dcalages
		move.w    %d2,%d1
		btst.b    #0,%d1
		jbeq      _FONT_DrawChar_ITALIC_pair
		addq.w    #1,%d1
_FONT_DrawChar_ITALIC_pair:
		lsr.w     #1,%d1
		subq.w    #1,%d1		
_FONT_DrawChar_ITALIC_loop:		
		move.w    (%a0),%d0
		lsr.w     %d1,%d0
		move.w    %d0,(%a0)+
		move.w    (%a0),%d0
		lsr.w     %d1,%d0
		move.w    %d0,(%a0)+
		subq.w    #1,%d1
		dbf       %d4,_FONT_DrawChar_ITALIC_loop
_FONT_DrawChar_ITALIC_end:	
		
		|Cration d'un masque
		moveq.l   #0,%d4
		not.w     %d4
		move.w    %d5,%d0
		move.w    %d3,%d1
	        jbsr      FONT_DrawCharWidth
		move.w    %d0,%d6
		lsr.w     %d0,%d4
		not.w     %d4
		
		|Caractre soulign
		btst.b    #2,%d3
		jbeq      _FONT_DrawChar_UNDERLINE_end
		addq.w    #2,%d2				|Hauteur += 2
		move.w    %d2,%d0
		subq.w    #1,%d0
		add.w     %d0,%d0
		or.w      %d4,(%d0.w,%a1)
_FONT_DrawChar_UNDERLINE_end:		
		|Caractre barr
		btst.b    #3,%d3
		jbeq      _FONT_DrawChar_BARRED_end
		move.w    FONT_SIZE_Y,%d0
		lsr.w     #1,%d0
		btst.b    #0,%d0
		jbne      _FONT_DrawChar_BARRED_next
		subq.w    #1,%d0
_FONT_DrawChar_BARRED_next:
		add.w     %d0,%d0
		or.w      %d4,(%d0.w,%a1)
_FONT_DrawChar_BARRED_end:
		
		|Mode NOT
		move.w    32(%SP),%d5				|Mode graphique
		btst.b    #2,%d5
		jbeq      _FONT_DrawChar_next2
		
		|Modifie le buffer en mode invers
		movea.l   %a1,%a0
		moveq.l   #0,%d1
		move.w    %d2,%d1
_FONT_DrawChar_invert_loop:
		move.w    (%a0),%d0
		not.w     %d0
		and.w     %d4,%d0
		move.w    %d0,(%a0)+
		dbf       %d1,_FONT_DrawChar_invert_loop
				
_FONT_DrawChar_next2:
		bclr.b    #2,%d5				|Mode graphique standard
		move.w    24(%SP),%d0				|Coordonne X
		move.w    26(%SP),%d1				|Coordonne Y
		movea.l   34(%SP),%a0				|Mmoire vido
		
		subq.w    #MODE_XOR,%d5
		jbcs      _FONT_DrawChar_Or
		jbeq      _FONT_DrawChar_Xor
		subq.w    #1,%d5
		jbeq      _FONT_DrawChar_And
_FONT_DrawChar_Replace:
		jbsr      FONT_ClipSprite16_BLIT_R

_FONT_DrawChar_exit:
		move.w    %d6,%d0
_FONT_DrawChar_exit2:		
		movem.l   (%SP)+,%d3-%d6/%a2 			|Restaure les registres
		rts
		
_FONT_DrawChar_exit_no_char:
		moveq.l   #0,%d0
		jbra      _FONT_DrawChar_exit2
		
		.end
		