		.include  "os.h"
		
		.include  "Defines.h"
		.include  "FontLib.h"
		
		.data
		.xdef     FILE_GenerateTIOSName
		.xdef     FILE_GetSymByName
		.xdef     FILE_Find

|=========================================================================
|FILE_GenerateTIOSName
|-------------------------------------------------------------------------
|Crer un nom de fichier au format du TIOS
|-------------------------------------------------------------------------
|input:
|  dc.l   a0 = File name.
|  dc.l   a2 = Empty buffer.
|output:
|  dc.l   a2 = Buffer with the TIOS name format.
|
|destroy: d0
|=========================================================================
FILE_GenerateTIOSName:
		clr.b     (%a2)+				|buffer [0] = 0
_FILE_GenerateTIOSName_loop:
		move.b    (%a0)+,(%a2)+
		jbne      _FILE_GenerateTIOSName_loop
		subq.l    #1,%a2
		rts
		

|=========================================================================
|FILE_GetSymByName
|-------------------------------------------------------------------------
|Renvoie un SYM ENTRY  partir d'un nom de fichier
|-------------------------------------------------------------------------
|input:
|  dc.l   a0 = File name.
|output:
|  dc.l   a0 = Pointer to structure SYM ENTRY.
|
|destroy:
|=========================================================================
_GetSymByName_hsym_TIOSName:
		movea.l   %a0,%a2
		jbra	  _GetSymByName_GetHSym

FILE_GetSymByName:
		move.l    %a2,-(%SP)
		lea.l     -18(%SP),%SP
		tst.b     (%a0)					|Nom du fichier dj au format TIOS
		jbeq      _GetSymByName_hsym_TIOSName
		move.l    %SP,%a2				|Prparation buffer
		jbsr      FILE_GenerateTIOSName			|Gnre un nom de fichier au format du TIOS
_GetSymByName_GetHSym:		
		pea.l	  (%a2)
		ROM_CALL  SymFind
		addq.l	  #4,%SP
		suba.l    %a0,%a0
		move.l    %d0,%d1
		swap	  %d0					|Rcupre HANDLE Folder
		jbeq	  _GetSymByName_HFolder_NULL
		move.l    %d1,-(%SP)
		ROM_CALL  DerefSym
		addq.l    #4,%SP
_GetSymByName_HFolder_NULL:		
		lea.l     18(%SP),%SP
		move.l    (%SP)+,%a2
		rts
		

|=========================================================================
|FILE_Find
|-------------------------------------------------------------------------
|Recherche un fichier dans tous les dossiers et renvoie son chemin complet
|-------------------------------------------------------------------------
|input:
|  dc.l   a0 = File name.
|output:
|  dc.l   a0 = Pointer of the file path.
|
|destroy: d0, d3, d4, a2
|=========================================================================
_FileFind_file_nofound:
		ROM_CALL  SymFindNext
		jbra	  _FileFind_loop

_FileFind_seek_echec:
		suba.l    %a0,%a0
		jbra	  _FileFind_exit

FILE_Find:
		movem.l    %d3/%d4/%a2,-(%SP)
		
		move.l	  %a0,%d4				|Sauvegarde File Name
		move.w    #FO_RECURSE,-(%SP)			|SymFindFirst (NULL, FO_RECURSE)	
		clr.l     -(%SP)
		ROM_CALL  SymFindFirst
		addq.l	  #6,%SP
_FileFind_loop:
		move.l    %a0,%d3				|Sauvegarde entry
		|tst.l     %d3					|While (entry)
		jbeq	  _FileFind_seek_echec			|Fin du while
		move.l	  %d3,-(%SP)				|strcmp (File Name, entry->name)
		move.l    %d4,-(%SP)
		ROM_CALL  strcmp
		addq.l	  #8,%SP
		tst.w     %d0					|Fichier non trouv
		jbne	  _FileFind_file_nofound
		
		|Fichier trouv
		ROM_CALL  SymFindFolderName
		pea.l     (%a0)					|strlen (folder)
		ROM_CALL  strlen
		move.l    %d0,%d3
		move.l    #17,-(%SP)				|memset (buffer, 0x00, 17)
		clr.w     -(%SP)
		lea.l     Buffer_FindFile,%a2
		pea.l     (%a2)
		ROM_CALL  memset
		lea.l     10(%SP),%SP				|memcpy (buffer, folder, len_folder)
		move.l	  %d3,-(%SP)
		move.l    4(%SP),-(%SP)
		pea.l     (%a2)
		ROM_CALL  memcpy
		lea.l     16(%SP),%SP
		adda.l    %d3,%a2
		move.b    #'\\',(%a2)				|huffer [len] = '\'
		move.l    %d4,-(%SP)				|strcat (buffer, entry->name)
		pea.l     1(%a2)
		ROM_CALL  strcat
		addq.l    #8,%SP
		lea.l     Buffer_FindFile,%a0
		
_FileFind_exit:	
		movem.l   (%SP)+,%d3/%d4/%a2
		rts
		
		.end
		