		.include  "os.h"
		
		.include  "Defines.h"
		.include  "FontLib.h"
		
		.data
		.xdef     FONT_OpenFile
		
|=========================================================================
|unsigned short FONT_OpenFile (unsigned char *file)
|-------------------------------------------------------------------------
|Ouverture d'une fonte
|-------------------------------------------------------------------------
|input:
|  dc.l   %a0 = Nom du fichier. (chemin facultatif).
|
|output:
|  dc.w   %d0 = Erreur si diffrent de 0.
|
|destroy:
|=========================================================================
_FONT_OpenFile_error_file_no_found:
		moveq.l   #1,%d0
		jbra      _FONT_OpenFile_exit
		
_FONT_OpenFile_error_incorrect_file:
		moveq.l   #2,%d0
		jbra      _FONT_OpenFile_exit
		
_FONT_OpenFile_error_incorrect_file_version:
		moveq.l   #3,%d0
		jbra      _FONT_OpenFile_exit
		

FONT_OpenFile:
		move.l    %a2,-(%SP) 				|Sauvegarde les registres
		
		move.l    %a0,-(%SP)
		jbsr      FONT_CloseFile			|Ferme Fonte prcdente
		move.l    (%SP)+,%a0
		
		movea.l   %a0,%a2				|Adresse nom du fichier
		jbsr      FILE_GetSymByName			|Recherche de base dans le dossier courant
		move.l    %a0,%d0				
		jbne      _FONT_OpenFile_file_found		|Fichier trouv
		movea.l   %a2,%a0
		jbsr      FILE_Find				|Recherche du fichier dans un dossier prcis
		move.l    %a0,%d0
		jbeq      _FONT_OpenFile_error_file_no_found	|Fichier non trouv
		jbsr      FILE_GetSymByName			|Recherche du fichier avec chemin complet
		move.l    %a0,%d0
		jbeq      _FONT_OpenFile_error_file_no_found	|Fichier non trouv
_FONT_OpenFile_file_found:
		lea.l     FONT_file_SymEntry,%a1
		move.l    %a0,(%a1)
		
		|Lock handle
		move.w    12(%a0),-(%SP)
		ROM_CALL  HeapLock
		lea.l     FONT_file_Handle,%a0
		move.w    %d0,(%a0)
		
		|Rcupre pointeur fichier
		move.w    %d0,-(%SP)
		ROM_CALL  HeapDeref
		lea.l     FONT_file_pointer,%a1
		movea.l   %a0,%a2
		move.l    %a2,(%a1)
		addq.l    #2,%a2				|Saute la taille du fichier
		
		|--------------------------------|		
		|Lecture Header                  |
		|--------------------------------|
		|xxxx     Signature (GFA_FNT)    |     
		|dc.b     Version (1.00)         |
		|				 |
		|dc.b*23  Font name		 |
		|dc.b     NULL			 |
		|				 |
		|dc.b     Mode			 |
		|dc.b     Font size X&Y          |
		|				 |
		|...      Sprites characteres    |
		|--------------------------------|
		
		|Vrification fichier GTK signature
		move.l    #FONT_SIGNATURE_Size,-(%SP)
		pea.l     FONT_SIGNATURE
		pea.l     (%a2)
		ROM_CALL  memcmp
		lea.l     4+4+4+2+2(%SP),%SP
		tst.w     %d0
		jbne      _FONT_OpenFile_error_incorrect_file
		
		|Vrification numro de version
		addq.l    #FONT_SIGNATURE_Size,%a2		|Prpare test numro de version
		move.b    (%a2)+,%d0
		cmp.b     FONT_VERSION,%d0
		jbne      _FONT_OpenFile_error_incorrect_file_version
		
		|Nom de la fonte
		lea.l     FONT_NAME,%a0
		move.l    %a2,(%a0)
		lea.l     24(%a2),%a2
		
		|Mode
		lea.l     FONT_MODE,%a0
		move.b    (%a2)+,(%a0)
		
		|Taille de la fonte
		move.b    (%a2)+,%d0
		move.b    %d0,%d1
		lsr.b     #4,%d0
		andi.b    #0x0F,%d1
		lea.l     FONT_SIZE_X,%a0
		move.b    %d0,1(%a0)
		lea.l     FONT_SIZE_Y,%a0
		move.b    %d1,1(%a0)
		
		|Sprites
		lea.l     FONT_sprites_pointer,%a0
		move.l    %a2,(%a0)
		
		|Constantes caracters blancs
		lea.l     FONT_CHAR256,%a0
		|move.w    #CHAR256_VALUE,(%a0)
		move.w    FONT_SIZE_X,(%a0)				|CHAR256_VALUE
		lea.l     FONT_CHAR257,%a0
		move.w    #CHAR257_VALUE,(%a0)
		
		|Taille parfaite en italique
		move.w    FONT_SIZE_X,%d0
		lea.l     FONT_italic_size,%a0
		move.w    %d0,(%a0)
		
		|Taille standard en italique
		move.w    FONT_SIZE_Y,%d1
		btst.b    #0,%d1				|Parit
		jbeq      _FONT_OpenFile_italic_pair
		addq.w    #1,%d1
_FONT_OpenFile_italic_pair:
		lsr.w     #1,%d1		
		subq.w    #1,%d1
		add.w     %d1,%d0
		lea.l     FONT_standard_italic_size,%a0
		move.w    %d0,(%a0)
		
		moveq.l   #0,%d0
_FONT_OpenFile_exit:		
		move.l    (%SP)+,%a2 				|Restaure les registres
		rts
		
		.end
		