// C Source File
// Created 21/04/2005; 19:30:15

#include <tigcclib.h>

#include "GFA_FontLib.h"

const unsigned char example_text[] = "Hello World!!!";

// Main Function
void _main(void)
{
	void *screen_buffer;
	unsigned short error;
	
	//Allocate screen buffer
	if (!(screen_buffer = malloc (LCD_SIZE))) {
		ST_helpMsg ("No enough memory.");
		return;}
	
	//Save screen
	memcpy (screen_buffer, LCD_MEM, LCD_SIZE);
	
	//Open the font file
	error = FONT_OpenFile ("gfa_font");
	if (error==1) ST_helpMsg ("gfa_font not found.");
	else if (error==2) ST_helpMsg ("Incorrect file format.");
	else if (error==3) ST_helpMsg ("Incorrect file version.");
	
	//An error occurred
	if (error) {
		free (screen_buffer);
		return;}
	
	//Clear screen
	clrscr ();

	//Title
	FONT_DrawStr (0,0, (unsigned char *)FONT_NAME, FONT_NORMAL, FONT_OR, LCD_MEM);
	
	//Font mode examples
	FONT_DrawStr (0, 10, (unsigned char*)example_text, FONT_NORMAL, FONT_OR, LCD_MEM);
	FONT_DrawStr (0, 20, (unsigned char*)example_text, FONT_BOLD, FONT_OR, LCD_MEM);
	FONT_DrawStr (0, 30, (unsigned char*)example_text, FONT_ITALIC, FONT_OR, LCD_MEM);
	FONT_DrawStr (0, 40, (unsigned char*)example_text, FONT_UNDERLINE, FONT_OR, LCD_MEM);
	FONT_DrawStr (0, 50, (unsigned char*)example_text, FONT_BARRED, FONT_OR, LCD_MEM);
	FONT_DrawStr (0, 60, (unsigned char*)example_text, FONT_BOLD|FONT_ITALIC, FONT_OR, LCD_MEM);
	FONT_DrawStr (0, 70, (unsigned char*)example_text, FONT_BOLD|FONT_UNDERLINE, FONT_OR, LCD_MEM);
	FONT_DrawStr (0, 80, (unsigned char*)example_text, FONT_ITALIC|FONT_BARRED, FONT_OR, LCD_MEM);
	FONT_DrawStr (0, 90, (unsigned char*)example_text, FONT_NORMAL, FONT_NOT+FONT_OR, LCD_MEM);
	
	
	GKeyFlush ();
	ngetchx ();
	
	//Close the font file
	FONT_CloseFile ();
	
	//Restore screen
	memcpy (LCD_MEM, screen_buffer, LCD_SIZE);
	
	//Unallocate screen buffer
	free (screen_buffer);
}
