// C Source File
// Created 16/08/2004; 13:27:40
/**
#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Tokens.h"
#include "..\System\String.h"
#include "..\System\Error.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\ExprMake.h"
#include "..\Other\ExprTokens.h"
#include "..\Other\ExprVar.h"
#include "..\Functions\TokensExec.h"
#include "..\Functions\ExprExecute.h"

s_data *ExcStack;
void *NumStack;
unsigned short NumStack_LastOffset;
HANDLE *StringStack;
unsigned char ExcStack_Ptr, NumStack_Ptr, StringStack_Ptr;
unsigned short Exec_Ptr;

unsigned char EndTagStack [MAX_ENDTAG_STACK];
unsigned char EndTagStack_Ptr;


//****************************************
//Allocation des piles
//****************************************
BOOL ExprExecute_Allocate (void)
{
	NumStack = NULL; NumStack_LastOffset = 0;
	ExcStack = NULL;
	StringStack = NULL;
	
	if ((ExcStack = calloc (MAX_EXEC_STACK, sizeof (s_data)))==NULL) return FALSE;	//Pile de donnes
	if ((NumStack = calloc (MAX_NUMBER_STACK, sizeof (float)))==NULL) return FALSE;	//Pile de nombres
	if ((StringStack = calloc (MAX_STRING_STACK, sizeof (HANDLE)))==NULL) return FALSE;	//Pile de chanes de caractres
	
	return TRUE;
}


//*******************************************
//Libre allocations
//*******************************************
void ExprExecute_Unallocate (void)
{
	if (ExcStack) free (ExcStack);
	if (NumStack) free (NumStack);
	if (StringStack) free (StringStack);
}


//**********************************************
//Execution des tokens
//**********************************************
void ExprExecute_Run (void)
{
	ExcStack_Ptr = NumStack_Ptr = EndTagStack_Ptr = StringStack_Ptr = 0;
	error_line = 1;
	
	//Parcours buffer de tokens
	for (Exec_Ptr=0; Exec_Ptr<TokensFile_size && !error_code;)
		(RunToken [TokensFile_buffer [Exec_Ptr++]])();
}


//******************************************
//Ajoute un simple nombre
//******************************************
BOOL ExprExecute_Number_Add (unsigned char type, unsigned char size)
{
	if (ExcStack_Ptr>=MAX_EXEC_STACK) {error_code = ERROR_OVERFLOW; return FALSE;}
	
  ExcStack [ExcStack_Ptr].operand = OPRD_NUMBER;
  ExcStack [ExcStack_Ptr].type = type;
	ExcStack [ExcStack_Ptr++].adr = TokensFile_buffer+Exec_Ptr;
  Exec_Ptr += size;
  
  return TRUE;
}


//******************************************
//Ajoute une variable
//******************************************
BOOL ExprExecute_AddVar (void *adr, unsigned short size, unsigned char type)
{
	if (ExcStack_Ptr>=MAX_EXEC_STACK) {error_code = ERROR_OVERFLOW; return FALSE;}
	
	ExcStack [ExcStack_Ptr].operand = OPRD_VAR;
	ExcStack [ExcStack_Ptr].type = type;
	ExcStack [ExcStack_Ptr].adr = adr;
	ExcStack [ExcStack_Ptr++].string_size = size;
		
	return TRUE;
}


//******************************************
//Ajoute une variable de type tableau
//******************************************
BOOL ExprExecute_AddVarTable (s_TblVar *table, unsigned char type, unsigned char blocsize)
{	
	if (ExcStack_Ptr>=MAX_EXEC_STACK) {error_code = ERROR_OVERFLOW; return FALSE;}
	
	unsigned char narg = ExprExecute_NumArg ();
	
	//Tableau dfini sans argument(s)
	if (!narg && table->ndim)
	{
		ExprExecute_EndFunc ();
		ExcStack [ExcStack_Ptr].operand = OPRD_EMPTY_VARTABLE;
		ExcStack [ExcStack_Ptr].adr = NULL;
	}
	//Tableau non dfini
	else if (!table->ndim)
	{	
		if (table->TblDim) free (table->TblDim);
		if (!(table->TblDim = calloc (narg, sizeof (unsigned short)))) {error_code = ERROR_MEMORY; return FALSE;}
		
		//Parcours arguments
		for (int i=FirstArg; i<=EndArg; i++)
		{
			if (!ExprExecute_ConvertType (number (i).type, TYPE_INT, i)) return FALSE;
			table->TblDim [i-FirstArg] = (unsigned short)(INT_num (i)+1); //Index 0
			//table->TblDim [i-FirstArg] = (unsigned short)(INT_num (i)); 	//Index 1
		}
		table->nTblDim = narg;
		
		ExprExecute_EndFunc ();
		ExcStack [ExcStack_Ptr].operand = OPRD_UNDEF_VARTABLE;
		ExcStack [ExcStack_Ptr].adr = NULL;
	}
	//Tableau dfini avec arguments
	else
	{
		unsigned short ptr = 0;
		unsigned short arg_value = 0;
		unsigned short total_dim = 1;
		
		if (narg!=table->ndim) {error_code = ERROR_TBL_INDICES; return FALSE;}
		
		//Parcours arguments
		for (int i=FirstArg; i<=EndArg; i++)
		{
			ExprExecute_ConvertType (number (i).type, TYPE_INT, i);
			
			arg_value = INT_num (i);
			if (arg_value>=table->TblDim [i-FirstArg]) {error_code = ERROR_TBL_INCORRECT_INDICE; return FALSE;}
			if (i!=FirstArg) total_dim *= table->TblDim [i-FirstArg-1];
			ptr += arg_value*total_dim;	//Index 0
			//ptr += (arg_value-1)*total_dim; //Index 1
		}
		
		ExprExecute_EndFunc ();
		
		ExcStack [ExcStack_Ptr].operand = OPRD_VARTABLE;
		ExcStack [ExcStack_Ptr].adr = (void *)(table->adr+(ptr*blocsize));
		
		if (type==TYPE_STRING) ExcStack [ExcStack_Ptr].string_size = *(unsigned short *)(table->adr+(ptr*blocsize)+sizeof (HANDLE));
	}
	
	ExcStack [ExcStack_Ptr].type = type;
	ExcStack [ExcStack_Ptr++].adr_base = table;
	
	return TRUE;
}


//******************************************
//Ajoute une valeur sur la pile
//******************************************
BOOL ExprExecute_AddValue (void *adr, unsigned char type, unsigned char size, unsigned char ptr)
{
	if (ptr>=MAX_EXEC_STACK || NumStack_Ptr++>=MAX_NUMBER_STACK) {error_code = ERROR_OVERFLOW; return FALSE;}
	
	ExcStack [ptr].operand = OPRD_RESULT;
	ExcStack [ptr].type = type;
	ExcStack [ptr].adr = NumStack+NumStack_LastOffset;
	
	if (type==TYPE_FLOAT) *(float *)(NumStack+NumStack_LastOffset) = *(float *)adr;
	else if (type==TYPE_INT) *(long *)(NumStack+NumStack_LastOffset) = *(long *)adr;
	else *(char *)(NumStack+NumStack_LastOffset++) = *(char *)adr;
	NumStack_LastOffset += size;
	
	return TRUE;
}


//*******************************************
//Vide la pile StringStack
//*******************************************
void ExprExecute_ClearStringStack (void) 
{
	for (int i=0; i<StringStack_Ptr; i++)	{
		if (StringStack [i]!=H_NULL) HeapFree (StringStack [i]);} 
	StringStack_Ptr = 0;
}


//*******************************************
//Ajoute une chane de caractre
//*******************************************
HANDLE ExprExecute_AddString (unsigned short size, unsigned char ptr)
{
	HANDLE handle;
	unsigned short addsize = ((size+1)<6)?6:size+1;	
	if (ptr>=MAX_EXEC_STACK) {error_code = ERROR_OVERFLOW; return H_NULL;}
	if (size>MAX_STRING_SIZE) {error_code = ERROR_STRING_OVERFLOW; return H_NULL;}
	
	if (StringStack_Ptr>=MAX_STRING_STACK) {error_code = ERROR_OVERFLOW; return H_NULL;}
	if ((handle = HeapAlloc (addsize))==H_NULL) {error_code = ERROR_MEMORY; return H_NULL;}
	if (handle!=H_NULL) *(unsigned char *)(HeapDeref (StringStack [StringStack_Ptr]=handle)+size) = 0;
	else {error_code = ERROR_MEMORY; return H_NULL;}
	
	ExcStack [ptr].operand = OPRD_RESULT;
	ExcStack [ptr].type = TYPE_STRING;
	ExcStack [ptr].string_size = size;
	ExcStack [ptr].adr = &StringStack [StringStack_Ptr++];
	
	return handle;
}


//********************************************
//Obtient l'adresse d'une chane de caractres
//********************************************
unsigned char *ExprExecute_GetString (unsigned char ptr)
{
	if (ExcStack [ptr].operand==OPRD_STRING) return (unsigned char *)ExcStack [ptr].adr;
	return HeapDeref (*(HANDLE *)ExcStack [ptr].adr);
}


//*******************************************
//Ajoute nombre
//*******************************************
BOOL ExprExecute_AddValue_Float (float value, unsigned char ptr) {return ExprExecute_AddValue (&value, TYPE_FLOAT, sizeof (float), ptr);}
BOOL ExprExecute_AddValue_Int (long value, unsigned char ptr) {return ExprExecute_AddValue (&value, TYPE_INT, sizeof (long), ptr);}
BOOL ExprExecute_AddValue_Bool (char value, unsigned char ptr) {return ExprExecute_AddValue (&value, TYPE_BOOL, sizeof (char), ptr);}


//***********************************************
//Conversion de type
//***********************************************
BOOL ExprExecute_ConvertType (unsigned char type1, unsigned char type2, unsigned char ptr)
{
	if (number (ptr).operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return FALSE;}
	if (number (ptr).operand==OPRD_EMPTY_VARTABLE) {error_code = ERROR_TBL_INDICES; return FALSE;}
	
	if (type1==type2) return TRUE;
	if (type1==TYPE_STRING || type2==TYPE_STRING) {error_code = ERROR_TYPE_INCOMPATIBLE; return FALSE;}
		
	//Float to
	if (type1==TYPE_FLOAT) {
		if (type2==TYPE_INT) return ExprExecute_Type_Float_To_Int (ptr);
		else return ExprExecute_Type_Float_To_Bool (ptr);}
	//Int to
	else if (type1==TYPE_INT) {
		if (type2==TYPE_FLOAT) return ExprExecute_Type_Int_To_Float (ptr);
		else return ExprExecute_Type_Int_To_Bool (ptr);}
	//Bool to
	else if (type1==TYPE_BOOL) {
		if (type2==TYPE_FLOAT) return ExprExecute_Type_Bool_To_Float (ptr);
		else return ExprExecute_Type_Bool_To_Int (ptr);}
		
	return TRUE;
}


//********************************************
//Conversion
//********************************************
BOOL ExprExecute_Type_Float_To_Int (unsigned char ptr) {return ExprExecute_AddValue_Int (trunc (FLOAT_num (ptr)), ptr);}
BOOL ExprExecute_Type_Float_To_Bool (unsigned char ptr) {return ExprExecute_AddValue_Bool (fcmp (FLOAT_num (ptr), 0)?-1:0, ptr);}
BOOL ExprExecute_Type_Int_To_Float (unsigned char ptr) {return ExprExecute_AddValue_Float (flt (INT_num (ptr)), ptr);}
BOOL ExprExecute_Type_Int_To_Bool (unsigned char ptr) {return ExprExecute_AddValue_Bool (INT_num (ptr)?-1:0, ptr);}
BOOL ExprExecute_Type_Bool_To_Float (unsigned char ptr) {return ExprExecute_AddValue_Float (flt ((long)(BOOL_num (ptr))), ptr);}
BOOL ExprExecute_Type_Bool_To_Int (unsigned char ptr) {return ExprExecute_AddValue_Int ((long)(BOOL_num (ptr)), ptr);}


//Conversion d'un argument
BOOL ExprExecute_ConvertOneType (BOOL fnum, BOOL integer, BOOL boolean, BOOL string, unsigned char optimized_type, unsigned char ptr)
{
	unsigned char type = number (ptr).type;
	if (number (ptr).operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return FALSE;}
	if (number (ptr).operand==OPRD_EMPTY_VARTABLE) {error_code = ERROR_TBL_INDICES; return FALSE;}
	if (type==TYPE_STRING && string==FALSE) {error_code = ERROR_TYPE_INCOMPATIBLE; return FALSE;}
	if ((type==TYPE_FLOAT && fnum==FALSE) || (type==TYPE_INT && integer==FALSE) || (type==TYPE_BOOL && boolean==FALSE)) return ExprExecute_ConvertType (type, optimized_type, ptr);
	return TRUE;
}

//Conversion de 2 arguments
BOOL ExprExecute_ConvertTwoType (BOOL fnum, BOOL integer, BOOL boolean, BOOL string, unsigned char optimized_type, unsigned char ptr2, unsigned char ptr1, BOOL ChangePtr2)
{
	unsigned char type1, type2;
	type1 = number (ptr1).type; type2 = number (ptr2).type;
	
	//Vrification tableaux
	if (number (ptr2).operand==OPRD_UNDEF_VARTABLE || number (ptr1).operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return FALSE;}
	if (number (ptr2).operand==OPRD_EMPTY_VARTABLE || number (ptr1).operand==OPRD_EMPTY_VARTABLE) {error_code = ERROR_TBL_INDICES; return FALSE;}
	
	//Vrification chanes de caractres
	if (((type1==TYPE_STRING || type2==TYPE_STRING) && (string==FALSE)) || ((type1==TYPE_STRING && type2!=TYPE_STRING) || (type1!=TYPE_STRING && type2==TYPE_STRING))) {error_code = ERROR_TYPE_INCOMPATIBLE; return FALSE;}
	if (type2==TYPE_STRING) return TRUE;
	
	//Mme type avec autorisation
  if (type2==type1 && ((type2==TYPE_FLOAT && fnum) || (type2==TYPE_INT && integer) || (type2==TYPE_BOOL && boolean))) 
  	return TRUE;
  
  //Nombre2 (Autoris) - Nombre1
	if ((type2==TYPE_FLOAT && fnum) || (type2==TYPE_INT && integer) || (type2==TYPE_BOOL && boolean)) 
	{
		//Priorite des types (Flottant contre Integer...)
		if (ChangePtr2 && !ExprExecute_PriorityType (type2, type1))
		{
		  if ((type1==TYPE_FLOAT && fnum) || (type1==TYPE_INT && integer) || (type1==TYPE_BOOL && boolean))
		    return ExprExecute_ConvertType (type2, type1, ptr2);
		} 
		return ExprExecute_ConvertType (type1, type2, ptr1);
	}
	
	//Nombre2 (Non autoris) - Nombre1 (Autoris)  
	if ((type1==TYPE_FLOAT && fnum) || (type1==TYPE_INT && integer) || (type1==TYPE_BOOL && boolean)) 
		return ExprExecute_ConvertType (type2, type1, ptr2);
	
	//Nombre2 (Non autoris) - Nombre1 (Non autoris)
	if (!ExprExecute_ConvertType (type2, optimized_type, ptr2)) return FALSE;
	if (!ExprExecute_ConvertType (type1, optimized_type, ptr1)) return FALSE;
	return TRUE;
}

//Transtypage dynamique
//---------------------
BOOL ExprExecute_MathType (BOOL fnum, BOOL integer, BOOL boolean, BOOL string, unsigned char optimized_type)
{
	if (ExcStack_Ptr<2) {error_code = ERROR_OPERATION; return FALSE;}
	return ExprExecute_ConvertTwoType (fnum, integer, boolean, string, optimized_type, ExcStack_Ptr-2, ExcStack_Ptr-1, TRUE);
}

BOOL ExprExecute_SimpleType (BOOL fnum, BOOL integer, BOOL boolean, BOOL string, unsigned char optimized_type)
{
	if (!ExcStack_Ptr) {error_code = ERROR_OPERATION; return FALSE;}
	return ExprExecute_ConvertOneType (fnum, integer, boolean, string, optimized_type, ExcStack_Ptr-1);
}

//Dominant:
//---------
//TRUE = Type2
//FALSE = Type1
BOOL ExprExecute_PriorityType (unsigned char type2, unsigned char type1)
{
	if ((type1==TYPE_FLOAT) || (type1==TYPE_INT && type2==TYPE_BOOL)) return FALSE;
	return TRUE;
}

BOOL ExprExecute_CheckTableVar (unsigned char ptr)
{
	if (number (ptr).operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return FALSE;}
	if (number (ptr).operand==OPRD_EMPTY_VARTABLE) {error_code = ERROR_TBL_INDICES; return FALSE;}
	return TRUE;
}

//**********************************
//Vrification du nombre d'arguments
//**********************************
BOOL ExprExecute_CheckArg (char narg)
{
	char numarg = ExprExecute_NumArg ();
	if (numarg<narg) {error_code = ERROR_FEW_ARGUMENT; return FALSE;}
	else if (numarg>narg) {error_code = ERROR_LOT_ARGUMENT; return FALSE;}
	
	return TRUE;
}

BOOL ExprExecute_CCheckArg (char narg)
{
	char numarg = ExprExecute_CNumArg ();
	if (numarg<narg) {error_code = ERROR_FEW_ARGUMENT; return FALSE;}
	else if (numarg>narg) {error_code = ERROR_LOT_ARGUMENT; return FALSE;}
	
	return TRUE;
}


void ExprExecute_AddResult_Func_Float (float value) {ExprExecute_EndFunc (); ExprExecute_AddValue_Float (value, ExcStack_Ptr++);}
void ExprExecute_AddResult_Func_Int (long value) {ExprExecute_EndFunc (); ExprExecute_AddValue_Int (value, ExcStack_Ptr++);}
void ExprExecute_AddResult_Func_Bool (char value)	{ExprExecute_EndFunc (); ExprExecute_AddValue_Bool (value, ExcStack_Ptr++);}
HANDLE ExprExecute_AddResult_Func_String (unsigned short size) {ExprExecute_EndFunc (); return ExprExecute_AddString (size, ExcStack_Ptr++);}

**/
