// C Source File
// Created 10/08/2004; 18:03:21

#include "Header.h"

/*#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Lst.h"
#include "..\System\String.h"
#include "..\System\Error.h"
#include "..\Other\Scanner.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\ExprFind.h"*/

//*****************************************
//Recherche d'un tableau
//*****************************************
//Type:
//0 = Variable
//1 = Tableau
//2 = Goto Label
//3 = Label:
//4 = Procedure name(...)
//5 = Gosub name(...)
BOOL ExprFind_FindVar (unsigned char ptr, unsigned char type)
{
	unsigned char *string = StackExpr [ptr].string.data;
	unsigned short size = StackExpr [ptr].string.size;
	
	lstring *Table = NULL;
	unsigned short *nItemTable = NULL;
	unsigned char subtag = SUBTAG_FLOAT;
	BOOL find = FALSE;
	unsigned short i;
	
	//Caractres interdits
	for (i=0; i<size; i++)
	{
		if (string [i]=='?'			//Point d'interrogation
		 || string [i]==0xA8 		//Racine carre
		 || string [i]==0x96)		//Exponentielle
		  {error_code = ERROR_SYNTAX; return FALSE;}
	}
	
	//Recherche typage
	if (string [size-1]=='%') subtag = SUBTAG_INT;
	else if (string [size-1]=='!') subtag = SUBTAG_BOOL;
	else if (string [size-1]=='$') subtag = SUBTAG_STRING;
	
	//Modification de la pile
	if (type==1) StackExpr [ptr].tag = TAG_VARTABLE;
	else if (type==0) StackExpr [ptr].tag = TAG_VAR;
	else
	{
		if (subtag!=SUBTAG_FLOAT) {error_code = ERROR_SYNTAX; return FALSE;}
		StackExpr [ptr].tag = (type==4 || type==5)?TAG_PROC:TAG_LABEL;
	}
	StackExpr [ptr].subtag = subtag;
	
	//Tableaux
	if (type==1)
	{
		if (subtag==SUBTAG_FLOAT) {nItemTable = &nTSym_tblfloat; Table = TSym_tblfloat;}
		else if (subtag==SUBTAG_INT) {nItemTable = &nTSym_tblinteger; Table = TSym_tblinteger;}
		else if (subtag==SUBTAG_BOOL) {nItemTable = &nTSym_tblbool; Table = TSym_tblbool;}
		else {nItemTable = &nTSym_tblstring; Table = TSym_tblstring;}
	}
	//Variable simple
	else if (type==0)
	{
		if (subtag==SUBTAG_FLOAT) {nItemTable = &nTSym_float; Table = TSym_float;}
		else if (subtag==SUBTAG_INT) {nItemTable = &nTSym_integer; Table = TSym_integer;}
		else if (subtag==SUBTAG_BOOL) {nItemTable = &nTSym_bool; Table = TSym_bool;}
		else {nItemTable = &nTSym_string; Table = TSym_string;}
	}
	//Label
	else if (type==2 || type==3) {
		nItemTable = &nTSym_label; Table = TSym_label;}
	//Procedure
	else {
		nItemTable = &nTSym_procedure; Table = TSym_procedure;}
	
	//Retire caractre de transtypage
	if (subtag!=SUBTAG_FLOAT) size--;
	
	//Prpare comparaison
	memcpy (string_buffer, string, size);
	string_buffer [size] = 0;
	StrUpper (string_buffer, size);

	//Parcours liste
	for (i=0; i<*nItemTable; i++) {
		memcpy (string_buffer2, Table [i].data, Table [i].size);
		string_buffer2 [Table [i].size] = 0;
		StrUpper (string_buffer2, Table [i].size);
		
		if (!strcmp2 (string_buffer, string_buffer2, size, Table [i].size)) 
		  {find = TRUE; break;}}
			  
	//Index trouv
	if (find) 
	{
		if (type==3) {
			if (defined_label [i]==TRUE) {error_code = ERROR_LABEL_DEFINED; return FALSE;}
			else defined_label [i] = TRUE;}
		else if (type==4) {
			if (defined_procedure [i]==TRUE) {error_code = ERROR_PROCEDURE_DEFINED; return FALSE;}
			else defined_procedure [i] = TRUE;}
		StackExpr [ptr].symbol_index = i;
	}
	else {
		if (*nItemTable==MAX_SYMBOL || ((type==2 || type==3) && *nItemTable==MAX_SYMBOL-1)) {
			error_code = (type==0 || type==1)?ERROR_VAR_OVERFLOW:((type==2 || type==3)?ERROR_LABEL_OVERFLOW:ERROR_PROCEDURE_OVERFLOW); return FALSE;}
		if (type==3) defined_label [*nItemTable] = TRUE;
		else if (type==2) defined_label [*nItemTable] = FALSE;
		else if (type==4) defined_procedure [*nItemTable] = TRUE;
		else if (type==5) defined_procedure [*nItemTable] = FALSE;
		
		StackExpr [ptr].symbol_index = *nItemTable; 
		Table [*nItemTable].data = string;
		Table [(*nItemTable)++].size = size;}
	return TRUE;
}


//**************************************************
//Vrifie dclaration de tous les labels
//**************************************************
BOOL ExprFind_CheckLabels (void)
{
	//Parcours labels
	for (unsigned short i=0; i<nTSym_label; i++)
		if (defined_label [i]==FALSE) {error_code = ERROR_LABEL_UNDEFINED; return FALSE;}
	return TRUE;
}


//**************************************************
//Vrifie dclaration de toutes les procdures
//**************************************************
BOOL ExprFind_CheckProcedures (void)
{
	//Parcours labels
	for (unsigned short i=0; i<nTSym_procedure; i++)
		if (defined_procedure [i]==FALSE) {error_code = ERROR_PROCEDURE_UNDEFINED; return FALSE;}
	return TRUE;
}