// C Source File
// Created 14/08/2004; 15:28:03

#include "Header.h"

/*#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Lst.h"
#include "..\System\String.h"
#include "..\System\Error.h"
#include "..\Other\Scanner.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\UnTokenisor.h"
#include "..\Other\ExprMake.h"
#include "..\Other\ExprTokens.h"*/


//****************************************************
//Lecture du fichier
//****************************************************
BOOL ExprMake_ReadFile (lstring *file)
{
	unsigned char *ptr = file->data;
	BOOL first_token = TRUE;
	unsigned token_type = TOKEN_COMMAND;

	StackExpr_Ptr = 0;		//Vide la pile
	s_tag tag;
	Scanner_NextTag (&tag, ptr);
	
	error_code = ERROR_NOERROR;
	error_line = 1;
	
	//Lecture de la table des symboles
	ptr += UnTokenisor_ReadTablesSymbols (ptr);
	
	while (*ptr!=TOKEN_ENDPROGRAM && error_code==ERROR_NOERROR)
	{
		//Nombre
		if (!first_token)
		{
			//Entiers
			if (*ptr>=TOKEN_START_INT && *ptr<=TOKEN_END_INT)
			{
				if (*ptr==TOKEN_SKIP_INT_DEC || *ptr==TOKEN_SKIP_INT_BIN || *ptr==TOKEN_SKIP_INT_OCT || *ptr==TOKEN_SKIP_INT_HEX)
					ptr++;
				ExprMake_AddTag (TYPE_SYMBOL, TAG_NUMBER, SUBTAG_INT, TOKEN_NOFOUND, TOKEN_NULL, 0x00, *(long *)(++ptr), 0, NULL, 0);
				ptr += sizeof (long);	//Avance de 4 octets
				continue;
			}
			//Flottant
			else if (*ptr==TOKEN_FLOAT_DEC || *ptr==TOKEN_SKIP_FLOAT_DEC)
			{
				//Avance d'un octet
				if (*ptr==TOKEN_SKIP_FLOAT_DEC) 
					ptr++;
				ExprMake_AddTag (TYPE_SYMBOL, TAG_NUMBER, SUBTAG_FLOAT, TOKEN_NOFOUND, TOKEN_NULL, 0x00, 0, *(float *)(++ptr), NULL, 0);
				ptr += sizeof (float);	//Avance de 10 octets
				continue;
			}
			//Chaine de caractre, saute commentaire
			else if (*ptr==TOKEN_STRING || *ptr==TOKEN_SKIP_STRING || *ptr==TOKEN_COMMENT)
			{
			  BOOL quote = *ptr==TOKEN_COMMENT?FALSE:TRUE;
			  if (*ptr==TOKEN_SKIP_STRING) ptr++;
			  
			  unsigned char size = *++ptr;
			  ptr++;
			  
			  //Chane de caractres
			  if (quote)
			    ExprMake_AddTag (TYPE_SYMBOL, TAG_STRING, SUBTAG_NONE, TOKEN_FUNCTION, TOKEN_STRING, 0x00, 0, 0, ptr++, size);
			  ptr += size;
			  continue;
			}		
		}
		
		//Variables:
		//==========
		if (*ptr>=TOKEN_START_SYMBOLS && *ptr<=TOKEN_END_SYMBOLS)
		{
			unsigned char tag = TAG_NONE;
			unsigned char subtag = SUBTAG_NONE;
			
			//Variables
			if (*ptr==TOKEN_VAR_FLOAT) {tag = TAG_VAR; subtag = SUBTAG_FLOAT;}
			else if (*ptr==TOKEN_VAR_INT) {tag = TAG_VAR; subtag = SUBTAG_INT;}
			else if (*ptr==TOKEN_VAR_BOOL) {tag = TAG_VAR; subtag = SUBTAG_BOOL;}
			else if (*ptr==TOKEN_VAR_STRING) {tag = TAG_VAR; subtag = SUBTAG_STRING;}
			
			//Tableaux
			else if (*ptr==TOKEN_VARTABLE_FLOAT) {tag = TAG_VARTABLE; subtag = SUBTAG_FLOAT;}
			else if (*ptr==TOKEN_VARTABLE_INT) {tag = TAG_VARTABLE; subtag = SUBTAG_INT;}
			else if (*ptr==TOKEN_VARTABLE_BOOL) {tag = TAG_VARTABLE; subtag = SUBTAG_BOOL;}
			else if (*ptr==TOKEN_VARTABLE_STRING) {tag = TAG_VARTABLE; subtag = SUBTAG_STRING;}
			
			//Labels
			else if (*ptr==TOKEN_LABEL) {tag = TAG_LABEL; subtag = SUBTAG_NONE;}
			
			//Procedures
			else if (*ptr==TOKEN_PROC) {tag = TAG_PROC; subtag = SUBTAG_NONE;}
			
			ExprMake_AddTag (TYPE_SYMBOL, tag, subtag, TOKEN_NOFOUND, TOKEN_NULL, *++ptr, 0, 0, NULL, 0);
		}
		//Commentaires
		else if (first_token && (*ptr==TOKEN_CMD_COMMENT1 || *ptr==TOKEN_CMD_COMMENT2));
		else if (!first_token && *ptr==TOKEN_FUNC_COMMENT3) ptr++;
		//Constantes par dfauts!
		else if (!first_token && (*ptr==TOKEN_PI || *ptr==TOKEN_PI_TXT || *ptr==TOKEN_EXP || *ptr==TOKEN_TRUE || *ptr==TOKEN_FALSE))
		{
			long lnum = 0;
			float fnum = 0;
			
			if (*ptr==TOKEN_PI || *ptr==TOKEN_PI_TXT) fnum = PI;
			else if (*ptr==TOKEN_EXP) fnum = EXP1;
			else if (*ptr==TOKEN_TRUE) lnum = -1;
			
			ExprMake_AddTag (TYPE_SYMBOL, TAG_NUMBER, fnum?SUBTAG_FLOAT:SUBTAG_INT, TOKEN_NOFOUND, TOKEN_NULL, 0x00, lnum, fnum, NULL, 0);
		}
		//Tokens de constantes
		else if (!first_token && *ptr==TOKEN_CONSTANT)
		{
			//Constante dfinie (prennent directement une valeur)
			if (*++ptr>=0x80)
			{
				long lnum = GFA_TableExecToken_Constant [*ptr-128];
				ExprMake_AddTag (TYPE_SYMBOL, TAG_NUMBER, SUBTAG_INT, TOKEN_NOFOUND, TOKEN_NULL, 0x00, lnum, 0, NULL, 0);
			}
			//Constante complexes
			else
			  ExprMake_AddTag (TYPE_CONSTANT, TAG_CONSTANT, SUBTAG_NONE, TOKEN_NOFOUND, *ptr, 0x00, 0, 0, NULL, 0);
		}
		//Oprations mathmatiques
		else if (!first_token && *ptr<=TOKEN_FUNC_END_CALC)
		{
			unsigned char tag = TAG_CALC;
			if (*ptr>=TOKEN_START_COMPARE) tag = TAG_COMPARE;
			ExprMake_AddTag (TYPE_SIGN, tag, GFA_TableCalc [*ptr], TOKEN_FUNCTION, *ptr, 0x00, 0, 0, NULL, 0);
		}
		//Division entire
		else if (!first_token && *ptr==TOKEN_DIVINT2)
			ExprMake_AddTag (TYPE_SIGN, TAG_CALC, SUBTAG_DIVINT, TOKEN_FUNCTION, *ptr, 0x00, 0, 0, NULL, 0);
		//Affectation
		else if (!first_token && *ptr==TOKEN_FUNC_AFFEC)
			ExprMake_AddTag (TYPE_SIGN, TAG_COMPARE, SUBTAG_AFFEC, TOKEN_FUNCTION, TOKEN_FUNC_AFFEC, 0x00, 0, 0, NULL, 0);
		//Signes
		else if (!first_token && (*ptr==TOKEN_PARENTH_OPEN || *ptr==TOKEN_PARENTH_CLOSE || *ptr==TOKEN_NEGATIF || *ptr==TOKEN_VIRGULE || *ptr==TOKEN_POINT_VIRGULE || *ptr==TOKEN_APOST))
		{
			unsigned char type = TYPE_NONE;
			unsigned char tag = TAG_NONE;
			
			if (*ptr==TOKEN_PARENTH_OPEN) type = TYPE_PARENTH_OPEN;
			else if (*ptr==TOKEN_PARENTH_CLOSE) type = TYPE_PARENTH_CLOSE;
			else if (*ptr==TOKEN_NEGATIF) type = TYPE_NEGATIF;
			else if (*ptr==TOKEN_VIRGULE || *ptr==TOKEN_POINT_VIRGULE || *ptr==TOKEN_APOST)
			{
				type = TYPE_VIRGULE;
				if (*ptr==TOKEN_POINT_VIRGULE) tag = TAG_POINT_VIRGULE;
				else if (*ptr==TOKEN_APOST) tag = TAG_APOST;
			}
			
			ExprMake_AddTag (type, tag, SUBTAG_NONE, TOKEN_FUNCTION, *ptr, 0x00, 0, 0, NULL, 0);
		}
		//Saute les 2 points ou Then
		else if (!first_token && (*ptr==TOKEN_TWO_POINT || *ptr==TOKEN_THEN));
		
		//Gestion du goto
		else if (first_token && *ptr==TOKEN_GOTO)
		{
			ExprMake_AddTag (TYPE_FUNC, TAG_NONE, SUBTAG_NONE, TOKEN_COMMAND, TOKEN_GOTO, *(ptr+2), 0, 0, NULL, 0);
			ptr += 2;
		}
		//Gestion de restore
		else if (first_token && *ptr==TOKEN_RESTORE)
		{
			//Gestion restore seul
			BOOL eofline = (*(ptr+1)==TOKEN_EOFLINE)?TRUE:FALSE;
			ExprMake_AddTag (TYPE_FUNC, TAG_NONE, SUBTAG_NONE, TOKEN_COMMAND, TOKEN_RESTORE, eofline?0xFF:(*(ptr+2)), 0, 0, NULL, 0);
			ptr += eofline?0:2;
		}
		//Gestion de procedure et gosub
		else if (first_token && (*ptr==TOKEN_PROCEDURE || *ptr==TOKEN_GOSUB || *ptr==TOKEN_GOSUB2))
		{
			ExprMake_AddTag (TYPE_FUNC, TAG_NONE, SUBTAG_NONE, TOKEN_COMMAND, (*ptr==TOKEN_GOSUB2)?TOKEN_GOSUB:*ptr, *(ptr+2), 0, 0, NULL, 0);
			ptr += 2;
		}
		//Tokens de fonctions
		//===================
		else if (*ptr!=TOKEN_EOFLINE)
			ExprMake_AddTag (TYPE_FUNC, TAG_NONE, SUBTAG_NONE, token_type, *ptr, 0x00, 0, 0, NULL, 0);
		
		//Fin de ligne
		else
		{
			if (!ExprMake_SetSimpleFunc ()) return FALSE;
			if (!ExprMake_MoveTags ()) return FALSE;				//Mise en ordre de la pile
			if (!ExprMake_OptimizeCalculs ()) return FALSE;	//Optimisation des calculs
			if (!ExprMake_LocalVar ()) return FALSE;				//Dtermination des variables locales
			if (!ExprMake_CheckStack ()) return FALSE;			//Vrification pile
			
			error_line++;
			if (!ExprTokens_MakeBuffer ()) return FALSE;		//Cration du buffer d'execution
			
			StackExpr_Ptr = 0;	//Vide la pile	
			ptr++;
			//ptr += 2+1; //Saute numro de ligne
			first_token = TRUE;
			token_type = TOKEN_COMMAND;
			continue;
		}
		
		//Changement de la table des tokens
		if (first_token)
		{
			first_token = FALSE;
			token_type = TOKEN_FUNCTION;
		}
		
		ptr++;
	}
	
	//Token de fin
	ExprTokens_Add (NULL, ETOKEN_END, 1);
	
	return TRUE;
}


//*******************************
//Ajoute tag sur la pile
//*******************************
BOOL ExprMake_AddTag (unsigned char type, unsigned char tag, unsigned char subtag, unsigned char token_type, unsigned char token_index, unsigned char symbol_index, long lnum, float fnum, unsigned char *data, unsigned short size)
{
	//Dpassement de la pile
	if (StackExpr_Ptr==MAX_TAG_STACK) {
		error_code = ERROR_EXPRSTACK_OVERFLOW;
		return FALSE;}

	StackExpr [StackExpr_Ptr].type = type;
	StackExpr [StackExpr_Ptr].tag = tag;
	StackExpr [StackExpr_Ptr].subtag = subtag;
	
	StackExpr [StackExpr_Ptr].token_type = token_type;
	StackExpr [StackExpr_Ptr].token_index = token_index;
	StackExpr [StackExpr_Ptr].symbol_index = symbol_index;
	StackExpr [StackExpr_Ptr].lnum = lnum;
	StackExpr [StackExpr_Ptr].fnum = fnum;
	StackExpr [StackExpr_Ptr].string.data = data;
	StackExpr [StackExpr_Ptr].string.size = size;
	ExprMake_SetPriority (StackExpr_Ptr++);
	
	return TRUE;
}


//********************************
//Efface un TAG dans la pile trie
//********************************
void ExprMake_DelTag (unsigned char ptr) {memmove (&TStackExpr [ptr], &TStackExpr [ptr+1],(TStackExpr_Ptr---ptr)<<2);}


//******************************
//Attribut priorit
//******************************
void ExprMake_SetPriority (unsigned char ptr)
{
	unsigned char type = StackExpr [ptr].type;
	unsigned char tag = StackExpr [ptr].tag;
	unsigned char subtag = StackExpr [ptr].subtag;
	unsigned char priority = 0x00;
	
	if (type==TYPE_SIGN)
	{
		if (tag==TAG_COMPARE && subtag==SUBTAG_AFFEC) priority = PRIORITY_AFFEC;
		else if (tag==TAG_COMPARE && subtag!=SUBTAG_AFFEC) priority = PRIORITY_COMPARE;
		else if (tag==TAG_CALC)
		{
			if (subtag==SUBTAG_LOGIC) priority = PRIORITY_LOGIC;
			else if (subtag==SUBTAG_ADD || subtag==SUBTAG_SUB) priority = PRIORITY_ADDSUB;
			else if (subtag==SUBTAG_MUL || subtag==SUBTAG_DIV || subtag==SUBTAG_MOD || subtag==SUBTAG_DIVINT) priority = PRIORITY_MULDIV;
			else if (subtag==SUBTAG_PUISS) priority = PRIORITY_PUISS;
		}
	}
	else if (type==TYPE_NEGATIF)
		priority = PRIORITY_NEGATIF;
		
	StackExpr [ptr].priority = priority;
}


//*************************************
//Ajoute parenthses si simple fonction
//*************************************
BOOL ExprMake_SetSimpleFunc (void)
{
	unsigned char preview_type, type, token_index;
	BOOL AddParenth = FALSE;
	unsigned char pos;
	unsigned char to_pos = 0;
	
	//Ajoute parenthses pour un token de Command comme Print...
	if (StackExpr_Ptr && StackExpr [0].type==TYPE_FUNC && StackExpr [0].token_type==TOKEN_COMMAND && 
	  StackExpr [0].token_index!=TOKEN_NEXT) //Pas de parenthses pour Next
	{
		AddParenth = TRUE;
		pos = 1;

		//Pos+1 si dtection du token IF
		if (StackExpr_Ptr>2 && StackExpr [1].token_index==TOKEN_IF2) pos++;
		
		//Ajoute parenthse
		if (!Scanner_AddPosTag (pos, TYPE_PARENTH_OPEN, TAG_NONE, SUBTAG_NONE, TOKEN_FUNCTION, TOKEN_PARENTH_OPEN)) return FALSE;
	}
	
	//Parcours la pile
	for (int i=2; i<StackExpr_Ptr; i++)
	{
		preview_type = StackExpr [i-1].type;
		type = StackExpr [i].type;
		token_index = StackExpr [i].token_index;
		
		//Fonction vierge du style Timer- devient Timer()-
		if (preview_type==TYPE_FUNC && type==TYPE_SIGN)
		{
			if (!Scanner_AddPosTag (i++, TYPE_PARENTH_OPEN, TAG_NONE, SUBTAG_NONE, TOKEN_FUNCTION, TOKEN_PARENTH_OPEN)) return FALSE;
			if (!Scanner_AddPosTag (i++, TYPE_PARENTH_CLOSE, TAG_NONE, SUBTAG_NONE, TOKEN_FUNCTION, TOKEN_PARENTH_CLOSE)) return FALSE;
		}
		
		//Ferme parenthse avant To et ouvre aprs To devient )To(
		if (token_index==TOKEN_TO || token_index==TOKEN_DOWNTO || token_index==TOKEN_STEP)
		{
			//Parenthse avant
			if (!Scanner_AddPosTag (i, TYPE_PARENTH_CLOSE, TAG_NONE, SUBTAG_NONE, TOKEN_FUNCTION, TOKEN_PARENTH_CLOSE)) return FALSE;
			//Parenthse aprs
			if (!Scanner_AddPosTag (i+2, TYPE_PARENTH_OPEN, TAG_NONE, SUBTAG_NONE, TOKEN_FUNCTION, TOKEN_PARENTH_OPEN)) return FALSE;
			i += 2;
		}
	}
	
	//Informe un To qu'un Step existe
	for (int i=2; i<StackExpr_Ptr; i++)
	{
		token_index = StackExpr [i].token_index;
		if (token_index==TOKEN_TO) 
		  to_pos = i;
		else if (token_index==TOKEN_STEP)
		  StackExpr [to_pos].symbol_index = TOKEN_STEP;
	}	  
		  	
	//Ferme parenthse
	if (AddParenth) {		
		if (!Scanner_AddPosTag (StackExpr_Ptr, TYPE_PARENTH_CLOSE, TAG_NONE, SUBTAG_NONE, TOKEN_FUNCTION, TOKEN_PARENTH_CLOSE)) return FALSE;}
	
	//Affiche pile
	/*ClrScr ();
	for (int i=0; i<StackExpr_Ptr; i++)
	{
		printf_xy (i*15, 10, "%u", StackExpr [i].type);
		printf_xy (i*15, 20, "%u", StackExpr [i].tag);
		printf_xy (i*15, 30, "%u", StackExpr [i].subtag);
		printf_xy (i*15, 50, "%u", StackExpr [i].token_type);
		printf_xy (i*15, 60, "%u", StackExpr [i].token_index);
		printf_xy (i*15, 70, "%u", StackExpr [i].symbol_index);
	}
	ngetchx ();*/
	
	return TRUE;
}


//******************************
//Ordonne la pile
//******************************
BOOL ExprMake_MoveTags (void)
{
	unsigned char type, tag, subtag;
	type = TYPE_NONE;	tag = TAG_NONE;	subtag = SUBTAG_NONE;
	OperatorStack_Ptr = 0;	//Pointeur de pile d'oprateurs
	TStackExpr_Ptr = 0; 	//Vide la pile d'expression finale
	
	//Transformation de Else If en ElseIf
	if (StackExpr_Ptr>=2 && StackExpr [0].token_index==TOKEN_ELSE && StackExpr [1].token_index==TOKEN_IF2) {
		StackExpr [0].token_index = TOKEN_ELSEIF;
		Scanner_DelTag (1);}
		
	//Transformation de Exit If en Exit
	if (StackExpr_Ptr>=2 && StackExpr [0].token_index==TOKEN_EXIT && StackExpr [1].token_index==TOKEN_IF2)
		Scanner_DelTag (1);
	
	//Ajoute END_TAG pour les fonctions
	for (int i=0; i<StackExpr_Ptr; i++)
	{
		//END_TAG pour les tableaux
		if (StackExpr [i].tag==TAG_VARTABLE) StackExpr [i].type = TYPE_FUNC;
		
		//End_TAG pour les fonctions sauf pour TO, Downto et Step
		if ((i && StackExpr [i].type==TYPE_FUNC && StackExpr [i].token_index!=TOKEN_TO && StackExpr [i].token_index!=TOKEN_DOWNTO && StackExpr [i].token_index!=TOKEN_STEP) || StackExpr [i].tag==TAG_VARTABLE) {
		  if (!Scanner_AddPosTag (i++, TYPE_ENDTAG, TAG_NONE, SUBTAG_NONE, TOKEN_NOFOUND, TOKEN_NULL)) return FALSE;}
	}
	
	//Ajoute While, gestion Jump et gestion If
	if (StackExpr_Ptr && StackExpr [0].token_index==TOKEN_WHILE) {
		if (!Scanner_AddPosTag (0, TYPE_SYMBOL, TAG_NONE, SUBTAG_NONE, TOKEN_COMMAND, TOKEN_WHILE)) return FALSE;}
	
	//Ajoute ElseIf, gestion Jump et gestion If
	if (StackExpr_Ptr && StackExpr [0].token_index==TOKEN_ELSEIF) {
		if (!Scanner_AddPosTag (0, TYPE_FUNC, TAG_NONE, SUBTAG_NONE, TOKEN_COMMAND, TOKEN_ELSEIF)) return FALSE;}
	
	//Parcours la pile d'expression de base
	for (int i=0; i<StackExpr_Ptr; i++)
	{
		type = StackExpr [i].type; tag = StackExpr [i].tag; subtag = StackExpr [i].subtag;
		
		//Simple nombre ou variable, ajoute dans la pile d'expressions finale
		if (type==TYPE_SYMBOL || type==TYPE_CONSTANT || type==TYPE_ENDTAG
		|| (!i && (StackExpr [0].token_index==TOKEN_ELSEIF || StackExpr [0].token_index==TOKEN_NEXT 
		  || StackExpr [0].token_index==TOKEN_LOCAL
		  || StackExpr [0].token_index==TOKEN_PROCEDURE)))	//Evite rejet pour ElseIf, Next
		    TStackExpr [TStackExpr_Ptr++] = &StackExpr [i]; 
	
		//Parenthse ouverte, ajoute dans la pile d'oprateurs	
		else if (type==TYPE_PARENTH_OPEN)
		  OperatorStack [OperatorStack_Ptr++] = &StackExpr [i];
		  
		//Parenthse ferme, ajouter dernier signe dans pile d'expressions finale puis tester si parenthse ouverte
		else if (type==TYPE_PARENTH_CLOSE)
		{
			//BOOL AddOpr = FALSE;
			
			//Erreur pile vide
			if (!OperatorStack_Ptr) {error_code = ERROR_INTERNE_MOVETAGS; return FALSE;}
			
			//Ajoute signe oprateur dans la pile d'expressions
			while (OperatorStack_Ptr-- && OperatorStack [OperatorStack_Ptr]->type!=TYPE_PARENTH_OPEN)
				TStackExpr [TStackExpr_Ptr++] = OperatorStack [OperatorStack_Ptr];
			
			//Parenthse non trouve
			if (OperatorStack [OperatorStack_Ptr]->type!=TYPE_PARENTH_OPEN) 
			  {error_code = ERROR_INTERNE_MOVETAGS; return FALSE;}
			
			//Tableau, fonction ou oprateur NOT
			if (OperatorStack_Ptr && (OperatorStack [OperatorStack_Ptr-1]->type==TYPE_FUNC || (OperatorStack [OperatorStack_Ptr-1]->token_type==TOKEN_FUNCTION && OperatorStack [OperatorStack_Ptr-1]->token_index==TOKEN_NOT)))
				TStackExpr [TStackExpr_Ptr++] = OperatorStack [--OperatorStack_Ptr];
			
			//Fonction	
			/*if (OperatorStack_Ptr && OperatorStack [OperatorStack_Ptr-1]->type==TYPE_FUNC)
			{
				//Tableau ou TOKEN_FUNCTION  ex: not 
				if ((OperatorStack [OperatorStack_Ptr-1]->tag==TAG_VARTABLE || OperatorStack [OperatorStack_Ptr-1]->token_type==TOKEN_FUNCTION))
			  	AddOpr = TRUE;
				//Fonction
				else
				{
					unsigned char token_type = OperatorStack [OperatorStack_Ptr-1]->token_type;
					unsigned char token_index = OperatorStack [OperatorStack_Ptr-1]->token_index;
					unsigned char size = strlen ((token_type==TOKEN_COMMAND)?Get_GFA_TableToken_Command (token_index):Get_GFA_TableToken_Function (token_index));
							
					if (size>1 && (token_type==TOKEN_COMMAND)?*(Get_GFA_TableToken_Command (token_index)+size-1):*(Get_GFA_TableToken_Function (token_index)+size-1)=='(')
			 	  AddOpr = TRUE;
			 	}
			}
			//Oprateur NOT
			else if (OperatorStack [OperatorStack_Ptr-1]->token_type==TOKEN_FUNCTION && OperatorStack [OperatorStack_Ptr-1]->token_index==TOKEN_NOT)
				AddOpr = TRUE;
					
			//Ajoute tableau ou fonction
			if (AddOpr) TStackExpr [TStackExpr_Ptr++] = OperatorStack [--OperatorStack_Ptr];*/
		}
		
		//Virgule
		else if (type==TYPE_VIRGULE)
		{
			//Ajoute signe oprateur dans la pile d'expressions
			while (OperatorStack_Ptr && OperatorStack [OperatorStack_Ptr-1]->type!=TYPE_PARENTH_OPEN && OperatorStack [OperatorStack_Ptr-1]->type!=TYPE_FUNC)
				TStackExpr [TStackExpr_Ptr++] = OperatorStack [--OperatorStack_Ptr];
			
			//Ajoute point virgule ou apostrophe
			if (tag==TAG_POINT_VIRGULE || tag==TAG_APOST)
				TStackExpr [TStackExpr_Ptr++] = &StackExpr [i];
		}
		
		//Autre
		else
		{
			//NOT ainsi qu'une fonction sont directement ajoutes
			if (OperatorStack_Ptr && OperatorStack [OperatorStack_Ptr-1]->type!=TYPE_PARENTH_OPEN && OperatorStack [OperatorStack_Ptr-1]->type!=TYPE_FUNC && StackExpr [i].type!=TYPE_FUNC
			&& !(StackExpr [i].token_type==TOKEN_FUNCTION && StackExpr [i].token_index==TOKEN_NOT))
			{
				//Priorite infrieur, priorite suprieur  tout pour la parenthse ouverte
			  while (OperatorStack_Ptr && OperatorStack [OperatorStack_Ptr-1]->type!=TYPE_PARENTH_OPEN && StackExpr [i].priority<=OperatorStack [OperatorStack_Ptr-1]->priority)
			    TStackExpr [TStackExpr_Ptr++] = OperatorStack [--OperatorStack_Ptr];  
			}
			
			OperatorStack [OperatorStack_Ptr++] = &StackExpr [i];
		}
		
		//Ligne trop longue
		if (OperatorStack_Ptr>=MAX_OPERATOR_STACK)
			{error_code = ERROR_INTERNE_MOVETAGS; return FALSE;}
	}
	
	//Dpiler la pile d'oprateurs
	while (OperatorStack_Ptr--)
	{
		if (OperatorStack [OperatorStack_Ptr]->type==TYPE_PARENTH_OPEN)
		  {error_code = ERROR_INTERNE_MOVETAGS; return FALSE;}
		
		TStackExpr [TStackExpr_Ptr++] = OperatorStack [OperatorStack_Ptr];
	}
	
	//Rcupre les variables type tableau
	for (int i=0; i<TStackExpr_Ptr; i++) {
		if (TStackExpr [i]->tag==TAG_VARTABLE) TStackExpr [i]->type = TYPE_SYMBOL;}
	
	//Transformation de While en fonction
	if (TStackExpr_Ptr && TStackExpr [0]->token_type==TOKEN_COMMAND && TStackExpr [0]->token_index==TOKEN_WHILE)
		TStackExpr [0]->type = TYPE_FUNC;
	
	//Affiche pile
	/*ClrScr ();
	for (int i=0; i<TStackExpr_Ptr; i++)
	{
		printf_xy (i*15, 10, "%u", TStackExpr [i]->type);
		printf_xy (i*15, 20, "%u", TStackExpr [i]->tag);
		printf_xy (i*15, 30, "%u", TStackExpr [i]->subtag);
		printf_xy (i*15, 50, "%u", TStackExpr [i]->token_type);
		printf_xy (i*15, 60, "%u", TStackExpr [i]->token_index);
		printf_xy (i*15, 70, "%u", TStackExpr [i]->symbol_index);
	}
	ngetchx ();*/
	
	return TRUE;
}


//*************************************
//Optimisation des calculs
//*************************************
BOOL ExprMake_OptimizeCalculs (void)
{
	unsigned char type, tag, subtag, token_index;
	
	//Parcours la pile
	for (int i=1; i<TStackExpr_Ptr; i++)
	{
		type = TStackExpr [i]->type; tag = TStackExpr [i]->tag;	subtag = TStackExpr [i]->subtag;
		token_index = TStackExpr [i]->token_index;
		
		if (tag==TAG_CALC && token_index!=TOKEN_NOT && TStackExpr [i-1]->tag==TAG_NUMBER && TStackExpr [i-2]->tag==TAG_NUMBER)
		{
			if (TStackExpr [i-2]->subtag==SUBTAG_INT) 
				TStackExpr [i-2]->fnum = flt (TStackExpr [i-2]->lnum);
			else 
				TStackExpr [i-2]->lnum = trunc (TStackExpr [i-2]->fnum);
			
			if (TStackExpr [i-1]->subtag==SUBTAG_INT)
				TStackExpr [i-1]->fnum = flt (TStackExpr [i-1]->lnum);
			else
				TStackExpr [i-1]->lnum = trunc (TStackExpr [i-1]->fnum);
			
			float fresult = 0;
			long lresult = 0;
			
			float *fval1 = &TStackExpr [i-2]->fnum;
			float *fval2 = &TStackExpr [i-1]->fnum;
			
			long lval1 = TStackExpr [i-2]->lnum;
			long lval2 = TStackExpr [i-1]->lnum;
			
			//Division par zro
			if ((subtag==SUBTAG_DIV || subtag==SUBTAG_DIVINT) && fcmp (TStackExpr [i-1]->fnum, 0)==0)
				{error_code = ERROR_DIVIDE_BY_ZERO; break;}
			
			if (subtag==SUBTAG_ADD) fresult = fadd (*fval1, *fval2);
			else if (subtag==SUBTAG_SUB) fresult = fsub (*fval1, *fval2);
			else if (subtag==SUBTAG_MUL) fresult = fmul (*fval1, *fval2);
			else if (subtag==SUBTAG_DIV) fresult = fdiv (*fval1, *fval2);
			else if (subtag==SUBTAG_PUISS) fresult = pow (*fval1, *fval2);
			else if (subtag==SUBTAG_MOD) fresult = fmod (*fval1, *fval2);
			else if (subtag==SUBTAG_DIVINT) fresult = trunc (fdiv (*fval1, *fval2));
			
			//Enregistrement du rsultat
			if (subtag!=SUBTAG_LOGIC)
			{	
				if ((TStackExpr [i-2]->subtag==SUBTAG_FLOAT || TStackExpr [i-1]->subtag==SUBTAG_FLOAT || subtag==SUBTAG_DIV) && subtag!=SUBTAG_DIVINT) {
			 		TStackExpr [i-2]->subtag = SUBTAG_FLOAT;
			  	TStackExpr [i-2]->fnum = fresult;}
				else {
			  	TStackExpr [i-2]->subtag = SUBTAG_INT;
			  	TStackExpr [i-2]->lnum = trunc (fresult);}
			}
			//Fonctions logiques
			else
			{
				if (token_index==TOKEN_AND) lresult = lval1 & lval2;
				else if (token_index==TOKEN_OR) lresult = lval1 | lval2;
				else if (token_index==TOKEN_XOR) lresult = lval1 ^ lval2;
				else if (token_index==TOKEN_IMP) lresult = ~lval1 | lval2;
				else if (token_index==TOKEN_EQV) lresult = (~lval1 | lval2) & (lval1 | ~lval2);
				
				TStackExpr [i-2]->lnum = lresult;
			}
						
			ExprMake_DelTag (i--); //Efface le signe
			ExprMake_DelTag (i--); //Efface chiffre
		}
		//Signe ngatif ou  NOT	
		else if ((type==TYPE_NEGATIF || (tag==TAG_CALC && subtag==SUBTAG_LOGIC && token_index==TOKEN_NOT)) && TStackExpr [i-1]->tag==TAG_NUMBER)
		{
			//Signe ngatif
			if (type==TYPE_NEGATIF)
			{
				TStackExpr [i-1]->fnum = fneg (TStackExpr [i-1]->fnum);
				TStackExpr [i-1]->lnum = -TStackExpr [i-1]->lnum;
			}
			//Oprateur NOT
			else
			{
				if (TStackExpr [i-1]->subtag==SUBTAG_FLOAT) TStackExpr [i-1]->lnum = trunc (TStackExpr [i-1]->fnum);
				TStackExpr [i-1]->lnum = ~TStackExpr [i-1]->lnum;
			}
			  
			ExprMake_DelTag (i--); //Efface le signe
		}
	}
		
	//Affiche pile
	/*ClrScr ();
	for (int i=0; i<TStackExpr_Ptr; i++)
	{
		printf_xy (i*10, 10, "%u", TStackExpr [i]->type);
		printf_xy (i*10, 20, "%u", TStackExpr [i]->tag);
		printf_xy (i*10, 30, "%u", TStackExpr [i]->subtag);
		printf_xy (i*10, 50, "%u", TStackExpr [i]->token_type);
		printf_xy (i*10, 60, "%u", TStackExpr [i]->token_index);
		printf_xy (i*10, 70, "%u", TStackExpr [i]->symbol_index);
	}
	ngetchx ();*/

	if (error_code!=ERROR_NOERROR) return FALSE;
	return TRUE;
}


//*************************************
//Attribution des variables locales
//*************************************
BOOL ExprMake_LocalVar (void)
{	
	unsigned char type, tag, subtag, token_index, symbol_index;
	
	token_index = TStackExpr [0]->token_index;
	if (TStackExpr [0]->token_type==TOKEN_COMMAND
	&& (token_index==TOKEN_PROCEDURE || token_index==TOKEN_LOCAL))
	{
	  for (int i=1; i<TStackExpr_Ptr; i++)
	  {
	  	type = TStackExpr [i]->type;
	  	tag = TStackExpr [i]->tag;
	  	subtag = TStackExpr [i]->subtag;
	  	symbol_index = TStackExpr [i]->symbol_index;
	  	
	  	//C'est une variable
	  	if (type==TYPE_SYMBOL && tag==TAG_VAR)
	  	{
	  		switch (subtag)
	  		{
	  			case SUBTAG_FLOAT:
	  			  if (Local_VAR_Float [symbol_index].local) break;
	  			  
	  			  if (LocalVar_current_offset&1) LocalVar_current_offset++;
	  			  Local_VAR_Float [symbol_index].local = TRUE;
	  			  Local_VAR_Float [symbol_index].offset = LocalVar_current_offset;
	  			  LocalVar_current_offset += sizeof (float);
	  			break;
	  			
	  			case SUBTAG_INT:
	  				if (Local_VAR_Int [symbol_index].local) break;
	  				
	  				if (LocalVar_current_offset&1) LocalVar_current_offset++;
	  			  Local_VAR_Int [symbol_index].local = TRUE;
	  			  Local_VAR_Int [symbol_index].offset = LocalVar_current_offset;
	  			  LocalVar_current_offset += sizeof (long);
	  			break;
	  			
	  			case SUBTAG_BOOL:
	  			  if (Local_VAR_Bool [symbol_index].local) break;
	  			  
	  			  Local_VAR_Bool [symbol_index].local = TRUE;
	  			  Local_VAR_Bool [symbol_index].offset = LocalVar_current_offset;
	  			  LocalVar_current_offset += sizeof (char);
	  			break;
	  			
	  			case SUBTAG_STRING:
	  				if (Local_VAR_String [symbol_index].local) break;
	  				
	  			  Local_VAR_String [symbol_index].local = TRUE;
	  			  Local_VAR_String [symbol_index].offset = LocalVar_current_string_offset;
	  			  LocalVar_current_string_offset += sizeof (unsigned short)+sizeof (unsigned long);
	  			break;
	  		}
	  	}
	  }
	  
	  //Force  se terminer sur une offset paire
	  if (LocalVar_current_offset&1) LocalVar_current_offset++;
	  
	  //Force la pile  ne contenir que Local
	  //TStackExpr_Ptr = 1;
	}
	
	return TRUE; 
}


//*************************************
//Vrification pile
//*************************************
BOOL ExprMake_CheckStack (void)
{
	int j;
	BOOL find;
	unsigned short cEndTag;
	
	//Vrification pour instruction DATA
	if (TStackExpr [TStackExpr_Ptr-1]->token_type==TOKEN_COMMAND && TStackExpr [TStackExpr_Ptr-1]->token_index==TOKEN_DATA)
	{
		for (int i=0; i<TStackExpr_Ptr-1; i++)
		{
			//Erreur de donnes
			if (TStackExpr [i]->tag!=TAG_NUMBER && TStackExpr [i]->tag!=TAG_STRING)
			  {error_code = ERROR_TYPE_INCOMPATIBLE; return FALSE;} 
		}
	}
	
	//Vrification pour instruction READ
	else if (TStackExpr [TStackExpr_Ptr-1]->token_type==TOKEN_COMMAND && TStackExpr [TStackExpr_Ptr-1]->token_index==TOKEN_READ)
	{
		for (int i=0; i<TStackExpr_Ptr-1; i++)
		{
			//Tableau
			if (TStackExpr [i]->type==TYPE_ENDTAG)
			{
				//Recherche Vartable, cas contraire = echec
				find = FALSE;
				cEndTag = 0;
				for (j=i+1; j<TStackExpr_Ptr-1; j++)
				{
					//Compte le nombre de EndTag
					if (TStackExpr [j]->type==TYPE_ENDTAG) cEndTag++;
					//Si fonction
					else if (TStackExpr [j]->type==TYPE_FUNC) cEndTag--;
					//Si tableau
					else if (TStackExpr [j]->tag==TAG_VARTABLE) 
					{
						//Fin du tableau
						if (!cEndTag) {
							find = TRUE;
							break;}
						
						cEndTag--;
					}
				}
				
				//Recherche choue
				if (find==FALSE)
				  {error_code = ERROR_TYPE_INCOMPATIBLE; return FALSE;}
				
				//Variable suivante
				i = j+1;  
			}
			//Erreur de type
			else if (TStackExpr [i]->tag!=TAG_VAR)
			  {error_code = ERROR_TYPE_INCOMPATIBLE; return FALSE;}
		}
	}
	
	return TRUE;
}
