// C Source File
// Created 15/08/2004; 17:11:07

#include "Header.h"

/*#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Tokens.h"
#include "..\Tables\Tbl_Lst.h"
#include "..\System\String.h"
#include "..\System\File.h"
#include "..\System\Error.h"
#include "..\Other\Scanner.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\ExprVar.h"
#include "..\Other\ExprTokens.h"*/


//********************************
//Ecriture fichier GTK
//********************************
BOOL ExprTokens_MakeFile (unsigned char *file_name)
{
	unsigned short offset_data = TokensFile_size+iData_TokensFile_size;
	
	FILE *file = fopen (file_name, "wb");
	if (!file) {error_code = ERROR_CREATEFILE; return FALSE;}
	
	FileHeader_GTK header;	//En-tte
	
	memcpy (header.file_id, "GFA_GTK", 7);
	header.version = 1;
	header.tokens_size = TokensFile_size;
	header.number_data = iData_Number;
	header.offset_data = (offset_data&0x01)?(offset_data+1):offset_data;
	header.nfloat = nVAR_Float;
	header.ninteger = nVAR_Int;
	header.nbool = nVAR_Bool;
	header.nstring = nVAR_String;
	header.ntblfloat = nVAR_TFloat;
	header.ntblinteger = nVAR_TInt;
	header.ntblbool = nVAR_TBool;
	header.ntblstring = nVAR_TString;
	memcpy (header.section_tk, "TK", 2);
	
	//Ecriture de la table
	fwrite (&header, sizeof (FileHeader_GTK), 1, file);
	
  //Tokens d'executions
	fwrite (TokensFile_buffer, TokensFile_size, 1, file);
	
	//Typage structure DATA
	fwrite (iData_TokensFile_buffer, iData_TokensFile_size, 1, file);
	
	//Donnes DATA
	//Force a tre sur une adresse paire
	if (offset_data&0x01)
	  fputc (0x00, file);
	
	//Ecriture du buffer
	fwrite (Data_TokensFile_buffer, Data_TokensFile_size, 1, file);
		
	//Fin du fichier (format GTK)
	fputc (0x00, file);
	fputs ("GTK", file);
	fputc (0x00, file);
	fputc (OTH_TAG, file);
	fclose (file);
	
	return TRUE;
}


//********************************
//Gestion de l'instruction DATA
//********************************
BOOL ExprTokens_MakeDataBuffer (void)
{
	unsigned char tag, subtag, data_type;
	unsigned long lnum;
	BOOL flag_noerror = TRUE;				//Oprations russies
	
	//Sauvegarde le buffer de tokens
	Sav_TokensFile_buffer = TokensFile_buffer;
	Sav_TokensFile_size = TokensFile_size;
	Sav_TokensFile_nbloc = TokensFile_nbloc;
	
	//BUFFER TYPAGE
	//-------------
	TokensFile_buffer = iData_TokensFile_buffer;
	TokensFile_size = iData_TokensFile_size;
	TokensFile_nbloc = iData_TokensFile_nbloc;
	
	//Parcours les donnes
	for (int i=0; i<TStackExpr_Ptr-1; i++)
	{
		tag = TStackExpr [i]->tag; subtag = TStackExpr [i]->subtag; 
		
		//Donnes incorrectes
		if (tag!=TAG_NUMBER && tag!=TAG_STRING)	{
			flag_noerror = FALSE;
			error_code = ERROR_TYPE_INCOMPATIBLE;
			break;}
		
		//Type de la donne
		data_type = DATA_UNKNOWN;
		if (tag==TAG_STRING) data_type = DATA_STRING;
		else if (subtag==SUBTAG_FLOAT) data_type = DATA_FLOAT;
		else if (subtag==SUBTAG_INT)
			data_type = (((unsigned long)TStackExpr [i]->lnum)<=0xFFFFUL)?DATA_INTEGER16:DATA_INTEGER32;
		
		//Ecriture typage
		//Donne MSB (xxxx0000)
		if (!(iData_Number++&0x01))
			ExprTokens_Add2 (NULL, data_type<<4, 1);
		//Donne LSB (0000xxxx)
		else
			TokensFile_buffer [TokensFile_size-1] = (TokensFile_buffer [TokensFile_size-1]&0xF0)|data_type;
	}
	
	//Sauvegarde infos iData
	if (flag_noerror)
	{
	  iData_TokensFile_buffer = TokensFile_buffer;
	  iData_TokensFile_size = TokensFile_size;
	  iData_TokensFile_nbloc = TokensFile_nbloc;
	}
	
	
	//BUFFER DE DONNEES
	//-----------------
	TokensFile_buffer = Data_TokensFile_buffer;
	TokensFile_size = Data_TokensFile_size;
	TokensFile_nbloc = Data_TokensFile_nbloc;
	
	//Parcours les donnes
	for (int i=0; i<TStackExpr_Ptr-1; i++)
	{
		tag = TStackExpr [i]->tag; subtag = TStackExpr [i]->subtag; 
		
		//Flottant
		if (/*tag==TAG_NUMBER && */subtag==SUBTAG_FLOAT)
			ExprTokens_Add2 (&TStackExpr [i]->fnum, 0, sizeof (float));
		//Chane de caractres
		else if (tag==TAG_STRING)
		{
			ExprTokens_Add2 (NULL, ETOKEN_NONE, 1);	//Alignement
			ExprTokens_Add2 (NULL, TStackExpr [i]->string.size, 1);	//Taille de la chane
			ExprTokens_Add2 (TStackExpr [i]->string.data, 0, TStackExpr [i]->string.size);	//Adresse de la chane
			ExprTokens_Add2 (NULL, 0, 1);	//Octet NULL
			if (TokensFile_size&0x01) ExprTokens_Add2 (NULL, ETOKEN_NONE, 1);	//Alignement
		}
		//Entier
		else
		{
			if ((lnum = TStackExpr [i]->lnum)<=0xFFFFUL) {
				lnum <<= 16;
		    ExprTokens_Add2 (&lnum, 0, sizeof(short));}
		  else
		    ExprTokens_Add2 (&lnum, 0, sizeof(long));
		}
	}
	
	//Sauvegarde infos Data
	if (flag_noerror)
	{
	  Data_TokensFile_buffer = TokensFile_buffer;
	  Data_TokensFile_size = TokensFile_size;
	  Data_TokensFile_nbloc = TokensFile_nbloc;
	}
	
	//Sauvegarde le buffer de tokens
	TokensFile_buffer = Sav_TokensFile_buffer;
	TokensFile_size = Sav_TokensFile_size;
	TokensFile_nbloc = Sav_TokensFile_nbloc;
	
	return flag_noerror;
}


//********************************
//Cration du buffer d'execution
//********************************
BOOL ExprTokens_MakeBuffer (void)
{
	unsigned char type, tag, subtag, token_type, token_index, symbol_index;
	//BOOL EOFLine = FALSE;
	
	//Structure DATA
	if (TStackExpr_Ptr && TStackExpr [TStackExpr_Ptr-1]->token_type==TOKEN_COMMAND && TStackExpr [TStackExpr_Ptr-1]->token_index==TOKEN_DATA)
	  return ExprTokens_MakeDataBuffer ();
	
	//Parcours la pile
	for (int i=0; i<TStackExpr_Ptr; i++)
	{
		type = TStackExpr [i]->type; tag = TStackExpr [i]->tag; subtag = TStackExpr [i]->subtag; 
		token_type = TStackExpr [i]->token_type; token_index = TStackExpr [i]->token_index;
		symbol_index = TStackExpr [i]->symbol_index;
		
		//ENDTAG
		if (type==TYPE_ENDTAG) ExprTokens_Add (NULL, ETOKEN_ENDTAG, 1);
		//Nombre
		else if (tag==TAG_NUMBER)
		{
			if (!(TokensFile_size&1)) ExprTokens_Add (NULL, ETOKEN_NONE, 1);	//Alignement
			ExprTokens_Add (NULL, (subtag==SUBTAG_FLOAT)?ETOKEN_NUMBER_FLOAT:ETOKEN_NUMBER_INT, 1);	//Token
			
			//Float
			if (subtag==SUBTAG_FLOAT)	ExprTokens_Add (&TStackExpr [i]->fnum, 0, sizeof (float));
			//Entier
			else ExprTokens_Add (&TStackExpr [i]->lnum, 0, sizeof (long));
		}
		//Chane de caractre
		else if (tag==TAG_STRING)
		{
			if (TokensFile_size&1) ExprTokens_Add (NULL, ETOKEN_NONE, 1);	//Alignement
			ExprTokens_Add (NULL, ETOKEN_STRING, 1);	//Token
			ExprTokens_Add (NULL, TStackExpr [i]->string.size, 1);	//Taille de la chane
			ExprTokens_Add (TStackExpr [i]->string.data, 0, TStackExpr [i]->string.size);	//Adresse de la chane
			ExprTokens_Add (NULL, 0, 1);	//Octet NULL
		}
		//Constantes
		else if (tag==TAG_CONSTANT)
		{
			ExprTokens_Add (NULL, ETOKEN_CONSTANT, 1);	//Token
			ExprTokens_Add (NULL, token_index, 1);	//Index
		}
		//Variable
		else if (tag==TAG_VAR)
		{
			s_LocalVar *ptr_local_var = NULL;
			
			switch (subtag)
	  	{
	  	  case SUBTAG_FLOAT:
	  	    ptr_local_var = &Local_VAR_Float [symbol_index];
	  		break;
	  			
	  		case SUBTAG_INT:
	  		  ptr_local_var = &Local_VAR_Int [symbol_index];
	  		break;
	  			
	  		case SUBTAG_BOOL:
	  		  ptr_local_var = &Local_VAR_Bool [symbol_index];
	  		break;
	  			
	  		case SUBTAG_STRING:
	  		  ptr_local_var = &Local_VAR_String [symbol_index];
	  		break;
	  	}
			
			//Variable locale?
			if (ptr_local_var->local)
			{
				unsigned short offset = ptr_local_var->offset;
				ExprTokens_Add (NULL, ETOKEN_LOCAL_VAR, 1);						//Token
				ExprTokens_Add (NULL, (subtag<<4)|((offset&0x00FFFFFF)>>8), 1); //Type + Dbut offset sur 12 Bits
				ExprTokens_Add (NULL, offset&0xFF, 1);								//Fin offset
			}
			//Variable publique
			else
			{
			  ExprTokens_Add (NULL, ETOKEN_VAR_FLOAT+(subtag-1), 1);	//Token
			  ExprTokens_Add (NULL, symbol_index, 1);	//Index
			}
		}
		//Tableaux
		else if (tag==TAG_VARTABLE)
		{
			ExprTokens_Add (NULL, ETOKEN_VAR_TFLOAT+(subtag-1), 1);	//Token
			ExprTokens_Add (NULL, symbol_index, 1);	//Index
		}
		//Label
		else if (tag==TAG_LABEL) 
		{
			TblLabelJump [symbol_index].address = TokensFile_size;	//Adresse du label
			TblLabelJump [symbol_index].data_number = iData_Number;	//Dernire donne
			TblLabelJump [symbol_index].data_ptr = Data_TokensFile_size; //Pointe sur la dernire donne
			TblLabelJump [symbol_index].isInLoop = (ExprTokens_FindStruct (STRUCT_FOR))?TRUE:FALSE;
			TblLabelJump [symbol_index].ProcedureOffset = isInProcedure?ProcedureOffset:0;
		}
		//Goto
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_GOTO)
		{		
			//Goto dans Loop?
			if (ExprTokens_FindStruct (STRUCT_FOR))
			  {error_code = ERROR_INCORRECT_GOTO; return FALSE;}
			
			//Token
			ExprTokens_Add (NULL, ETOKEN_JUMP, 1);
			
			//Adresse connue
			if (TblLabelJump [symbol_index].address) 
			{
			  //Label dans Loop ou hors procdure?
			  if ((TblLabelJump [symbol_index].isInLoop) 
			   || (TblLabelJump [symbol_index].ProcedureOffset!=(isInProcedure?ProcedureOffset:0))) {
			  	error_code = ERROR_INCORRECT_GOTO; return FALSE;}
			  
			  ExprTokens_Add (&TblLabelJump [symbol_index].address, 0, 2); //Adresse du label
			}
			else
			{
				//Evite Goto hors procdure
				TblGotoJump [nTblGotoJump].ProcedureOffset = isInProcedure?ProcedureOffset:0;
				
				//Prparation du saut
				TblGotoJump [nTblGotoJump].lbl_index = symbol_index;
				TblGotoJump [nTblGotoJump++].token_address = TokensFile_size;
				
				//Adresse
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			}
		}
		//Restore
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_RESTORE)
		{
			if (!(TokensFile_size&1)) ExprTokens_Add (NULL, ETOKEN_NONE, 1);	//Alignement
			ExprTokens_Add (NULL, ETOKEN_FUNC_RESTORE, 1);	//Token
			
			//Restore seul
			if (symbol_index==0xFF) 
			{
			  //Numro de la donne
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				
				//Adresse de la donne
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			}
			//Label connu
			else if (TblLabelJump [symbol_index].address)
			{
			  ExprTokens_Add (&TblLabelJump [symbol_index].data_number, 0, 2); //Numro de la donne
			  ExprTokens_Add (&TblLabelJump [symbol_index].data_ptr, 0, 2); //Adresse de la donne
			}
			else
			{
				if (nTblRestoreJump>=MAX_RESTORE) {error_code = ERROR_RESTORE_OVERFLOW; return FALSE;}
				TblRestoreJump [nTblRestoreJump].lbl_index = symbol_index;
				TblRestoreJump [nTblRestoreJump++].token_address = TokensFile_size;
				
				//Numro de la donne
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				
				//Adresse de la donne
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			}
		}
		//If
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_IF)
		{
			if (n_IF_Jump>=MAX_IF) {error_code = ERROR_IF_OVERFLOW; return FALSE;}
			if (!ExprTokens_NewStruct (STRUCT_IF)) return FALSE; //Ajoute structure
			
			ExprTokens_Add (NULL, ETOKEN_IF, 1);	//Token
			
			//Token_address
			Tbl_IF_Jump [n_IF_Jump].nElseIf = 0;
			Tbl_IF_Jump [n_IF_Jump].branch_else = FALSE;
			Tbl_IF_Jump [n_IF_Jump++].token_address = TokensFile_size;
			
			//Adresse
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
		}
		//Elseif
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_ELSEIF)
		{
			if (!n_IF_Jump || Tbl_IF_Jump [n_IF_Jump-1].branch_else || !nTblStruct || TblStruct [nTblStruct-1]!=STRUCT_IF) 
				{error_code = ERROR_ELSEIF; return FALSE;}
			
			//Jump
			//====
			if (i!=TStackExpr_Ptr-1)
			{	
				if (TotalElseIf>=MAX_ELSEIF) {error_code = ERROR_ELSEIF_OVERFLOW; return FALSE;}
				
				//Ecriture de Jump
				ExprTokens_Add (NULL, ETOKEN_JUMP, 1);	//Token
				
				//Branchement aprs Jump
				ExprTokens_MakeAddress (TokensFile_buffer+Tbl_IF_Jump [n_IF_Jump-1].token_address, TokensFile_size+2);
				Tbl_IF_Jump [n_IF_Jump-1].nElseIf++;
				Tbl_ElseIf_Address [TotalElseIf++] = TokensFile_size;
				
				//Adresse
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				
				//Rinitialisation des piles d'execution
				//ExprTokens_Add (NULL, ETOKEN_CLEAR, 1);
			}
			//Condition
			else
			{
				ExprTokens_Add (NULL, ETOKEN_IF, 1);	//Token
			
				//Token_address
				Tbl_IF_Jump [n_IF_Jump-1].token_address = TokensFile_size;
			
				//Adresse
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			}
		}
		//Else
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_ELSE)
		{
			if (!n_IF_Jump || Tbl_IF_Jump [n_IF_Jump-1].branch_else || !nTblStruct || TblStruct [nTblStruct-1]!=STRUCT_IF) 
				{error_code = ERROR_ELSE; return FALSE;}
			
			//Ecriture de Jump
			ExprTokens_Add (NULL, ETOKEN_JUMP, 1);	//Token
			
			//Branchement aprs Jump
			ExprTokens_MakeAddress (TokensFile_buffer+Tbl_IF_Jump [n_IF_Jump-1].token_address, TokensFile_size+2);
			Tbl_IF_Jump [n_IF_Jump-1].branch_else = TRUE;
			Tbl_IF_Jump [n_IF_Jump-1].token_address = TokensFile_size;
			
			//Adresse
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
		}
		//Endif
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_ENDIF)
		{
			if (!n_IF_Jump || !nTblStruct || TblStruct [nTblStruct-1]!=STRUCT_IF) 
				{error_code = ERROR_ENDIF; return FALSE;}
			
			unsigned char nElseif = Tbl_IF_Jump [n_IF_Jump-1].nElseIf;
			for (unsigned short i=TotalElseIf-nElseif; i<TotalElseIf; i++) {
				ExprTokens_MakeAddress (TokensFile_buffer+Tbl_ElseIf_Address [i], TokensFile_size);}
			ExprTokens_MakeAddress (TokensFile_buffer+Tbl_IF_Jump [n_IF_Jump-1].token_address, TokensFile_size);
			n_IF_Jump--;
			TotalElseIf -= nElseif;
			
			//Efface structure
			ExprTokens_DelStruct (0);
		}
		//Do
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_DO)
		{
			if (TotalDo>=MAX_DO) {error_code = ERROR_DO_OVERFLOW; return FALSE;}
			if (!ExprTokens_NewStruct (STRUCT_DO)) return FALSE; //Ajoute structure
			
			ExprTokens_MakeContinueAddress (TokensFile_size);
			Tbl_Do_Address [TotalDo++] = TokensFile_size;
		}
		//Loop
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_LOOP)
		{
			if (!TotalDo || !nTblStruct || TblStruct [nTblStruct-1]!=STRUCT_DO) 
				{error_code = ERROR_LOOP; return FALSE;}
			
			//Ecriture de Jump
			ExprTokens_Add (NULL, ETOKEN_JUMP, 1);	//Token
			
			//Adresse
			ExprTokens_Add (&Tbl_Do_Address [--TotalDo], 0, sizeof (unsigned short));
			
			//Efface structure
			ExprTokens_DelStruct (TokensFile_size); 
		}
		//Repeat
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_REPEAT)
		{
			if (TotalRepeat>=MAX_REPEAT) {error_code = ERROR_REPEAT_OVERFLOW; return FALSE;}
			if (!ExprTokens_NewStruct (STRUCT_REPEAT)) return FALSE; //Ajoute structure
			
			ExprTokens_MakeContinueAddress (TokensFile_size);
			Tbl_Repeat_Address [TotalRepeat++] = TokensFile_size;
		}
		//Until
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_UNTIL)
		{
			if (!TotalRepeat || !nTblStruct || TblStruct [nTblStruct-1]!=STRUCT_REPEAT) 
				{error_code = ERROR_UNTIL; return FALSE;}
				
			//Ecriture de If
			ExprTokens_Add (NULL, ETOKEN_IF, 1);	//Token
			
			//Adresse
			ExprTokens_Add (&Tbl_Repeat_Address [--TotalRepeat], 0, sizeof (unsigned short));
			
			//Efface structure
			ExprTokens_DelStruct (TokensFile_size);	
		}
		//While
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_WHILE)
		{
			//While Jump
			if (i!=TStackExpr_Ptr-1)
			{
				if (TotalWhile>=MAX_WHILE) {error_code = ERROR_WHILE_OVERFLOW; return FALSE;}
				if (!ExprTokens_NewStruct (STRUCT_WHILE)) return FALSE; //Ajoute structure
				
				ExprTokens_MakeContinueAddress (TokensFile_size);
				Tbl_While_Address_Jump [TotalWhile] = TokensFile_size;
			}
			//While If
			else
			{	
				//Ecriture de If
				ExprTokens_Add (NULL, ETOKEN_IF, 1);	//Token
				
				Tbl_While_Address_If [TotalWhile++] = TokensFile_size;
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			}
		}
		//Wend
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_WEND)
		{
			if (!TotalWhile || !nTblStruct || TblStruct [nTblStruct-1]!=STRUCT_WHILE) 
				{error_code = ERROR_WEND; return FALSE;}
			
			//Saut pour dbut de While
			ExprTokens_Add (NULL, ETOKEN_JUMP, 1);	//Token
			ExprTokens_Add (&Tbl_While_Address_Jump [--TotalWhile], 0, sizeof (unsigned short));	//Adresse
			
			//Saut pour la condition
			ExprTokens_MakeAddress (TokensFile_buffer+Tbl_While_Address_If [TotalWhile], TokensFile_size);
				
			//Efface structure
			ExprTokens_DelStruct (TokensFile_size);
		}
		//For
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_FOR)
		{
			if (TotalFor>=MAX_FOR) {error_code = ERROR_FOR_OVERFLOW; return FALSE;}
			if (!ExprTokens_NewStruct (STRUCT_FOR)) return FALSE; //Ajoute structure
			
			//Informations de la variables
			Tbl_FOR_Jump [TotalFor].var_subtag = TStackExpr [0]->subtag;
			Tbl_FOR_Jump [TotalFor].var_number = TStackExpr [0]->symbol_index;
			
			//Token de sauvegarde variable
			ExprTokens_Add (NULL, ETOKEN_FORs, 1);
		}
		//To
		else if (token_type==TOKEN_FUNCTION && token_index==TOKEN_TO)
		{						
			//Token For, marque sauvegarde nombre de comparaison
			ExprTokens_Add (NULL, ETOKEN_FORc, 1);
			
			//To seule?
			if (symbol_index!=TOKEN_STEP)
			{
			  ExprTokens_Add (NULL, ETOKEN_FORe, 1);				//Fin de la boucle For
			  ExprTokens_Add (NULL, ETOKEN_FORe_add1, 1);		//Boucle For avec To seule donc ajoute 1  chaque fois!
			  
			  //Condition du For
			  ExprTokens_Add (NULL, ETOKEN_FOR_if, 1);				//Premire condition du For
			
				//Adresse pour saut fin condition If
				Tbl_FOR_Jump [TotalFor].token_address_if = TokensFile_size;
			
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			  
			  //Adresse de dbut des instructions
				Tbl_FOR_Jump [TotalFor++].token_address_data = TokensFile_size;
			}
		}
		//DownTo
		else if (token_type==TOKEN_FUNCTION && token_index==TOKEN_DOWNTO)
		{
			//Token For, marque sauvegarde nombre de comparaison
			ExprTokens_Add (NULL, ETOKEN_FORc, 1);
			
			//Condition du For
			ExprTokens_Add (NULL, ETOKEN_FORe, 1);				//Fin de la boucle For
			ExprTokens_Add (NULL, ETOKEN_FORe_sub1, 1);		//Boucle For avec To seule donc soustrait 1  chaque fois!
			
			ExprTokens_Add (NULL, ETOKEN_FOR_if, 1);				//Premire condition du For
			
			//Adresse pour saut fin condition If
			Tbl_FOR_Jump [TotalFor].token_address_if = TokensFile_size;
			
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			
			//Adresse de dbut des instructions
			Tbl_FOR_Jump [TotalFor++].token_address_data = TokensFile_size;
		}
		//Step
		else if (token_type==TOKEN_FUNCTION && token_index==TOKEN_STEP)
		{
			ExprTokens_Add (NULL, ETOKEN_FORe, 1);				//Fin de la boucle For
			ExprTokens_Add (NULL, ETOKEN_FORe_addi, 1);		//Boucle For avec Step
			
			//Condition du For
			ExprTokens_Add (NULL, ETOKEN_FOR_if, 1);				//Premire condition du For
			
			//Adresse pour saut fin condition If
			Tbl_FOR_Jump [TotalFor].token_address_if = TokensFile_size;
			
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			
			//Adresse de dbut des instructions
			Tbl_FOR_Jump [TotalFor++].token_address_data = TokensFile_size;
		}
		//Next
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_NEXT)
		{
			//Structure for inexistante
			if (!TotalFor || !nTblStruct || TblStruct [nTblStruct-1]!=STRUCT_FOR
			//Next incorrect seulement dans le cas de Next var
			 || (TStackExpr_Ptr==2 && !(Tbl_FOR_Jump [TotalFor-1].var_subtag==TStackExpr [1]->subtag && Tbl_FOR_Jump [TotalFor-1].var_number==TStackExpr [1]->symbol_index))) 
				{error_code = ERROR_NEXT; return FALSE;}
			
			ExprTokens_MakeContinueAddress (TokensFile_size);
			
			ExprTokens_Add (NULL, ETOKEN_FOR_add, 1);				//Fin de la boucle For
			ExprTokens_Add (&Tbl_FOR_Jump [--TotalFor].token_address_data, 0, sizeof (unsigned short));	//Adresse
			
			//Saut pour fin condition For
			ExprTokens_MakeAddress (TokensFile_buffer+Tbl_FOR_Jump [TotalFor].token_address_if, TokensFile_size);
			
			//Efface structure
			ExprTokens_DelStruct (TokensFile_size);
			
			//Vide la pile For
			ExprTokens_Add (NULL, ETOKEN_FOR_clear, 1);
				
			i++; //Evite de tokeniser la variable
		}
		//Exit If
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_EXIT)
		{
			if (!nTblStructExitIf) {error_code = ERROR_EXITIF; return FALSE;}
			if (TotalExitIf>=MAX_EXITIF) {error_code = ERROR_EXITIF_OVERFLOW; return FALSE;}
			
			//Exit seule
			if (TStackExpr_Ptr==1) ExprTokens_Add (NULL, ETOKEN_JUMP, 1);	//Token
			//Exit If
			else ExprTokens_Add (NULL, ETOKEN_IFJUMP, 1);	//Token			
			
			nTblExitIf [nTblStructExitIf-1]++;
			TblExitIf [TotalExitIf++] = TokensFile_size;
			
			//Adresse
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
		}
		//Continue
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_CONTINUE)
		{
			if (!nTblStructContinue) {error_code = ERROR_CONTINUE; return FALSE;}
			if (TotalContinue>=MAX_CONTINUE) {error_code = ERROR_CONTINUE_OVERFLOW; return FALSE;}
			
			ExprTokens_Add (NULL, ETOKEN_JUMP, 1); //Token
			
			nTblContinue [nTblStructContinue-1]++;
			TblContinue [TotalContinue++] = TokensFile_size;
			
			//Adresse
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
		}
		
		
		//Gestion des PROCEDUREs et variables LOCALES.
		//Local
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_LOCAL)
		{
			/*ExprTokens_Add (NULL, ETOKEN_INIT_LOCAL_VAR, 1); //Token
			ExprTokens_Add (&LocalVar_current_offset, 0, 2); 	//Variables locales offsets*/
			
			//Local  l'extrieure d'une procdure
			if (!isInProcedure)
			  {error_code = ERROR_LOCAL_OUT_PROCEDURE; return FALSE;}
			//Local dans une boucle
			else if (nTblStruct)
			  {error_code = ERROR_LOCAL_IN_LOOP; return FALSE;}
			
			//Fin tokenisation
			i = TStackExpr_Ptr;
		}
		//Procedure
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_PROCEDURE) 
		{
			//Marquage fin de programme principal
			if (!FirstProcedure) {
				FirstProcedure = TRUE;
				ExprTokens_Add (NULL, ETOKEN_FUNC_END, 1);} //Token
			
			//Procedure dans structure ou dans procdure?
			if (isInProcedure || nTblStruct) {error_code = ERROR_PROCEDURE_IN_LOOP; return FALSE;}
			
			TblProcedureJump [symbol_index] = TokensFile_size;	//Adresse du label
			
			//Offset de dbut procdure
			ProcedureOffset = TokensFile_size; 
			
			//Offsets variables locales
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			
			//Offsets variables locales type string
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			
			//Nombre de variables
			ExprTokens_Add (NULL, TStackExpr_Ptr-1, 1);
			
			//Codage typage
			BOOL MakeByte = FALSE;
			unsigned char BType = 0x00;
			unsigned char var_subtag;
			for (int j=1; j<TStackExpr_Ptr; j++)
			{
				var_subtag = TStackExpr [j]->subtag;
				
				//MSB
				if (!MakeByte) 
				{
					MakeByte = TRUE;
					BType = var_subtag<<4;
				}
				//LSB
				else
				{
					MakeByte = FALSE;
					BType |= var_subtag&0x0F;
					ExprTokens_Add (NULL, BType, 1);
					BType = 0x00;
				}
			}
			
			if (MakeByte) 
			  ExprTokens_Add (NULL, BType, 1);
			
			isInProcedure = TRUE;
			
			//Fin tokenisation
			i = TStackExpr_Ptr;
		}
		//Return
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_RETURN)
		{
		  //Return sans procdure ou dans structure?
			if (!isInProcedure || nTblStruct) {error_code = ERROR_RETURN; return FALSE;}
			
			//Ecriture offsets variables locales pour procdure
			ExprTokens_MakeAddress (TokensFile_buffer+ProcedureOffset, LocalVar_current_offset);
			ExprTokens_MakeAddress (TokensFile_buffer+ProcedureOffset+2, LocalVar_current_string_offset);
			
			ExprTokens_Add (NULL, ETOKEN_RETURN, 1);		//Token
			ExprTokens_Add (&LocalVar_current_offset, 0, 2); 	//Variables locales offsets
			ExprTokens_Add (&LocalVar_current_string_offset, 0, 2); 	//Variables locales offsets type string
			
			//Efface variables locales
			isInProcedure = FALSE;
			memset (Local_VAR_Float, 0x00, MAX_LOCAL_VAR*sizeof (s_LocalVar));
			memset (Local_VAR_Int, 0x00, MAX_LOCAL_VAR*sizeof (s_LocalVar));
			memset (Local_VAR_Bool, 0x00, MAX_LOCAL_VAR*sizeof (s_LocalVar));
			memset (Local_VAR_String, 0x00, MAX_LOCAL_VAR*sizeof (s_LocalVar));
			LocalVar_current_offset = LocalVar_current_string_offset = 0;
		} 
		//Gosub
		else if (token_type==TOKEN_COMMAND && token_index==TOKEN_GOSUB)
		{
			ExprTokens_Add (NULL, ETOKEN_GOSUB, 1);	//Token
			
			//Adresse connue
			if (TblProcedureJump [symbol_index]) 
			  ExprTokens_Add (&TblProcedureJump [symbol_index], 0, 2); //Adresse de la procdure
			else
			{
				if (nTblGosubJump>=MAX_GOSUB) {error_code = ERROR_GOSUB_OVERFLOW; return FALSE;}
				TblGosubJump [nTblGosubJump].lbl_index = symbol_index;
				TblGosubJump [nTblGosubJump++].token_address = TokensFile_size;
				
				//Adresse
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
				ExprTokens_Add (NULL, ETOKEN_NONE, 1);
			}
		}
		
		//Autre
		else if (tag==TAG_POINT_VIRGULE) ExprTokens_Add (NULL, ETOKEN_POINT_VIRGULE, 1);
		else if (tag==TAG_APOST) ExprTokens_Add (NULL, ETOKEN_APOST, 1);
		//Fonctions
		else ExprTokens_Add (NULL, (token_type==TOKEN_COMMAND)?GFA_TableExecToken_Command [token_index]:GFA_TableExecToken_Function [token_index], 1);
		
		//Optimisation, terminer par numro de ligne (Token gale ou tokens de commandes)
		if ((token_type==TOKEN_FUNCTION && token_index==TOKEN_FUNC_AFFEC) || (token_index!=TOKEN_EOFLINE && token_type==TOKEN_COMMAND && 
		(GFA_TableExecToken_Command [token_index]!=ETOKEN_NONE && token_index!=TOKEN_END && token_index!=TOKEN_RUN)))
		{
			ExprTokens_Add (NULL, error_line>>8, 1);
			ExprTokens_Add (NULL, error_line, 1);
			/*EOFLine = TRUE;
			break;*/
		}
	}
	
	//N'crit pas une ligne vierge ou une ligne de commentaire
	/*if (TStackExpr_Ptr && !EOFLine)
	{
		ExprTokens_Add (NULL, ETOKEN_EOFLINE, 1);
		ExprTokens_Add (NULL, error_line>>8, 1);
		ExprTokens_Add (NULL, error_line, 1);
	}*/
	
	return TRUE;
}


//***************************************
//Attribution des adresses pour les GOTOS
//***************************************
BOOL ExprTokens_MakeGotoJump (void)
{
	unsigned short address, token_address;
	
	//Parcours sauts  effectuer
	for (unsigned short i=0; i<nTblGotoJump; i++)
	{
		//Label dans Loop ou Goto hors procedure?
		if ((TblLabelJump [TblGotoJump [i].lbl_index].isInLoop) 
		 || (TblLabelJump [TblGotoJump [i].lbl_index].ProcedureOffset!=TblGotoJump [i].ProcedureOffset)) {
		  error_code = ERROR_INCORRECT_GOTO; return FALSE;}
		
		token_address = TblGotoJump [i].token_address;
		address = TblLabelJump [TblGotoJump [i].lbl_index].address;
		
		ExprTokens_MakeAddress (TokensFile_buffer+token_address, address);
	}
	
	return TRUE;
}


//******************************************
//Attribution des adresses pour les RESTOREs
//******************************************
void ExprTokens_MakeRestoreJump (void)
{
  unsigned short data_number, data_ptr, token_address;
	
	//Parcours sauts  effectuer
	for (unsigned short i=0; i<nTblRestoreJump; i++)
	{
		token_address = TblRestoreJump [i].token_address;
		data_number = TblLabelJump [TblRestoreJump [i].lbl_index].data_number;
		data_ptr = TblLabelJump [TblRestoreJump [i].lbl_index].data_ptr;
		
		ExprTokens_MakeAddress (TokensFile_buffer+token_address, data_number);
		ExprTokens_MakeAddress (TokensFile_buffer+token_address+sizeof (unsigned short), data_ptr);
	}
}


//******************************************
//Attribution des adresses pour les GOSUBs
//******************************************
void ExprTokens_MakeGosubJump (void)
{
  unsigned short address, token_address;
	
	//Parcours sauts  effectuer
	for (unsigned short i=0; i<nTblGosubJump; i++)
	{
		token_address = TblGosubJump [i].token_address;
		address = TblProcedureJump [TblGosubJump [i].lbl_index];
		
		ExprTokens_MakeAddress (TokensFile_buffer+token_address, address);
	}
}

//********************************************
//Vrifie si il ne manque pas un Endif...
//********************************************
BOOL ExprTokens_CheckStruct (void)
{
	if (n_IF_Jump) {error_code = ERROR_IF; return FALSE;}
	if (TotalDo) {error_code = ERROR_DO; return FALSE;}
	if (TotalRepeat) {error_code = ERROR_REPEAT; return FALSE;}
	if (TotalWhile) {error_code = ERROR_WHILE; return FALSE;}
	if (TotalFor) {error_code = ERROR_FOR; return FALSE;}
	
	if (isInProcedure) {error_code = ERROR_PROCEDURE; return FALSE;}
	return TRUE;
}

//**********************************************************
//Ajoute une structure
//**********************************************************
BOOL ExprTokens_NewStruct (unsigned char x)
{
	if (nTblStruct>=MAX_STRUCT) {error_code = ERROR_STRUCT_OVERFLOW; return FALSE;}
	
	TblStruct [nTblStruct++] = x; 
	if (x!=STRUCT_IF) 
	{
		if (nTblStructExitIf>=MAX_EXITIF) {error_code = ERROR_EXITIF_OVERFLOW; return FALSE;}
		nTblExitIf [nTblStructExitIf++] = 0;
		
		if (nTblStructContinue>=MAX_CONTINUE) {error_code = ERROR_CONTINUE_OVERFLOW; return FALSE;}
		nTblContinue [nTblStructContinue++] = 0;
	}
		
	return TRUE;
}

//**********************************************************
//Efface structure
//**********************************************************
void ExprTokens_DelStruct (unsigned short address)
{
	if (TblStruct [--nTblStruct]==STRUCT_IF) return;
	unsigned char nExitIf = nTblExitIf [nTblStructExitIf-1];
	unsigned char nContinue = nTblContinue [nTblStructContinue-1];
	
	//Exit	
	for (int i=1; i<=nExitIf; i++) {
		ExprTokens_MakeAddress (TokensFile_buffer+TblExitIf [TotalExitIf-i], address);}
	
	TotalExitIf -= nTblExitIf [--nTblStructExitIf];
	
	//Continue
	unsigned short continue_address = TblStructContinue_address [nTblStructContinue-1];
	for (int i=1; i<=nContinue; i++) {
		ExprTokens_MakeAddress (TokensFile_buffer+TblContinue [TotalContinue-i], continue_address);}
	
	TotalContinue -= nTblContinue [--nTblStructContinue];
}


//**********************************************************
//Recherche structure
//**********************************************************
BOOL ExprTokens_FindStruct (unsigned char fstruct)
{
	//Recherche Goto dans boucle For
	for (int i=nTblStruct-1; i>=0; i--) {
		if (TblStruct [i]==fstruct)
		  return TRUE;}
		  
	return FALSE;
}
