// C Source File
// Created 16/08/2004; 13:10:58

#include "Header.h"

/*#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Tokens.h"
#include "..\Tables\Tbl_Lst.h"
#include "..\System\String.h"
#include "..\System\File.h"
#include "..\System\Error.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\ExprVar.h"*/

EXTERN void *VarMemory;
EXTERN void **VAR_Float;
EXTERN void **VAR_Int;
EXTERN void **VAR_Bool;
EXTERN void **VAR_String;
EXTERN s_TblVar *VAR_TFloat;
EXTERN s_TblVar *VAR_TInt;
EXTERN s_TblVar *VAR_TBool;
EXTERN s_TblVar *VAR_TString;

EXTERN s_LocalVar *Local_VAR_Float;
EXTERN s_LocalVar *Local_VAR_Int;
EXTERN s_LocalVar *Local_VAR_Bool;
EXTERN s_LocalVar *Local_VAR_String;
EXTERN unsigned short LocalVar_current_offset;
EXTERN unsigned short LocalVar_current_string_offset;
//EXTERN unsigned short LocalVar_start_offset;

EXTERN BOOL isInProcedure;
EXTERN BOOL FirstProcedure;
EXTERN unsigned short ProcedureOffset;
EXTERN unsigned short *TblProcedureJump;
EXTERN s_GotoJump *TblGosubJump;
EXTERN unsigned short nTblGosubJump;

EXTERN s_LabelJump *TblLabelJump;
EXTERN s_GotoJump *TblGotoJump;
EXTERN unsigned short nTblGotoJump;

EXTERN s_GotoJump *TblRestoreJump;
EXTERN unsigned short nTblRestoreJump;

EXTERN unsigned char *TblStruct;
EXTERN unsigned short nTblStruct;
EXTERN unsigned short nTblStructExitIf;
EXTERN unsigned char *nTblExitIf;
EXTERN unsigned short *TblExitIf;
EXTERN unsigned short TotalExitIf;

EXTERN unsigned short nTblStructContinue;
EXTERN unsigned char *nTblContinue;
EXTERN unsigned short *TblContinue;
EXTERN unsigned short TotalContinue;
EXTERN unsigned short *TblStructContinue_address;

EXTERN s_IFJump *Tbl_IF_Jump;
EXTERN unsigned short n_IF_Jump;
EXTERN unsigned short *Tbl_ElseIf_Address;
EXTERN unsigned short TotalElseIf;
EXTERN unsigned short *Tbl_Do_Address;
EXTERN unsigned short TotalDo;
EXTERN unsigned short *Tbl_Repeat_Address;
EXTERN unsigned short TotalRepeat;
EXTERN unsigned short *Tbl_While_Address_If;
EXTERN unsigned short *Tbl_While_Address_Jump;
EXTERN unsigned short TotalWhile;
EXTERN s_FORJump *Tbl_FOR_Jump;
EXTERN unsigned short TotalFor;

//*******************************************
//Allocation mmoire pour les variables
//*******************************************
/*BOOL ExprVar_Allocate (void)
{
	unsigned short StartFloat = 0;
	unsigned short StartInt = StartFloat + (nVAR_Float*sizeof (float));
	unsigned short StartBool = StartInt + (nVAR_Int*sizeof (long));
	unsigned short StartString = StartBool + (nVAR_Bool*sizeof (char))+(nVAR_Bool&1);
	unsigned short VarMemory_size = (nVAR_Float*sizeof (float))+(nVAR_Int*sizeof (long))+(nVAR_Bool*sizeof(char))+(nVAR_Bool&1)+(nVAR_String*(sizeof (HANDLE)+sizeof (unsigned short)));
	HANDLE handle_tmp;

	VAR_Float = NULL; VAR_Int = NULL; VAR_Bool = NULL; VAR_String = NULL;
	VarMemory = NULL;
	
	if (!(VAR_Float = calloc (nVAR_Float+nVAR_Int+nVAR_Bool+nVAR_String, sizeof (void *)))) return FALSE;
	VAR_Int = VAR_Float+nVAR_Float;
	VAR_Bool = VAR_Float+nVAR_Float+nVAR_Int;
	VAR_String = VAR_Float+nVAR_Float+nVAR_Int+nVAR_Bool;
	
	//Cration de la zone de variables
	if (!(VarMemory = malloc (VarMemory_size))) return FALSE;
	memset (VarMemory, 0x00, VarMemory_size);
	
	//Attribution des adresses
	for (unsigned short i=0; i<nVAR_Float; i++)
		VAR_Float [i] = (void *)(VarMemory+StartFloat+(i*sizeof (float)));
	for (unsigned short i=0; i<nVAR_Int; i++)
		VAR_Int [i] = (void *)(VarMemory+StartInt+(i*sizeof (long)));
	for (unsigned short i=0; i<nVAR_Bool; i++)
		VAR_Bool [i] = (void *)(VarMemory+StartBool+(i*sizeof (char)));
	
	for (unsigned short i=0; i<nVAR_String; i++) 
	{
		if ((handle_tmp = HeapAlloc (6))==H_NULL) return FALSE;
		*(unsigned char *)(HeapDeref (handle_tmp)) = 0;
		*(HANDLE *)(VarMemory+StartString+(i*(sizeof (HANDLE)+sizeof (unsigned short)))) = handle_tmp;
		VAR_String [i] = (void *)(VarMemory+StartString+(i*(sizeof (HANDLE)+sizeof (unsigned short))));
	}
	
	//Allocation des variables type tableaux
	unsigned short total_table = nVAR_TFloat+nVAR_TInt+nVAR_TBool+nVAR_TString;
	VAR_TFloat = VAR_TInt = VAR_TBool = VAR_TString = NULL;
	
	if (!(VAR_TFloat = calloc (total_table, sizeof (s_TblVar)))) return FALSE;
	VAR_TInt = VAR_TFloat+nVAR_TFloat;
	VAR_TBool = VAR_TFloat+nVAR_TFloat+nVAR_TInt;
	VAR_TString = VAR_TFloat+nVAR_TFloat+nVAR_TInt+nVAR_TBool;
	memset (VAR_TFloat, 0x00, total_table*sizeof (s_TblVar));
			
	return TRUE;
}

//*******************************************
//Efface allocations
//*******************************************
void ExprVar_Unallocate (void)
{
	if (VAR_Float)
	{
		//VAR_String
		for (unsigned short i=0; i<nVAR_String; i++) {
			if (*(HANDLE *)(VAR_String [i])!=H_NULL) HeapFree (*(HANDLE *)(VAR_String [i]));}
			
		if (VarMemory) free (VarMemory);
		free (VAR_Float);
	}
	
	//Efface allocations, variables type tableaux
	unsigned short total_bloc = 1;
	if (VAR_TFloat)
	{
		//Float
		for (unsigned short i=0; i<nVAR_TFloat; i++) {
			if (VAR_TFloat [i].adr) free (VAR_TFloat [i].adr);
			if (VAR_TFloat [i].TblDim) free (VAR_TFloat [i].TblDim);}
			
		//Int
		for (unsigned short i=0; i<nVAR_TInt; i++) {
			if (VAR_TInt [i].adr) free (VAR_TInt [i].adr);
			if (VAR_TInt [i].TblDim) free (VAR_TInt [i].TblDim);}
			
		//Bool
		for (unsigned short i=0; i<nVAR_TBool; i++) {
			if (VAR_TBool [i].adr) free (VAR_TBool [i].adr);
			if (VAR_TBool [i].TblDim) free (VAR_TBool [i].TblDim);}
		
		//String
		for (unsigned short i=0; i<nVAR_TString; i++) 
		{
			if (VAR_TString [i].ndim)
			{
				total_bloc = 1;
				//Compte le nombre de chanes
				for (unsigned short j=0; j<VAR_TString [i].ndim; j++)
					total_bloc *= VAR_TString [i].TblDim [j];
			
				//Parcours chanes pour effacer handle
				for (unsigned short j=0; j<total_bloc; j++) {
					if (*(HANDLE *)(VAR_TString [i].adr+(j*(sizeof (HANDLE)+sizeof (unsigned short))))) HeapFree (*(HANDLE *)(VAR_TString [i].adr+(j*(sizeof (HANDLE)+sizeof (unsigned short)))));}
			}
		
			if (VAR_TString [i].adr) free (VAR_TString [i].adr);
			if (VAR_TString [i].TblDim) free (VAR_TString [i].TblDim);
		}
		
		free (VAR_TFloat);
	}
}*/


//***************************************
//Initialise les tables des structures
//***************************************
void ExprVar_InitTables (void) 
{
  LocalVar_current_offset = LocalVar_current_string_offset = 0;
  //LocalVar_start_offset;
  nTblGotoJump = nTblGosubJump = nTblRestoreJump = nTblStruct = nTblStructExitIf = TotalExitIf = nTblStructContinue = TotalContinue = n_IF_Jump = TotalElseIf = TotalDo = TotalRepeat = TotalWhile = TotalFor = 0;
}

//*********************************************************
//Allocation tables d'analyses
//*********************************************************
BOOL ExprVar_AllocateTables (void)
{
	Local_VAR_Float = Local_VAR_Int = Local_VAR_Bool = Local_VAR_String = NULL;
	
	isInProcedure = FALSE;
	FirstProcedure = FALSE;
	
  TblProcedureJump = NULL;
	TblGosubJump = NULL;
	
	TblLabelJump = NULL;
	TblGotoJump = NULL;
	TblRestoreJump = NULL;
	Tbl_IF_Jump = NULL;
	Tbl_ElseIf_Address = NULL;
	Tbl_Do_Address = NULL;
	Tbl_Repeat_Address = NULL;
	Tbl_While_Address_If = NULL;
	Tbl_While_Address_Jump = NULL;
	Tbl_FOR_Jump = NULL;
	
	TblStruct = NULL;
	nTblExitIf = NULL;
	TblExitIf = NULL;
	nTblContinue = NULL;
	TblContinue = NULL;
	TblStructContinue_address = NULL;
	
	//Variables locales
	if (!(Local_VAR_Float = calloc (MAX_LOCAL_VAR, sizeof (s_LocalVar)))) return FALSE;
	if (!(Local_VAR_Int = calloc (MAX_LOCAL_VAR, sizeof (s_LocalVar)))) return FALSE;
	if (!(Local_VAR_Bool = calloc (MAX_LOCAL_VAR, sizeof (s_LocalVar)))) return FALSE;
	if (!(Local_VAR_String = calloc (MAX_LOCAL_VAR, sizeof (s_LocalVar)))) return FALSE;
	
	//Efface structures
	memset (Local_VAR_Float, 0x00, MAX_LOCAL_VAR*sizeof (s_LocalVar));
	memset (Local_VAR_Int, 0x00, MAX_LOCAL_VAR*sizeof (s_LocalVar));
	memset (Local_VAR_Bool, 0x00, MAX_LOCAL_VAR*sizeof (s_LocalVar));
	memset (Local_VAR_String, 0x00, MAX_LOCAL_VAR*sizeof (s_LocalVar));
	
	//Procdures
	if (!(TblProcedureJump = calloc (MAX_PROCEDURE, sizeof (unsigned short)))) return FALSE;
	memset (TblProcedureJump, 0x00, MAX_PROCEDURE*sizeof (unsigned short));
	
	//Gosubs
	if (!(TblGosubJump = calloc (MAX_GOSUB, sizeof (s_GotoJump)))) return FALSE;
	
	
	//Labels
	if (!(TblLabelJump = calloc (MAX_LABEL, sizeof (s_LabelJump)))) return FALSE;
	memset (TblLabelJump, 0x00, MAX_LABEL*sizeof (s_LabelJump));
	
	//Gotos
	if (!(TblGotoJump = calloc (MAX_GOTO, sizeof (s_GotoJump)))) return FALSE;
	
	//Restore
	if (!(TblRestoreJump = calloc (MAX_RESTORE, sizeof (s_GotoJump)))) return FALSE;
	
	//Liste des structures
	if (!(TblStruct = calloc (MAX_STRUCT, sizeof (unsigned char)))) return FALSE;
	
	if (!(nTblExitIf = calloc (MAX_EXITIF, sizeof (unsigned char)))) return FALSE;
	if (!(TblExitIf = calloc (MAX_EXITIF, sizeof (unsigned short)))) return FALSE;
	
	if (!(nTblContinue = calloc (MAX_CONTINUE, sizeof (unsigned char)))) return FALSE;
	if (!(TblContinue = calloc (MAX_CONTINUE, sizeof (unsigned short)))) return FALSE;
	if (!(TblStructContinue_address = calloc (MAX_CONTINUE, sizeof (unsigned short)))) return FALSE;
	
	//IFs
	if (!(Tbl_IF_Jump = calloc (MAX_IF, sizeof (s_IFJump)))) return FALSE;
	
	//ElseIf
	if (!(Tbl_ElseIf_Address = calloc (MAX_ELSEIF, sizeof (unsigned short)))) return FALSE;
	
	//Do...Loop
	if (!(Tbl_Do_Address = calloc (MAX_DO, sizeof (unsigned short)))) return FALSE;
	
	//Repeat...Until
	if (!(Tbl_Repeat_Address = calloc (MAX_REPEAT, sizeof (unsigned short)))) return FALSE;
	
	//While...Wend
	if (!(Tbl_While_Address_If = calloc (MAX_WHILE, sizeof (unsigned short)))) return FALSE;
	if (!(Tbl_While_Address_Jump = calloc (MAX_WHILE, sizeof (unsigned short)))) return FALSE;
	
	//For.To. ...Next.
	if (!(Tbl_FOR_Jump = calloc (MAX_FOR, sizeof (s_FORJump)))) return FALSE;
	
	return TRUE;
}


//*********************************************************
//Efface allcoations tables
//*********************************************************
void ExprVar_UnallocateTables (void)
{
	if (Local_VAR_Float) free (Local_VAR_Float);
	if (Local_VAR_Int) free (Local_VAR_Int);
	if (Local_VAR_Bool) free (Local_VAR_Bool);
	if (Local_VAR_String) free (Local_VAR_String);
	
	if (TblProcedureJump) free (TblProcedureJump);
	if (TblGosubJump) free (TblGosubJump);
	
	if (TblLabelJump) free (TblLabelJump);
	if (TblGotoJump) free (TblGotoJump);
	if (TblRestoreJump) free (TblRestoreJump);
	if (TblStruct) free (TblStruct);
	
	if (nTblExitIf) free (nTblExitIf);
	if (TblExitIf) free (TblExitIf);
	
	if (nTblContinue) free (nTblContinue);
	if (TblContinue) free (TblContinue);
	if (TblStructContinue_address) free (TblStructContinue_address);
	
	if (Tbl_IF_Jump) free (Tbl_IF_Jump);
	if (Tbl_ElseIf_Address) free (Tbl_ElseIf_Address);
	
	if (Tbl_Do_Address) free (Tbl_Do_Address);
	if (Tbl_Repeat_Address) free (Tbl_Repeat_Address);
	if (Tbl_While_Address_If) free (Tbl_While_Address_If);
	if (Tbl_While_Address_Jump) free (Tbl_While_Address_Jump);
	
	if (Tbl_FOR_Jump) free (Tbl_FOR_Jump);
}
