// C Source File
// Created 10/08/2004; 15:00:06

#include "Header.h"

/*#include <tigcclib.h>
#include "..\Structs.h"
#include "..\System\File.h"*/

EXTERN unsigned char GFAFile_name [9];
EXTERN lstring GFAFile;
EXTERN SYM_ENTRY *entry_GFAFile;
EXTERN HANDLE h_GFAFile;
EXTERN unsigned char GFAFile_type;

EXTERN void *FileTOKENS;
EXTERN SYM_ENTRY *entry_fileTOKENS;
EXTERN HANDLE HANDLE_entry_fileTOKENS;

EXTERN unsigned short *GFA_TableToken_Command;
EXTERN unsigned short *GFA_TableToken_Function;
EXTERN unsigned short *GFA_TableToken_Constant;

/*----------------------------------------------------------
Crer un nom du tios  partir d'une chane de caractres en C
Retourne le pointeur de fin du nom du fichier
-----------------------------------------------------------*/
char *File_GenerateTIOSName (const char *cname, char *buffer) 
{
	buffer[0] = 0;
  return (strcpy(buffer + 1, cname) + strlen(cname));
}


/*-----------------------------------------------------
Renvoie un SYM_ENTRY  partir d'une chane de caractre
-------------------------------------------------------*/
SYM_ENTRY *File_GetSymByName (const char *name) 
{
	char buf[50];
  HSym hs;

  if (*name) hs = SymFind(File_GenerateTIOSName(name,buf));  /* cname    */
  else       hs = SymFind(name);                        /* tiosname */

  if (!hs.folder) return NULL;
  else            return DerefSym(hs);
}

//Trouve un fichier et renvoie son chemin complet
char *File_Find (char file[8])
{
	SYM_ENTRY *entry;
	static unsigned char buffer_out [17];
	char *folder;
	size_t len;
	
	//Parcours dossiers
	entry=SymFindFirst (NULL, FO_RECURSE);
	while (entry)
	{	
		//Fichier trouv!
		if (!strcmp (file, entry->name))
		{		
			folder=SymFindFolderName ();
			len=strlen (folder);
			
			memset (buffer_out, 0, 17);
			memcpy (buffer_out, folder, len);
			buffer_out [len++]='\\';
			strcat (buffer_out, entry->name);
							
			return buffer_out;
		}
		entry=SymFindNext ();
	}
	
	return NULL;
}

//*******************************
//Ouvrir un fichier  interprter
//*******************************
BOOL File_Open (const char *file)
{
	void *ptr;
	
	entry_GFAFile = File_GetSymByName (file);
	if (entry_GFAFile==NULL) return FALSE;
	
	h_GFAFile = HeapLock (entry_GFAFile->handle);
	ptr = HeapDeref (h_GFAFile); 
	
	GFAFile.data = (char *)(ptr+2); 
	GFAFile.size = *(unsigned short *)(ptr)-2;
	
	if (!strncmp ("GFABasic", GFAFile.data, 8)) GFAFile_type = FILE_TOKENIZED;
	else
	{
		GFAFile_type = FILE_TEXT;
		GFAFile.data += 3; //+3 octets format TEXT
		GFAFile.size -= 3;
	}
	
	return TRUE;
}


//******************************
//Ferme le fichier  interprter
//******************************
void File_Close (void)
{
	HeapUnlock (h_GFAFile);
}


//*******************************
//Ouvre fichiers de donnes
//*******************************
BOOL File_OpenDatas (void)
{
	HANDLE_entry_fileTOKENS = H_NULL;
	entry_fileTOKENS = File_GetSymByName (File_Find ("gfa_tfcs"));
	if (entry_fileTOKENS==NULL) {
		ST_helpMsg ("Error: gfa_tfcs no found.");
		return FALSE;}
	HANDLE_entry_fileTOKENS = HeapLock (entry_fileTOKENS->handle);
	FileTOKENS = HeapDeref (HANDLE_entry_fileTOKENS)+2;
	
	if (memcmp ("GFABasic", FileTOKENS, 8)) {
		ST_helpMsg ("Error: gfa_tfcs incorrect.");
		return FALSE;}
		
	if (*(unsigned char *)(FileTOKENS+8)!=VERSION_FILE_TOKENS) {
		ST_helpMsg ("Error: Incorrect version of gfa_tfcs.");
		return FALSE;}
	
	FileTOKENS += 10;
	GFA_TableToken_Command = FileTOKENS;
	GFA_TableToken_Function = FileTOKENS+(sizeof (unsigned short)<<8);
	GFA_TableToken_Constant = FileTOKENS+(sizeof (unsigned short)<<9);
	
	return TRUE;
}


//********************************
//Ferme fichiers de donnes
//********************************
void File_CloseDatas (void)
{
	//Unlock Handles
	if (HANDLE_entry_fileTOKENS) HeapUnlock (HANDLE_entry_fileTOKENS);
}
