// C Source File
// Created 10/08/2004; 15:05:49

#include "Header.h"

/*#include <tigcclib.h>
#include "..\System\Interrupt.h"*/

INT_HANDLER OldInt1 = NULL;
INT_HANDLER OldInt2 = NULL;
INT_HANDLER OldInt5 = NULL;
EXTERN volatile long counter_time;
EXTERN volatile unsigned short __COUNTER_HARDWARE = 0;
EXTERN volatile unsigned short __COUNTER_TIMER = 0;

//***************************
//Interruption n2 dsactive
//***************************
DEFINE_INT_HANDLER (interrupt2) {pokeIO (0x60001B,0);}

//**********************
//Auto int n1
//**********************
DEFINE_INT_HANDLER (interrupt1)
{
  //HARDWARE VERSION 1.0 
	if (HW_VERSION==1)
	{
		//Incrmentation
		__COUNTER_HARDWARE += __HARDWARE_FREQUENCY;
		
		//Execution interrupotion
		if (__COUNTER_HARDWARE>32768)
		{
			//Remise  zro
			__COUNTER_HARDWARE -= 32768;
			
			//Execute interruption
			SET_INT1 ();
		}
		return;
	}
	
	//HARDWARE VERSION 2.0
	SET_INT1 ();
}



//**********************
//Init interruption 1
//**********************
void Interrupt_Init (void)
{
	OldInt1 = GetIntVec (AUTO_INT_1);
	OldInt2 = GetIntVec (AUTO_INT_2);
	OldInt5 = GetIntVec (AUTO_INT_5);
  SetIntVec (AUTO_INT_1, interrupt1);
  SetIntVec (AUTO_INT_2, interrupt2);
  SetIntVec (AUTO_INT_5, DUMMY_HANDLER);
  
  __COUNTER_HARDWARE = 0;
  __COUNTER_TIMER = 0;
  counter_time = 0;
}


//***********************
//Uninit interriuption 1
//***********************
void Interrupt_Uninit (void) 
{
	SetIntVec (AUTO_INT_1, OldInt1);
	SetIntVec (AUTO_INT_2, OldInt2);
	SetIntVec (AUTO_INT_5, OldInt5);
}

//*********************
//Interruption  200 Hz
//*********************
void SET_INT1 (void)
{
	//Incrmentation
	__COUNTER_TIMER += __TIMER_FREQUENCY;
		
	//Execution interrupotion
	if (__COUNTER_TIMER>32768)
	{
		//Remise  zro
		__COUNTER_TIMER -= 32768;
		
		//Execute interruption
		EXEC_INT1 ();
	}
	return;
}


//********************
//Interruption n1
//********************
void EXEC_INT1 (void)
{
	counter_time++;
}