// C Source File
// Created 10/08/2004; 15:05:13

#include "Header.h"

/*#include <tigcclib.h>

#include "Structs.h"
#include "Error.h"
#include "Scanner.h"
#include "Tokenisor.h"
#include "Memory.h"*/

//Effectue allocations
BOOL Memory_Allocate (void)
{
	BOOL flag = TRUE;
	
	if (!Memory_Scanner_Allocate ()) flag = FALSE; 

	if (!Memory_Tokenisor_AllocateSymbols ()) flag = FALSE;
	if (!Memory_Tokenisor_AllocateBuffer ()) flag = FALSE;
	
	return flag;
}

//Efface allocations
void Memory_Unallocate (void)
{
	Memory_Scanner_Unallocate ();
	
	Memory_Tokenisor_UnallocateSymbols ();
	Memory_Tokenisor_UnallocateBuffer ();
}


//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
//Scanner.h
//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
//*******************************************
//Allocation pour le scanner
//*******************************************
BOOL Memory_Scanner_Allocate (void)
{
	StackExpr = NULL;
	StackExpr_Ptr = 0; 
	if ((StackExpr = calloc (MAX_TAG_STACK, sizeof (s_tag)))==NULL) return FALSE;
	
	return TRUE;
}

//*******************************************
//Efface allocation
//*******************************************
void Memory_Scanner_Unallocate (void)
{
	if (StackExpr) free (StackExpr);
}


//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
//Tokenisor.h
//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
//********************************************
//Allocation mmoire pour tables des symboles
//********************************************
BOOL Memory_Tokenisor_AllocateSymbols (void)
{
	TSym_float = TSym_integer = TSym_bool = TSym_string = NULL;
	TSym_tblfloat = TSym_tblinteger = TSym_tblbool = TSym_tblstring = NULL;
	TSym_label = NULL;
	TSym_procedure = NULL;
	
	nTSym_float = nTSym_integer = nTSym_bool = nTSym_string = 0;
	nTSym_tblfloat = nTSym_tblinteger = nTSym_tblbool = nTSym_tblstring = 0;
	nTSym_label = 0;
	nTSym_procedure = 0;
	
	//Symboles des variables
	if (!(TSym_float = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	if (!(TSym_integer = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	if (!(TSym_bool = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	if (!(TSym_string = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	
	//Symboles des variables type tableau
	if (!(TSym_tblfloat = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	if (!(TSym_tblinteger = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	if (!(TSym_tblbool = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	if (!(TSym_tblstring = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	
	//Symboles des labels
	if (!(TSym_label = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	
	//Symboles des procdures
	if (!(TSym_procedure = calloc (MAX_SYMBOL, sizeof (lstring)))) return FALSE;
	return TRUE;
}


//**************************************************
//Efface allocations des symboles
//**************************************************
void Memory_Tokenisor_UnallocateSymbols (void)
{
	//Symboles des variables
	if (TSym_float) free (TSym_float);
	if (TSym_integer) free (TSym_integer);
	if (TSym_bool) free (TSym_bool);
	if (TSym_string) free (TSym_string);
	
	//Symboles des variables type tableau
	if (TSym_tblfloat) free (TSym_tblfloat);
	if (TSym_tblinteger) free (TSym_tblinteger);
	if (TSym_tblbool) free (TSym_tblbool);
	if (TSym_tblstring) free (TSym_tblstring);
	
	//Symboles des labels
	if (TSym_label) free (TSym_label);
	
	//Symboles des procdures
	if (TSym_procedure) free (TSym_procedure);
}


//***************************************************
//Allocation du buffer de tokens
//***************************************************
BOOL Memory_Tokenisor_AllocateBuffer (void)
{
	TokensFile_buffer = Data_TokensFile_buffer = iData_TokensFile_buffer = NULL;
	TokensFile_size = Data_TokensFile_size = iData_TokensFile_size = 0;
	TokensFile_nbloc = Data_TokensFile_nbloc = iData_TokensFile_nbloc = 1;
	iData_Number = 0;
		
	if (!(TokensFile_buffer = malloc (MAX_PAGE_TOKENSFILE))) return FALSE;
	if (!(Data_TokensFile_buffer = malloc (MAX_PAGE_TOKENSFILE))) return FALSE;
	if (!(iData_TokensFile_buffer = malloc (MAX_PAGE_TOKENSFILE))) return FALSE;
	return TRUE;
}


//****************************************************
//Efface allocation du buffet tokens
//****************************************************
void Memory_Tokenisor_UnallocateBuffer (void)
{
	if (TokensFile_buffer) free (TokensFile_buffer);
	if (Data_TokensFile_buffer) free (Data_TokensFile_buffer);
	if (iData_TokensFile_buffer) free (iData_TokensFile_buffer);
}