// C Source File
// Created 10/08/2004; 15:51:11

#include "Header.h"

/*#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Lst.h"
#include "..\System\String.h"
#include "..\System\File.h"
#include "..\System\Error.h"
#include "..\Other\ExprFind.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\Scanner.h"*/

EXTERN s_tag *StackExpr;
EXTERN s_tag *OperatorStack [MAX_OPERATOR_STACK];
EXTERN s_tag *TStackExpr [MAX_TAG_STACK];

EXTERN unsigned char StackExpr_Ptr, TStackExpr_Ptr, OperatorStack_Ptr;

//************************************************************
//Lecture du fichier avec tokenisation et rgles grammaticales
//************************************************************
BOOL Scanner_ReadFile (lstring file)
{
	BOOL CharRead = FALSE;
	unsigned char *ptr = file.data;
	unsigned short size = file.size;
	unsigned short line_size = 0;
	
	StackExpr_Ptr = 0; //Vide la pile
	s_tag tag;
	Scanner_NextTag (&tag, ptr);
	
	error_line = 1;
	error_ptr = size;
	
	//Parcours fichier
	while (size-- && error_code==ERROR_NOERROR)
	{
		CharRead = FALSE;
		
		//Commentaire
		if ((StackExpr_Ptr==1 && StackExpr [0].token_type==TOKEN_COMMAND && (StackExpr [0].token_index==TOKEN_CMD_COMMENT1 || StackExpr [0].token_index==TOKEN_CMD_COMMENT2))
		 || (StackExpr_Ptr && StackExpr [StackExpr_Ptr-1].token_type==TOKEN_FUNCTION && StackExpr [StackExpr_Ptr-1].token_index==TOKEN_FUNC_COMMENT3))
		{
			while (size && *ptr!=13) {tag.string.size++; line_size++; ptr++; size--;}
			if (!size) tag.string.size++;
			Scanner_AddTag (tag.string.data, tag.string.size, TYPE_COMMENT, TAG_NONE);
			Scanner_NextTag (&tag, ptr);
		}
		
		//Symbol
		else if ((*ptr>='A' && *ptr<='Z') 
		 || (*ptr>='a' && *ptr<='z') 
		 || (*ptr>='0' && *ptr<='9') 
		 || *ptr=='.' 
		 || *ptr==0x95 		//E puissance
		 || *ptr==0xA8		//Racine carre
		 || *ptr==0x96		//Exponentielle
		 || *ptr=='&'			//Conversion
		 || *ptr=='%'
		 || *ptr=='!'
		 || *ptr=='$'
		 || *ptr=='?'
		 || *ptr=='_')
		{
			//Ajoute signe de comparaison
			if (tag.string.size && tag.tag==TAG_COMPARE) 
			{
				Scanner_AddTag (tag.string.data, tag.string.size, TYPE_SIGN, TAG_COMPARE);
				Scanner_NextTag (&tag, ptr);
			}
			
			//Commentaire
			if (*ptr=='!' && !tag.string.size)
			{
				Scanner_AddTag (tag.string.data, 1, TYPE_SIGN, TAG_NONE);
				Scanner_NextTag (&tag, ptr+1);
			}
			//Conversion (binaire, hexadcimal ou octale)
			else if (*ptr=='&' && tag.string.size) {error_code = ERROR_SYNTAX; break;}
			//Fonction exponentielle sous la forme e^(
			else if ((*ptr==0x96 && tag.string.size==0) && *(ptr+1)=='^' && *(ptr+2)=='(')
			{
				//Ajoute la fonction exponentielle
				Scanner_AddTag (ptr, 2, TYPE_SYMBOL, TAG_NONE);
											
				//TAG suivant
				Scanner_NextTag (&tag, ptr+2);
				ptr++;
				line_size++;
				size--;
				CharRead = TRUE;
			}
			//Fonction exponentielle seule (e)
			else if (*ptr==0x96)
			{
				if (tag.string.size) Scanner_AddTag (tag.string.data, tag.string.size, tag.type, tag.tag);
				Scanner_AddTag (ptr, 1, TYPE_SIGN, TAG_NONE);
				Scanner_NextTag (&tag, ptr+1);
			}
			else 
			{
				tag.type = TYPE_SYMBOL;
				tag.string.size++;
			}
			line_size++;
		}
		//Comparaison
		else if (*ptr=='=' || *ptr=='<' || *ptr=='>')
		{
			if (tag.string.size && tag.type==TYPE_SYMBOL) 
			{
				Scanner_AddTag (tag.string.data, tag.string.size, TYPE_SYMBOL, TAG_NONE);
				Scanner_NextTag (&tag, ptr);
			}
			tag.tag = TAG_COMPARE;
			tag.string.size++; line_size++;
		}
		//Chane de caractres
		else if (*ptr==34)
		{
			if (tag.string.size) Scanner_AddTag (tag.string.data, tag.string.size, tag.type, tag.tag);	
			Scanner_NextTag (&tag, ptr+1);
		
			while (*++ptr!=34)
			{
				if (!--size || *ptr==13) {error_code = ERROR_SYNTAX; break;}
				tag.string.size++; line_size++;
			}
			
			if (error_code!=ERROR_NOERROR) break;
			size--;
			Scanner_AddTag (tag.string.data, tag.string.size, TYPE_SYMBOL, TAG_STRING);
			Scanner_NextTag (&tag, ptr+1);
		}
		//Autre caractre
		else if (*ptr!=13)
		{
			unsigned char type = TYPE_SIGN;
			
			//Extension du type numberE-value
			if ((*ptr==0xAD || *ptr=='-') && *(ptr-1)==0x95) 
			{
			  tag.string.size++;
				type = 0x00;
			}	
			
			//Signe ngatif (-)
			if (type && *ptr==0xAD) type = TYPE_NEGATIF;
			
			//Ignore extension avec signe ngatif
			if (type)
			{
				if (tag.string.size) Scanner_AddTag (tag.string.data, tag.string.size, tag.type, tag.tag);
				if (StackExpr_Ptr==1 && *ptr!=32 && StackExpr [0].token_type==TOKEN_COMMAND && StackExpr [0].token_index==TOKEN_CMD_COMMENT1)
			  	{Scanner_NextTag (&tag, ptr); size++; continue;}
			
				if (*ptr!=32) Scanner_AddTag (ptr, 1, type, TAG_NONE);
				Scanner_NextTag (&tag, ptr+1);
			}
			
			line_size++;
		}
		//Fin de ligne
		if ((*ptr==13 || !size) && !CharRead)
		{
			if (tag.string.size) Scanner_AddTag (tag.string.data, tag.string.size, tag.type, tag.tag);
			Scanner_AddTag (ptr, error_line+1, TYPE_EOFLINE, TAG_NONE);
			line_size = 0;
			
			//Recherche de fonctions et variables
			if (!Scanner_FindVarAndFunc ()) return FALSE;
			
			//Ajustement des tags
			if (!Scanner_AdjustTags ()) return FALSE;
			
			//Vrification de la syntaxe
			if (!Scanner_CheckSyntax ()) return FALSE;
			
			//Cration des tokens
			if (!Tokenisor_MakeTokens ()) return FALSE;
			
			if (size && *ptr==13) {ptr++; size--; error_line++; error_ptr = size;}
			StackExpr_Ptr = 0;
			Scanner_NextTag (&tag, ptr+1);
		}
		
		//Ligne trop longue
		if (line_size>MAX_LINE_SIZE) {error_code = ERROR_LINETOOLONG; return FALSE;}
		
		ptr++;
	}
	
	if (error_code!=ERROR_NOERROR) return FALSE;
	return TRUE;
}


//****************************
//Prepare tag suivante
//****************************
void Scanner_NextTag (s_tag *tag, void *ptr)
{
	tag->type = TYPE_NONE;
	tag->tag = TAG_NONE;
	tag->subtag = SUBTAG_NONE;
	
	tag->token_type = TOKEN_NOFOUND;
	tag->token_index = 0x00;
	tag->symbol_index = 0x00;
	tag->string.data = ptr;
	tag->string.size = 0;
}

//*******************************
//Ajoute tag sur la pile
//*******************************
BOOL Scanner_AddTag (void *data, unsigned short size, unsigned char type, unsigned char tag)
{
	//Dpassement de la pile
	if (StackExpr_Ptr==MAX_TAG_STACK) {
		error_code = ERROR_EXPRSTACK_OVERFLOW;
		return FALSE;}

	StackExpr [StackExpr_Ptr].type = type;
	StackExpr [StackExpr_Ptr].tag = tag;
	StackExpr [StackExpr_Ptr].subtag = SUBTAG_NONE;
	
	StackExpr [StackExpr_Ptr].token_type = TOKEN_NOFOUND;
	StackExpr [StackExpr_Ptr].token_index = 0x00;
	StackExpr [StackExpr_Ptr].symbol_index = 0;
	
	StackExpr [StackExpr_Ptr].string.data = data;
	StackExpr [StackExpr_Ptr].string.size = size;
	if (!(Scanner_SetTag (StackExpr_Ptr++))) return FALSE;
	return TRUE;
}


//********************************
//Ajoute en tag en dplace la pile
//********************************
BOOL Scanner_AddPosTag (unsigned char ptr, unsigned char type, unsigned char tag, unsigned char subtag, unsigned char token_type, unsigned char token_index)
{
	//Dpassement de la pile
	if (StackExpr_Ptr==MAX_TAG_STACK) {
		error_code = ERROR_EXPRSTACK_OVERFLOW;
		return FALSE;}
	
	//Dplace la pile
	memmove (&StackExpr [ptr+1], &StackExpr [ptr],(StackExpr_Ptr++-ptr)*sizeof (s_tag));
	
	//Ajoute instruction dans la pile
	StackExpr [ptr].type = type;
	StackExpr [ptr].tag = tag;
	StackExpr [ptr].subtag = subtag;
	
	StackExpr [ptr].token_type = token_type;
	StackExpr [ptr].token_index = token_index;
	StackExpr [ptr].symbol_index = 0;
	
	StackExpr [ptr].string.data = NULL;
	StackExpr [ptr].string.size = 0;
	
	return TRUE;
}

//********************************
//Efface un tag sur la pile
//********************************
void Scanner_DelTag (unsigned char ptr) {memmove (&StackExpr [ptr], &StackExpr [ptr+1],(StackExpr_Ptr---ptr)*sizeof (s_tag));}


//********************************************
//Attribution des tokens et syntaxe dfinitive
//********************************************
BOOL Scanner_SetTag (unsigned char ptr)
{
	BOOL find = FALSE;
	unsigned char token_find;
	unsigned char type = StackExpr [ptr].type;
	unsigned char tag = StackExpr [ptr].tag;
	unsigned char token_index;
	
	char *str = StackExpr [ptr].string.data;
	unsigned short size = StackExpr [ptr].string.size;
	
	//Parcours chane, vite les variables composes seulement de tirets et de points.
	if (type==TYPE_SYMBOL && tag!=TAG_NUMBER && tag!=TAG_STRING)
	{
	  BOOL CheckStr = FALSE;
	  for (unsigned short i=0; i<size; i++)
	  {
		  //Evite les rptitions de variables avec seulement les caractres _ et .
		  if (str [i]!='_' && str[i]!='.' && !(i==size-1 && (str [i]=='%' || str [i]=='!' || str [i]=='$')))
		    CheckStr = TRUE;
		    
		  //Evite les rptitions du caractre . et vite de le voir en dbut ou en fin de variable
		  if ((str [i]=='.' && (!i || i==size-1 || (i && (str [i-1]=='.' || str [i-1]=='_'))))
		   || (str [i]=='_' && (i && str[i-1]=='.')))
		    {CheckStr = FALSE; break;}
	  }
	  if (!CheckStr) 
	    {error_code = ERROR_SYNTAX; return FALSE;}
	}
	
	//Signes de comparaison
	if (tag==TAG_COMPARE) StackExpr [ptr].type = type = TYPE_SIGN;
		
	//Recherche de token
	if ((type==TYPE_SYMBOL && tag==TAG_NONE) || type==TYPE_SIGN || type==TYPE_NEGATIF)
	{		
		if (!ptr) token_find = TOKEN_COMMAND;
		else token_find = TOKEN_FUNCTION;
		if (!Scanner_FindToken (StackExpr [ptr].string.data, StackExpr [ptr].string.size, &find, &StackExpr [ptr].token_index, token_find)) return FALSE;
		
		//Token non trouv
		if (!find)
		{
			if (type==TYPE_SYMBOL) {if (!Scanner_CheckSymbol (ptr)) return FALSE;}
			else {error_code = ERROR_SYNTAX; return FALSE;}
		}
		//Identification des fonctions
		else 
		{
			token_index = StackExpr [ptr].token_index;
			StackExpr [ptr].token_type = token_find;
			
			//Fonction
			if (type==TYPE_SYMBOL) StackExpr [ptr].type = TYPE_FUNC;
			
			//Force l'affichage en majuscules seulement pour les constante
			if (token_find==TOKEN_FUNCTION && (token_index==TOKEN_TRUE || token_index==TOKEN_FALSE || token_index==TOKEN_PI_TXT))
				StrUpper (StackExpr [ptr].string.data, StackExpr [ptr].string.size);
			//Force l'affichage majuscule suivie de minuscules
			else
				ConvertStr (StackExpr [ptr].string.data, StackExpr [ptr].string.size);
			
			//Attribution des types
			if (token_find==TOKEN_FUNCTION && type==TYPE_SIGN)
			{
				//Commentaire
				if (token_index==TOKEN_FUNC_COMMENT3) StackExpr [ptr].type = TYPE_NONE;
				else if (token_index==TOKEN_PARENTH_OPEN) StackExpr [ptr].type = TYPE_PARENTH_OPEN;
				else if (token_index==TOKEN_PARENTH_CLOSE) StackExpr [ptr].type = TYPE_PARENTH_CLOSE;
				else if (token_index==TOKEN_VIRGULE || token_index==TOKEN_POINT_VIRGULE || token_index==TOKEN_APOST) 
				{
					StackExpr [ptr].type = TYPE_VIRGULE;
					//Point virgule
					if (token_index==TOKEN_POINT_VIRGULE) StackExpr [ptr].tag = TAG_POINT_VIRGULE;
					//Apostrophe
					else if (token_index==TOKEN_APOST) StackExpr [ptr].tag = TAG_APOST;
				}
				else if (token_index==TOKEN_PI) 
				{
					StackExpr [ptr].type = TYPE_SYMBOL;
					StackExpr [ptr].tag = TAG_PI;
				}
				else if (token_index==TOKEN_EXP)
				{
					StackExpr [ptr].type = TYPE_SYMBOL;
					StackExpr [ptr].tag = TAG_EXP;
				}
				//Gestion des labels :
				else if (token_index==TOKEN_TWO_POINT) StackExpr [ptr].type = TYPE_TWO_POINT;
				//<=, >= ou <> de la TI
				else if (token_index==TOKEN_INFEGAL || token_index==TOKEN_SUPEGAL || token_index==TOKEN_DIFF) 
					StackExpr [ptr].tag = TAG_COMPARE;
			}
		}
	}
	
	return TRUE;
}


//**********************************************
//Vrification d'un symbol
//**********************************************
BOOL Scanner_CheckSymbol (unsigned char ptr)
{
	unsigned char *string = StackExpr [ptr].string.data;
	unsigned short size = StackExpr [ptr].string.size;
	unsigned char tag = TAG_NONE;
	unsigned char subtag = SUBTAG_NONE;
	unsigned char point = FALSE, exposant = FALSE;
	
	//Dpassement de capacit
	if (size>MAX_EXPR_SIZE) {error_code = ERROR_EXPR_OVERFLOW; return FALSE;}
	
	//Conversion
	if (string [0]=='&')
	{
		if (size>2)
		{
			StackExpr [ptr].tag = TAG_NUMBER;
			if (string [1]=='X' || string [1]=='x') StackExpr [ptr].subtag = SUBTAG_BIN;
			if (string [1]=='O' || string [1]=='o') StackExpr [ptr].subtag = SUBTAG_OCT;
			if (string [1]=='H' || string [1]=='h') StackExpr [ptr].subtag = SUBTAG_HEX;
			StackExpr [ptr].lnum = StrToBase (string, size, TRUE);
			
			//Force l'affichage en majuscules
			StrUpper (StackExpr [ptr].string.data, StackExpr [ptr].string.size);
			
			if (error_code!=ERROR_NOERROR) return FALSE;
			return TRUE;
		}
		else {error_code = ERROR_SYNTAX; return FALSE;}
	}
	
	//Nombre?
	if ((string [0]>='0' && string [0]<='9') || string [0]=='.' || string [0]==0x95) 
		tag = TAG_NUMBER;
		
	//Parcours la chane de caractres
	for (unsigned short i=0; i<size; i++)
	{
		//Nombre
		if (tag==TAG_NUMBER)
		{
			if (string [i]=='.')
			{
				if (point || size<2 || (i && string [i-1]==0x95)) {error_code = ERROR_SYNTAX; return FALSE;}
				point = TRUE; subtag = SUBTAG_FLOAT;
			}
			else if (string [i]==0x95)
			{
				if (exposant || size<2 || (i==size-1) || (i && string [i-1]=='.')) {error_code = ERROR_SYNTAX; return FALSE;}
				point = TRUE; exposant = TRUE;
			}
			else if (string [i]==0xAD || string [i]=='-');
			else if (!(string [i]>='0' && string [i]<='9'))
				{error_code = ERROR_SYNTAX; return FALSE;}
		}
		//Variable ou fonction
		else if (/*string [i]=='.' ||*/ string [i]==0x95
				 || ((string [i]=='%' || string [i]=='!' || string [i]=='$' /*|| string [i]=='?'*/) && (i!=size-1 || size==1))
				 || ((string [i]=='_' || string [i]=='.') && size==1))
					 {error_code = ERROR_SYNTAX; return FALSE;}
	}
	
	//Modification des infos
	StackExpr [ptr].tag = tag;
	
	//Attribution des nombres
	if (tag==TAG_NUMBER)
	{
		/*//Signe ngatif
		if (ptr && StackExpr [ptr-1].type==TYPE_NEGATIF)
		{
			StackExpr [ptr].string.data--; StackExpr [ptr].string.size++;
			Scanner_DelTag (--ptr);
		}*/
		
		if (StackExpr [ptr].string.size>MAX_NUMBER_SIZE)
			{error_code = ERROR_OVERFLOW; return FALSE;}
		
		//Conversion
		memcpy (string_buffer, StackExpr [ptr].string.data, StackExpr [ptr].string.size);
		string_buffer [StackExpr [ptr].string.size] = 0;
		
		float fval = StrToFloat (string_buffer, string_buffer, StackExpr [ptr].string.size);
		long lval = atol (string_buffer);
		
		//Entier  partir d'un flottant
		if (ceil(trunc (fval))==fval && subtag==SUBTAG_NONE)
		{
			StackExpr [ptr].lnum = trunc (fval);
			StackExpr [ptr].subtag = SUBTAG_INT;
		}
		//Entier
		else if (!fcmp (fval, trunc (lval)) && subtag==SUBTAG_NONE) {
			StackExpr [ptr].lnum = lval;
			StackExpr [ptr].subtag = SUBTAG_INT;}
		else {
			StackExpr [ptr].fnum = fval;
			StackExpr [ptr].subtag = SUBTAG_FLOAT;}
	}
	//Force affichage Majuscule suivie de minuscules
	else
	  ConvertStr (StackExpr [ptr].string.data, StackExpr [ptr].string.size);	
	
	return TRUE;
}


//********************************
//Recherche un token
//********************************
BOOL Scanner_FindToken (void *data, unsigned short size, BOOL *find, unsigned char *index, unsigned char token_find)
{
	//Instruction trop grande
	if (size>MAX_EXPR_SIZE) {error_code = ERROR_EXPR_OVERFLOW; return FALSE;}
	
	//Buffer texte
	memcpy (string_buffer, data, size);
	StrUpper (string_buffer, size);
	string_buffer [size] = 0;
	
	//Recherche d'un token
	for (int i=0; i<=0xFF; i++)
	{
		if (!strcmp2 (string_buffer, (token_find==TOKEN_COMMAND)?Get_GFA_TableToken_Command (i):Get_GFA_TableToken_Function (i), size, strlen ((token_find==TOKEN_COMMAND)?Get_GFA_TableToken_Command (i):Get_GFA_TableToken_Function (i))))
		{
			*index = i;
			*find = TRUE;
			return TRUE;
		}
	}
	
	*find = FALSE;
	return TRUE;
}

//********************************
//Recherche une constantes
//********************************
BOOL Scanner_FindConstant (void *data, unsigned short size, BOOL *find, unsigned char *index)
{
	//Instruction trop grande
	if (size>MAX_EXPR_SIZE) {error_code = ERROR_EXPR_OVERFLOW; return FALSE;}
	
	//Buffer texte
	memcpy (string_buffer, data, size);
	StrUpper (string_buffer, size);
	string_buffer [size] = 0;
	
	//Recherche d'un token
	for (int i=0; i<=0xFF; i++)
	{		
		if (!strcmp2 (string_buffer, Get_GFA_TableToken_Constant (i), size, strlen (Get_GFA_TableToken_Constant (i))))
		{
			*index = i;
			*find = TRUE;
			
			return TRUE;
		}
	}
	
	*find = FALSE;
	return TRUE;
}


//***********************************
//Recherche de variables ou fonctions
//***********************************
BOOL Scanner_FindVarAndFunc (void)
{
	BOOL find = FALSE;
	
	//Parcours la pile d'expressions
	for (int i=0; i<StackExpr_Ptr; i++)
	{
		if (StackExpr [i].type==TYPE_SYMBOL && StackExpr [i].tag==TAG_NONE)
		{
			//Label
			if (StackExpr [i+1].type==TYPE_TWO_POINT
			|| (StackExpr [i-1].token_type==TOKEN_COMMAND && (StackExpr [i-1].token_index==TOKEN_GOTO || StackExpr [i-1].token_index==TOKEN_RESTORE))) 
			{
				unsigned char type = 2; //Goto label
				if (StackExpr [i+1].type==TYPE_TWO_POINT) type = 3; //Label:
				if (!ExprFind_FindVar (i, type)) return FALSE;
				StackExpr [i].tag = TAG_LABEL;
			}
			
			//Procedure
			else if (StackExpr [i-1].token_type==TOKEN_COMMAND 
			&& (StackExpr [i-1].token_index==TOKEN_PROCEDURE || StackExpr [i-1].token_index==TOKEN_GOSUB || StackExpr [i-1].token_index==TOKEN_GOSUB2))
			{
				unsigned char type = 5; //Gosub name(...)
				if (StackExpr [i-1].token_index==TOKEN_PROCEDURE) type = 4; //Procedure name(...)
				if (!ExprFind_FindVar (i, type)) return FALSE;
				StackExpr [i].tag = TAG_PROC; 
			}
			
			//Parenthse ouverte (TABLEAUX)
			else if (StackExpr [i+1].type==TYPE_PARENTH_OPEN)
			{
				//Recherche d'un token
				find = FALSE;
				if (i) 
				{
					//Ajoute la parenthse
					memcpy (string_buffer2, StackExpr [i].string.data, StackExpr [i].string.size);
					string_buffer2 [StackExpr [i].string.size] = '(';
					string_buffer2 [StackExpr [i].string.size+1] = 0;
					if (!Scanner_FindToken (string_buffer2, StackExpr [i].string.size+1, &find, &StackExpr [i].token_index, TOKEN_FUNCTION)) return FALSE;
				}
				
				//Token trouv
				if (find)
				{
					StackExpr [i].type = TYPE_FUNC;
					StackExpr [i].token_type = TOKEN_FUNCTION;
					
					//Saute la parenthse
					i++; continue;
				}
				//Tableau
				else if (!ExprFind_FindVar (i, 1)) return FALSE;
			}
			//Pas de parenthse ouverte (VARIABLES)
			else
			{
				//Recherche d'un token
				find = FALSE;
				if (i) {if (!Scanner_FindToken (StackExpr [i].string.data, StackExpr [i].string.size, &find, &StackExpr [i].token_index, TOKEN_FUNCTION)) return FALSE;}
				
				//Token trouv
				if (find)
				{
					StackExpr [i].type = TYPE_FUNC;
					StackExpr [i].token_type = TOKEN_FUNCTION;
					continue;
				}
				//Recherche de constantes
				else if (i)
				{
					find = FALSE;
					if (!Scanner_FindConstant (StackExpr [i].string.data, StackExpr [i].string.size, &find, &StackExpr [i].token_index)) return FALSE;
					if (find)
					{
						StackExpr [i].type = TYPE_CONSTANT;
						StackExpr [i].tag = TAG_CONSTANT;
						StackExpr [i].token_type = TOKEN_NOFOUND;
						StrUpper (StackExpr [i].string.data, StackExpr [i].string.size);
					}
					//Variable simple
					else if (!ExprFind_FindVar (i, 0)) return FALSE;
					continue;
				}
				
				//Variable simple
				if (!ExprFind_FindVar (i, 0)) return FALSE;
			}
		}
	}
	
	return TRUE;
}


//**********************************
//Ajustement des tags
//**********************************
BOOL Scanner_AdjustTags (void)
{
	unsigned char type = StackExpr [0].type;
	unsigned char tag = StackExpr [0].tag;
	unsigned char subtag = StackExpr [0].subtag;
	unsigned char token_index = StackExpr [0].token_index;
	unsigned char preview_type;/*, preview_tag, preview_subtag, preview_token_index;*/
	
	//Type de egal
	BOOL egal_affec = TRUE;
	
	//Egal devient conditon
	//if (token_index==TOKEN_IF || token_index==TOKEN_ELSEIF || token_index==TOKEN_ELSE || token_index==TOKEN_EXIT || token_index==TOKEN_UNTIL || token_index==TOKEN_WHILE) 
	if (!((type==TYPE_SYMBOL && (tag==TAG_VAR || tag==TAG_VARTABLE)) || token_index==TOKEN_FOR)) //Egal autoris seulement dans ses cas
		egal_affec = FALSE;  
	
	//Parcours la pile
	for (int i=1; i<StackExpr_Ptr-1; i++)
	{
		type = StackExpr [i].type;
		tag = StackExpr [i].tag;
		subtag = StackExpr [i].subtag;
		token_index = StackExpr [i].token_index;
		
		preview_type = StackExpr [i-1].type;
		/*preview_tag = StackExpr [i-1].tag;
		preview_subtag = StackExpr [i-1].subtag;
		preview_token_index = StackExpr [i-1].token_index;*/
		
		//Signe de calcul
		if ((type==TYPE_SIGN || type==TYPE_FUNC) && token_index<=TOKEN_FUNC_END_CALC && token_index!=TOKEN_NOT)
		{
			StackExpr [i].type = type = TYPE_SIGN;
			if (tag==TAG_NONE) StackExpr [i].tag = tag = TAG_CALC; 
			StackExpr [i].subtag = subtag = GFA_TableCalc [token_index];
					
			//Signe gal d'affectation
			if (egal_affec && tag==TAG_COMPARE)
			{
				egal_affec = FALSE;
				
				//Applique affectation
				if (subtag==SUBTAG_EGAL)
				{
					StackExpr [i].subtag = SUBTAG_AFFEC;
					StackExpr [i].token_index = TOKEN_FUNC_AFFEC;
				}
			}
		}
		//Signe de la division entire
		else if (token_index==TOKEN_DIVINT2) {
			StackExpr [i].tag = TAG_CALC; 
			StackExpr [i].subtag = SUBTAG_DIVINT;}
			
		//Transfomation de - en ngation (-)
		if ((i && type==TYPE_SIGN && tag==TAG_CALC && subtag==SUBTAG_SUB)
		 && ((preview_type==TYPE_FUNC && i==1) || preview_type==TYPE_SIGN || preview_type==TYPE_PARENTH_OPEN || preview_type==TYPE_VIRGULE))
		{
		  StackExpr [i].type = TYPE_NEGATIF;
		  StackExpr [i].token_type = TOKEN_FUNCTION;
		  StackExpr [i].token_index = TOKEN_NEGATIF;
		}
		 
		//Simplification des nombres
		if ((type==TYPE_SYMBOL && tag==TAG_NUMBER && subtag!=SUBTAG_STRING && subtag!=SUBTAG_BOOL) && preview_type==TYPE_NEGATIF)
		{
			//Applique ngation
			StackExpr [i].fnum = fneg (StackExpr [i].fnum);
			StackExpr [i].lnum = -StackExpr [i].lnum;
			
			//Efface signe ngatif
			Scanner_DelTag (--i);
		}
	}
	
	return TRUE;
}


//**********************************
//Vrification de la syntaxe
//**********************************
BOOL Scanner_CheckSyntax (void)
{
	unsigned char type = StackExpr [0].type;
	unsigned char tag = StackExpr [0].tag;
	unsigned char token_type = StackExpr [0].token_type;
	unsigned char token_index = StackExpr [0].token_index;
	
	unsigned char preview_type = TYPE_NONE;
	unsigned char preview_tag = TAG_NONE;
	unsigned char preview_token_type = TOKEN_NOFOUND;
	unsigned char preview_token_index = 0x00;
	unsigned char nparenth = 0;
	unsigned char end_stack = StackExpr_Ptr;
	
	BOOL token_constant0 = FALSE, token_constanti = FALSE;
	unsigned char sav_token_index0 = TOKEN_NULL;
	unsigned char sav_token_indexi = TOKEN_NULL;
	
	//Recherche un commentaire marquant la fin de la pile
	for (int i=1; i<StackExpr_Ptr-1; i++) {
	  if (StackExpr [i].token_type==TOKEN_FUNCTION && StackExpr [i].token_index==TOKEN_FUNC_COMMENT3) {
	  	end_stack = i+1; break;}}
	
	//Sauvegarde Token_constant 0
	if (StackExpr [0].type==TYPE_CONSTANT) 
	{
	  token_constant0 = TRUE;
	  sav_token_index0 = StackExpr [0].token_index;
	  StackExpr [0].token_index = TOKEN_NULL;
	}
	
	//Premier argument
	if ((tag==TAG_NUMBER || tag==TAG_STRING)
	 //Gestion de Goto
	 || (token_index==TOKEN_GOTO && !(end_stack==3 && StackExpr [1].tag==TAG_LABEL))
	 //Gestion d'un label
	 || (tag==TAG_LABEL && !(end_stack==3 && StackExpr [1].type==TYPE_TWO_POINT))
	 //Gestion de if, ElseIf, Until, While
	 || ((token_index==TOKEN_IF || token_index==TOKEN_ELSEIF || token_index==TOKEN_UNTIL || token_index==TOKEN_WHILE) && end_stack<3)
	 //Gestion de Else [If] et Exit [If] 
	 || ((token_index==TOKEN_ELSE || token_index==TOKEN_EXIT) && ((StackExpr [1].token_type==TOKEN_FUNCTION && StackExpr [1].token_index==TOKEN_IF2 && end_stack<4) || (StackExpr [1].token_type!=TOKEN_FUNCTION && StackExpr [1].token_index!=TOKEN_IF2 && end_stack>2)))
	 //Gestion de Endif, Do, Loop, Repeat, Continue
	 || ((token_index==TOKEN_ENDIF || token_index==TOKEN_DO || token_index==TOKEN_LOOP || token_index==TOKEN_REPEAT || token_index==TOKEN_CONTINUE) && end_stack>2)
	 //INPUT seul
	 || (token_index==TOKEN_INPUT && end_stack<3)
	 //Gestion de FOR
	 || (token_index==TOKEN_FOR && (end_stack<7 
	   || (!(StackExpr [1].type==TYPE_SYMBOL && StackExpr [1].tag==TAG_VAR && (StackExpr [1].subtag==SUBTAG_FLOAT || StackExpr [1].subtag==SUBTAG_INT)))
	   || (!(StackExpr [2].type==TYPE_SIGN && StackExpr [2].tag==TAG_COMPARE && StackExpr [2].subtag==SUBTAG_AFFEC))))
	 //Gestion de NEXT
	 || (token_index==TOKEN_NEXT && (end_stack>3
	   ||	(end_stack==3 && !(StackExpr [1].type==TYPE_SYMBOL && StackExpr [1].tag==TAG_VAR && (StackExpr [1].subtag==SUBTAG_FLOAT || StackExpr [1].subtag==SUBTAG_INT)))))
	 //Gestion de DATA
	 || ((token_index==TOKEN_DATA || token_index==TOKEN_READ) && end_stack<=2)
	 //Gestion de RESTORE
	 || (token_index==TOKEN_RESTORE && !(end_stack==2 || (end_stack==3 && StackExpr [1].tag==TAG_LABEL)))
	 //Gestion de PROCEDURE et GOSUB
	 || ((token_index==TOKEN_PROCEDURE || token_index==TOKEN_GOSUB || token_index==TOKEN_GOSUB2) && !(end_stack>=3 && StackExpr [1].tag==TAG_PROC))
	 //Gestion de RETURN
	 || (token_index==TOKEN_RETURN && end_stack!=2)
	 //Gestion de LOCAL
	 || (token_index==TOKEN_LOCAL && end_stack<=2))
	     {error_code = ERROR_SYNTAX; return FALSE;}

	//Gestion du FOR, recherche du TO, Downto ou Step
	if (token_index==TOKEN_FOR)
	{
	  BOOL find_to = FALSE;
	  BOOL find_down_to = FALSE;
	  BOOL find_step = FALSE;
	  for (int i=1; i<end_stack-1; i++)
	  {
	  	//Ignore les constantes
	  	if (StackExpr [i].token_type!=TOKEN_FUNCTION)
	  		continue;
	  	
	  	//Gestion du TO
	  	if (StackExpr [i].token_index==TOKEN_TO) 
	  	{
	  		//Si plusieurs To existent ou Downto existe ou step dj trouv
	  		if (find_to || find_down_to || find_step) {error_code = ERROR_SYNTAX; return FALSE;}
	  		find_to = TRUE;
	  	}
	  	//Gestion du DOWNTO
	  	else if (StackExpr [i].token_index==TOKEN_DOWNTO)
	  	{
	  		//Si plusieurs Downto existent ou To existe ou step dj trouv
	  		if (find_to || find_down_to || find_step) {error_code = ERROR_SYNTAX; return FALSE;}
	  		find_down_to = TRUE;
	  	}
	  	//Gestion de STEP
	  	else if (StackExpr [i].token_index==TOKEN_STEP)
	  	{
	  		//Si To non trouv ou si plusieurs Step existent
	  		if (!find_to || find_step) {error_code = ERROR_SYNTAX; return FALSE;}
	  		find_step = TRUE;
	  	}
	  }
	  
	  //TO non trouv et Downto non trouv
	  if (!find_to && !find_down_to) {error_code = ERROR_SYNTAX; return FALSE;}
	}	
	
	//Gestion de PROCEDURE et LOCAL, recherche de variables
	else if (token_index==TOKEN_PROCEDURE || token_index==TOKEN_LOCAL)
	{
		int start = (token_index==TOKEN_PROCEDURE)?3:1;
		int end = end_stack-((token_index==TOKEN_PROCEDURE)?2:1);
		
		for (int i=start; i<end; i++)
	  {
	    if (i&1) {
	      if (!(StackExpr [i].type==TYPE_SYMBOL && StackExpr [i].tag==TAG_VAR))
	  	    {error_code = ERROR_SYNTAX; return FALSE;}}
	    else if (StackExpr [i].type!=TYPE_VIRGULE) 
	  	  {error_code = ERROR_SYNTAX; return FALSE;}
	  }
	}
			
	//Fin de gestion de syntaxe
	if (token_index==TOKEN_GOTO || token_index==TOKEN_RESTORE
	 || tag==TAG_LABEL)
	 return TRUE;
		
	//Parcours pile d'expressions  la recherche d'erreurs de syntaxes simples
	for (int i=1; i<end_stack; i++)
	{
		//Sauvegarde Token_constant
	  if (StackExpr [i].type==TYPE_CONSTANT) 
	  {
		  token_constanti = TRUE;
		  sav_token_indexi = StackExpr [i].token_index;
		  StackExpr [i].token_index = TOKEN_NULL;
		}
		
		type = StackExpr [i].type;
		tag = StackExpr [i].tag;
		token_type = StackExpr [i].token_type;
		token_index = StackExpr [i].token_index;
		
		preview_type = StackExpr [i-1].type;
		preview_tag = StackExpr [i-1].tag;
		preview_token_type = StackExpr [i-1].token_type;
		preview_token_index = StackExpr [i-1].token_index;
		
		if ((((type==TYPE_SYMBOL && tag!=TAG_PI && tag!=TAG_EXP) || type==TYPE_CONSTANT || type==TYPE_SIGN || (type==TYPE_VIRGULE && tag!=TAG_APOST && preview_tag!=TAG_APOST) || type==TYPE_NEGATIF) && type==preview_type)	//Doublons
			|| ((tag==TAG_PI || tag==TAG_EXP) && (preview_type==TYPE_CONSTANT || (preview_type==TYPE_SYMBOL && preview_tag!=TAG_NUMBER)))							//Symbole autre qu'un nombre PI
			|| (type==TYPE_SYMBOL && (preview_type==TYPE_CONSTANT || preview_type==TYPE_PARENTH_CLOSE))
			|| (type==TYPE_CONSTANT && (preview_type==TYPE_SYMBOL || preview_type==TYPE_PARENTH_CLOSE))																//) Symbole
			|| (type==TYPE_SIGN && (preview_type==TYPE_NEGATIF || preview_type==TYPE_VIRGULE || preview_type==TYPE_PARENTH_OPEN || (preview_type==TYPE_FUNC && (preview_token_type==TOKEN_COMMAND || preview_token_index==TOKEN_IF2))))	//(-) ou ( Signe
			|| (type==TYPE_VIRGULE && (preview_type==TYPE_NEGATIF || preview_type==TYPE_PARENTH_OPEN || (preview_type==TYPE_FUNC && tag!=TAG_APOST && (preview_token_type==TOKEN_COMMAND || preview_token_index==TOKEN_IF2))))	//(-) ou ( Signe
			|| ((type==TYPE_FUNC && token_index!=TOKEN_THEN && token_index!=TOKEN_TO && token_index!=TOKEN_DOWNTO && token_index!=TOKEN_STEP) && (preview_type==TYPE_SYMBOL || preview_type==TYPE_CONSTANT))																				//Symbole Fonction
			|| (type==TYPE_NEGATIF && (preview_type==TYPE_SYMBOL || preview_type==TYPE_CONSTANT || preview_type==TYPE_PARENTH_CLOSE))
			|| (type==TYPE_PARENTH_OPEN && ((preview_type==TYPE_SYMBOL && preview_tag!=TAG_VARTABLE && preview_tag!=TAG_PROC) || preview_type==TYPE_CONSTANT || preview_type==TYPE_PARENTH_CLOSE))	//Symbole autre qu'un tableau ou ) (
			|| (type==TYPE_PARENTH_CLOSE && (preview_type==TYPE_SIGN || preview_type==TYPE_VIRGULE || preview_type==TYPE_NEGATIF)) //Signe ou (-) )
			|| ((type==TYPE_EOFLINE || token_index==TOKEN_FUNC_COMMENT3) && (preview_type==TYPE_SIGN || preview_type==TYPE_NEGATIF || preview_type==TYPE_PARENTH_OPEN || preview_type==TYPE_NEGATIF || (preview_type==TYPE_VIRGULE && preview_tag==TAG_NONE)))			//(-) ou Signe EOF
			
			//Gestion point virgule (PRINT et INPUT)
			|| (tag==TAG_POINT_VIRGULE && StackExpr [0].token_index!=TOKEN_PRINT && StackExpr [0].token_index!=TOKEN_INPUT)
			//Gestion apostrophe (PRINT)
			|| (tag==TAG_APOST && StackExpr [0].token_index!=TOKEN_PRINT)
			//Gestion de AT (PRINT et INPUT)
			|| (token_index==TOKEN_AT && (i!=1 || (StackExpr [0].token_index!=TOKEN_PRINT && StackExpr [0].token_index!=TOKEN_INPUT)))
			
			//Gestion de structures
			//=====================
		  //Label
		  || (tag==TAG_LABEL || type==TYPE_TWO_POINT)
		  //Then
		  || (token_index==TOKEN_THEN && ((StackExpr [0].token_index!=TOKEN_IF && StackExpr [0].token_index!=TOKEN_ELSEIF && StackExpr [0].token_index!=TOKEN_ELSE) || i!=end_stack-2 || (StackExpr [0].token_index!=TOKEN_ELSE && i==1) || (StackExpr [0].token_index==TOKEN_ELSE && i==2)))
			//IF 2
			|| (token_index==TOKEN_IF2 && ((StackExpr [0].token_index!=TOKEN_ELSE && StackExpr [0].token_index!=TOKEN_EXIT) || i!=1))
			//To, Downto et Step pour for
			|| ((token_index==TOKEN_TO || token_index==TOKEN_DOWNTO || token_index==TOKEN_STEP) && (StackExpr [0].token_index!=TOKEN_FOR || i==end_stack-2))
			//For To-Downto, To Step interdit
			|| ((token_index==TOKEN_TO || token_index==TOKEN_DOWNTO || token_index==TOKEN_STEP) && i==1)
			 || (token_index==TOKEN_STEP && preview_token_index==TOKEN_TO))
			 {error_code = ERROR_SYNTAX; return FALSE;}
		
		//Ajoute le signe multiplier pour PI et EXP
		if (((tag==TAG_PI || tag==TAG_EXP) && preview_tag==TAG_NUMBER) || ((preview_tag==TAG_PI || preview_tag==TAG_EXP) && tag==TAG_NUMBER)) {
			if (!Scanner_AddPosTag (i++, TYPE_SIGN, TAG_CALC, SUBTAG_MUL, TOKEN_FUNCTION, TOKEN_MUL)) return FALSE;}
			
		//Vrification des parenthses
		if (type==TYPE_PARENTH_OPEN) nparenth++;
		else if (type==TYPE_PARENTH_CLOSE) {
			if (!nparenth--) {error_code = ERROR_NOPARENTH_OPEN; return FALSE;}}
			
		//Restaure Token_constant
	  if (token_constanti) 
	  {
		  token_constanti = FALSE;
		  StackExpr [i].token_index = sav_token_indexi;
		}
	}
		
	//Parenthses ouvertes restantes
	if (nparenth) {error_code = ERROR_NOPARENTH_CLOSE; return FALSE;}
	
	//Restaure Token_constant
	if (token_constant0) 
	{
	  token_constant0 = FALSE;
	  StackExpr [0].token_index = sav_token_index0;
	}
	
	return TRUE;
}
