// C Source File
// Created 10/08/2004; 15:02:18

#include "Header.h"

/*#include <tigcclib.h>

#include "..\Structs.h"
#include "..\System\Error.h"
#include "..\System\String.h"*/

EXTERN unsigned char string_buffer [66];
EXTERN unsigned char string_buffer2 [66];

//******************************************
//Convertie un entier en chane de caractre
//******************************************
char *IntToStr (long integer)
{
  static char result [12];
  memset (result, 0x00, 12);
  char *ptr = result + 10;
  BOOL negatif = FALSE;
  
  //Zero
  if (!integer) {*ptr = '0'; return ptr;}
  
  //Signe ngatif
  if (integer&(1UL<<31))
  {
  	negatif = TRUE;
  	integer = ~integer;
  	integer++;
  }
  
  while (integer)
  {
    *ptr-- = integer % 10 + '0';
    integer/=10;
  }
  
  if (negatif) *ptr-- = 0xAD;
  return ptr+1;
}


//**********************************************
//Convertie un flottant en chane de caractre
//**********************************************
char *FloatToStr (float value)
{
	unsigned char size;
	BOOL CheckPoint = FALSE;
	sprintf (string_buffer, "%f", value);
	size = strlen (string_buffer);
	
	for (int i=0; i<size; i++)
	{
		if (string_buffer [i]=='-') string_buffer [i] = 0xAD;
		else if (string_buffer [i]=='e' || string_buffer [i]=='E') string_buffer [i] = 0x95;
		else if (string_buffer [i]=='+') {memmove (string_buffer+i, string_buffer+i+1, size-- -i); i--;}
		else if (string_buffer [i]=='.') CheckPoint = TRUE;
	}
	
	//Ajoute le point
	if (!CheckPoint) 
	{
		string_buffer [size] = '.';
		string_buffer [size+1] = 0;
	}
	
	return string_buffer;
}


//**********************************************
//Convertie une chane de caractres en flottant
//**********************************************
float StrToFloat (unsigned char *src, unsigned char *dest, unsigned short size)
{
	if (src!=dest)
	{
		memcpy (dest, src, size);
		dest [size] = 0;
	}
	
	for (unsigned short i=0; i<size; i++)
	{
		if (dest [i]=='-') dest [i] = 0xAD;
		else if (dest [i]=='e' || dest [i]=='E') dest [i] = 0x95;
		else if (dest [i]=='+') {memmove (dest+i, dest+i+1, size-- -i); i--;}
	}
	
	return atof (dest);
}

//************************************************
//Chane de caractres en UPPER CASE ou LOWER CASE
//************************************************
//UPPER
void StrUpper (unsigned char *str, unsigned short size) 
{
	for (unsigned short i=0; i<size; i++) 
	  str [i] = ((str [i]>='a' && str [i]<='z') || (str [i]>=224 && str [i]<=239) || (str [i]>=241 && str [i]<=246) || (str [i]>=248 && str [i]<=254))?str [i]-('a'-'A'):str [i];
}

//LOWER
void StrLower (unsigned char *str, unsigned short size)
{
	for (unsigned short i=0; i<size; i++) 
	  str [i] = ((str [i]>='A' && str [i]<='Z') || (str [i]>=192 && str [i]<=207) || (str [i]>=209 && str [i]<=214) || (str [i]>=216 && str [i]<=221))?str [i]+('a'-'A'):str [i];
}


//******************************
//Majuscule suivie de minuscules
//******************************
void ConvertStr (unsigned char *str, unsigned short size) 
{
  StrUpper (str, 1);
  StrLower (str+1, size-1);
  
  //Force a avoir une majuscule aprs un tiret _
  for (unsigned short i=0; i<size; i++)
  {
  	if ((str [i]=='_' || str [i]=='.') && i!=size-1)
  	  StrUpper (str+i+1, 1);
  }
}  

//******************************************************
//Comparaison chanes de caractres
//******************************************************
short strcmp2 (const unsigned char *s1, const unsigned char *s2, unsigned short size1, unsigned short size2)
{	
	if (size1>size2) return size1;
	else if (size1<size2) return -size1;
	
	return strncmp (s1, s2, size1);
}


//******************************************************
//Conversion Binaire, Octal, Hexadcimal
//******************************************************
long StrToBase (unsigned char *ptr, unsigned short size, BOOL error)
{
	long result = 0;
	if (ptr [0]!='&') return 0;
	
	//Binaire
	if (ptr [1]=='X' || ptr [1]=='x')
	{
		if (size>32+2) {if (error) {error_code = ERROR_OVERFLOW;} return 0;}
			
		for (unsigned short i=2; i<size; i++)
		{
			if (ptr [i]!='0' && ptr [i]!='1') {if (error) {error_code = ERROR_SYNTAX;} return 0;}
			result += (unsigned long)(ptr [i]-'0')<<(size-i-1);
		}
	}
	//Octal
	else if (ptr [1]=='O' || ptr [1]=='o')
	{
		if (size>11+2) {if (error) {error_code = ERROR_OVERFLOW;} return 0;}
		
		for (unsigned short i=2; i<size; i++)
		{
			if (ptr [i]<'0' || ptr [i]>'7') {if (error) {error_code = ERROR_SYNTAX;} return 0;}
			result += (unsigned long)(ptr [i]-'0')<<((size-i-1)*3);
		}
	}
	//Hexadcimal
	else if (ptr [1]=='H' || ptr [1]=='h')
	{
		if (size>8+2) {if (error) {error_code = ERROR_OVERFLOW;} return 0;}
		
		unsigned char value;
		for (unsigned short i=2; i<size; i++)
		{
			if (ptr [i]>='0' && ptr [i]<='9') value = ptr [i]-'0';
			else if (ptr [i]>='a' && ptr [i]<='f') value = (ptr [i]-'a')+10;
			else if (ptr [i]>='A' && ptr [i]<='F') value = (ptr [i]-'A')+10;
			else {if (error) {error_code = ERROR_SYNTAX;} return 0;}
			result += (unsigned long)value<<((size-i-1)<<2);
		}
	}
	//Inconnu
	else
		{if (error) {error_code = ERROR_SYNTAX;} return 0;}
	
	return result;
}


//******************************************************
//Retourne le nombre de bits d'un nombre
//******************************************************
unsigned char GetnBits (unsigned long integer)
{
  for (unsigned char nbit = 31; nbit>0; nbit--)
    if (integer&(1UL<<nbit)) return nbit+1;
  return 1;
}


//******************************************************
//Retourne le nombre de digits
//******************************************************
unsigned char GetnDigits (unsigned long integer, unsigned char div)
{
	unsigned char digit = 1;
	for (;integer>>=div; digit++); return digit;
}
