// C Source File
// Created 10/08/2004; 13:49:13

#include "Header.h"

/*#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Lst.h"
#include "..\System\String.h"
#include "..\System\File.h"
#include "..\System\Error.h"
#include "..\Other\Scanner.h"
#include "..\Other\Tokenisor.h"*/

EXTERN lstring *TSym_float;
EXTERN lstring *TSym_integer;
EXTERN lstring *TSym_bool;
EXTERN lstring *TSym_string;

EXTERN lstring *TSym_tblfloat;
EXTERN lstring *TSym_tblinteger;
EXTERN lstring *TSym_tblbool;
EXTERN lstring *TSym_tblstring;

EXTERN lstring *TSym_label, *TSym_procedure;

unsigned short nTSym_float, nTSym_integer, nTSym_bool, nTSym_string;
unsigned short nTSym_tblfloat, nTSym_tblinteger, nTSym_tblbool, nTSym_tblstring;

unsigned short nTSym_label;
BOOL defined_label [MAX_SYMBOL];

unsigned short nTSym_procedure;
BOOL defined_procedure [MAX_SYMBOL];

unsigned char *TokensFile_buffer;
unsigned short TokensFile_size, TokensFile_nbloc;
unsigned char *Sav_TokensFile_buffer;
unsigned short Sav_TokensFile_size, Sav_TokensFile_nbloc;

unsigned char *Data_TokensFile_buffer;
unsigned short Data_TokensFile_size, Data_TokensFile_nbloc;
unsigned char *iData_TokensFile_buffer;
unsigned short iData_TokensFile_size, iData_TokensFile_nbloc;
unsigned short iData_Number;


//********************************************
//Ajoute token
//********************************************
BOOL Tokenisor_AddToken (void *adr, unsigned char token, unsigned char size)
{
	//Dpassement du bloc mmoire
	if ((TokensFile_size+size)>=(TokensFile_nbloc*MAX_PAGE_TOKENSFILE))
	{
		while ((TokensFile_size+size)>=(++TokensFile_nbloc*MAX_PAGE_TOKENSFILE));
		if (!(TokensFile_buffer = realloc (TokensFile_buffer, TokensFile_nbloc*MAX_PAGE_TOKENSFILE))) 
		  {error_code = ERROR_MEMORY; return FALSE;}
	}
	
	//Simple token
	if (size==1 && adr==NULL)
		((unsigned char *)TokensFile_buffer) [TokensFile_size++] = token;
	else {
		memcpy (TokensFile_buffer+TokensFile_size, adr, size); 
		TokensFile_size += size;}
		
	return TRUE;
}


//*****************************************************************
//Phase de tokenisation
//*****************************************************************
BOOL Tokenisor_MakeTokens (void)
{
	unsigned char type, tag, subtag;
	unsigned char token_index, symbol_index;
	unsigned char *string;
	unsigned short size;
	unsigned char token = TOKEN_NULL;
	
	//Parcours la pile d'expressions.
	for (int i=0; i<StackExpr_Ptr; i++)
	{
		//Donnes
		type = StackExpr [i].type;
		tag = StackExpr [i].tag;
		subtag = StackExpr [i].subtag;
		token_index = StackExpr [i].token_index;
		symbol_index = StackExpr [i].symbol_index;
		string = StackExpr [i].string.data;
		size = StackExpr [i].string.size;
		
		//======================================
		//EXCEPTIONS
		//======================================
		//SYMBOL
		if (type==TYPE_SYMBOL && tag!=TAG_PI && tag!=TAG_EXP)
		{
			//Variables, tableaux ou labels
			if (tag==TAG_VAR || tag==TAG_VARTABLE || tag==TAG_LABEL || tag==TAG_PROC)
			{
				if (tag==TAG_VAR) Tokenisor_Add (NULL, TOKEN_START_VAR+(subtag-1), 1);								//Variable
				else if (tag==TAG_VARTABLE) Tokenisor_Add (NULL, TOKEN_START_VARTABLE+(subtag-1), 1);	//Tableau
				else if (tag==TAG_LABEL) Tokenisor_Add (NULL, TOKEN_LABEL, 1);												//Label
				else if (tag==TAG_PROC) Tokenisor_Add (NULL, TOKEN_PROC, 1);													//Procedure
				Tokenisor_Add (NULL, symbol_index, 1);	//Index
			}
			//Chanes de caractre
			else if (tag==TAG_STRING)
			{
				token = TOKEN_STRING;
				if (TokensFile_size&1) token = TOKEN_SKIP_STRING;
					
				Tokenisor_Add (NULL, token, 1);						//Token
				//Caractre NULL d'alignement
				if (token==TOKEN_SKIP_STRING) Tokenisor_Add (NULL, TOKEN_NULL, 1);
				Tokenisor_Add (NULL, size, 1);						//Taille
				Tokenisor_Add (string, TOKEN_NULL, size); //Chane de caractres
				Tokenisor_Add (NULL, 0, 1);								//Octet NULL
			}
			//Nombre
			else if (tag==TAG_NUMBER)
			{				
				//Alignement TOKEN_SKIP_xxxx
				if (!(TokensFile_size&1))
				{
					if (subtag==SUBTAG_FLOAT) token = TOKEN_SKIP_FLOAT_DEC;
					else if (subtag==SUBTAG_INT) token = TOKEN_SKIP_INT_DEC;
					else if (subtag==SUBTAG_BIN) token = TOKEN_SKIP_INT_BIN;
					else if (subtag==SUBTAG_OCT) token = TOKEN_SKIP_INT_OCT;
					else if (subtag==SUBTAG_HEX) token = TOKEN_SKIP_INT_HEX;
					
					Tokenisor_Add (NULL, token, 1);						//Token
					Tokenisor_Add (NULL, TOKEN_NULL, 1);			//Caractre NULL d'alignement
				}
				//Sans alignement
				else
				{
					if (subtag==SUBTAG_FLOAT) token = TOKEN_FLOAT_DEC;
					else if (subtag==SUBTAG_INT) token = TOKEN_INT_DEC;
					else if (subtag==SUBTAG_BIN) token = TOKEN_INT_BIN;
					else if (subtag==SUBTAG_OCT) token = TOKEN_INT_OCT;
					else if (subtag==SUBTAG_HEX) token = TOKEN_INT_HEX;
					
					Tokenisor_Add (NULL, token, 1);						//Token
				}
				
				//Ajoute nombre
				if (subtag==SUBTAG_FLOAT) Tokenisor_Add (&StackExpr [i].fnum, TOKEN_NULL, sizeof (float));
				else Tokenisor_Add (&StackExpr [i].lnum, TOKEN_NULL, sizeof (long));
			}
		}
		//Signe dbut commentaire !
		else if (i && token_index==TOKEN_FUNC_COMMENT3)
		{
		  unsigned char calc_space = 0;
		  unsigned char *ptr = string-1;
		  while (*ptr--==32) calc_space++;
		  Tokenisor_Add (NULL, token_index, 1);						//Token
		  Tokenisor_Add (NULL, calc_space, 1);						//Token
		}
		//Commentaire
		else if (type==TYPE_COMMENT)
		{
			Tokenisor_Add (NULL, TOKEN_COMMENT, 1);				//Token
			Tokenisor_Add (NULL, size, 1);								//Taille
			Tokenisor_Add (string, TOKEN_NULL, size); 		//Commentaire
		}
		//Tokens de constantes
		else if (type==TYPE_CONSTANT)
		{
			Tokenisor_Add (NULL, TOKEN_CONSTANT, 1);			//Token
			Tokenisor_Add (NULL, token_index, 1);					//Index de la constante
		}
		//EOF Line
		else if (type==TYPE_EOFLINE)
		{
			Tokenisor_Add (NULL, TOKEN_EOFLINE, 1);
			
			//Exception pas d'alignement
			//Tokenisor_Add (NULL, size>>8, 1);
			//Tokenisor_Add (NULL, size, 1);
		}
		
		//======================================
		//AUTRE
		//======================================
		else
			Tokenisor_Add (NULL, token_index, 1);
	}
	
	return TRUE;
}


//*****************************************************************
//Ecriture d'une table de symbole
//*****************************************************************
void Tokenisor_WriteSymbols (lstring *table, unsigned char nitem, FILE *file)
{
	//Ecriture des tables des symboles
	for (unsigned short i=0; i<nitem; i++)
	{
		memcpy (string_buffer, table [i].data, table [i].size);
		string_buffer [table [i].size] = 0;
		StrUpper (string_buffer, table [i].size);
		fputs (string_buffer, file);
		fputc (0x00, file);
	}
}

//*****************************************************************
//Cration du fichier GFA
//*****************************************************************
BOOL Tokenisor_MakeFile (unsigned char *file_name)
{
	FILE *file = fopen (file_name, "wb");
	if (!file) {error_code = ERROR_CREATEFILE; return FALSE;}
	
	FileHeader_GFA header;	//En-tte
	
	memcpy (header.file_id, "GFABasic", 8);
	header.version = 1;
	header.type = 0x00;
	header.nfloat = nTSym_float;
	header.ninteger = nTSym_integer;
	header.nbool = nTSym_bool;
	header.nstring = nTSym_string;
	header.ntblfloat = nTSym_tblfloat;
	header.ntblinteger = nTSym_tblinteger;
	header.ntblbool = nTSym_tblbool;
	header.ntblstring = nTSym_tblstring;
	header.nlabel = nTSym_label;
	header.nprocedure = nTSym_procedure;
	//header.octet_null = 0x00;
	
	//Ecriture de la table
	fwrite (&header, sizeof (FileHeader_GFA), 1, file);
	
	//Ecriture tables (Variables)
	Tokenisor_WriteSymbols (TSym_float, nTSym_float, file);
	Tokenisor_WriteSymbols (TSym_integer, nTSym_integer, file);
	Tokenisor_WriteSymbols (TSym_bool, nTSym_bool, file);
	Tokenisor_WriteSymbols (TSym_string, nTSym_string, file);
	
	//Ecriture tables (Tableaux)
	Tokenisor_WriteSymbols (TSym_tblfloat, nTSym_tblfloat, file);
	Tokenisor_WriteSymbols (TSym_tblinteger, nTSym_tblinteger, file);
	Tokenisor_WriteSymbols (TSym_tblbool, nTSym_tblbool, file);
	Tokenisor_WriteSymbols (TSym_tblstring, nTSym_tblstring, file);
	
	//Ecriture labels
	Tokenisor_WriteSymbols (TSym_label, nTSym_label, file);
	
	//Ecriture procedure
	Tokenisor_WriteSymbols (TSym_procedure, nTSym_procedure, file);
	
	//Fichier taille impaire
	if (ftell (file)&0x01) fputc (0xFD, file);
	
	//Tokens
	fwrite (TokensFile_buffer, TokensFile_size, 1, file);
	
	//Token de fin de program
	fputc (TOKEN_ENDPROGRAM, file);
	
	//Format perso
	fputc (0, file);
	fputs ("BAS", file);
	fputc (0, file);
	fputc (OTH_TAG, file);
	fclose (file);
	
	return TRUE;
}
