// C Source File
// Created 15/08/2004; 19:03:21
/**

#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Tokens.h"
#include "..\System\String.h"
#include "..\System\Error.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\ExprMake.h"
#include "..\Other\ExprTokens.h"
#include "..\Other\ExprVar.h"
#include "..\Functions\ExprExecute.h"
#include "..\Functions\TokensExec.h"

void ExecToken_none (void) {}
void ExecToken_Jump (void) 
{
	Exec_Ptr = *(unsigned short *)(TokensFile_buffer+Exec_Ptr);
}

void ExecToken_If (void)
{
	if (!ExprExecute_ConvertType (number1.type, TYPE_BOOL, 0)) return;
	Exec_Ptr = BOOL_num1?Exec_Ptr+2:*(unsigned short *)(TokensFile_buffer+Exec_Ptr);
}

void ExecToken_IfJump (void)
{
	if (!ExprExecute_ConvertType (number1.type, TYPE_BOOL, 0)) return;
	Exec_Ptr = BOOL_num1?*(unsigned short *)(TokensFile_buffer+Exec_Ptr):Exec_Ptr+2;
}

void ExecToken_Clear (void)
{
	ExprExecute_ClearStringStack ();
	ExcStack_Ptr = NumStack_Ptr = NumStack_LastOffset = EndTagStack_Ptr = 0;
}

void ExecToken_Eofline (void) 
{
	error_line = *(unsigned short *)(TokensFile_buffer+Exec_Ptr);	Exec_Ptr += 2;
	ExprExecute_ClearStringStack ();
	ExcStack_Ptr = NumStack_Ptr = NumStack_LastOffset = EndTagStack_Ptr = 0;
}

void ExecToken_Endtag (void) 
{
	if (EndTagStack_Ptr>=MAX_ENDTAG_STACK) {error_code = ERROR_OVERFLOW; return;}
	EndTagStack [EndTagStack_Ptr++] = ExcStack_Ptr;
}

void ExecToken_Pointvirgule (void) {ExcStack [ExcStack_Ptr++].operand = OPRD_POINT_VIRGULE;}
void ExecToken_Apost (void) {ExcStack [ExcStack_Ptr++].operand = OPRD_APOST;}
	
void ExecToken_Number_Float (void) {ExprExecute_Number_Add (TYPE_FLOAT, sizeof (float));}
void ExecToken_Number_Int (void) {ExprExecute_Number_Add (TYPE_INT, sizeof (long));}

void ExecToken_String (void) 
{
	unsigned char size = TokensFile_buffer [Exec_Ptr++];
	ExcStack [ExcStack_Ptr].operand = OPRD_STRING;
	ExcStack [ExcStack_Ptr].type = TYPE_STRING;
	ExcStack [ExcStack_Ptr].adr = &TokensFile_buffer [Exec_Ptr++];
	ExcStack [ExcStack_Ptr++].string_size = size;
	Exec_Ptr += size;
}

void ExecToken_Var_Float (void) {ExprExecute_AddVar (VAR_Float [(unsigned char)TokensFile_buffer [Exec_Ptr++]], 0, TYPE_FLOAT);}
void ExecToken_Var_Int (void) {ExprExecute_AddVar (VAR_Int [(unsigned char)TokensFile_buffer [Exec_Ptr++]], 0, TYPE_INT);}
void ExecToken_Var_Bool (void) {ExprExecute_AddVar (VAR_Bool [(unsigned char)TokensFile_buffer [Exec_Ptr++]], 0, TYPE_BOOL);}
void ExecToken_Var_String (void) {ExprExecute_AddVar (VAR_String [(unsigned char)TokensFile_buffer [Exec_Ptr]], *(unsigned short *)(VAR_String [(unsigned char)TokensFile_buffer [Exec_Ptr]]+sizeof (HANDLE)), TYPE_STRING); Exec_Ptr++;}

void ExecToken_Var_TFloat (void) {ExprExecute_AddVarTable (&VAR_TFloat [(unsigned char)TokensFile_buffer [Exec_Ptr++]], TYPE_FLOAT, sizeof (float));}
void ExecToken_Var_TInt (void) {ExprExecute_AddVarTable (&VAR_TInt [(unsigned char)TokensFile_buffer [Exec_Ptr++]], TYPE_INT, sizeof (long));}
void ExecToken_Var_TBool (void) {ExprExecute_AddVarTable (&VAR_TBool [(unsigned char)TokensFile_buffer [Exec_Ptr++]], TYPE_BOOL, sizeof (char));}
void ExecToken_Var_TString (void) {ExprExecute_AddVarTable (&VAR_TString [(unsigned char)TokensFile_buffer [Exec_Ptr++]], TYPE_STRING, sizeof (HANDLE)+sizeof (unsigned short));}


//Calculs mathmatiques
//*********************	
//Addition												 
void ExecToken_Math_Add (void)
{	
	if (!ExprExecute_MathType (TRUE, TRUE, FALSE, TRUE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult2_Int (INT_num2+INT_num1);
	else if (number1.type==TYPE_FLOAT) ExprExecute_AddResult2_Float (fadd (FLOAT_num2, FLOAT_num1));
	else
	{
		unsigned char *dest;
		unsigned char *string2_ptr = STRING_num2;
		unsigned short string2_size = string2.string_size;
		
		HANDLE handle = ExprExecute_AddString (string2.string_size+string1.string_size, ExcStack_Ptr-2);
		if (handle==H_NULL) {error_code = ERROR_MEMORY; return;}
		dest = HeapDeref (handle);
		memcpy (dest, string2_ptr, string2_size);
		memcpy (dest+string2_size, STRING_num1, string1.string_size);
		ExcStack_Ptr--;
	}
}
//Soustraction
void ExecToken_Math_Sub (void) 
{
	if (!ExprExecute_MathType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult2_Int (INT_num2 - INT_num1);
	else ExprExecute_AddResult2_Float (fsub (FLOAT_num2, FLOAT_num1));
}

//Multiplication
void ExecToken_Math_Mul (void) 
{
	if (!ExprExecute_MathType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult2_Int (INT_num2 * INT_num1);
	else ExprExecute_AddResult2_Float (fmul (FLOAT_num2, FLOAT_num1));
}

//Division
void ExecToken_Math_Div (void) 
{
	if (!ExprExecute_MathType (TRUE, FALSE, FALSE, FALSE, TYPE_FLOAT)) return; **/
	/*if (number1.type==TYPE_INT) {
		if (!INT_num1) {error_code = ERROR_DIVIDE_BY_ZERO; return;}
		ExprExecute_AddResult2_Int (INT_num2 / INT_num1);}
	else {*//**
	if (!fcmp (FLOAT_num1, 0)) {error_code = ERROR_DIVIDE_BY_ZERO; return;}
	ExprExecute_AddResult2_Float (fdiv (FLOAT_num2, FLOAT_num1));
}

//Puissance
void ExecToken_Math_Puiss (void) 
{
	if (!ExprExecute_MathType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT)
	{
		long val1 = INT_num2;
		long val2 = INT_num1;
		long result = 1;
	
		for (long i=0; i<val2; i++) result *= val1;
		ExprExecute_AddResult2_Int (result);
	}
	else
		ExprExecute_AddResult2_Float (pow (FLOAT_num2, FLOAT_num1));
}


//Comparaisons
//************
//Suprieur												 
void ExecToken_Compare_Superior (void) 
{
	if (!ExprExecute_MathType (TRUE, TRUE, TRUE, TRUE, TYPE_NONE)) return;
	
	char result;
	if (number1.type==TYPE_INT) result = (INT_num2>INT_num1)?-1:0;
	else if (number1.type==TYPE_BOOL) result = (BOOL_num2>BOOL_num1)?-1:0;
	else if (number1.type==TYPE_FLOAT) result = (fcmp (FLOAT_num2, FLOAT_num1)>0)?-1:0;
	else result = (strcmp (STRING_num2, STRING_num1)>0)?-1:0;
	ExprExecute_AddResult2_Bool (result);
}

//Infrieur
void ExecToken_Compare_Inferior (void) 
{	
	if (!ExprExecute_MathType (TRUE, TRUE, TRUE, TRUE, TYPE_NONE)) return;
	
	char result;
	if (number1.type==TYPE_INT) result = (INT_num2<INT_num1)?-1:0;
	else if (number1.type==TYPE_BOOL) result = (BOOL_num2<BOOL_num1)?-1:0;
	else if (number1.type==TYPE_FLOAT) result =  (fcmp (FLOAT_num2, FLOAT_num1)<0)?-1:0;
	else result = (strcmp (STRING_num2, STRING_num1)<0)?-1:0;
	ExprExecute_AddResult2_Bool (result);
}

//Egal
void ExecToken_Egal (void) 
{
	if (!ExprExecute_MathType (TRUE, TRUE, TRUE, TRUE, TYPE_NONE)) return;
	
	char result;
	if (number1.type==TYPE_INT) result = (INT_num2==INT_num1)?-1:0;
	else if (number1.type==TYPE_BOOL) result = (BOOL_num2==BOOL_num1)?-1:0;
	else if (number1.type==TYPE_FLOAT) result = (!fcmp (FLOAT_num2, FLOAT_num1))?-1:0;
	else result = (strcmp (STRING_num2, STRING_num1)==0)?-1:0;
	ExprExecute_AddResult2_Bool (result);
}

//Suprieur ou egal
void ExecToken_Supegal (void) 
{
	if (!ExprExecute_MathType (TRUE, TRUE, TRUE, TRUE, TYPE_NONE)) return;
	
	char result;
	if (number1.type==TYPE_INT) result = (INT_num2>=INT_num1)?-1:0;
	else if (number1.type==TYPE_BOOL) result = (BOOL_num2>=BOOL_num1)?-1:0;
	else if (number1.type==TYPE_FLOAT) result = (fcmp (FLOAT_num2, FLOAT_num1)>=0)?-1:0;
	else result = (strcmp (STRING_num2, STRING_num1)>=0)?-1:0;
	ExprExecute_AddResult2_Bool (result);
}

//Infrieur ou gal
void ExecToken_Infegal (void) 
{
	if (!ExprExecute_MathType (TRUE, TRUE, TRUE, TRUE, TYPE_NONE)) return;
	
	char result;
	if (number1.type==TYPE_INT) result = (INT_num2<=INT_num1)?-1:0;
	else if (number1.type==TYPE_BOOL) result = (BOOL_num2<=BOOL_num1)?-1:0;
	else if (number1.type==TYPE_FLOAT) result = (fcmp (FLOAT_num2, FLOAT_num1)<=0)?-1:0;
	else result = (strcmp (STRING_num2, STRING_num1)<=0)?-1:0;
	ExprExecute_AddResult2_Bool (result);
}

//Diffrent
void ExecToken_Diff (void) 
{
	if (!ExprExecute_MathType (TRUE, TRUE, TRUE, TRUE, TYPE_NONE)) return;
	
	char result;
	if (number1.type==TYPE_INT) result = (INT_num2!=INT_num1)?-1:0;
	else if (number1.type==TYPE_BOOL) result = (BOOL_num2!=BOOL_num1)?-1:0;
	else if (number1.type==TYPE_FLOAT) result = fcmp (FLOAT_num2, FLOAT_num1)?-1:0;
	else result = strcmp (STRING_num2, STRING_num1)?-1:0;
	ExprExecute_AddResult2_Bool (result);
}


//Affectation
//***********														 
void ExecToken_Affec (void) 
{
	if (ExcStack_Ptr<2) {error_code = ERROR_OPERATION; return;}
	if (!ExprExecute_CheckTableVar (ExcStack_Ptr-2)) return;
	if (!ExprExecute_ConvertType (number1.type, number2.type, ExcStack_Ptr-1)) return;
	
	if (number2.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if (number2.operand!=OPRD_VAR && number2.operand!=OPRD_VARTABLE) {error_code = ERROR_INCORRECT_ARG; return;}
		
	if (number2.type==TYPE_INT)	INT_num2 = INT_num1;
	else if (number2.type==TYPE_BOOL) BOOL_num2 = BOOL_num1;
	else if (number2.type==TYPE_FLOAT) FLOAT_num2 = FLOAT_num1;
	else
	{
		if (*(HANDLE *)(string2.adr)) HeapFree (*(HANDLE *)(string2.adr));
		if (string1.operand==OPRD_RESULT)
		{
			*(HANDLE *)(string2.adr) = *(HANDLE *)(string1.adr);
			StringStack_Ptr--;
		}
		else
		{
			unsigned char *dest;
			HANDLE handle_tmp = HeapAlloc ((string1.string_size<6)?6-string1.string_size:string1.string_size);
			if (handle_tmp==H_NULL) {error_code = ERROR_MEMORY; return;}
			*(HANDLE *)(string2.adr) = handle_tmp;
			dest = HeapDeref (handle_tmp); 
			memcpy (dest, STRING_num1, string1.string_size);
			dest [string1.string_size] = 0;
		}
		
		*(unsigned short *)(string2.adr+sizeof (HANDLE)) = string1.string_size;
	}
	
	ExcStack_Ptr -= 2;
}


//Oprations logiques
//*******************														 
//NON logique
void ExecToken_Logic_Not (void) 
{
	if (!ExprExecute_SimpleType (FALSE, TRUE, TRUE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult_Int (~INT_num1);
	else ExprExecute_AddResult_Bool (~BOOL_num1);
}

//ET logique
void ExecToken_Logic_And (void) 
{
	if (!ExprExecute_MathType (FALSE, TRUE, TRUE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult2_Int (INT_num2 & INT_num1);
	else ExprExecute_AddResult2_Bool (BOOL_num2 & BOOL_num1);
}

//OU logique inclusif
void ExecToken_Logic_Or (void) 
{
	if (!ExprExecute_MathType (FALSE, TRUE, TRUE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult2_Int (INT_num2 | INT_num1);
	else ExprExecute_AddResult2_Bool (BOOL_num2 | BOOL_num1);
}

//OU logique exclusif
void ExecToken_Logic_Xor (void) 
{
	if (!ExprExecute_MathType (FALSE, TRUE, TRUE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult2_Int (INT_num2 ^ INT_num1);
	else ExprExecute_AddResult2_Bool (BOOL_num2 ^ BOOL_num1);
}

//Implication
void ExecToken_Logic_Imp (void) 
{
	if (!ExprExecute_MathType (FALSE, TRUE, TRUE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT)	ExprExecute_AddResult2_Int (~INT_num2 | INT_num1);
	else ExprExecute_AddResult2_Bool (~BOOL_num2 | BOOL_num1);
}

//Equivalence
void ExecToken_Logic_Eqv (void) 
{
	if (!ExprExecute_MathType (FALSE, TRUE, TRUE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) {
	  long num1 = INT_num1; long num2 = INT_num2;
	  ExprExecute_AddResult2_Int ((~num2 | num1) & (num2 | ~num1));}
	else {
		char num1 = BOOL_num1; char num2 = BOOL_num2;
		ExprExecute_AddResult2_Bool ((~num2 | num1) & (num2 | ~num1));}
}

//Modulo
void ExecToken_Math_Mod (void)
{
	if (!ExprExecute_MathType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult2_Int (INT_num2%INT_num1);
	else ExprExecute_AddResult2_Float (fmod (FLOAT_num2, FLOAT_num1));
}

//Division entire
void ExecToken_Math_Divint (void)
{
	if (!ExprExecute_MathType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) {
		if (!INT_num1) {error_code = ERROR_DIVIDE_BY_ZERO; return;}
		ExprExecute_AddResult2_Int (INT_num2 / INT_num1);}
	else {
		if (!fcmp (FLOAT_num1, 0)) {error_code = ERROR_DIVIDE_BY_ZERO; return;}
		ExprExecute_AddResult2_Int (trunc (fdiv (FLOAT_num2, FLOAT_num1)));}
}

//Signe ngatif
//*************
void ExecToken_Negatif (void)
{
	if (!ExprExecute_SimpleType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult_Int (-INT_num1);
	else ExprExecute_AddResult_Float (fneg (FLOAT_num1));
}
**/
