// C Source File
// Created 15/08/2004; 19:04:40
/**
#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Library.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Tokens.h"
#include "..\Tables\Tbl_Lst.h"
#include "..\System\String.h"
#include "..\System\Error.h"
#include "..\System\Interrupt.h"
#include "..\System\Parameters.h"
#include "..\System\Functions.h"
#include "..\Other\Scanner.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\ExprMake.h"
#include "..\Other\ExprTokens.h"
#include "..\Other\ExprVar.h"
#include "..\Functions\ExprExecute.h"
#include "..\Functions\TokensFunc.h"


void ExecToken_Func_At (void)
{
	if (!ExprExecute_CheckArg (2)) return;
	if (!ExprExecute_ConvertType (number2.type, TYPE_INT, FirstArg)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	PARAM_PRINT_AT = TRUE;
	PARAM_PRINT_ATx = INT_num2-1;
	PARAM_PRINT_ATy = INT_num1-1;
	
	PARAM_PRINT_REAL_ATx = PARAM_PRINT_ATx*PARAM_FONT_DIVX;
	PARAM_PRINT_REAL_ATy = PARAM_PRINT_ATy*PARAM_FONT_DIVY;
	
	ExprExecute_EndFunc ();
}

void ExecToken_Func_Print (void)
{
	char narg = ExprExecute_CNumArg ();
		
	//Coordonne x et y pour print at(x,y)...
	if (PARAM_PRINT_AT) {
		PARAM_PRINT_AT = FALSE;
		MoveTo (PARAM_PRINT_REAL_ATx, PARAM_PRINT_REAL_ATy);}

	//Parcours arguments
	for (int i=CFirstArg; i<=CEndArg; i++)
	{
		if (!ExprExecute_CheckTableVar (i)) return;
		if (number (i).operand==OPRD_POINT_VIRGULE) continue;
		if (number (i).operand==OPRD_APOST) {printf (" "); continue;}
		
		if (number (i).type==TYPE_INT) printf ("%ld", INT_num (i));
		else if (number (i).type==TYPE_BOOL) printf ("%d", (short)BOOL_num (i));
		else if (number (i).type==TYPE_FLOAT) printf ("%f", FLOAT_num (i));
		else printf ("%s", STRING_num (i));
		
		//Saut de ligne
		if (i==CEndArg	|| (number (i+1).operand!=OPRD_POINT_VIRGULE && number (i+1).operand!=OPRD_APOST)) 
			printf ("\n");	
	}
	
	//Commande print seule
	if (!narg) printf ("\n");
}

void ExecToken_Func_Dim (void)
{
	char narg = ExprExecute_CNumArg ();
	if (narg<=0) {error_code = ERROR_FEW_ARGUMENT; return;}
	
	unsigned short total_dim = 1;
	unsigned short ndim;
	unsigned char blocsize;
	s_TblVar *table;
	HANDLE handle_tmp;
	
	//Parcours arguments
	for (int i=CFirstArg; i<=CEndArg; i++)
	{
		if (number (i).operand==OPRD_VARTABLE) {error_code = ERROR_TBL_DEF; return;}
		if (number (i).operand!=OPRD_UNDEF_VARTABLE) {error_code = ERROR_INCORRECT_ARG; return;}
		
		//Taille d'un bloc
		if (number (i).type==TYPE_FLOAT) blocsize = sizeof (float);
		else if (number (i).type==TYPE_INT) blocsize = sizeof (long);
		else if (number (i).type==TYPE_BOOL) blocsize = sizeof (char);
		else blocsize = sizeof (HANDLE)+sizeof (unsigned short);
		
		table = number (i).adr_base; ndim = table->nTblDim;
		total_dim = 1;
		if (!ndim) {error_code = ERROR_INCORRECT_ARG; return;}
		for (unsigned short j=0; j<ndim; j++) total_dim *= table->TblDim [j];
		if (!total_dim) {error_code = ERROR_TBL_ZERODIM; return;}
		table->ndim = ndim; table->total_dim = total_dim;
		if (table->adr) free (table->adr);
		if (!(table->adr = calloc (total_dim, blocsize))) {error_code = ERROR_MEMORY; return;}
		memset (table->adr, 0x00, total_dim*blocsize);
		
		//Cration des handles pour les chanes de caractres
		if (number (i).type==TYPE_STRING)
		{
			for (unsigned short j=0; j<total_dim; j++)
			{
				if ((handle_tmp = HeapAlloc (6))==H_NULL) {error_code = ERROR_MEMORY; return;}
				*(unsigned char *)(HeapDeref (handle_tmp)) = 0;
				*(HANDLE *)(table->adr+(j*blocsize)) = handle_tmp;
			}
		} 
	}
}

void ExecToken_Func_Cls (void) 
{
	if (!ExprExecute_CCheckArg (0)) return; clrscr ();
}

void ExecToken_Func_Getkey (void)
{
	char narg = ExprExecute_NumArg ();
	if (narg>1) {error_code = ERROR_LOT_ARGUMENT; return;}
	ExprExecute_AddResult_Func_Int (_kb_getkey (CALCULATOR));
}

void ExecToken_Func_Abs (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	
	if (!ExprExecute_SimpleType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	if (number1.type==TYPE_INT) ExprExecute_AddResult_Func_Int (labs (INT_num1));
	else ExprExecute_AddResult_Func_Float (fabs (FLOAT_num1));
}

void ExecToken_Func_Add (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (number2.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if ((number2.operand!=OPRD_VAR && number2.operand!=OPRD_VARTABLE)) {error_code = ERROR_INCORRECT_ARG; return;}
	
	if (!ExprExecute_ConvertTwoType (TRUE, TRUE, FALSE, FALSE, TYPE_INT, CFirstArg, CEndArg, FALSE)) return;
	if (number1.type==TYPE_INT) INT_num2 += INT_num1;
	else FLOAT_num2 = fadd (FLOAT_num2, FLOAT_num1);
}

void ExecToken_Func_Atn (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	ExprExecute_AddResult_Func_Float (atan (FLOAT_num1));
}

void ExecToken_Func_Clr (void)
{
	char narg = ExprExecute_CNumArg ();
	if (!narg) {error_code = ERROR_FEW_ARGUMENT; return;}
	
	s_TblVar *table;
	HANDLE handle_tmp;
	unsigned short total_bloc = 1;

	//Parcours arguments
	for (int i=CFirstArg; i<=CEndArg; i++)
	{	
		if (number (i).operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
		if (number (i).operand!=OPRD_EMPTY_VARTABLE && number (i).operand!=OPRD_VAR) {error_code = ERROR_INCORRECT_ARG; return;}
		
		//Variable
		if (number (i).operand==OPRD_VAR)
		{
			if (number (i).type==TYPE_INT) INT_num (i) = 0;
			else if (number (i).type==TYPE_BOOL) BOOL_num (i) = 0;
			else if (number (i).type==TYPE_FLOAT) FLOAT_num (i) = 0;
			else 
			{
				handle_tmp = *(HANDLE *)string (i).adr;
				if  (!(handle_tmp = HeapRealloc (handle_tmp, 6))) {error_code = ERROR_MEMORY; return;}
				*(HANDLE *)string (i).adr = handle_tmp;
				*(unsigned short *)(string (i).adr+sizeof (HANDLE)) = 0;	//Taille  zro
				*(unsigned char *)(HeapDeref (handle_tmp)) = 0;	//Octet NULL
			}
		}
		//Tableau
		else
		{
			table = number (i).adr_base;
			if (number (i).type==TYPE_STRING)
			{
				total_bloc = 1;
				//Compte le nombre de chanes
				for (unsigned short j=0; j<table->ndim; j++)
					total_bloc *= table->TblDim [j];
			
				//Parcours chanes pour effacer handle
				for (unsigned short j=0; j<total_bloc; j++) {
					if (*(HANDLE *)(table->adr+(j*(sizeof (HANDLE)+sizeof (unsigned short))))) HeapFree (*(HANDLE *)(table->adr+(j*(sizeof (HANDLE)+sizeof (unsigned short)))));}
			}
			
			if (table->adr) free (table->adr);
			if (table->TblDim) free (table->TblDim);
			table->ndim = 0; table->nTblDim = 0;
			table->adr = NULL; table->TblDim = NULL;
		}
	}
}

void ExecToken_Func_Cos (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	ExprExecute_AddResult_Func_Float (cos (FLOAT_num1));
}

void ExecToken_Func_Dec (void)
{
	if (!ExprExecute_CCheckArg (1)) return;
	if (number1.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if ((number1.operand!=OPRD_VAR && number1.operand!=OPRD_VARTABLE) || number1.type==TYPE_BOOL || number1.type==TYPE_STRING) {error_code = ERROR_INCORRECT_ARG; return;}
	
	if (number1.type==TYPE_INT) INT_num1--;
	else FLOAT_num1 = fsub (FLOAT_num1, 1);
}

void ExecToken_Func_Div (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (number2.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if ((number2.operand!=OPRD_VAR && number2.operand!=OPRD_VARTABLE)) {error_code = ERROR_INCORRECT_ARG; return;}
	
	if (!ExprExecute_ConvertTwoType (TRUE, TRUE, FALSE, FALSE, TYPE_INT, CFirstArg, CEndArg, FALSE)) return;
	if (number1.type==TYPE_INT) {
		if (!INT_num1) {error_code = ERROR_DIVIDE_BY_ZERO; return;}
		INT_num2 /= INT_num1;}
	else {
		if (!fcmp (FLOAT_num1, 0)) {error_code = ERROR_DIVIDE_BY_ZERO; return;}
		FLOAT_num2 = fdiv (FLOAT_num2, FLOAT_num1);}
}

void ExecToken_Func_Even (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	ExprExecute_AddResult_Func_Bool ((INT_num1&1)-1);
}

void ExecToken_Func_Exp (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	ExprExecute_AddResult_Func_Float (exp (FLOAT_num1));
}

void ExecToken_Func_Fix (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	EndTagStack_Ptr--;
}

void ExecToken_Func_Frac (void)
{	
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	ExprExecute_AddResult_Func_Float (FLOAT_num1-trunc (FLOAT_num1));
}

void ExecToken_Func_Inc (void)
{
	if (!ExprExecute_CCheckArg (1)) return;
	if (number1.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if ((number1.operand!=OPRD_VAR && number1.operand!=OPRD_VARTABLE) || number1.type==TYPE_BOOL || number1.type==TYPE_STRING) {error_code = ERROR_INCORRECT_ARG; return;}
	
	if (number1.type==TYPE_INT) INT_num1++;
	else FLOAT_num1 = fadd (FLOAT_num1, 1);
}

void ExecToken_Func_Log (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	
	if (fcmp (FLOAT_num1, 0)<0) {error_code = ERROR_NON_REAL_RESULT; return;}
	ExprExecute_AddResult_Func_Float (log (FLOAT_num1));
}

void ExecToken_Func_Log10 (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	
	if (fcmp (FLOAT_num1, 0)<0) {error_code = ERROR_NON_REAL_RESULT; return;}
	ExprExecute_AddResult_Func_Float (log10 (FLOAT_num1));
}

void ExecToken_Func_Mul (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (number2.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if ((number2.operand!=OPRD_VAR && number2.operand!=OPRD_VARTABLE)) {error_code = ERROR_INCORRECT_ARG; return;}
	
	if (!ExprExecute_ConvertTwoType (TRUE, TRUE, FALSE, FALSE, TYPE_INT, CFirstArg, CEndArg, FALSE)) return;
	if (number1.type==TYPE_INT) INT_num2 *= INT_num1;
	else FLOAT_num2 = fmul (FLOAT_num2, FLOAT_num1);
}

void ExecToken_Func_Odd (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	ExprExecute_AddResult_Func_Bool (((INT_num1&1)^1)-1);
}

void ExecToken_Func_Sgn (void)
{
	if (!ExprExecute_CheckArg (1)) return;	
	if (!ExprExecute_SimpleType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	
	if (number1.type==TYPE_INT) {
		if (!INT_num1) ExprExecute_AddResult_Func_Int (0);
		else ExprExecute_AddResult_Func_Int ((INT_num1<0)?-1:1);}
	else {
		if (!fcmp (FLOAT_num1, 0)) ExprExecute_AddResult_Func_Int (0);
		else ExprExecute_AddResult_Func_Int (fcmp (FLOAT_num1, 0)<0?-1:1);}
}

void ExecToken_Func_Sin (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	ExprExecute_AddResult_Func_Float (sin (FLOAT_num1));
}

void ExecToken_Func_Sqr (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	
	if (fcmp (FLOAT_num1, 0)<=0) {error_code = ERROR_NON_REAL_RESULT; return;}
	ExprExecute_AddResult_Func_Float (sqrt (FLOAT_num1));
}

void ExecToken_Func_Tan (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	ExprExecute_AddResult_Func_Float (tan (FLOAT_num1));
}

void ExecToken_Func_Round (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	ExprExecute_AddResult_Func_Int ((fcmp (FLOAT_num1,0)>=0)?trunc (fadd (FLOAT_num1,0.5)):-trunc (fsub (0.5,FLOAT_num1)));
}

void ExecToken_Func_Sub (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (number2.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if ((number2.operand!=OPRD_VAR && number2.operand!=OPRD_VARTABLE)) {error_code = ERROR_INCORRECT_ARG; return;}
	
	if (!ExprExecute_ConvertTwoType (TRUE, TRUE, FALSE, FALSE, TYPE_INT, CFirstArg, CEndArg, FALSE)) return;
	if (number1.type==TYPE_INT) INT_num2 -= INT_num1;
	else FLOAT_num2 = fsub (FLOAT_num2, FLOAT_num1);
}

void ExecToken_Func_Asc (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_CheckTableVar (EndArg)) return;
	if (string (FirstArg).type!=TYPE_STRING) {error_code = ERROR_TYPE_INCOMPATIBLE; return;}
	ExprExecute_AddResult_Func_Int (*STRING_num1);
}

void ExecToken_Func_Bin (void)
{	
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	HANDLE handle;
	unsigned long value = (unsigned long)INT_num1;
	unsigned char nbit = GetnBits (value);
	if (!(handle = ExprExecute_AddResult_Func_String (nbit))) return;
	unsigned char *ptr = HeapDeref (handle);
	unsigned char pos = 0;
	
	for (int i=nbit-1; i>=0; i--, pos++)
		ptr [pos] = value&(1UL<<i)?'1':'0';
}

void ExecToken_Func_Hex (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	HANDLE handle;
	unsigned long value = (unsigned long)INT_num1;
	unsigned char ndigit = GetnDigits (value, 4);
	if (!(handle = ExprExecute_AddResult_Func_String (ndigit))) return;
	unsigned char *ptr = HeapDeref (handle);
	unsigned char pos = 0;
	
	for (int i=ndigit-1; i>=0; i--, pos++)
		ptr [pos] = GFA_TableHexa [(value>>(i<<2))&15UL];
}

void ExecToken_Func_Oct (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	HANDLE handle;
	unsigned long value = (unsigned long)INT_num1;
	unsigned char ndigit = GetnDigits (value, 3);
	if (!(handle = ExprExecute_AddResult_Func_String (ndigit))) return;
	unsigned char *ptr = HeapDeref (handle);
	unsigned char pos = 0;
	
	for (int i=ndigit-1; i>=0; i--, pos++)
		ptr [pos] = '0'+((value>>(i*3))&7UL);
}

void ExecToken_Func_Chr (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	HANDLE handle;
	unsigned char value = INT_num1;
	if (!(handle = ExprExecute_AddResult_Func_String (1))) return;
	*(unsigned char *)HeapDeref (handle) = value;
}

void ExecToken_Func_Left (void)
{
	char narg = ExprExecute_NumArg ();
	unsigned short ncar = 1;
	
	if (narg<=0) {error_code = ERROR_FEW_ARGUMENT; return;}
	else if (narg>2) {error_code = ERROR_LOT_ARGUMENT; return;}
	if (!ExprExecute_ConvertType (string (FirstArg).type, TYPE_STRING, FirstArg)) return;
	
	if (narg==2) {
		if (!ExprExecute_ConvertType (number (EndArg).type, TYPE_INT, EndArg)) return;
		ncar = INT_num (EndArg);}
	
	HANDLE handle;
	if (ncar>string (FirstArg).string_size) ncar = string (FirstArg).string_size;
	unsigned char *ptr = STRING_num (FirstArg);
	if (!(handle = ExprExecute_AddResult_Func_String (ncar))) return;
	memcpy (HeapDeref (handle), ptr, ncar);
}

void ExecToken_Func_Len (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (string1.type, TYPE_STRING, EndArg)) return;
	ExprExecute_AddResult_Func_Int (string1.string_size);
}

void ExecToken_Func_Mid (void)
{
	char narg = ExprExecute_NumArg ();
	unsigned short len, pos;
	
	if (narg<=1) {error_code = ERROR_FEW_ARGUMENT; return;}
	else if (narg>3) {error_code = ERROR_LOT_ARGUMENT; return;}
	if (!ExprExecute_ConvertType (number (FirstArg).type, TYPE_STRING, FirstArg)) return;
	if (!ExprExecute_ConvertType (number (FirstArg+1).type, TYPE_INT, FirstArg+1)) return;
	pos = INT_num (FirstArg+1);
	pos = !pos?0:pos-1;
	
	if (narg==3) {
		if (!ExprExecute_ConvertType (number (EndArg).type, TYPE_INT, EndArg)) return;
		len = INT_num (EndArg);}
	else
		len = string (FirstArg).string_size-pos;
	
	HANDLE handle;
	unsigned char *ptr = STRING_num (FirstArg);
	if (pos>=string (FirstArg).string_size) len = 0;
	else if (pos+len>=string (FirstArg).string_size) len = string (FirstArg).string_size-pos;
	if (!(handle = ExprExecute_AddResult_Func_String (len))) return;
	memcpy (HeapDeref (handle), ptr+pos, len);
}

void ExecToken_Func_Right (void)
{
	char narg = ExprExecute_NumArg ();
	unsigned short ncar = 1;
	
	if (narg<=0) {error_code = ERROR_FEW_ARGUMENT; return;}
	else if (narg>2) {error_code = ERROR_LOT_ARGUMENT; return;}
	if (!ExprExecute_ConvertType (string (FirstArg).type, TYPE_STRING, FirstArg)) return;
	
	if (narg==2) {
		if (!ExprExecute_ConvertType (number (EndArg).type, TYPE_INT, EndArg)) return;
		ncar = INT_num (EndArg);}
	
	if (ncar>string (FirstArg).string_size) ncar = string (FirstArg).string_size;
	HANDLE handle;
	unsigned char *ptr = STRING_num (FirstArg);
	unsigned short size = string (FirstArg).string_size;
	if (!(handle = ExprExecute_AddResult_Func_String (ncar))) return;
	memcpy (HeapDeref (handle), ptr+(size-ncar), ncar);
}

void ExecToken_Func_Space (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	HANDLE handle;
	unsigned short size = INT_num1;
	if (!(handle = ExprExecute_AddResult_Func_String (size))) return;
	memset (HeapDeref (handle), 32, size);
}

void ExecToken_Func_Str (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_SimpleType (TRUE, TRUE, FALSE, FALSE, TYPE_INT)) return;
	
	HANDLE handle;
	unsigned short size = 0;
	unsigned char *buffer;
	
	if (number1.type==TYPE_INT) buffer = IntToStr (INT_num1);
	else buffer = FloatToStr (FLOAT_num1);
	size = strlen (buffer);
	
	if (!(handle = ExprExecute_AddResult_Func_String (size))) return;
	memcpy (HeapDeref (handle), buffer, size);
}

void ExecToken_Func_String (void)
{
	if (!ExprExecute_CheckArg (2)) return;
	if (!ExprExecute_ConvertType (number2.type, TYPE_INT, FirstArg)) return;
	
	BOOL SimpleCar = FALSE;
	unsigned char car = 0x00;
	unsigned short size = INT_num2;
	unsigned char *ptr;
	unsigned char *str = NULL;
	
	if (number1.type!=TYPE_STRING)
  {
		if (!ExprExecute_ConvertType (number1.type, TYPE_INT, FirstArg)) return;
		car = INT_num1;
		SimpleCar = TRUE;
	}
	else {
		if (!ExprExecute_CheckTableVar (EndArg)) return;
		str = STRING_num1;}
	
	HANDLE handle;
	if (!(handle = ExprExecute_AddResult_Func_String (SimpleCar?size:(string1.string_size*size)))) return;
	ptr = HeapDeref (handle);
	if (SimpleCar) memset (ptr, car, size);
	else
	{
		memset (ptr, 0x00, string1.string_size);
		for (; size; size--) strcat (ptr, str);
	}
}

void ExecToken_Func_Upper (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (string1.type, TYPE_STRING, EndArg)) return;
	
	HANDLE handle;
	unsigned short size = string1.string_size;
	unsigned char *ptr = STRING_num1;
	if (!(handle = ExprExecute_AddResult_Func_String (size))) return;
	unsigned char *dest = HeapDeref (handle);
	memcpy (dest, ptr, size);
	StrUpper (dest, size);
}

void ExecToken_Func_Val (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (string1.type, TYPE_STRING, EndArg)) return;
	
	unsigned short size = string1.string_size;
	unsigned char *ptr = STRING_num1;
	long lresult = 0;
	float fresult = 0;
	
	//&X ou &O ou &H
	if (size>2 && ptr [0]=='&')	{
		ExprExecute_AddResult_Func_Int (StrToBase (ptr, size, FALSE));
		return;}
	
	unsigned short i = 0;
	for (; i<size; i++)
	{
		if (!((ptr [0]>='0' && ptr [0]<='9') || ptr [0]=='.' || ptr [0]==0x95 || ptr [0]=='e' || ptr [0]=='E' || ptr [0]==0xAD || ptr [0]=='+' || ptr [0]=='-'))
		  break;
	}
	
	if (size>=MAX_NUMBER_SIZE) {error_code = ERROR_OVERFLOW; return;}
	fresult = StrToFloat (ptr, string_buffer, i+1); lresult = atol (ptr);
	if (is_nan (fresult)) ExprExecute_AddResult_Func_Int (lresult);
	else if (fcmp (fresult, flt (lresult))==0) ExprExecute_AddResult_Func_Int (lresult);
	else ExprExecute_AddResult_Func_Float (fresult);
}

void ExecToken_Func_Arrayfill (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (number2.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if (number2.operand!=OPRD_EMPTY_VARTABLE || number2.type==TYPE_STRING) {error_code = ERROR_INCORRECT_ARG; return;}
	if (!ExprExecute_ConvertType (number1.type, number2.type, CEndArg)) return;
		
	s_TblVar *table;
	table = number2.adr_base;
	for (unsigned short i=0; i<table->total_dim; i++)
	{
		if (number2.type==TYPE_FLOAT)	*(float *)(table->adr+(i*sizeof (float))) = FLOAT_num1;
		else if (number2.type==TYPE_INT) *(long *)(table->adr+(i*sizeof (long))) = INT_num1;
		else *(char *)(table->adr+(i*sizeof (char))) = BOOL_num1;
	}
}

void ExecToken_Func_Ldim (void)
{	
	if (!ExprExecute_CheckArg (1)) return;
	if (number1.operand==OPRD_UNDEF_VARTABLE) {ExprExecute_AddResult_Func_Int (0); return;}
	if (number1.operand!=OPRD_EMPTY_VARTABLE) {error_code = ERROR_INCORRECT_ARG; return;}
	ExprExecute_AddResult_Func_Int ((long)(((s_TblVar *)number1.adr_base)->total_dim));
}

void ExecToken_Func_End (void)
{	
	if (!ExprExecute_CCheckArg (0)) return;
	Exec_Ptr = TokensFile_size;
}

void ExecToken_Func_Fre (void)
{
	char narg = ExprExecute_NumArg ();
	if (narg>1) {error_code = ERROR_LOT_ARGUMENT; return;}
	HeapCompress ();	//Garbage Collect
	ExprExecute_AddResult_Func_Int (HeapAvail ());
}

void ExecToken_Func_Pause (void)
{
	if (!ExprExecute_CCheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, CEndArg)) return;
	
	long value = counter_time+(INT_num1*(200/50));		//200 Hz/50 Hz
	while (counter_time<=value);
}

void ExecToken_Func_Swap (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (number2.operand==OPRD_UNDEF_VARTABLE || number1.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if ((number2.operand!=number1.operand) || (number2.type!=number1.type) || (number2.operand!=OPRD_VAR && number2.operand!=OPRD_VARTABLE && number2.operand!=OPRD_EMPTY_VARTABLE)) 
		{error_code = ERROR_INCORRECT_ARG; return;}
	
	//Variables ou donnes de tableau
	if (number2.operand==OPRD_VAR || number2.operand==OPRD_VARTABLE)
	{
		if (number2.type==TYPE_INT) {long value = INT_num2; INT_num2 = INT_num1; INT_num1 = value;}
		else if (number2.type==TYPE_BOOL) {char value = BOOL_num2; BOOL_num2 = BOOL_num1; BOOL_num1 = value;}
		else if (number2.type==TYPE_FLOAT) {float value = FLOAT_num2; FLOAT_num2 = FLOAT_num1; FLOAT_num1 = value;}
		else
		{
			HANDLE handle = *(HANDLE *)(string2.adr);
			unsigned short size = *(unsigned short *)(string2.adr+sizeof (HANDLE));
			
			*(HANDLE *)(string2.adr) = *(HANDLE *)(string1.adr);
			*(unsigned short *)(string2.adr+sizeof (HANDLE)) = *(unsigned short *)(string1.adr+sizeof (HANDLE));
			*(HANDLE *)(string1.adr) = handle;
			*(unsigned short *)(string1.adr+sizeof (HANDLE)) = size;
		}
	}
	//Tableaux entiers
	else
	{
		s_TblVar table;
		memcpy (&table, number2.adr_base, sizeof (s_TblVar));
		memcpy (number2.adr_base, number1.adr_base, sizeof (s_TblVar));
		memcpy (number1.adr_base, &table, sizeof (s_TblVar));
	}
}

void ExecToken_Func_Mki (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	HANDLE handle;
	unsigned short value = INT_num1;
	if (!(handle = ExprExecute_AddResult_Func_String (sizeof (short)))) return;
	*(unsigned short *)HeapDeref (handle) = value;
}

void ExecToken_Func_Mkl (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	HANDLE handle;
	long value = INT_num1;
	if (!(handle = ExprExecute_AddResult_Func_String (sizeof (long)))) return;
	*(long *)HeapDeref (handle) = value;
}

void ExecToken_Func_Mkf (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_FLOAT, EndArg)) return;
	
	HANDLE handle;
	float value = FLOAT_num1;
	if (!(handle = ExprExecute_AddResult_Func_String (sizeof (float)))) return;
	*(float *)HeapDeref (handle) = value;
}

void ExecToken_Func_Cvi (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (string1.type, TYPE_STRING, EndArg)) return;
	ExprExecute_AddResult_Func_Int (*(unsigned short *)STRING_num1);
}

void ExecToken_Func_Cvl (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (string1.type, TYPE_STRING, EndArg)) return;
	ExprExecute_AddResult_Func_Int (*(long *)STRING_num1);
}

void ExecToken_Func_Cvf (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (string1.type, TYPE_STRING, EndArg)) return;
	ExprExecute_AddResult_Func_Float (*(float *)STRING_num1);
}

void ExecToken_Func_Setfont (void)
{
	if (!ExprExecute_CCheckArg (1)) return;
	if (!ExprExecute_ConvertType (number (CEndArg).type, TYPE_INT, CEndArg)) return;
	FontSetSys ((PARAM_FONT = INT_num (CEndArg))%3);
	
	if (PARAM_FONT==F_4x6) {PARAM_FONT_DIVX = 4; PARAM_FONT_DIVY = 6;}
	else if (PARAM_FONT==F_6x8) {PARAM_FONT_DIVX = 6; PARAM_FONT_DIVY = 8;}
	else {PARAM_FONT_DIVX = 8; PARAM_FONT_DIVY = 10;}
}

void ExecToken_Func_Getfont (void)
{
	char narg = ExprExecute_NumArg ();
	if (narg>1) {error_code = ERROR_LOT_ARGUMENT; return;}
	ExprExecute_AddResult_Func_Int (PARAM_FONT);
}

void ExecToken_Func_Lower (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (string1.type, TYPE_STRING, EndArg)) return;
	
	HANDLE handle;
	unsigned short size = string1.string_size;
	unsigned char *ptr = STRING_num1;
	if (!(handle = ExprExecute_AddResult_Func_String (size))) return;
	unsigned char *dest = HeapDeref (handle);
	memcpy (dest, ptr, size);
	StrLower (dest, size);
}

void ExecToken_Func_Run (void)
{
	ExprExecute_ClearStringStack ();
	ExcStack_Ptr = NumStack_Ptr = EndTagStack_Ptr = 0;
	Exec_Ptr = 0;
}

void ExecToken_Func_Ngetchx (void)
{
	char narg = ExprExecute_NumArg ();
	if (narg>1) {error_code = ERROR_LOT_ARGUMENT; return;}
	
	unsigned short key;
	_kb_flush (); //Front montant
	while (!(key = _kb_getkey (CALCULATOR)));
	ExprExecute_AddResult_Func_Int (key);
}

void ExecToken_Func_Rnd (void)
{
	char narg = ExprExecute_NumArg ();
	if (narg>1) {error_code = ERROR_LOT_ARGUMENT; return;}
	ExprExecute_AddResult_Func_Float (((float)random(RAND_MAX))/RAND_MAX);
}

void ExecToken_Func_Timer (void)
{
	if (!ExprExecute_CheckArg (0)) return;
	ExprExecute_AddResult_Func_Int (counter_time);
}

void ExecToken_Func_System (void)
{
	if (!ExprExecute_CCheckArg (0)) return;
	PARAM_SHOW_ENDTEXT = FALSE;
	Exec_Ptr = TokensFile_size;
}

void ExecToken_Func_Crslin (void)
{
	if (!ExprExecute_CheckArg (0)) return;
	ExprExecute_AddResult_Func_Int (PARAM_PRINT_ATx);
}

void ExecToken_Func_Crscol (void)
{
	if (!ExprExecute_CheckArg (0)) return;
	ExprExecute_AddResult_Func_Int (PARAM_PRINT_ATy);
}

void ExecToken_Func_Random (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	ExprExecute_AddResult_Func_Int (random (INT_num1));
}

void ExecToken_Func_Type (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	
	short result = -1;
	if (number1.operand==OPRD_VAR)
	{
		if (number1.type==TYPE_FLOAT) result = 0;
		else if (number1.type==TYPE_STRING) result = 1;
		else if (number1.type==TYPE_INT) result = 2;
		else if (number1.type==TYPE_BOOL) result = 3;
	}
	else if (number1.operand==OPRD_EMPTY_VARTABLE)
	{
		if (number1.type==TYPE_FLOAT) result = 4;
		else if (number1.type==TYPE_STRING) result = 5;
		else if (number1.type==TYPE_INT) result = 6;
		else if (number1.type==TYPE_BOOL) result = 7;
	}
	
	ExprExecute_AddResult_Func_Int (result);
}

void ExecToken_Func_Lval (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (string1.type, TYPE_STRING, EndArg)) return;
	
	unsigned char nval = 0;
	unsigned char *ptr = STRING_num1;
	unsigned short size = string1.string_size;
	unsigned char point = FALSE, exposant = FALSE;
	unsigned char plus_moins = FALSE;
	
	if (size)
	{
		//Nombre Binaire, Octal ou Hexadcimal
		if (ptr [0]=='&')
		{
			if (size>2)
			{
				BOOL error = FALSE;
				
				if (ptr [1]=='X' || ptr [1]=='x') 
				{
					for (unsigned short i=2; i<size; i++)
					{
						if (nval>32) break;
						else if (ptr [i]=='0' || ptr [i]=='1') 
							nval++;
						else {error = TRUE; break;}
					}
				}
				if (ptr [1]=='O' || ptr [1]=='o') 
				{
					for (unsigned short i=2; i<size; i++)
					{
						if (nval>11) break;
						else if (ptr [i]>='0' && ptr [i]<='7') 
							nval++;
						else {error = TRUE; break;}
					}
				}
			
				if (ptr [1]=='H' || ptr [1]=='h') 
				{
					for (unsigned short i=2; i<size; i++)
					{
						if (nval>8) break;
						else if ((ptr [i]>='0' && ptr [i]<='9') || (ptr [i]>='A' && ptr [i]<='F') || (ptr [i]>='a' && ptr [i]<='f')) 
							nval++;
						else {error = TRUE; break;}
					}
				}
				
				if (!error)	nval += 2;
			}
		}
		//Simple nombre
		else if ((ptr [0]>='0' && ptr [0]<='9') || ptr [0]=='.' || ptr [0]==0x95 || ptr [0]=='e' || ptr [0]=='E' || ptr [0]==0xAD || ptr [0]=='+' || ptr [0]=='-')
		{
			if (ptr [0]=='+' || ptr [0]=='-') plus_moins = TRUE;
			
			nval = 1;
			for (unsigned short i=1; i<size; i++)
			{
				if (ptr [i]=='.')
				{
					if (point || size<2 || ptr [i-1]==0x95 || ptr [i-1]=='e' || ptr [i-1]=='E') break;
					point = TRUE;
				}
				else if (ptr [i]==0x95 || ptr [i]=='e' || ptr [i]=='E')
				{
					if (exposant || plus_moins || size<2 || ptr [i-1]=='.') break;
					point = TRUE; exposant = TRUE;
				}
				else if (ptr [i]==0xAD || ptr [i]=='+')	{
					if (ptr [i-1]!=0x95 && ptr [i-1]!='e' && ptr [i-1]!='E') break;}
				else if (!(ptr [i]>='0' && ptr [i]<='9') || ptr [i]=='-') break;
				
				nval++;
			}
		}
	}
	
	ExprExecute_AddResult_Func_Int (nval);
}

void ExecToken_Func_Varptr (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (number1.operand==OPRD_UNDEF_VARTABLE) {error_code = ERROR_TBL_UNDEF; return;}
	if (number1.operand!=OPRD_VAR && number1.operand!=OPRD_VARTABLE) {error_code = ERROR_INCORRECT_ARG; return;}
	
	long adr = 0;
	
	if (number1.type==TYPE_STRING) adr = (long)STRING_num1;
	else adr = (long)number1.adr;
	
	ExprExecute_AddResult_Func_Int (adr);
}

void ExecToken_Func_Arrptr (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (number1.operand!=OPRD_VAR && number1.operand!=OPRD_EMPTY_VARTABLE) {error_code = ERROR_INCORRECT_ARG; return;}
	
	long adr = 0;
	if (number1.operand==OPRD_VAR) adr = (long)number1.adr;
	else adr = (long)number1.adr_base;
	
	ExprExecute_AddResult_Func_Int (adr);
}

void ExecToken_Func_Dfree (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	
	long value = 0;
	if (!INT_num1) value = HeapAvail ();
	else 
	{
		unsigned long nodata, Free, FreeAfterGC;
		EM_survey (&nodata, &FreeAfterGC, &Free, &nodata, &nodata, &nodata);
		value = Free+FreeAfterGC;
	}
	
	ExprExecute_AddResult_Func_Int (value);
}

void ExecToken_Func_Peek (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	ExprExecute_AddResult_Func_Int (peek (INT_num1));
}

void ExecToken_Func_Dpeek (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	ExprExecute_AddResult_Func_Int (peek_w (INT_num1));
}

void ExecToken_Func_Lpeek (void)
{
	if (!ExprExecute_CheckArg (1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, EndArg)) return;
	ExprExecute_AddResult_Func_Int (speek_l (INT_num1));
}

void ExecToken_Func_Poke (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (!ExprExecute_ConvertType (number2.type, TYPE_INT, CFirstArg)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, CEndArg)) return;
	poke (INT_num2, INT_num1);
}

void ExecToken_Func_Dpoke (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (!ExprExecute_ConvertType (number2.type, TYPE_INT, CFirstArg)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, CEndArg)) return;
	poke_w (INT_num2, INT_num1);
}

void ExecToken_Func_Lpoke (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	if (!ExprExecute_ConvertType (number2.type, TYPE_INT, CFirstArg)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, CEndArg)) return;
	poke_l (INT_num2, INT_num1);
}

void ExecToken_Func_Box (void)
{
	if (!ExprExecute_CCheckArg (4)) return;
	
	if (!ExprExecute_ConvertType (number (CFirstArg).type, TYPE_INT, CFirstArg)) return;
	if (!ExprExecute_ConvertType (number (CFirstArg+1).type, TYPE_INT, CFirstArg+1)) return;
	if (!ExprExecute_ConvertType (number2.type, TYPE_INT, CEndArg-1)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, CEndArg)) return;
	
	DrawClipRect (&(WIN_RECT){INT_num (CFirstArg), INT_num (CFirstArg+1), INT_num2, INT_num1}, &(SCR_RECT){{0, 0, LCD_WIDTH-1, LCD_HEIGHT-1}}, A_NORMAL); 
}

void ExecToken_Func_Input (void)
{
	char narg = ExprExecute_CNumArg ();
	unsigned char StartArg = CFirstArg;	
	
	//Pas d'arguments
	if (narg==0) {error_code = ERROR_SYNTAX; return;}
	
	//Point virgule, argument de dbut
	if (PARAM_PRINT_AT && number (CFirstArg).operand==OPRD_POINT_VIRGULE) StartArg++;
	
	//Coordonne x et y pour Input at(x,y)...
	if (PARAM_PRINT_AT) {
		PARAM_PRINT_AT = FALSE;
		MoveTo (PARAM_PRINT_REAL_ATx, PARAM_PRINT_REAL_ATy);}
	
	//Parcours arguments
	for (int i=StartArg; i<=CEndArg; i++)
	{
		//Argument finale, pas de point virgule ni de texte
		if (i==CEndArg && (number (i).operand==OPRD_POINT_VIRGULE || number (i).operand==OPRD_STRING))
		  {error_code = ERROR_SYNTAX; return;}
		
		if (!ExprExecute_CheckTableVar (i)) return;
		if (number (i).operand==OPRD_POINT_VIRGULE) continue;
		if ((number (i).operand!=OPRD_VAR && number (i).operand!=OPRD_VARTABLE && number (i).operand!=OPRD_STRING) || (number (i).operand==OPRD_STRING && i!=StartArg))
			{error_code = ERROR_INCORRECT_ARG; return;}
		
		//Affiche texte
		if (number (i).operand==OPRD_STRING) 
			printf ("%s", STRING_num (i));
		//Fonction INPUT
		else
		{
			IncorrectInput:
						
			//Point d'interrogation
			if (!(i==StartArg+1 && number (StartArg).operand==OPRD_STRING && number (StartArg+1).operand!=OPRD_POINT_VIRGULE))
			  printf ("? ");
			
			//INPUT
			unsigned short size = InputStr (string_buffer, 65);
			
			//Chaine de caractre
			if (number (i).type==TYPE_STRING)
			{
				if (*(HANDLE *)(number (i).adr)) HeapFree (*(HANDLE *)(number (i).adr));
				
				HANDLE handle = HeapAlloc ((size<6)?6-size:size);
				if (handle==H_NULL) {error_code = ERROR_MEMORY; return;}
				*(HANDLE *)(number (i).adr) = handle;
				unsigned char *dest = HeapDeref (handle); 
				memcpy (dest, string_buffer, size);
				dest [size] = 0;
				*(unsigned short *)(number (i).adr+sizeof (HANDLE)) = size;
			}
			else
			{
				float result = 0;
				BOOL error = FALSE;
				
				//&X ou &O ou &H
				if (size>2 && string_buffer [0]=='&')	
				{
					result = StrToBase (string_buffer, size, TRUE);
					if (error_code!=ERROR_NOERROR)
					{
						error_code = ERROR_NOERROR;
						error = TRUE;
					}
				}
				//Simple nombre
				else
				{
					//Ce n'est pas un nombre
					for (unsigned short j=0; j<size; j++)	{
						if (!((string_buffer [j]>='0' && string_buffer [j]<='9') || string_buffer [j]=='.' || string_buffer [j]==0x95 || string_buffer [j]=='e' || string_buffer [j]=='E' || string_buffer [j]==0xAD || string_buffer [j]=='+' || string_buffer [j]=='-'))
					  	{error = TRUE; break;}}
					
					if (!error)
					{
						//Dpassement de capacits
						if (!size || size>MAX_NUMBER_SIZE) 
				  		error = TRUE;
						else {
							result = StrToFloat (string_buffer, string_buffer, size);
							if (is_nan (result)) error = TRUE;}
					}
				}
				
				//Erreur de donnes
				if (error)
				{
					printf ("\n");
					if (number (StartArg).operand==OPRD_STRING && (i==StartArg+1 || (i==StartArg+2 && number (StartArg+1).operand==OPRD_POINT_VIRGULE)))
						printf ("%s", STRING_num (StartArg));
					goto IncorrectInput;
				}
				
				//Enregistrement du nombre
				if (number (i).type==TYPE_FLOAT) *(float *)(number (i).adr) = result;
				else if (number (i).type==TYPE_INT) *(long *)(number (i).adr) = trunc (result);
				else *(char *)(number (i).adr) = fcmp (result, 0)?-1:0;
			}
		}
				
		//Saut de ligne
		if (i==CEndArg || number (i).operand!=OPRD_STRING) 
			printf ("\n");
	}
}

void ExecToken_Func_Text (void)
{
	char narg = ExprExecute_CNumArg ();
	
	//3 arguments ou 4 arguments si nombre numrique comme dernier argument
	if (narg<3 || (number (CEndArg).type!=TYPE_STRING && narg<4))
	  {error_code = ERROR_FEW_ARGUMENT; return;}
	
	//Si plus de 4 arguments
	if (narg>4)
		{error_code = ERROR_LOT_ARGUMENT; return;}
	
	short x,y,l = 0;
	BOOL adjust_x = FALSE;
	BOOL adjust_car = FALSE;		//FALSE = spaces, TRUE = caracteres
	
	//x
	if (!ExprExecute_ConvertType (number (CFirstArg).type, TYPE_INT, CFirstArg)) return;
	//y
	if (!ExprExecute_ConvertType (number (CFirstArg+1).type, TYPE_INT, CFirstArg+1)) return;
	
	//String
	if (!ExprExecute_ConvertType (string (CEndArg).type, TYPE_STRING, CEndArg)) return;
	
	
	//Coordonnes du texte
	x = INT_num (CFirstArg);
	y = INT_num (CFirstArg+1);
	
	unsigned char *ptr = STRING_num1;
	unsigned short size = string1.string_size;
	
	//Chane vide
	if (!size) return;
	
	//Gestion longueur l
	if (narg==4) 
	{
		if (!ExprExecute_ConvertType (number2.type, TYPE_INT, CEndArg-1)) return;
		l = INT_num2;
		
		short ncar = 0;
		
		//Ajuste espaces
		if (l<0)
		{
			l = -l;
			//Compte les espaces
			for (unsigned short i=0; i<size; i++) {
				if (ptr [i]==32) ncar++;}
			adjust_x = TRUE;
		}
		//Ajuste caractres
		else
		{
			ncar = size-1;
			adjust_x = adjust_car = TRUE;
		}
		
		//Si pas d'espaces ou aucun caractres
		if (!ncar || !l) 
			adjust_x = FALSE;
		else
			l = (l-DrawStrWidth (ptr, PARAM_FONT))/ncar;
	}
	
	//Dessine caractres
	for (unsigned short i=0; i<size; i++)
	{
		DrawClipChar (x, y, ptr [i], &(SCR_RECT){{0, 0, LCD_WIDTH-1, LCD_HEIGHT-1}}, A_NORMAL);
		
		//Coordonne x simple!
		x += FontCharWidth (ptr [i]); //PARAM_FONT_DIVX;
		
		//Ajustement
		if (i+1<size && adjust_x && ((!adjust_car && ptr [i+1]==32) || adjust_car))
			x += l;
	}
}


void ExecToken_Func_Plot (void)
{
	if (!ExprExecute_CCheckArg (2)) return;
	
	if (!ExprExecute_ConvertType (number2.type, TYPE_INT, CFirstArg)) return;
	if (!ExprExecute_ConvertType (number1.type, TYPE_INT, CEndArg)) return;
	
	DrawClipPix (INT_num2, INT_num1); 
}
**/
