// Header File
// Created 12/08/2004; 18:52:38

#include "Header.h"

/*#include <tigcclib.h>

#include "..\Structs.h"
#include "..\Tables\Tbl_Tags.h"
#include "..\Tables\Tbl_Lst.h"
#include "..\System\String.h"
#include "..\System\File.h"
#include "..\System\Error.h"
#include "..\Other\Tokenisor.h"
#include "..\Other\UnTokenisor.h"*/

//********************************************
//Dtokenise un fichier
//********************************************
BOOL UnTokenisor_ReadFile (lstring *input_file, unsigned char *output_file)
{
	FILE *file = fopen (output_file, "w");
	if (!file) {error_code = ERROR_CREATEFILE; return FALSE;}

	unsigned char ndigit;
	unsigned char *ptr = input_file->data;
	BOOL first_token = TRUE;
	unsigned char nindent = 0;
	
	//Lecture de la table des symboles
	ptr += UnTokenisor_ReadTablesSymbols (ptr);
		
	while (*ptr!=TOKEN_ENDPROGRAM)
	{
		//Indentation
		if (first_token)
		{
			unsigned char total_nindent = nindent;
			
			//Ralise indentations
			if (total_nindent && (*ptr==TOKEN_ELSEIF || *ptr==TOKEN_ELSE || *ptr==TOKEN_ENDIF || *ptr==TOKEN_LOOP || *ptr==TOKEN_UNTIL || *ptr==TOKEN_WEND || *ptr==TOKEN_NEXT || *ptr==TOKEN_PROCEDURE || *ptr==TOKEN_RETURN)) 
				total_nindent -= 2;
			
			//Effectue indentation
			memset (string_buffer, 32, total_nindent);
			fwrite (string_buffer, total_nindent, 1, file);
			
			//Indentation ligne suivante			
			if (*ptr==TOKEN_IF || *ptr==TOKEN_DO || *ptr==TOKEN_REPEAT || *ptr==TOKEN_WHILE || *ptr==TOKEN_FOR || *ptr==TOKEN_PROCEDURE) nindent += 2;
			else if (nindent && (*ptr==TOKEN_ENDIF || *ptr==TOKEN_LOOP || *ptr==TOKEN_UNTIL || *ptr==TOKEN_WEND || *ptr==TOKEN_NEXT || *ptr==TOKEN_RETURN)) nindent -= 2;
		}
		
		if (!first_token)
		{
			//Nombres
			if (*ptr>=TOKEN_START_INT && *ptr<=TOKEN_END_INT)
			{
				long value;
				
				//Dcimal
				if (*ptr==TOKEN_INT_DEC || *ptr==TOKEN_SKIP_INT_DEC)
				{
					//Avance d'un octet
					if (*ptr==TOKEN_SKIP_INT_DEC) ptr++;
					fputs (IntToStr (*(unsigned long *)(++ptr)), file);
				}
				//Binaire
				else if (*ptr==TOKEN_INT_BIN || *ptr==TOKEN_SKIP_INT_BIN)
				{
					//Avance d'un octet
					if (*ptr==TOKEN_SKIP_INT_BIN) ptr++;
					value = *(unsigned long *)(++ptr);
					fputs ("&X", file);
					ndigit = GetnBits (value);
					for (int i=ndigit-1; i>=0; i--)	fputc (value&(1UL<<i)?'1':'0', file);
				}
				//Octal
				else if (*ptr==TOKEN_INT_OCT || *ptr==TOKEN_SKIP_INT_OCT)
				{
					//Avance d'un octet
					if (*ptr==TOKEN_SKIP_INT_OCT) ptr++;
					value = *(unsigned long *)(++ptr);
					fputs ("&O", file);
					ndigit = GetnDigits (value, 3);
					for (int i=ndigit-1; i>=0; i--) fputc ('0'+((value>>(i*3))&7UL), file);
				}
				//Hexadcimal
				else if (*ptr==TOKEN_INT_HEX || *ptr==TOKEN_SKIP_INT_HEX)
				{
					//Avance d'un octet
					if (*ptr==TOKEN_SKIP_INT_HEX) ptr++;
					value = *(unsigned long *)(++ptr);
					fputs ("&H", file);
					ndigit = GetnDigits (value, 4);
					for (int i=ndigit-1; i>=0; i--) fputc (GFA_TableHexa [(value>>(i<<2))&15UL], file);
				}
				
				//Avance de 4 octets
				ptr += sizeof (long);
				continue;
			}
			//Flottant
			else if (*ptr==TOKEN_FLOAT_DEC || *ptr==TOKEN_SKIP_FLOAT_DEC)
			{
				//Avance d'un octet
				if (*ptr==TOKEN_SKIP_FLOAT_DEC) ptr++;
				fputs (FloatToStr (*(float *)(++ptr)), file);
				
				//Avance de 10 octets
				ptr += sizeof (float);
				continue;
			}
			//Chane de caractre ou commentaire
			else if (*ptr==TOKEN_STRING || *ptr==TOKEN_SKIP_STRING || *ptr==TOKEN_COMMENT)
			{ 
			  BOOL quote = *ptr==TOKEN_COMMENT?FALSE:TRUE;
			  if (*ptr==TOKEN_SKIP_STRING) ptr++;
			  unsigned char size = *++ptr;
			  if (quote) fputc (34, file);
			  fwrite (++ptr, size, 1, file);
			  if (quote) fputc (34, file);
			  if (quote) ptr++; //Saute octet NULL
			  ptr += size;
			  continue;
			}		
		}
		
		//Variable
		//========
		if (*ptr>=TOKEN_START_SYMBOLS && *ptr<=TOKEN_END_SYMBOLS)
		{
			lstring *table = NULL;
			unsigned char addcar = 0;
			
			//Variables
			if (*ptr==TOKEN_VAR_FLOAT) table = TSym_float;
			else if (*ptr==TOKEN_VAR_INT) {table = TSym_integer; addcar = '%';}
			else if (*ptr==TOKEN_VAR_BOOL) {table = TSym_bool; addcar = '!';}
			else if (*ptr==TOKEN_VAR_STRING) {table = TSym_string; addcar = '$';}
			
			//Tableaux
			else if (*ptr==TOKEN_VARTABLE_FLOAT) table = TSym_tblfloat;
			else if (*ptr==TOKEN_VARTABLE_INT) {table = TSym_tblinteger; addcar = '%';}
			else if (*ptr==TOKEN_VARTABLE_BOOL) {table = TSym_tblbool; addcar = '!';}
			else if (*ptr==TOKEN_VARTABLE_STRING) {table = TSym_tblstring; addcar = '$';}
			
			//Labels
			else if (*ptr==TOKEN_LABEL) table = TSym_label;

			//Procedures
			else if (*ptr==TOKEN_PROC) table = TSym_procedure;

			*ptr++;
			memcpy (string_buffer, table [*ptr].data, table [*ptr].size);
			string_buffer [table [*ptr].size] = 0;
			ConvertStr (string_buffer, table [*ptr].size);				
			fputs (string_buffer, file);
			if (addcar) fputc (addcar, file);
		}
		
		//Commentaire de la forme !
		else if (!first_token && *ptr==TOKEN_FUNC_COMMENT3)	
		{
			unsigned char n_space = *++ptr;
			for (int j=0; j<n_space; j++)
			  fputc (32, file);
			fputc ('!', file);
		}
		//Fin de ligne
		//============
		else if (*ptr==TOKEN_EOFLINE)
		{
			fputs ("\n", file);
			ptr++;
			//ptr += 2+1;
			first_token = TRUE;
			continue;
		}
		
		//Tokens de Constantes
		else if (*ptr==TOKEN_CONSTANT)
			fputs (Get_GFA_TableToken_Constant (*++ptr), file);
		
		//AUTRE TOKEN
		else
		{
			unsigned char size;
			unsigned char token_index = *ptr;
			unsigned char calc_subtag = SUBTAG_NONE;
			BOOL space_after, space_befor;
			space_after = space_befor = FALSE;
			
			strcpy (string_buffer, first_token?Get_GFA_TableToken_Command (token_index):Get_GFA_TableToken_Function (token_index));
			size = strlen (string_buffer);
			
			//Oprateurs logiques (Espace avant et aprs)
			if (!first_token && token_index<TOKEN_START_COMPARE)
			{
				calc_subtag = GFA_TableCalc [token_index];
				if (calc_subtag==SUBTAG_LOGIC || calc_subtag==SUBTAG_MOD || calc_subtag==SUBTAG_DIVINT) 
				{
					if (token_index!=TOKEN_NOT) space_befor = TRUE;
					space_after = TRUE;
				}
			}
			//To espace avant et aprs
			else if (!first_token && (token_index==TOKEN_TO || token_index==TOKEN_DOWNTO || token_index==TOKEN_STEP))
			{
				space_befor = TRUE;
				space_after = TRUE;
			}
			//Then espace avant
			else if (!first_token && token_index==TOKEN_THEN)
				space_befor = TRUE;
			else if (size>1 && !(!first_token && token_index<=TOKEN_FUNC_END_CALC))
			{
			  //Efface parenthse
			  if (string_buffer [size-1]=='(') string_buffer [--size] = 0;
				else space_after = TRUE;
			}	 
			
			//Pas de conversion pour les constantes TRUE et FALSE
			if (!(!first_token && (token_index==TOKEN_TRUE || token_index==TOKEN_FALSE || token_index==TOKEN_PI_TXT)))	
				ConvertStr (string_buffer, strlen (string_buffer));
			//Pas d'espace pour les constantes
			else space_after = FALSE;
			
			//Enleve l'espace entre une fonction et un oprateur mathmatique par exemple
			if (space_after && !first_token)
			{
				unsigned char *ptr2 = ptr+1;
				if (*ptr2==TOKEN_PARENTH_OPEN
      	||  *ptr2==TOKEN_PARENTH_CLOSE
      	||  *ptr2==TOKEN_VIRGULE
      	||  *ptr2==TOKEN_NEGATIF
      	||  *ptr2==TOKEN_TWO_POINT
      	||  *ptr2==TOKEN_POINT_VIRGULE
      	||  *ptr2==TOKEN_APOST
      	||  *ptr2==TOKEN_FUNC_COMMENT3
      	||  *ptr2==TOKEN_EOFLINE
      	||  *ptr2==TOKEN_ENDPROGRAM
      	||  ((/**ptr2>=TOKEN_FUNC_START_CALC &&*/ *ptr2<=TOKEN_FUNC_END_CALC) && *ptr2!=TOKEN_NOT && *ptr2!=TOKEN_MOD && *ptr2!=TOKEN_DIVINT))
        space_after = FALSE;
			}
			//Enlve l'espace pour un token de command en fin de ligne
			else if (space_after && first_token)
			{
				unsigned char *ptr2 = ptr+1;
				if (*ptr2==TOKEN_FUNC_COMMENT3
				 || *ptr2==TOKEN_EOFLINE)
				space_after = FALSE;
			}
			
			if (space_befor) fputc (32, file);	
			fputs (string_buffer, file);
			if (space_after) fputc (32, file);
		}
		
		//Changement de la table des tokens
		if (first_token)
			first_token = FALSE;
		
		ptr++;
	}
	
	fclose (file);
	
	return TRUE;
}


//*********************************************
//Lecture de la table des symboles
//*********************************************
unsigned short UnTokenisor_ReadTablesSymbols (unsigned char *ptr)
{
	unsigned short ptr_jump = 8+1+1;
	
	//Saute informations
	ptr += ptr_jump;
	
	//Variables
	nTSym_float = *ptr++;
	nTSym_integer = *ptr++;
	nTSym_bool = *ptr++;
	nTSym_string = *ptr++;
	
	//Tableaux
	nTSym_tblfloat = *ptr++;
	nTSym_tblinteger = *ptr++;
	nTSym_tblbool = *ptr++;
	nTSym_tblstring = *ptr++;
	
	//Labels
	nTSym_label = *ptr++;
	nTSym_procedure = *ptr++;
	//*ptr++; //Octet NULL
	
	ptr_jump += 4+4+1+1;
	
	//Variables
	ptr = UnTokenisor_ReadSymbols (nTSym_float, TSym_float, ptr, &ptr_jump);
	ptr = UnTokenisor_ReadSymbols (nTSym_integer, TSym_integer, ptr, &ptr_jump);
	ptr = UnTokenisor_ReadSymbols (nTSym_bool, TSym_bool, ptr, &ptr_jump);
	ptr = UnTokenisor_ReadSymbols (nTSym_string, TSym_string, ptr, &ptr_jump);
	
	//Tableaux
	ptr = UnTokenisor_ReadSymbols (nTSym_tblfloat, TSym_tblfloat, ptr, &ptr_jump);
	ptr = UnTokenisor_ReadSymbols (nTSym_tblinteger, TSym_tblinteger, ptr, &ptr_jump);
	ptr = UnTokenisor_ReadSymbols (nTSym_tblbool, TSym_tblbool, ptr, &ptr_jump);
	ptr = UnTokenisor_ReadSymbols (nTSym_tblstring, TSym_tblstring, ptr, &ptr_jump);
	
	//Labels
	ptr = UnTokenisor_ReadSymbols (nTSym_label, TSym_label, ptr, &ptr_jump);
	
	//Procedures
	ptr = UnTokenisor_ReadSymbols (nTSym_procedure, TSym_procedure, ptr, &ptr_jump);
	
	if (*ptr==0xFD) ptr_jump++;
	
	return ptr_jump;
}


//*********************************************
//Lecture d'une table
//*********************************************
unsigned char *UnTokenisor_ReadSymbols (unsigned short nitem, lstring *table, unsigned char *ptr, unsigned short *ptr_jump)
{
	unsigned short size;
	
	for (unsigned short i=0; i<nitem; i++)
	{
		size = strlen (ptr);
		table [i].data = ptr;
		table [i].size = size;
		*ptr_jump += size+1;
		ptr += size+1;
	}
	
	return ptr;
}
