| Assembly Source File
| Created 03/04/2005; 16:38:27

		.include  "os.h"
		
		.include  "Defines.h"
		.include  "EXCEPT.h"
		
		.xdef     _v200
		.xdef 	  _ti92plus
		.xdef	  _ti89
		.xdef 	  _tigcc_native
		.xdef     __ref_all___startup_code
		.xdef     __ref_all___nostub
		.xdef     __main;_main:
		
|=========================================================================
|Programme principal
|=========================================================================		
__main:
		bclr.b    #2,PORT_PROTECT_VECTORS			|Dsactive protection en criture
		move.l    #_vector_Bus_Error,		VECTOR_BUS_ERROR
		move.l    #_vector_Address_Error,	VECTOR_ADDRESS_ERROR
		move.l    #_vector_Illegal_Instruction,	VECTOR_ILLEGAL_INSTRUCTION
		move.l    #_vector_Divide_By_Zero,	VECTOR_DIVIDE_BY_ZERO
		move.l    #_vector_Privilege_Violation,	VECTOR_PRIVILEGE_VIOLATION
		move.l    #_vector_Memory_Violation,	AUTO_INT_7
		bset.b    #2,PORT_PROTECT_VECTORS			|Active protection en criture
		
		|moveq.l   #0,%d0
		|divu      %d0,%d1
		|move.l    #0xF0F0F1F1,%d0
		|move.w    string_data+1,%d0
		|illegal
		
		move.w    #0,VECTOR_BUS_ERROR
		rts

_vector_Bus_Error:
		move.w    #0x00,-(%SP)
		jbra      Current_Except

_vector_Address_Error:
		move.w    #0x01,-(%SP)
		jbra      Current_Except
		
_vector_Illegal_Instruction:
		move.w    #0x02,-(%SP)
		jbra      Current_Except
		
_vector_Divide_By_Zero:
		move.w    #0x03,-(%SP)
		jbra      Current_Except
		
_vector_Privilege_Violation:
		move.w    #0x04,-(%SP)
		jbra      Current_Except
		
_vector_Memory_Violation:
		move.w    #0x05,-(%SP)
		jbra      Current_Except
		

|Gestion exception (SAUVEGARDE DES REGISTRES)
Current_Except:	
		|jbra       Current_Except
		|jbsr      _Current_Except_SavRegisters				|Empilage du PC
		|nop
		
_Current_Except_SavRegisters:
		clr.w     VectState
		clr.l     VectBusAddress
		clr.w     VectIntRegister
		move.w    (%a7),VectExc					|Sauvegarde de SSP
		cmpi.w    #1,(%a7)+
		jbhi      _Current_Except_SavRegisters_next
		andi.w    #0x001F,(%a7)
		move.w    (%a7)+,VectState
		move.l    (%a7)+,VectBusAddress
		move.w    (%a7)+,VectIntRegister
_Current_Except_SavRegisters_next:
		move.w    (%a7)+,VectSR
		move.l    (%a7)+,VectPC
		movem.l   %d0-%d7/%a0-%a7,SavRegisters			|des registres
		move      %USP,%a0					|et de USP
		move.l    %a0,SavRegisters+64|(4*(8+8))

|AFFICHAGE DES DONNES		
		jbsr      clrscr					|Efface cran
		
		|Affiche de l'exception
		move.w    #F_4x6,-(%SP)					|Fonte moyenne
		ROM_CALL  FontSetSys
		addq.l    #2,%SP
		
		clr.l     %d7						|Numro de l'exception en Hexadcimale
		move.w    VectExc(%PC),%d7
		
		moveq.l   #2,%d1
		move.l    %d7,%d0
		move.l    #string_data,%a0
		jbsr      Func_IntToHex
		
		move.l    %d7,%d0					|Nom de l'exception
		lsl.w     #2,%d0
		lea.l     Table_Exceptions(%PC),%a0    
		lea.l     (%d0.w,%a0),%a0
		
		pea.l     string_data(%PC)				|Affichage de l'exception
		move.l    (%a0),-(%SP)
		pea.l     printf_except(%PC)
		jbsr      printf
		lea.l     4+4+4(%SP),%SP
		
		|Affiche tat processeur
		moveq.l   #2,%d1
		clr.l     %d0
		move.w    VectState(%PC),%d0
		move.l    #string_data,%a0
		jbsr      Func_IntToHex
		
		pea.l     string_data(%PC)
		pea.l     printf_processor_state
		jbsr      printf
		addq.l    #4+4,%SP
		
		|Affiche adresse du bus et registre de l'instruction
		moveq.l   #4,%d1
		clr.l     %d0
		move.w    VectIntRegister(%PC),%d0
		move.l    #string_data2,%a0
		jbsr      Func_IntToHex
		
		moveq.l   #8,%d1
		move.l    VectBusAddress(%PC),%d0
		move.l    #string_data,%a0
		jbsr      Func_IntToHex
		
		pea.l     string_data2(%PC)
		pea.l     string_data(%PC)
		pea.l     printf_others_infos(%PC)
		jbsr      printf
		lea.l     4+4+4(%SP),%SP
				
		|Affichage SR et USP
		moveq.l   #8,%d1
		move.l    (SavRegisters+64)(%PC),%d0
		move.l    #string_data2,%a0
		jbsr      Func_IntToHex
		
		moveq.l   #4,%d1
		moveq.l   #0,%d0
		move.w    VectSR(%PC),%d0
		move.l    #string_data,%a0
		jbsr      Func_IntToHex
		
		pea.l     string_data2(%PC)
		pea.l     string_data(%PC)
		pea.l     printf_others_registers(%PC)
		jbsr      printf
		lea.l     4+4+4(%SP),%SP
		
		|Affichage de crash address
		moveq.l   #8,%d1
		move.l    VectPC(%PC),%d0
		move.l    #string_data,%a0
		jbsr      Func_IntToHex
		
		pea.l     string_data(%PC)
		pea.l     printf_crash_address(%PC)
		jbsr      printf
		addq.l    #8,%SP
		
		|Affichage des registres		
		moveq.l   #7,%d7
_Current_Except_Show_Registers_loop:
		moveq.l   #7,%d6
		sub.w     %d7,%d6
		
		move.w    %d6,%d0
		lsl.w     #2,%d0
		move.l    #SavRegisters,%a5
		lea.l     32(%d0.w,%a5),%a6
		moveq.l   #8,%d1
		move.l    (%a6),%d0
		move.l    #string_data2,%a0
		jbsr      Func_IntToHex
		
		move.w    %d6,%d0
		lsl.w     #2,%d0		
		lea.l     (%d0.w,%a5),%a6
		moveq.l   #8,%d1
		move.l    (%a6),%d0
		move.l    #string_data,%a0
		jbsr      Func_IntToHex
		
		pea.l     string_data2(%PC)
		move.w    %d6,-(%SP)
		pea.l     string_data(%PC)
		move.w    %d6,-(%SP)
		pea.l     printf_registers(%PC)
		jbsr      printf
		lea.l     16(%SP),%SP
		dbf       %d7,_Current_Except_Show_Registers_loop
				
_Current_Except_loop:
		jbra      _Current_Except_loop
		|rts


|=========================================================================
|Constantes
|=========================================================================
  .global  Table_Exceptions
  .global  _Exception_0x00
  .global  _Exception_0x01
  .global  _Exception_0x02
  .global  _Exception_0x03
  .global  _Exception_0x04
  .global  _Exception_0x05
  
  .global  printf_except
  .global  printf_registers

Table_Exceptions:
  .long    _Exception_0x00
  .long    _Exception_0x01
  .long    _Exception_0x02
  .long    _Exception_0x03
  .long    _Exception_0x04
  .long    _Exception_0x05
  .even

_Exception_0x00:
  .ascii   "BUS ERROR\0"
_Exception_0x01:
  .ascii   "ADDRESS ERROR\0"
_Exception_0x02:
  .ascii   "ILLEGAL INSTRUCTION\0"
_Exception_0x03:
  .ascii   "DIVIDE BY ZERO\0"
_Exception_0x04:
  .ascii   "PRIVILEGE VIOLATION\0"
_Exception_0x05:
  .ascii   "PROTECT MEMORY VIOLATION\0"
  .even
  
printf_except:
  .ascii   "- %s (%s) -\n\n\0"
printf_processor_state:
  .ascii   "Processor state: %s\n\0"
printf_others_infos:
  .ascii   "Bus address = %s\n"
  .ascii   "Instruction register = %s\n\n\0"
printf_others_registers:
  .ascii   "SR = %s            USP = %s\n\0"
printf_crash_address:
  .ascii   "Crash address:         PC = %s\n\n"
  .ascii   "Registers:\n\0"
printf_registers:
  .ascii   "D%d = %s  -  A%d = %s\n\0"
  .even

|=========================================================================
|Variables
|=========================================================================
  .global  VectExc
  .global  Savregisters
  .global  string_data
  .global  string_data2
  
VectExc:	.space 	2
VectState:	.space	2
VectBusAddress:	.space	4
VectIntRegister:.space 	2
VectSR:		.space 	4			
VectPC:		.space	4

SavRegisters:	.space	4*(8+8)+4
string_data:	.space	12
string_data2:	.space	12
			
		.end
		