| Assembly Source File
| Created 03/04/2005; 18:05:51
|=========
|Fonctions
|=========
		.include  "os.h"
		
		.include  "Defines.h"
		.include  "EXCEPT.h"
		
		.xdef     Func_GetnBits
		.xdef     Func_GetnDigits
		.xdef     Func_IntToHex

|=========================================================================
|Func_GetnBits
|-------------------------------------------------------------------------
|Renvoie le nombres de bits d'un nombre
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Nombre
|
|output:
|  dc.l %d0 = Nombre de bits  
|
|destroy: 
|=========================================================================		
_Func_GetnBits_return:
		addq.w    #1,%d1
		move.l    %d1,%d0
		rts

Func_GetnBits:
		moveq.l   #31,%d1
_Func_GetnBits_loop:
		add.l     %d0,%d0
		dbcs      %d1,_Func_GetnBits_loop
		jbcs      _Func_GetnBits_return
		moveq.l   #1,%d0
		rts
		

|=========================================================================
|Func_GetnDigits
|-------------------------------------------------------------------------
|Renvoie le nombres de digits d'un nombre dans une certaine base
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Nombre
|  dc.l %d1 = Base
|
|output:
|  dc.l %d0 = Nombre de digits  
|
|destroy:
|=========================================================================		
Func_GetnDigits:
		moveq.l    #1,%d2
		jbra       _Func_GetnDigits_loop
_Func_GetnDigits_add_digit:
		addq.l     #1,%d2
_Func_GetnDigits_loop:
		lsr.l      %d1,%d0
		jbne	   _Func_GetnDigits_add_digit
		move.l     %d2,%d0
		rts


|=========================================================================
|Func_IntToHex
|-------------------------------------------------------------------------
|Conversion en Hexadcimale
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Nombre
|  dc.w %d1 = Digits
|  dc.l %a0 = Chane de caractres
|
|output: 
|
|destroy:
|=========================================================================
Func_IntToHex:
		move.b    #'0',(%a0)+
		move.b    #'x',(%a0)+
		
		move.w    %d1,%d4
		moveq.l   #4,%d1
		move.l    %d0,%d3
		jbsr      Func_GetnDigits
		moveq.l   #0,%d1
		move.w    %d4,%d1
		sub.w     %d0,%d1
		subq.w    #1,%d1
		jbcs      _Func_IntToHex_next    
_Func_IntToHex_loop_string:
		move.b    #'0',(%a0)+
		dbf       %d1,_Func_IntToHex_loop_string	
_Func_IntToHex_next:		
		lea.l     TableHexa(%PC),%a2
		dbf       %d0,_Func_Hex_loop
		
_Func_Hex_loop:
		move.l    %d0,%d1
		lsl.l     #2,%d1
		move.l    %d3,%d2
		lsr.l     %d1,%d2
		andi.l    #15,%d2
		lea.l     (%d2.w,%a2),%a1
		move.b    (%a1),(%a0)+
		dbf       %d0,_Func_Hex_loop
		clr.b     (%a0)		
		rts
		
		
|*************************************************************************
|Table Hexadcimal de digits
|*************************************************************************		
  		.even
  		.global     TableHexa
TableHexa:
		.byte       '0'
		.byte       '1'
		.byte       '2'
		.byte       '3'
		.byte       '4'
		.byte       '5'
		.byte       '6'
		.byte       '7'
		.byte       '8'
		.byte       '9'
		.byte       'A'
		.byte       'B'
		.byte       'C'
		.byte       'D'
		.byte       'E'
		.byte       'F'
		.even
		
		.end
		