// Header File
// Created 16/08/2004; 13:26:51
#ifndef __H_EXPREXECUTE
#define __H_EXPREXECUTE

#define MAX_EXEC_STACK				80
#define MAX_NUMBER_STACK			30
#define MAX_STRING_STACK			20
#define MAX_ENDTAG_STACK			15

#define MAX_STRING_SIZE				32767

#define FLOAT_num(x)					(*(float *)ExcStack [x].adr)
#define INT_num(x)						(*(long *)ExcStack [x].adr)
#define BOOL_num(x)						(*(char *)ExcStack [x].adr)
#define STRING_num(x)					ExprExecute_GetString(x)
#define FLOAT_num1						(*(float *)ExcStack [ExcStack_Ptr-1].adr)
#define FLOAT_num2						(*(float *)ExcStack [ExcStack_Ptr-2].adr)
#define INT_num1							(*(long *)ExcStack [ExcStack_Ptr-1].adr)
#define INT_num2							(*(long *)ExcStack [ExcStack_Ptr-2].adr)
#define BOOL_num1							(*(char *)ExcStack [ExcStack_Ptr-1].adr)
#define BOOL_num2							(*(char *)ExcStack [ExcStack_Ptr-2].adr)
#define STRING_num1						ExprExecute_GetString(ExcStack_Ptr-1)
#define STRING_num2						ExprExecute_GetString(ExcStack_Ptr-2)

#define number(x)							ExcStack [x]
#define number1								ExcStack [ExcStack_Ptr-1]
#define number2								ExcStack [ExcStack_Ptr-2]
#define string(x)							number(x)
#define string1								number1
#define string2								number2

extern s_data *ExcStack;											//Pile de calculs
extern void *NumStack;												//Pile de nombre et rsultats
extern unsigned short NumStack_LastOffset;		//Position suivante
extern HANDLE *StringStack;										//Pile de chanes de caractres
extern unsigned char ExcStack_Ptr, NumStack_Ptr, StringStack_Ptr;
extern unsigned short Exec_Ptr;								//Pointeur d'execution des tokens

extern unsigned char EndTagStack [MAX_ENDTAG_STACK];
extern unsigned char EndTagStack_Ptr;

extern BOOL ExprExecute_Allocate (void);
extern void ExprExecute_Unallocate (void);

extern void ExprExecute_Run (void);

extern BOOL ExprExecute_Number_Add (unsigned char, unsigned char);
extern BOOL ExprExecute_AddVar (void *, unsigned short, unsigned char);
extern BOOL ExprExecute_AddVarTable (s_TblVar *, unsigned char, unsigned char);
extern BOOL ExprExecute_AddValue (void *, unsigned char, unsigned char, unsigned char);
extern void ExprExecute_ClearStringStack (void);
extern HANDLE ExprExecute_AddString (unsigned short, unsigned char);
extern unsigned char *ExprExecute_GetString (unsigned char);
extern unsigned char *ExprExecute_GetString (unsigned char);
extern BOOL ExprExecute_AddValue_Float (float, unsigned char);
extern BOOL ExprExecute_AddValue_Int (long, unsigned char);
extern BOOL ExprExecute_AddValue_Bool (char, unsigned char);
#define ExprExecute_AddNumber_Float(value)	{ExprExecute_AddValue_Float (value, ExcStack_Ptr++); Exec_Ptr += sizeof (float);}	
#define ExprExecute_AddNumber_Int(value)		{ExprExecute_AddValue_Int (value, ExcStack_Ptr++); Exec_Ptr += sizeof (long);}
#define ExprExecute_AddNumber_Bool(value)		{ExprExecute_AddValue_Bool (value, ExcStack_Ptr++); Exec_Ptr += sizeof (char);}

extern BOOL ExprExecute_ConvertType (unsigned char, unsigned char, unsigned char);
extern BOOL ExprExecute_Type_Float_To_Int (unsigned char);
extern BOOL ExprExecute_Type_Float_To_Bool (unsigned char);
extern BOOL ExprExecute_Type_Int_To_Float (unsigned char);
extern BOOL ExprExecute_Type_Int_To_Bool (unsigned char);
extern BOOL ExprExecute_Type_Bool_To_Float (unsigned char);
extern BOOL ExprExecute_Type_Bool_To_Int (unsigned char);

extern BOOL ExprExecute_ConvertOneType (BOOL, BOOL, BOOL, BOOL, unsigned char, unsigned char);
extern BOOL ExprExecute_ConvertTwoType (BOOL, BOOL, BOOL, BOOL, unsigned char, unsigned char, unsigned char, BOOL);
extern BOOL ExprExecute_MathType (BOOL, BOOL, BOOL, BOOL, unsigned char);
extern BOOL ExprExecute_SimpleType (BOOL, BOOL, BOOL, BOOL, unsigned char);
extern BOOL ExprExecute_PriorityType (unsigned char, unsigned char);
extern BOOL ExprExecute_CheckTableVar (unsigned char);


//***********************************************
//Ajoute un rsultat avec deux oprandes
//***********************************************
#define ExprExecute_AddResult2_Float(value)			({ExprExecute_AddValue_Float (value, ExcStack_Ptr-2); ExcStack_Ptr--;})
#define ExprExecute_AddResult2_Int(value)				({ExprExecute_AddValue_Int (value, ExcStack_Ptr-2); ExcStack_Ptr--;})
#define ExprExecute_AddResult2_Bool(value)			({ExprExecute_AddValue_Bool (value, ExcStack_Ptr-2); ExcStack_Ptr--;})

//***********************************************
//Ajoute un rsultat avec une oprande
//***********************************************
#define ExprExecute_AddResult_Float(value)			ExprExecute_AddValue_Float (value, ExcStack_Ptr-1)
#define ExprExecute_AddResult_Int(value)				ExprExecute_AddValue_Int (value, ExcStack_Ptr-1)
#define ExprExecute_AddResult_Bool(value)				ExprExecute_AddValue_Bool (value, ExcStack_Ptr-1)

//**********************
///Gestion des fonctions
//**********************
extern BOOL ExprExecute_CheckArg (char);
extern BOOL ExprExecute_CCheckArg (char);
#define ExprExecute_NumArg()				ExcStack_Ptr-EndTagStack [EndTagStack_Ptr-1]
#define ExprExecute_EndFunc()				ExcStack_Ptr -= (ExcStack_Ptr-EndTagStack [--EndTagStack_Ptr])
#define FirstArg										EndTagStack [EndTagStack_Ptr-1]
#define EndArg											ExcStack_Ptr-1
#define CFirstArg										0
#define CEndArg											ExcStack_Ptr-1
#define ExprExecute_CNumArg()				ExcStack_Ptr

extern void ExprExecute_AddResult_Func_Float (float value);
extern void ExprExecute_AddResult_Func_Int (long value);
extern void ExprExecute_AddResult_Func_Bool (char value);
extern HANDLE ExprExecute_AddResult_Func_String (unsigned short);
#endif
