// Header File
// Created 16/08/2004; 13:11:08
#ifndef __H_EXPRVAR
#define __H_EXPRVAR

#define nVAR_Float					nTSym_float
#define nVAR_Int						nTSym_integer
#define nVAR_Bool						nTSym_bool
#define nVAR_String					nTSym_string

#define nVAR_TFloat					nTSym_tblfloat
#define nVAR_TInt						nTSym_tblinteger
#define nVAR_TBool					nTSym_tblbool
#define nVAR_TString				nTSym_tblstring

#define MAX_LOCAL_VAR				MAX_SYMBOL
#define MAX_PROCEDURE				MAX_SYMBOL
#define MAX_GOSUB						MAX_SYMBOL

#define MAX_LABEL						MAX_SYMBOL
#define MAX_GOTO						MAX_SYMBOL
#define MAX_RESTORE					MAX_SYMBOL
#define MAX_IF							MAX_SYMBOL
#define MAX_ELSEIF					MAX_SYMBOL
#define MAX_DO							MAX_SYMBOL
#define MAX_REPEAT					MAX_SYMBOL
#define MAX_WHILE						MAX_SYMBOL
#define MAX_FOR							MAX_SYMBOL

#define MAX_STRUCT					MAX_SYMBOL
#define MAX_EXITIF					MAX_SYMBOL
#define MAX_CONTINUE				MAX_SYMBOL

#define STRUCT_IF						1
#define STRUCT_DO						2
#define STRUCT_REPEAT				3
#define STRUCT_WHILE				4
#define STRUCT_FOR					5

#define FOR_TYPE_TO					0
#define FOR_TYPE_DOWNTO			1
#define FOR_TYPE_STEP				2

extern void *VarMemory;
extern void **VAR_Float;
extern void **VAR_Int;
extern void **VAR_Bool;
extern void **VAR_String;
extern s_TblVar *VAR_TFloat;
extern s_TblVar *VAR_TInt;
extern s_TblVar *VAR_TBool;
extern s_TblVar *VAR_TString;

extern s_LocalVar *Local_VAR_Float;
extern s_LocalVar *Local_VAR_Int;
extern s_LocalVar *Local_VAR_Bool;
extern s_LocalVar *Local_VAR_String;
extern unsigned short LocalVar_current_offset;
extern unsigned short LocalVar_current_string_offset;
//extern unsigned short LocalVar_start_offset;

extern BOOL isInProcedure;
extern BOOL FirstProcedure;
extern unsigned short ProcedureOffset;
extern unsigned short *TblProcedureJump;
extern s_GotoJump *TblGosubJump;
extern unsigned short nTblGosubJump;

extern s_LabelJump *TblLabelJump;
extern s_GotoJump *TblGotoJump;
extern unsigned short nTblGotoJump;

extern s_GotoJump *TblRestoreJump;
extern unsigned short nTblRestoreJump;

extern unsigned char *TblStruct;
extern unsigned short nTblStruct;
extern unsigned short nTblStructExitIf;
extern unsigned char *nTblExitIf;
extern unsigned short *TblExitIf;
extern unsigned short TotalExitIf;

extern unsigned short nTblStructContinue;
extern unsigned char *nTblContinue;
extern unsigned short *TblContinue;
extern unsigned short TotalContinue;
extern unsigned short *TblStructContinue_address;

extern s_IFJump *Tbl_IF_Jump;
extern unsigned short n_IF_Jump;
extern unsigned short *Tbl_ElseIf_Address;
extern unsigned short TotalElseIf;
extern unsigned short *Tbl_Do_Address;
extern unsigned short TotalDo;
extern unsigned short *Tbl_Repeat_Address;
extern unsigned short TotalRepeat;
extern unsigned short *Tbl_While_Address_If;
extern unsigned short *Tbl_While_Address_Jump;
extern unsigned short TotalWhile;
extern s_FORJump *Tbl_FOR_Jump;
extern unsigned short TotalFor;

extern BOOL ExprVar_Allocate (void);
extern void ExprVar_Unallocate (void);

extern void ExprVar_InitTables (void);
extern BOOL ExprVar_AllocateTables (void);
extern void ExprVar_UnallocateTables (void);

#endif
