// Header File
// Created 10/08/2004; 15:51:33
#ifndef __H_SCANNER
#define __H_SCANNER

#define MAX_TAG_STACK							120
#define MAX_OPERATOR_STACK				20
#define MAX_COMMENT_SIZE					1000
#define MAX_EXPR_SIZE							64
#define MAX_LINE_SIZE							256
#define MAX_NUMBER_SIZE						20

extern s_tag *StackExpr;
extern s_tag *OperatorStack [MAX_OPERATOR_STACK];
extern s_tag *TStackExpr [MAX_TAG_STACK];
extern unsigned char StackExpr_Ptr, TStackExpr_Ptr, OperatorStack_Ptr;

extern BOOL Scanner_ReadFile (lstring);
extern void Scanner_NextTag (s_tag *, void *);
extern BOOL Scanner_AddTag (void *, unsigned short, unsigned char, unsigned char);
extern BOOL Scanner_AddPosTag (unsigned char, unsigned char, unsigned char, unsigned char, unsigned char, unsigned char);
extern void Scanner_DelTag (unsigned char);
extern BOOL Scanner_SetTag (unsigned char);
extern BOOL Scanner_CheckSymbol (unsigned char);
extern BOOL Scanner_FindToken (void *, unsigned short, BOOL *, unsigned char *, unsigned char);
extern BOOL Scanner_FindConstant (void *, unsigned short, BOOL *, unsigned char *);
extern BOOL Scanner_FindVarAndFunc (void);
extern BOOL Scanner_AdjustTags (void);
extern BOOL Scanner_CheckSyntax (void);

#endif
