// Header File
// Created 15/07/2004; 19:07:21
#ifndef __H_STRUCTS
#define __H_STRUCTS

//Structure d'un fichier tokenis	GFA			30 octets
typedef struct {
	unsigned char file_id [8];			// "GfaBASIC"
	unsigned char version;					//1
	unsigned char type;
	unsigned char nfloat;
	unsigned char ninteger;
	unsigned char nbool;
	unsigned char nstring;
	unsigned char ntblfloat;
	unsigned char ntblinteger;
	unsigned char ntblbool;
	unsigned char ntblstring;
	unsigned char nlabel;
	unsigned char nprocedure;
} FileHeader_GFA;


//Structure d'un fichier contenant des tokens d'execution GTK		24 octets
typedef struct {
	unsigned char file_id [7];			// "GFA_GTK"
	unsigned char version;					//1
	unsigned short tokens_size;			//Taille de la section des tokens
	unsigned short number_data;			//Nombre de donnes DATA
	unsigned short offset_data;			//Offset dbut donnes DATA
	unsigned char nfloat;
	unsigned char ninteger;
	unsigned char nbool;
	unsigned char nstring;
	unsigned char ntblfloat;
	unsigned char ntblinteger;
	unsigned char ntblbool;
	unsigned char ntblstring;
	unsigned char section_tk [2];		// "TK"
} FileHeader_GTK;

//Chane de caractres
typedef struct {
	unsigned char *data;
	unsigned short size;
} lstring;


//Structure d'un tag
typedef struct {
	//Phase 1
	unsigned char type;
	unsigned char tag;
	unsigned char subtag;
	
	//Phase 2
	unsigned char token_type;			//Token de command ou token de fonction
	unsigned char token_index;		//Index dans la table
	unsigned char symbol_index;		//Index du symbol
	
	//Phase 3
	unsigned char priority;				//Priorit de calcul
	
	//Stockage de donnes
	float fnum;
	long lnum;
	lstring string;
} s_tag;


//Contenu de ExecStack
typedef struct {
	void *adr;
	unsigned char operand;
	unsigned char type;
	void *adr_base;
	unsigned short string_size;
} s_data;


//Structure d'un tableau
typedef struct {
	unsigned char ndim;
	unsigned char nTblDim;
	unsigned short total_dim;
	unsigned short *TblDim;
	void *adr;
} s_TblVar;


//Structure des labels
typedef struct {
	unsigned short address;
	unsigned short data_number;
	unsigned short data_ptr;
	BOOL isInLoop;						//Ce trouve dans une boucle FOR!
	unsigned short ProcedureOffset;
} s_LabelJump;


//Structure d'adressage des GOTOs
typedef struct {
	unsigned char lbl_index;
	unsigned short token_address;
	unsigned short ProcedureOffset;
} s_GotoJump;


//Structure de saut pour les conditons IF
typedef struct {
	unsigned short nElseIf;
	BOOL branch_else;
	unsigned short token_address;
} s_IFJump;


//Structure de gestion des boucles FOR
typedef struct {
  unsigned char var_subtag;
  unsigned char var_number;
  unsigned short token_address_data;
  unsigned short token_address_if;
} s_FORJump;


//Structure de gestion des variables locales
typedef struct {
	BOOL local;
	unsigned short offset;
} s_LocalVar;

#endif
