// Header File
// Created 10/08/2004; 18:12:21
#ifndef __H_TBL_LST
#define __H_TBL_LST

#define TOKEN_NULL								0x00
#define TOKEN_CMD_COMMENT1				0x00
#define TOKEN_CMD_COMMENT2				0x10
#define TOKEN_FUNC_COMMENT3				0xBB

#define TOKEN_FUNC_START_CALC			0x00
#define TOKEN_FUNC_END_CALC				0x17
#define TOKEN_FUNC_AFFEC					0x45
#define TOKEN_FUNC_START_SGNCALC 	0x05

#define TOKEN_START_COMPARE				0x0D

#define TOKEN_START_SYMBOLS				0xE0
#define TOKEN_END_SYMBOLS					0xE9

#define TOKEN_START_VAR						0xE0
#define TOKEN_START_VARTABLE			0xE4
#define TOKEN_LABEL								0xE8
#define TOKEN_PROC								0xE9
#define TOKEN_STRING							0xDE
#define TOKEN_SKIP_STRING					0xDC

#define TOKEN_SKIP_FLOAT_DEC			0xDD
#define TOKEN_SKIP_INT_DEC				0xC9
#define TOKEN_SKIP_INT_BIN				0xCF
#define TOKEN_SKIP_INT_OCT				0xCD
#define TOKEN_SKIP_INT_HEX				0xCB

#define TOKEN_FLOAT_DEC						0xDF
#define TOKEN_INT_DEC							0xC8
#define TOKEN_INT_BIN							0xCE
#define TOKEN_INT_OCT							0xCC
#define TOKEN_INT_HEX							0xCA

#define TOKEN_START_INT						0xC8
#define TOKEN_END_INT							0xCF

#define TOKEN_COMMENT							0xC6

#define TOKEN_PARENTH_OPEN				0x23
#define TOKEN_PARENTH_CLOSE				0x20
#define TOKEN_VIRGULE							0x21
#define TOKEN_NEGATIF							0x1E
#define TOKEN_TWO_POINT						0x7C
#define TOKEN_POINT_VIRGULE				0x22
#define TOKEN_APOST								0x2D

#define TOKEN_CONSTANT						0xFD
#define TOKEN_EOFLINE							0xFE
#define TOKEN_ENDPROGRAM					0xFF

//Variables
#define TOKEN_VAR_FLOAT						0xE0
#define TOKEN_VAR_INT							0xE1
#define TOKEN_VAR_BOOL						0xE2
#define TOKEN_VAR_STRING					0xE3

//Tableaux
#define TOKEN_VARTABLE_FLOAT			0xE4
#define TOKEN_VARTABLE_INT				0xE5
#define TOKEN_VARTABLE_BOOL				0xE6
#define TOKEN_VARTABLE_STRING			0xE7

//Labels
#define TOKEN_LABEL								0xE8

//Procedures
#define TOKEN_PROC								0xE9

//Constantes
#define TOKEN_TRUE								0xBC
#define TOKEN_FALSE								0xBD
#define TOKEN_PI_TXT							0xBE
#define TOKEN_PI									0xBF
#define TOKEN_EXP									0xC0

//Signes mathmatiques
#define TOKEN_MUL									0x07
#define TOKEN_MOD									0x0A
#define TOKEN_DIVINT							0x0C
#define TOKEN_DIVINT2							0x5B

//Comparaison
#define TOKEN_INFEGAL							0x15
#define TOKEN_SUPEGAL							0x16
#define TOKEN_DIFF								0x17

//Logique
#define TOKEN_AND									0x00
#define TOKEN_OR									0x01
#define TOKEN_XOR									0x02
#define TOKEN_IMP									0x03
#define TOKEN_EQV									0x04
#define TOKEN_NOT									0x0B

//Structures
#define TOKEN_GOTO								0x2D
#define TOKEN_PRINT								0x0E
#define TOKEN_AT									0x59
#define TOKEN_IF									0x0B
#define TOKEN_ELSE								0x0C
#define TOKEN_ELSEIF							0x0F
#define TOKEN_IF2									0x5A
#define TOKEN_ENDIF								0x0D
#define TOKEN_THEN								0x4A
#define TOKEN_NOT									0x0B
#define TOKEN_DO									0x06
#define TOKEN_LOOP								0x07
#define TOKEN_EXIT								0x0A
#define TOKEN_CONTINUE						0x23
#define TOKEN_REPEAT							0x02
#define TOKEN_UNTIL								0x03
#define TOKEN_WHILE								0x04
#define TOKEN_WEND								0x05
#define TOKEN_INPUT								0x3A
#define TOKEN_FOR									0x08
#define TOKEN_NEXT								0x09
#define TOKEN_TO									0x47
#define TOKEN_STEP								0x48
#define TOKEN_DOWNTO							0x49
#define TOKEN_DATA								0x01
#define TOKEN_READ								0x51
#define TOKEN_RESTORE							0x52
#define TOKEN_PROCEDURE						0x2B
#define TOKEN_GOSUB								0x2C
#define TOKEN_GOSUB2							0x4D
#define TOKEN_RETURN							0x2E
#define TOKEN_LOCAL								0x68

//Autres
#define TOKEN_RUN									0x70
#define TOKEN_END									0x71

			
//Table de calcul
extern const unsigned char GFA_TableCalc [24];

//Tables de tokens
extern const unsigned char GFA_TableExecToken_Command [0x100];
extern const unsigned char GFA_TableExecToken_Function [0x100];
extern const long GFA_TableExecToken_Constant [0x80];

extern const char GFA_TableHexa [16];

#endif
