// Header File
// Created 10/08/2004; 15:47:53
#ifndef __H_TBL_TAGS
#define __H_TBL_TAGS

#define TOKEN_NOFOUND						0
#define TOKEN_COMMAND						1
#define TOKEN_FUNCTION					2

#define TYPE_NONE								0x00
#define TYPE_SYMBOL							0x01
#define TYPE_FUNC								0x02
#define TYPE_CONSTANT						0x03
#define TYPE_SIGN								0x04
#define TYPE_NEGATIF						0x05
#define TYPE_PARENTH_OPEN				0x06
#define TYPE_PARENTH_CLOSE			0x07
#define TYPE_VIRGULE						0x08
#define TYPE_TWO_POINT					0x09
#define TYPE_COMMENT						0x0A
#define TYPE_EOFLINE						0x0B
#define TYPE_ENDTAG							0x0C


#define TAG_NONE								0x00
#define SUBTAG_NONE							0x00

//Symbole
#define TAG_NUMBER							0x01
	#define SUBTAG_FLOAT		  			0x01
  #define SUBTAG_INT			 	  		0x02
  #define SUBTAG_BOOL			  			0x03
  #define SUBTAG_STRING		  			0x04
  #define SUBTAG_BIN							0x05
  #define SUBTAG_OCT							0x06
  #define SUBTAG_HEX							0x07
#define TAG_STRING							0x02
#define TAG_VARTABLE						0x03
#define TAG_VAR									0x04
#define TAG_LABEL								0x05
#define TAG_PI									0x06
#define TAG_EXP									0x07
#define TAG_PROC								0x08

//Signe
#define TAG_COMPARE							0x08
	#define SUBTAG_AFFEC						0x01
	#define SUBTAG_EGAL							0x02
	#define SUBTAG_SUPERIOR					0x03
	#define SUBTAG_INFERIOR					0x04
	#define SUBTAG_SUPEGAL					0x05
	#define SUBTAG_INFEGAL					0x06
	#define SUBTAG_DIFF							0x07
#define TAG_CALC								0x09
	#define SUBTAG_ADD							0x01
	#define SUBTAG_SUB							0x02
	#define SUBTAG_MUL							0x03
	#define SUBTAG_DIV							0x04
	#define SUBTAG_PUISS						0x05
	#define SUBTAG_MOD							0x06
	#define SUBTAG_DIVINT						0x07
	#define SUBTAG_LOGIC						0x08
#define TAG_POINT_VIRGULE				0x0A
#define TAG_APOST								0x0B
#define TAG_CONSTANT						0x0C
	
	
//Priorit des oprateurs
//-----------------------
#define PRIORITY_AFFEC			0x01			//= soit <-
#define PRIORITY_LOGIC			0x02			//AND, OR, XOR, IMP, EQV, NOT
#define PRIORITY_COMPARE		0x03			//=, <>, <, >, <=, >=
#define PRIORITY_ADDSUB			0x04			//+, -
#define PRIORITY_MULDIV			0x05			//*, /, MOD, DIV
#define PRIORITY_NEGATIF		0x06			//Negatif
#define PRIORITY_PUISS			0x07			//^


//Table de typage de la structure DATA
//------------------------------------
#define DATA_UNKNOWN				SUBTAG_NONE
#define DATA_FLOAT					SUBTAG_FLOAT
#define DATA_STRING					SUBTAG_STRING
#define DATA_INTEGER16			SUBTAG_INT
#define DATA_INTEGER32			SUBTAG_INT+1
	
#endif
