// C Source File
// Created 10/07/2004; 19:16:40

#include "Header.h"
#include "Tbl_Funcs.h"
#include "Tbl_Error.h"

//Programme principal
void _main (void)
{		
	BOOL ErrorPtr = FALSE;
	BOOL ExecRun = FALSE;
	error_code = ERROR_NOERROR;
	
	const char *file=NULL;
  ESI arg;
  InitArgPtr (arg);
  
  //Fichiers de donnes
  if (!File_OpenDatas ()) {
  	File_CloseDatas ();
  	return;}
 
  if (GetArgType (arg) == STR_TAG) {file = GetStrnArg (arg); strcpy (GFAFile_name, file);}
  if (File_Open (file)==FALSE) {
    error_code = ERROR_OPENFILE;
    File_Close ();
    File_CloseDatas ();
    Error_Print (FALSE, FALSE);
  	return;}
   
  //Effectue allocations 
  if (!Memory_Allocate ()) {
  	error_code = ERROR_MEMORY;
  	Memory_Unallocate ();
  	File_Close ();
  	File_CloseDatas ();
  	Error_Print (FALSE, FALSE);
  	return;}
  
  //FICHIER TEXT
  //============
  if (GFAFile_type==FILE_TEXT)
  {
  	ErrorPtr = TRUE;
  	
  	//Lecture du fichier
  	if (!Scanner_ReadFile (GFAFile)) goto endprogram;
  	
  	//Vrification des labels
  	if (!ExprFind_CheckLabels ()) goto endprogram;
		
		//Vrification des procdures
		if (!ExprFind_CheckProcedures ()) goto endprogram;
		
  	//Ecriture du fichier tokenis
  	if (!Tokenisor_MakeFile ("tokens")) {
  		File_Close ();
  		File_CloseDatas ();
  		Error_Print (FALSE, FALSE);
  		return;}
  }
  //FICHIER TOKENISE
  //================
  else
  {
  	ErrorPtr = FALSE;
  	
  	if (!UnTokenisor_ReadFile (&GFAFile, "untokens")) goto endprogram;
  	Memory_Tokenisor_UnallocateBuffer ();
  	Memory_Tokenisor_AllocateBuffer ();
  	
  	if (error_code) {
  		error_code = ERROR_MEMORY;
  		File_Close ();
  		File_CloseDatas ();
  		Error_Print (FALSE, FALSE);
  		return;}
  	
  	ExprVar_InitTables ();
  	ExprVar_AllocateTables ();
  	
  	//Cration du buffer d'execution
  	if (!ExprMake_ReadFile (&GFAFile)) {
  		ExprVar_UnallocateTables ();
  		goto endprogram;}
  	
  	ExprTokens_MakeGotoJump ();				//Adressage des gotos
  	ExprTokens_MakeRestoreJump ();		//Adressage des restores
  	ExprTokens_MakeGosubJump ();			//Adressage des gosubs
  	ExprTokens_CheckStruct ();
  	
  	ExprVar_UnallocateTables ();
  	
  	Param_Initialize ();
  	//ExprVar_Allocate ();
  	//ExprExecute_Allocate ();
  	
  	Interrupt_Init ();
  	Screen_Init ();										//Sauvegarde cran
  	
  	//Execution des tokens
  	ExecRun = TRUE;
  	//ExprExecute_Run ();
  
  	Interrupt_Uninit ();
  	
  	//ExprExecute_Unallocate ();  	
  	//ExprVar_Unallocate ();
  	
  	ExprTokens_MakeFile ("tokenbuf");
  }
  
  //Fin du programme
  endprogram:

  //Efface allocations
  Memory_Unallocate ();
  
  //Unlock fichiers
  File_Close ();
  File_CloseDatas ();
  
  HeapCompress ();									//Rorganisation du Heap (Tas)
  GKeyFlush ();
  
  //Affiche erreur
  if (error_code!=ERROR_NOERROR) 
  {
  	//Restaure cran
  	if (ExecRun) Screen_Uninit ();
  	Error_Print (ErrorPtr, TRUE);
  }
  //Fin d'execution du programme
  else if (ExecRun)
  {
    if (PARAM_SHOW_ENDTEXT)
  	{
  		FontSetSys (F_4x6);
  		printf_xy (0, LCD_HEIGHT-PARAM_FONT_DIVY, "%s", "Appuyez sur une touche pour quitter.");
  		ngetchx ();
  	}
  	
  	Screen_Uninit ();									//Restaure cran
  }
}
