|=======================
|Dfinitions
|=======================

|***********************
|ASIC PORTS
|***********************
  .equ ASIC_PROTECT_VECTORS,		0x600001
  

|***********************
|VECTORS
|***********************
  .equ  VECTOR_BUS_ERROR,		0x08
  .equ	VECTOR_ADDRESS_ERROR,		0x0C
  .equ  VECTOR_ILLEGAL_INSTRUCTION,	0x10
  .equ  VECTOR_DIVIDE_BY_ZERO,		0x14
  .equ  VECTOR_CHK_INSTRUCTION,		0x18
  .equ  VECTOR_TRAPV_INSTRUCTION,	0x1C
  .equ  VECTOR_PRIVILEGE_VIOLATION,	0x20
  .equ  VECTOR_TRACE_MODE,		0x24
  
  .equ  VECTOR_AUTO_INT_1,		0x64
  .equ  VECTOR_AUTO_INT_2,		0x68
  .equ  VECTOR_AUTO_INT_3,		0x6C
  .equ  VECTOR_AUTO_INT_4,		0x70
  .equ  VECTOR_AUTO_INT_5,		0x74
  .equ  VECTOR_AUTO_INT_6,		0x78
  .equ  VECTOR_AUTO_INT_7,		0x7C
  
  
|***********************
|TRAPS
|***********************
  .equ  TRAP_RESET,			0x02


|***********************
|Clavier
|***********************
  .equ  KEY_ENTER,			13
  .equ  KEY_ESC,			264
  .equ  KEY_F1,				268
  .equ  KEY_F2,				269
  .equ  KEY_F3,				270
  .equ  KEY_F4,				271
  .equ  KEY_F5,				272
  

|***********************
|Divers
|***********************
  .equ LCD_SIZE,			3840
  .equ LCD_MEM,				0x4C00
  .equ MIN_LCD_WIDTH,			0
  .equ MIN_LCD_HEIGHT,			0
  .equ MAX_LCD_WIDTH,			239
  .equ MAX_LCD_HEIGHT,			127
  .equ TRUE,				-1
  .equ FALSE,				0
  .equ CLIP_MIN_LCD_WIDTH,		SCR_RECT	|0
  .equ CLIP_MIN_LCD_HEIGHT,		SCR_RECT+1	|0
  .equ CLIP_MAX_LCD_WIDTH,		SCR_RECT+2	|239
  .equ CLIP_MAX_LCD_HEIGHT,		SCR_RECT+3	|127
  
  .equ KEY_BACKSPACE,			257
  .equ KEY_ENTER,			13

|***********************
|Vat.h FindOptions
|*********************** 
  .equ FO_SINGLE_FOLDER,   		0x01
  .equ FO_RECURSE,	   		0x02
  .equ FO_SKIP_TEMPS, 	   		0x04
  .equ FO_NOTEMPS,	   		0x04
  .equ FO_RETURN_TWINS,    		0x08
  .equ FO_CKTWINS,	   		0x08
  .equ FO_RETURN_FOLDER,   		0x10
  .equ FO_SKIP_COLLAPSE,   		0x20
  
|***********************
|Fonts
|*********************** 
  .equ F_4x6,				0
  .equ F_6x8,				1
  .equ F_8x10,				2

|***********************
|Graph.h Attrs
|***********************
  .equ A_REVERSE, 			0
  .equ A_NORMAL, 			1
  .equ A_XOR, 				2
  .equ A_SHADED, 			3
  .equ A_REPLACE, 			4
  .equ A_OR, 				5
  .equ A_AND,				6
  .equ A_THICK1, 			7
  .equ A_SHADE_V, 			8
  .equ A_SHADE_H,			9
  .equ A_SHADE_NS, 			10
  .equ A_SHADE_PS,			11
  
|***********************
|Graph.h BoxAttrs
|***********************
  .equ B_NORMAL,			0x10
  .equ B_ROUNDED,			0x20
  .equ B_DOUBLE,			0x40
  .equ B_CUT,				0x80 

|*****************************
|Attribut fonctions graphiques
|*****************************
  .equ SPRT_OR,				0
  .equ SPRT_XOR,			1
  .equ SPRT_AND,			2
  		
  .equ MODE_DEL,			0	|0 Effacer
  .equ MODE_AND,			1	|C And I
  .equ MODE_AND_V,			2	|C And Not(I)
  .equ MODE_OVER,			3	|C
  .equ MODE_NAND,			4	|Not (C) And I
  .equ MODE_NO,				5	|I (Inchang)
  .equ MODE_XOR,			6	|C Xor I
  .equ MODE_OR,				7	|C Or I
  .equ MODE_NOT_A_OR_V,			8	|Not (C Or I)
  .equ MODE_NOT_A_XOR_V,		9	|Not (C Xor I)
  .equ MODE_INV,			10	|Not I (Inverse vido)
  .equ MODE_C_OR_NOT_V,			11	|C Or Not(I)
  .equ MODE_NOVER,			12	|Not C
  .equ MODE_NOR,			13	|Not (C) Or I
  .equ MODE_NOT_A_AND_V,		14	|Not (C and I)
  .equ MODE_WRITE,			15	|1 Ecrire

|***********************
|Format fichier GTK
|***********************
  .equ GTK_Signature_Size, 		7
  .equ GTK_Tokens_Section_Size, 	2
  .equ GTK_Header_Size,			24
  
|************************
|Taille type
|************************
  .equ SIZE_FLOAT,			10
  .equ SIZE_INTEGER,			4
  .equ SIZE_INTEGER16,			2
  .equ SIZE_BOOL,			1
  .equ SIZE_DESCRIPTOR,			6
  
|************************
|ES et DT taille mmoire
|************************
  .equ ES_SIZE,				600	|50 items* 12 octets
  .equ DT_SIZE,				1000
  .equ FOR_SIZE,			260	|10 items* 26 octets
  .equ LOCAL_VAR_SIZE,			1000	|Max 100 Flottants
  .equ LOCAL_VAR_STRING_SIZE,		400	|Max 100 Chanes de caractres
  .equ STRING_BUFFER_SIZE,		256
  
|************************
|Dfinitions pile FOR
|************************
  |Token aprs FORe
  .equ FOR_STEP,			0x00
  .equ FOR_INC,				0x01
  .equ FOR_DEC,				0x02
  
  |Type de la variable			|1 octet
  |Comparaison  effectuer		|1 octet
  .equ FOR_POS,				0x00
  .equ FOR_NEG,				0x11
  
  |Adresse variable			|4 octets
  |Nombre pour comparaison		|10 octets
  |Nombre pour Step			|10 octets	
  
|************************
|Gestion pile ES
|************************
  .equ OPRD_RESULT,      		0x00
  .equ OPRD_NUMBER,      		0x01
  .equ OPRD_STRING,      		0x02
  .equ OPRD_VAR,      			0x03
  .equ OPRD_VARTABLE,			0x04
  .equ OPRD_UNDEF_VARTABLE,		0x05
  .equ OPRD_EMPTY_VARTABLE,		0x06
  .equ OPRD_POINT_VIRGULE,		0x07
  .equ OPRD_APOST,      		0x08
  .equ OPRD_ENDTAG,			0x09

  .equ TYPE_NONE,      			0x00	
  .equ TYPE_FLOAT,  	   		0x01
  .equ TYPE_INTEGER,    		0x02
  .equ TYPE_BOOL,      			0x03
  .equ TYPE_STRING,      		0x04 
  
  
|************************
|Gestion structure DATA
|************************
  .equ DATA_UNKNOWN,			0x00
  .equ DATA_FLOAT,			0x01
  .equ DATA_INTEGER16,			0x02
  .equ DATA_INTEGER32,			0x03
  .equ DATA_STRING,			0x04
  
  
|************************
|Gestion interruptions
|************************ 
  .equ __HARDWARE_FREQUENCY,		26214	|320 Hz -> 256 Hz
  .equ __TIMER_FREQUENCY,		25600 	|256 Hz -> 200 Hz
  
  
|************************
|Init parameters
|************************
  .equ DEFAULT_REPEAT_KEYDELAY,		210
  .equ DEFAULT_BETWEEN_KEYDELAY,	20
  .equ DEFAULT_CURATTR,			A_NORMAL
  .equ DEFAULT_SPRITE_LCD_MEM,  	LCD_MEM
  .equ DEFAULT_FONTLIB,			FALSE
  .equ DEFAULT_FONTLIB_MODE,		FONT_NORMAL
  .equ DEFAULT_FONTLIB_GRAPHMODE,	FONT_REPLACE

  .equ PRINT_DIGITS,			6
  .equ PRINT_ATx,			1
  .equ PRINT_ATy,			1
  .equ PRINT_REAL_ATx,			0
  .equ PRINT_REAL_ATy,			0
  .equ FONT,				F_4x6
  .equ FONT_DIVx,			4
  .equ FONT_DIVy,			6
  .equ SHOW_ENDTEXT,			TRUE
  .equ INPUT_LENGTH,			64
  