// C Source File
// Created 09/02/2005; 15:06:42

#include <tigcclib.h>

#define DLPA 0x60000E
#define LP 0x60000C

INT_HANDLER OldInt1 = NULL;
INT_HANDLER OldInt5 = NULL;

#define display_width		240
#define display_height  128

unsigned char sprite []={
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
	0b10101010,0b01010101,
};

void SpriteClipX8(short x,short y,short h, unsigned char* sprite1, short bytewidth)
{
  long offset;
  unsigned char* addr1;
  unsigned short shift1;
  unsigned short shift2;
  unsigned short lineoffset;
  short loop;
  short buffer;

  if(x <= -bytewidth * 8 || x >=  display_width || y < -h || y >= display_height) return;

  if(y < 0)
  {
    h += y;
    sprite1 -= (y * bytewidth);
    y = 0;
  }
   
  if(y + h >= display_height) 
    h = display_height - y;

  offset = (y<<5)-(y<<1)+(x>>3);
  addr1 = ((unsigned char*)LCD_MEM)+offset;

  shift1 = x & 7;
  lineoffset = 30-bytewidth;

  shift2 = 8 - shift1;
  if(x < 0) 
  {
    buffer = (-x) >> 3;
    if((buffer << 3)!= (-x)) 
      buffer++;

    for (;h;h--,addr1+=lineoffset) 
    {
      sprite1 += buffer - 1;
      addr1 += buffer;

      for (loop=buffer;loop<bytewidth;loop++) 
      {
        *addr1   |= ((*sprite1++) << shift2);
        *addr1++ |= (*sprite1 >> shift1);
      }
      
      *addr1 |= (*sprite1++ << shift2);
    }
  } 
  else if(x + (bytewidth << 3) >= display_width) 
  {
    buffer = (x + (bytewidth << 3) - display_width) >> 3;

    for (;h;h--,addr1+=lineoffset) 
    {
      *addr1++ |= *sprite1 >> shift1;
      for (loop=1;loop<bytewidth-buffer;loop++) 
      {
        *addr1   |= ((*sprite1++) << shift2);
        *addr1++ |= (*sprite1 >> shift1);
      }

      sprite1 += buffer + 1;
      addr1 += buffer;
    }
  } 
  else 
  {
    for (;h;h--,addr1+=lineoffset) 
    {
      *addr1++ |= *sprite1 >> shift1;
      for (loop=1;loop<bytewidth;loop++) 
      {
        *addr1   |= ((*sprite1++) << shift2);
        *addr1++ |= (*sprite1 >> shift1);
      }
      
      *addr1 |= (*sprite1++ << shift2);
    }
  }
}


// Main Function
void _main(void)
{
  OldInt1 = GetIntVec (AUTO_INT_1);
  OldInt5 = GetIntVec (AUTO_INT_5);
  SetIntVec (AUTO_INT_1, DUMMY_HANDLER);
  SetIntVec (AUTO_INT_5, DUMMY_HANDLER);
  
  short x=240/2;
  short y=128/2;
  BOOL key=TRUE;
  unsigned long i;
  
  while (!_keytest (RR_ESC))
  {
  	if (_keytest (RR_LEFT)) {x--; key=TRUE;}
  	else if (_keytest (RR_RIGHT)) {x++; key=TRUE;}
  	
  	if (_keytest (RR_UP)) {y--; key=TRUE;}
  	else if (_keytest (RR_DOWN)) {y++; key=TRUE;}
  	
  	if (key)
  	{
  		clrscr ();
  		printf_xy (0,0,"%d - %d",x,y);
  		SpriteClipX8 (x,y,8,sprite,4);
  		key=FALSE;
  		for (i=0; i<5000;i++);
  	}
  }
  
  SetIntVec (AUTO_INT_1, OldInt1);
  SetIntVec (AUTO_INT_5, OldInt5);
}
